# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['CatalogEntryArgs', 'CatalogEntry']

@pulumi.input_type
class CatalogEntryArgs:
    def __init__(__self__, *,
                 address: pulumi.Input[str],
                 node: pulumi.Input[str],
                 datacenter: Optional[pulumi.Input[str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CatalogEntry resource.
        :param pulumi.Input[str] address: The address of the node being added to,
               or referenced in the catalog.
        :param pulumi.Input[str] node: The name of the node being added to, or
               referenced in the catalog.
        :param pulumi.Input[str] datacenter: The datacenter to use. This overrides the
               agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]] services: A service to optionally associated with
               the node. Supported values are documented below.
        :param pulumi.Input[str] token: ACL token.
        """
        pulumi.set(__self__, "address", address)
        pulumi.set(__self__, "node", node)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if token is not None:
            warnings.warn("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""", DeprecationWarning)
            pulumi.log.warn("""token is deprecated: The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Input[str]:
        """
        The address of the node being added to,
        or referenced in the catalog.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: pulumi.Input[str]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def node(self) -> pulumi.Input[str]:
        """
        The name of the node being added to, or
        referenced in the catalog.
        """
        return pulumi.get(self, "node")

    @node.setter
    def node(self, value: pulumi.Input[str]):
        pulumi.set(self, "node", value)

    @property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[str]]:
        """
        The datacenter to use. This overrides the
        agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datacenter", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]]]:
        """
        A service to optionally associated with
        the node. Supported values are documented below.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        ACL token.
        """
        warnings.warn("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""", DeprecationWarning)
        pulumi.log.warn("""token is deprecated: The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")

        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


@pulumi.input_type
class _CatalogEntryState:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 node: Optional[pulumi.Input[str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CatalogEntry resources.
        :param pulumi.Input[str] address: The address of the node being added to,
               or referenced in the catalog.
        :param pulumi.Input[str] datacenter: The datacenter to use. This overrides the
               agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[str] node: The name of the node being added to, or
               referenced in the catalog.
        :param pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]] services: A service to optionally associated with
               the node. Supported values are documented below.
        :param pulumi.Input[str] token: ACL token.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if node is not None:
            pulumi.set(__self__, "node", node)
        if services is not None:
            pulumi.set(__self__, "services", services)
        if token is not None:
            warnings.warn("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""", DeprecationWarning)
            pulumi.log.warn("""token is deprecated: The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The address of the node being added to,
        or referenced in the catalog.
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[str]]:
        """
        The datacenter to use. This overrides the
        agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datacenter", value)

    @property
    @pulumi.getter
    def node(self) -> Optional[pulumi.Input[str]]:
        """
        The name of the node being added to, or
        referenced in the catalog.
        """
        return pulumi.get(self, "node")

    @node.setter
    def node(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "node", value)

    @property
    @pulumi.getter
    def services(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]]]:
        """
        A service to optionally associated with
        the node. Supported values are documented below.
        """
        return pulumi.get(self, "services")

    @services.setter
    def services(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['CatalogEntryServiceArgs']]]]):
        pulumi.set(self, "services", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        ACL token.
        """
        warnings.warn("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""", DeprecationWarning)
        pulumi.log.warn("""token is deprecated: The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")

        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


class CatalogEntry(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 node: Optional[pulumi.Input[str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogEntryServiceArgs']]]]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        !> The `CatalogEntry` resource has been deprecated in version 2.0.0 of the provider
        and will be removed in a future release. Please read the [upgrade guide](https://www.terraform.io/docs/providers/consul/guides/upgrading.html#deprecation-of-consul_catalog_entry)
        for more information.

        Registers a node or service with the [Consul Catalog](https://www.consul.io/docs/agent/http/catalog.html#catalog_register).
        Currently, defining health checks is not supported.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The address of the node being added to,
               or referenced in the catalog.
        :param pulumi.Input[str] datacenter: The datacenter to use. This overrides the
               agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[str] node: The name of the node being added to, or
               referenced in the catalog.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogEntryServiceArgs']]]] services: A service to optionally associated with
               the node. Supported values are documented below.
        :param pulumi.Input[str] token: ACL token.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CatalogEntryArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        !> The `CatalogEntry` resource has been deprecated in version 2.0.0 of the provider
        and will be removed in a future release. Please read the [upgrade guide](https://www.terraform.io/docs/providers/consul/guides/upgrading.html#deprecation-of-consul_catalog_entry)
        for more information.

        Registers a node or service with the [Consul Catalog](https://www.consul.io/docs/agent/http/catalog.html#catalog_register).
        Currently, defining health checks is not supported.

        :param str resource_name: The name of the resource.
        :param CatalogEntryArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CatalogEntryArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 node: Optional[pulumi.Input[str]] = None,
                 services: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogEntryServiceArgs']]]]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CatalogEntryArgs.__new__(CatalogEntryArgs)

            if address is None and not opts.urn:
                raise TypeError("Missing required property 'address'")
            __props__.__dict__["address"] = address
            __props__.__dict__["datacenter"] = datacenter
            if node is None and not opts.urn:
                raise TypeError("Missing required property 'node'")
            __props__.__dict__["node"] = node
            __props__.__dict__["services"] = services
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(CatalogEntry, __self__).__init__(
            'consul:index/catalogEntry:CatalogEntry',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            address: Optional[pulumi.Input[str]] = None,
            datacenter: Optional[pulumi.Input[str]] = None,
            node: Optional[pulumi.Input[str]] = None,
            services: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogEntryServiceArgs']]]]] = None,
            token: Optional[pulumi.Input[str]] = None) -> 'CatalogEntry':
        """
        Get an existing CatalogEntry resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The address of the node being added to,
               or referenced in the catalog.
        :param pulumi.Input[str] datacenter: The datacenter to use. This overrides the
               agent's default datacenter and the datacenter in the provider setup.
        :param pulumi.Input[str] node: The name of the node being added to, or
               referenced in the catalog.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['CatalogEntryServiceArgs']]]] services: A service to optionally associated with
               the node. Supported values are documented below.
        :param pulumi.Input[str] token: ACL token.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CatalogEntryState.__new__(_CatalogEntryState)

        __props__.__dict__["address"] = address
        __props__.__dict__["datacenter"] = datacenter
        __props__.__dict__["node"] = node
        __props__.__dict__["services"] = services
        __props__.__dict__["token"] = token
        return CatalogEntry(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[str]:
        """
        The address of the node being added to,
        or referenced in the catalog.
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter
    def datacenter(self) -> pulumi.Output[str]:
        """
        The datacenter to use. This overrides the
        agent's default datacenter and the datacenter in the provider setup.
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter
    def node(self) -> pulumi.Output[str]:
        """
        The name of the node being added to, or
        referenced in the catalog.
        """
        return pulumi.get(self, "node")

    @property
    @pulumi.getter
    def services(self) -> pulumi.Output[Optional[Sequence['outputs.CatalogEntryService']]]:
        """
        A service to optionally associated with
        the node. Supported values are documented below.
        """
        return pulumi.get(self, "services")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[str]]:
        """
        ACL token.
        """
        warnings.warn("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""", DeprecationWarning)
        pulumi.log.warn("""token is deprecated: The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")

        return pulumi.get(self, "token")

