# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['CertificateAuthorityArgs', 'CertificateAuthority']

@pulumi.input_type
class CertificateAuthorityArgs:
    def __init__(__self__, *,
                 connect_provider: pulumi.Input[str],
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 config_json: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a CertificateAuthority resource.
        :param pulumi.Input[str] connect_provider: Specifies the CA provider type to use.
        """
        pulumi.set(__self__, "connect_provider", connect_provider)
        if config is not None:
            warnings.warn("""The config attribute is deprecated, please use config_json instead.""", DeprecationWarning)
            pulumi.log.warn("""config is deprecated: The config attribute is deprecated, please use config_json instead.""")
        if config is not None:
            pulumi.set(__self__, "config", config)
        if config_json is not None:
            pulumi.set(__self__, "config_json", config_json)

    @property
    @pulumi.getter(name="connectProvider")
    def connect_provider(self) -> pulumi.Input[str]:
        """
        Specifies the CA provider type to use.
        """
        return pulumi.get(self, "connect_provider")

    @connect_provider.setter
    def connect_provider(self, value: pulumi.Input[str]):
        pulumi.set(self, "connect_provider", value)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        warnings.warn("""The config attribute is deprecated, please use config_json instead.""", DeprecationWarning)
        pulumi.log.warn("""config is deprecated: The config attribute is deprecated, please use config_json instead.""")

        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="configJson")
    def config_json(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "config_json")

    @config_json.setter
    def config_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_json", value)


@pulumi.input_type
class _CertificateAuthorityState:
    def __init__(__self__, *,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 config_json: Optional[pulumi.Input[str]] = None,
                 connect_provider: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering CertificateAuthority resources.
        :param pulumi.Input[str] connect_provider: Specifies the CA provider type to use.
        """
        if config is not None:
            warnings.warn("""The config attribute is deprecated, please use config_json instead.""", DeprecationWarning)
            pulumi.log.warn("""config is deprecated: The config attribute is deprecated, please use config_json instead.""")
        if config is not None:
            pulumi.set(__self__, "config", config)
        if config_json is not None:
            pulumi.set(__self__, "config_json", config_json)
        if connect_provider is not None:
            pulumi.set(__self__, "connect_provider", connect_provider)

    @property
    @pulumi.getter
    def config(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        warnings.warn("""The config attribute is deprecated, please use config_json instead.""", DeprecationWarning)
        pulumi.log.warn("""config is deprecated: The config attribute is deprecated, please use config_json instead.""")

        return pulumi.get(self, "config")

    @config.setter
    def config(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "config", value)

    @property
    @pulumi.getter(name="configJson")
    def config_json(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "config_json")

    @config_json.setter
    def config_json(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "config_json", value)

    @property
    @pulumi.getter(name="connectProvider")
    def connect_provider(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the CA provider type to use.
        """
        return pulumi.get(self, "connect_provider")

    @connect_provider.setter
    def connect_provider(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "connect_provider", value)


class CertificateAuthority(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 config_json: Optional[pulumi.Input[str]] = None,
                 connect_provider: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The `CertificateAuthority` resource can be used to manage the configuration of the Certificate Authority used by [Consul Connect](https://www.consul.io/docs/connect/ca).

        > **Note:** The keys in the `config` argument must be using Camel case.

        ## Import

        ```sh
        $ pulumi import consul:index/certificateAuthority:CertificateAuthority connect connect-ca
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connect_provider: Specifies the CA provider type to use.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: CertificateAuthorityArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The `CertificateAuthority` resource can be used to manage the configuration of the Certificate Authority used by [Consul Connect](https://www.consul.io/docs/connect/ca).

        > **Note:** The keys in the `config` argument must be using Camel case.

        ## Import

        ```sh
        $ pulumi import consul:index/certificateAuthority:CertificateAuthority connect connect-ca
        ```

        :param str resource_name: The name of the resource.
        :param CertificateAuthorityArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(CertificateAuthorityArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 config_json: Optional[pulumi.Input[str]] = None,
                 connect_provider: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = CertificateAuthorityArgs.__new__(CertificateAuthorityArgs)

            __props__.__dict__["config"] = config
            __props__.__dict__["config_json"] = config_json
            if connect_provider is None and not opts.urn:
                raise TypeError("Missing required property 'connect_provider'")
            __props__.__dict__["connect_provider"] = connect_provider
        super(CertificateAuthority, __self__).__init__(
            'consul:index/certificateAuthority:CertificateAuthority',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            config: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            config_json: Optional[pulumi.Input[str]] = None,
            connect_provider: Optional[pulumi.Input[str]] = None) -> 'CertificateAuthority':
        """
        Get an existing CertificateAuthority resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] connect_provider: Specifies the CA provider type to use.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _CertificateAuthorityState.__new__(_CertificateAuthorityState)

        __props__.__dict__["config"] = config
        __props__.__dict__["config_json"] = config_json
        __props__.__dict__["connect_provider"] = connect_provider
        return CertificateAuthority(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def config(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        warnings.warn("""The config attribute is deprecated, please use config_json instead.""", DeprecationWarning)
        pulumi.log.warn("""config is deprecated: The config attribute is deprecated, please use config_json instead.""")

        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="configJson")
    def config_json(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "config_json")

    @property
    @pulumi.getter(name="connectProvider")
    def connect_provider(self) -> pulumi.Output[str]:
        """
        Specifies the CA provider type to use.
        """
        return pulumi.get(self, "connect_provider")

