# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs
from ._inputs import *

__all__ = ['ConfigEntryServiceSplitterArgs', 'ConfigEntryServiceSplitter']

@pulumi.input_type
class ConfigEntryServiceSplitterArgs:
    def __init__(__self__, *,
                 splits: pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceSplitterSplitArgs']]],
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 partition: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a ConfigEntryServiceSplitter resource.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceSplitterSplitArgs']]] splits: Defines how much traffic to send to sets of service instances during a traffic split.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] meta: Specifies key-value pairs to add to the KV store.
        :param pulumi.Input[str] name: Specifies a name for the configuration entry.
        :param pulumi.Input[str] namespace: Specifies the namespace to apply the configuration entry.
        :param pulumi.Input[str] partition: Specifies the admin partition to apply the configuration entry.
        """
        pulumi.set(__self__, "splits", splits)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)

    @property
    @pulumi.getter
    def splits(self) -> pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceSplitterSplitArgs']]]:
        """
        Defines how much traffic to send to sets of service instances during a traffic split.
        """
        return pulumi.get(self, "splits")

    @splits.setter
    def splits(self, value: pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceSplitterSplitArgs']]]):
        pulumi.set(self, "splits", value)

    @property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies key-value pairs to add to the KV store.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "meta", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a name for the configuration entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the namespace to apply the configuration entry.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the admin partition to apply the configuration entry.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition", value)


@pulumi.input_type
class _ConfigEntryServiceSplitterState:
    def __init__(__self__, *,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 splits: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceSplitterSplitArgs']]]] = None):
        """
        Input properties used for looking up and filtering ConfigEntryServiceSplitter resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] meta: Specifies key-value pairs to add to the KV store.
        :param pulumi.Input[str] name: Specifies a name for the configuration entry.
        :param pulumi.Input[str] namespace: Specifies the namespace to apply the configuration entry.
        :param pulumi.Input[str] partition: Specifies the admin partition to apply the configuration entry.
        :param pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceSplitterSplitArgs']]] splits: Defines how much traffic to send to sets of service instances during a traffic split.
        """
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if name is not None:
            pulumi.set(__self__, "name", name)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if splits is not None:
            pulumi.set(__self__, "splits", splits)

    @property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies key-value pairs to add to the KV store.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "meta", value)

    @property
    @pulumi.getter
    def name(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies a name for the configuration entry.
        """
        return pulumi.get(self, "name")

    @name.setter
    def name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "name", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the namespace to apply the configuration entry.
        """
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[str]]:
        """
        Specifies the admin partition to apply the configuration entry.
        """
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter
    def splits(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceSplitterSplitArgs']]]]:
        """
        Defines how much traffic to send to sets of service instances during a traffic split.
        """
        return pulumi.get(self, "splits")

    @splits.setter
    def splits(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ConfigEntryServiceSplitterSplitArgs']]]]):
        pulumi.set(self, "splits", value)


class ConfigEntryServiceSplitter(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 splits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigEntryServiceSplitterSplitArgs']]]]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_consul as consul

        web = consul.ConfigEntry("web",
            name="web",
            kind="service-defaults",
            config_json=json.dumps({
                "Protocol": "http",
                "Expose": {},
                "MeshGateway": {},
                "TransparentProxy": {},
            }))
        service_resolver = consul.ConfigEntryServiceResolver("service_resolver",
            name="service-resolver",
            default_subset="v1",
            subsets=[
                consul.ConfigEntryServiceResolverSubsetArgs(
                    name="v1",
                    filter="Service.Meta.version == v1",
                ),
                consul.ConfigEntryServiceResolverSubsetArgs(
                    name="v2",
                    filter="Service.Meta.version == v2",
                ),
            ])
        foo = consul.ConfigEntryServiceSplitter("foo",
            name=service_resolver.name,
            meta={
                "key": "value",
            },
            splits=[
                consul.ConfigEntryServiceSplitterSplitArgs(
                    weight=80,
                    service="web",
                    service_subset="v1",
                    request_headers=consul.ConfigEntryServiceSplitterSplitRequestHeadersArgs(
                        set={
                            "x-web-version": "from-v1",
                        },
                    ),
                    response_headers=consul.ConfigEntryServiceSplitterSplitResponseHeadersArgs(
                        set={
                            "x-web-version": "to-v1",
                        },
                    ),
                ),
                consul.ConfigEntryServiceSplitterSplitArgs(
                    weight=10,
                    service="web",
                    service_subset="v2",
                    request_headers=consul.ConfigEntryServiceSplitterSplitRequestHeadersArgs(
                        set={
                            "x-web-version": "from-v2",
                        },
                    ),
                    response_headers=consul.ConfigEntryServiceSplitterSplitResponseHeadersArgs(
                        set={
                            "x-web-version": "to-v2",
                        },
                    ),
                ),
                consul.ConfigEntryServiceSplitterSplitArgs(
                    weight=10,
                    service="web",
                    service_subset="v2",
                ),
            ])
        ```

        ## Import

        ```sh
        $ pulumi import consul:index/configEntryServiceSplitter:ConfigEntryServiceSplitter foo web
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] meta: Specifies key-value pairs to add to the KV store.
        :param pulumi.Input[str] name: Specifies a name for the configuration entry.
        :param pulumi.Input[str] namespace: Specifies the namespace to apply the configuration entry.
        :param pulumi.Input[str] partition: Specifies the admin partition to apply the configuration entry.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigEntryServiceSplitterSplitArgs']]]] splits: Defines how much traffic to send to sets of service instances during a traffic split.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: ConfigEntryServiceSplitterArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import json
        import pulumi_consul as consul

        web = consul.ConfigEntry("web",
            name="web",
            kind="service-defaults",
            config_json=json.dumps({
                "Protocol": "http",
                "Expose": {},
                "MeshGateway": {},
                "TransparentProxy": {},
            }))
        service_resolver = consul.ConfigEntryServiceResolver("service_resolver",
            name="service-resolver",
            default_subset="v1",
            subsets=[
                consul.ConfigEntryServiceResolverSubsetArgs(
                    name="v1",
                    filter="Service.Meta.version == v1",
                ),
                consul.ConfigEntryServiceResolverSubsetArgs(
                    name="v2",
                    filter="Service.Meta.version == v2",
                ),
            ])
        foo = consul.ConfigEntryServiceSplitter("foo",
            name=service_resolver.name,
            meta={
                "key": "value",
            },
            splits=[
                consul.ConfigEntryServiceSplitterSplitArgs(
                    weight=80,
                    service="web",
                    service_subset="v1",
                    request_headers=consul.ConfigEntryServiceSplitterSplitRequestHeadersArgs(
                        set={
                            "x-web-version": "from-v1",
                        },
                    ),
                    response_headers=consul.ConfigEntryServiceSplitterSplitResponseHeadersArgs(
                        set={
                            "x-web-version": "to-v1",
                        },
                    ),
                ),
                consul.ConfigEntryServiceSplitterSplitArgs(
                    weight=10,
                    service="web",
                    service_subset="v2",
                    request_headers=consul.ConfigEntryServiceSplitterSplitRequestHeadersArgs(
                        set={
                            "x-web-version": "from-v2",
                        },
                    ),
                    response_headers=consul.ConfigEntryServiceSplitterSplitResponseHeadersArgs(
                        set={
                            "x-web-version": "to-v2",
                        },
                    ),
                ),
                consul.ConfigEntryServiceSplitterSplitArgs(
                    weight=10,
                    service="web",
                    service_subset="v2",
                ),
            ])
        ```

        ## Import

        ```sh
        $ pulumi import consul:index/configEntryServiceSplitter:ConfigEntryServiceSplitter foo web
        ```

        :param str resource_name: The name of the resource.
        :param ConfigEntryServiceSplitterArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ConfigEntryServiceSplitterArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 name: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 splits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigEntryServiceSplitterSplitArgs']]]]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ConfigEntryServiceSplitterArgs.__new__(ConfigEntryServiceSplitterArgs)

            __props__.__dict__["meta"] = meta
            __props__.__dict__["name"] = name
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["partition"] = partition
            if splits is None and not opts.urn:
                raise TypeError("Missing required property 'splits'")
            __props__.__dict__["splits"] = splits
        super(ConfigEntryServiceSplitter, __self__).__init__(
            'consul:index/configEntryServiceSplitter:ConfigEntryServiceSplitter',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            name: Optional[pulumi.Input[str]] = None,
            namespace: Optional[pulumi.Input[str]] = None,
            partition: Optional[pulumi.Input[str]] = None,
            splits: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigEntryServiceSplitterSplitArgs']]]]] = None) -> 'ConfigEntryServiceSplitter':
        """
        Get an existing ConfigEntryServiceSplitter resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] meta: Specifies key-value pairs to add to the KV store.
        :param pulumi.Input[str] name: Specifies a name for the configuration entry.
        :param pulumi.Input[str] namespace: Specifies the namespace to apply the configuration entry.
        :param pulumi.Input[str] partition: Specifies the admin partition to apply the configuration entry.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ConfigEntryServiceSplitterSplitArgs']]]] splits: Defines how much traffic to send to sets of service instances during a traffic split.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _ConfigEntryServiceSplitterState.__new__(_ConfigEntryServiceSplitterState)

        __props__.__dict__["meta"] = meta
        __props__.__dict__["name"] = name
        __props__.__dict__["namespace"] = namespace
        __props__.__dict__["partition"] = partition
        __props__.__dict__["splits"] = splits
        return ConfigEntryServiceSplitter(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter
    def meta(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies key-value pairs to add to the KV store.
        """
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def name(self) -> pulumi.Output[str]:
        """
        Specifies a name for the configuration entry.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the namespace to apply the configuration entry.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[str]]:
        """
        Specifies the admin partition to apply the configuration entry.
        """
        return pulumi.get(self, "partition")

    @property
    @pulumi.getter
    def splits(self) -> pulumi.Output[Sequence['outputs.ConfigEntryServiceSplitterSplit']]:
        """
        Defines how much traffic to send to sets of service instances during a traffic split.
        """
        return pulumi.get(self, "splits")

