# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetAclAuthMethodResult',
    'AwaitableGetAclAuthMethodResult',
    'get_acl_auth_method',
    'get_acl_auth_method_output',
]

@pulumi.output_type
class GetAclAuthMethodResult:
    """
    A collection of values returned by getAclAuthMethod.
    """
    def __init__(__self__, config=None, config_json=None, description=None, display_name=None, id=None, max_token_ttl=None, name=None, namespace=None, namespace_rules=None, partition=None, token_locality=None, type=None):
        if config and not isinstance(config, dict):
            raise TypeError("Expected argument 'config' to be a dict")
        pulumi.set(__self__, "config", config)
        if config_json and not isinstance(config_json, str):
            raise TypeError("Expected argument 'config_json' to be a str")
        pulumi.set(__self__, "config_json", config_json)
        if description and not isinstance(description, str):
            raise TypeError("Expected argument 'description' to be a str")
        pulumi.set(__self__, "description", description)
        if display_name and not isinstance(display_name, str):
            raise TypeError("Expected argument 'display_name' to be a str")
        pulumi.set(__self__, "display_name", display_name)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if max_token_ttl and not isinstance(max_token_ttl, str):
            raise TypeError("Expected argument 'max_token_ttl' to be a str")
        pulumi.set(__self__, "max_token_ttl", max_token_ttl)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if namespace_rules and not isinstance(namespace_rules, list):
            raise TypeError("Expected argument 'namespace_rules' to be a list")
        pulumi.set(__self__, "namespace_rules", namespace_rules)
        if partition and not isinstance(partition, str):
            raise TypeError("Expected argument 'partition' to be a str")
        pulumi.set(__self__, "partition", partition)
        if token_locality and not isinstance(token_locality, str):
            raise TypeError("Expected argument 'token_locality' to be a str")
        pulumi.set(__self__, "token_locality", token_locality)
        if type and not isinstance(type, str):
            raise TypeError("Expected argument 'type' to be a str")
        pulumi.set(__self__, "type", type)

    @property
    @pulumi.getter
    def config(self) -> Mapping[str, str]:
        """
        The configuration options of the ACL Auth Method. This attribute is
        deprecated and will be removed in a future version. If the configuration is
        too complex to be represented as a map of strings, it will be blank.
        `config_json` should be used instead.
        """
        warnings.warn("""The config attribute is deprecated, please use config_json instead.""", DeprecationWarning)
        pulumi.log.warn("""config is deprecated: The config attribute is deprecated, please use config_json instead.""")

        return pulumi.get(self, "config")

    @property
    @pulumi.getter(name="configJson")
    def config_json(self) -> str:
        """
        The configuration options of the ACL Auth Method.
        """
        return pulumi.get(self, "config_json")

    @property
    @pulumi.getter
    def description(self) -> str:
        """
        The description of the ACL Auth Method.
        """
        return pulumi.get(self, "description")

    @property
    @pulumi.getter(name="displayName")
    def display_name(self) -> str:
        """
        An optional name to use instead of the name attribute when
        displaying information about this auth method.
        """
        return pulumi.get(self, "display_name")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="maxTokenTtl")
    def max_token_ttl(self) -> str:
        """
        The maximum life of any token created by this auth method.
        """
        return pulumi.get(self, "max_token_ttl")

    @property
    @pulumi.getter
    def name(self) -> str:
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter(name="namespaceRules")
    def namespace_rules(self) -> Sequence['outputs.GetAclAuthMethodNamespaceRuleResult']:
        """
        (Enterprise Only) A set of rules that control which
        namespace tokens created via this auth method will be created within
        """
        return pulumi.get(self, "namespace_rules")

    @property
    @pulumi.getter
    def partition(self) -> Optional[str]:
        return pulumi.get(self, "partition")

    @property
    @pulumi.getter(name="tokenLocality")
    def token_locality(self) -> str:
        """
        The kind of token that this auth method produces. This can
        be either 'local' or 'global'.
        """
        return pulumi.get(self, "token_locality")

    @property
    @pulumi.getter
    def type(self) -> str:
        """
        The type of the ACL Auth Method.
        """
        return pulumi.get(self, "type")


class AwaitableGetAclAuthMethodResult(GetAclAuthMethodResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAclAuthMethodResult(
            config=self.config,
            config_json=self.config_json,
            description=self.description,
            display_name=self.display_name,
            id=self.id,
            max_token_ttl=self.max_token_ttl,
            name=self.name,
            namespace=self.namespace,
            namespace_rules=self.namespace_rules,
            partition=self.partition,
            token_locality=self.token_locality,
            type=self.type)


def get_acl_auth_method(name: Optional[str] = None,
                        namespace: Optional[str] = None,
                        partition: Optional[str] = None,
                        opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAclAuthMethodResult:
    """
    The `AclAuthMethod` data source returns the information related to a
    [Consul Auth Method](https://www.consul.io/docs/acl/acl-auth-methods.html).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_consul as consul

    test = consul.get_acl_auth_method(name="minikube")
    pulumi.export("consulAclAuthMethod", test.config)
    ```


    :param str name: The name of the ACL Auth Method.
    :param str namespace: The namespace to lookup the auth method.
    :param str partition: The partition to lookup the auth method.
    """
    __args__ = dict()
    __args__['name'] = name
    __args__['namespace'] = namespace
    __args__['partition'] = partition
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('consul:index/getAclAuthMethod:getAclAuthMethod', __args__, opts=opts, typ=GetAclAuthMethodResult).value

    return AwaitableGetAclAuthMethodResult(
        config=pulumi.get(__ret__, 'config'),
        config_json=pulumi.get(__ret__, 'config_json'),
        description=pulumi.get(__ret__, 'description'),
        display_name=pulumi.get(__ret__, 'display_name'),
        id=pulumi.get(__ret__, 'id'),
        max_token_ttl=pulumi.get(__ret__, 'max_token_ttl'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        namespace_rules=pulumi.get(__ret__, 'namespace_rules'),
        partition=pulumi.get(__ret__, 'partition'),
        token_locality=pulumi.get(__ret__, 'token_locality'),
        type=pulumi.get(__ret__, 'type'))


@_utilities.lift_output_func(get_acl_auth_method)
def get_acl_auth_method_output(name: Optional[pulumi.Input[str]] = None,
                               namespace: Optional[pulumi.Input[Optional[str]]] = None,
                               partition: Optional[pulumi.Input[Optional[str]]] = None,
                               opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAclAuthMethodResult]:
    """
    The `AclAuthMethod` data source returns the information related to a
    [Consul Auth Method](https://www.consul.io/docs/acl/acl-auth-methods.html).

    ## Example Usage

    ```python
    import pulumi
    import pulumi_consul as consul

    test = consul.get_acl_auth_method(name="minikube")
    pulumi.export("consulAclAuthMethod", test.config)
    ```


    :param str name: The name of the ACL Auth Method.
    :param str namespace: The namespace to lookup the auth method.
    :param str partition: The partition to lookup the auth method.
    """
    ...
