# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetAgentConfigResult',
    'AwaitableGetAgentConfigResult',
    'get_agent_config',
    'get_agent_config_output',
]

@pulumi.output_type
class GetAgentConfigResult:
    """
    A collection of values returned by getAgentConfig.
    """
    def __init__(__self__, datacenter=None, id=None, node_id=None, node_name=None, revision=None, server=None, version=None):
        if datacenter and not isinstance(datacenter, str):
            raise TypeError("Expected argument 'datacenter' to be a str")
        pulumi.set(__self__, "datacenter", datacenter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if node_id and not isinstance(node_id, str):
            raise TypeError("Expected argument 'node_id' to be a str")
        pulumi.set(__self__, "node_id", node_id)
        if node_name and not isinstance(node_name, str):
            raise TypeError("Expected argument 'node_name' to be a str")
        pulumi.set(__self__, "node_name", node_name)
        if revision and not isinstance(revision, str):
            raise TypeError("Expected argument 'revision' to be a str")
        pulumi.set(__self__, "revision", revision)
        if server and not isinstance(server, bool):
            raise TypeError("Expected argument 'server' to be a bool")
        pulumi.set(__self__, "server", server)
        if version and not isinstance(version, str):
            raise TypeError("Expected argument 'version' to be a str")
        pulumi.set(__self__, "version", version)

    @property
    @pulumi.getter
    def datacenter(self) -> str:
        """
        The datacenter the agent is running in
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter(name="nodeId")
    def node_id(self) -> str:
        """
        The ID of the node the agent is running on
        """
        return pulumi.get(self, "node_id")

    @property
    @pulumi.getter(name="nodeName")
    def node_name(self) -> str:
        """
        The name of the node the agent is running on
        """
        return pulumi.get(self, "node_name")

    @property
    @pulumi.getter
    def revision(self) -> str:
        """
        The first 9 characters of the VCS revision of the build of Consul that is running
        """
        return pulumi.get(self, "revision")

    @property
    @pulumi.getter
    def server(self) -> bool:
        """
        Boolean if the agent is a server or not
        """
        return pulumi.get(self, "server")

    @property
    @pulumi.getter
    def version(self) -> str:
        """
        The version of the build of Consul that is running
        """
        return pulumi.get(self, "version")


class AwaitableGetAgentConfigResult(GetAgentConfigResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetAgentConfigResult(
            datacenter=self.datacenter,
            id=self.id,
            node_id=self.node_id,
            node_name=self.node_name,
            revision=self.revision,
            server=self.server,
            version=self.version)


def get_agent_config(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetAgentConfigResult:
    """
    > **Note:** The `get_agent_config` resource differs from [`get_agent_self`](https://www.terraform.io/docs/providers/consul/d/agent_self.html),
    providing less information but utilizing stable APIs. `get_agent_self` will be
    deprecated in a future release.

    The `get_agent_config` data source returns
    [configuration data](https://www.consul.io/api/agent.html#read-configuration)
    from the agent specified in the `provider`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_consul as consul

    remote_agent = consul.get_agent_config()
    pulumi.export("consulVersion", remote_agent.version)
    ```
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('consul:index/getAgentConfig:getAgentConfig', __args__, opts=opts, typ=GetAgentConfigResult).value

    return AwaitableGetAgentConfigResult(
        datacenter=pulumi.get(__ret__, 'datacenter'),
        id=pulumi.get(__ret__, 'id'),
        node_id=pulumi.get(__ret__, 'node_id'),
        node_name=pulumi.get(__ret__, 'node_name'),
        revision=pulumi.get(__ret__, 'revision'),
        server=pulumi.get(__ret__, 'server'),
        version=pulumi.get(__ret__, 'version'))


@_utilities.lift_output_func(get_agent_config)
def get_agent_config_output(opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetAgentConfigResult]:
    """
    > **Note:** The `get_agent_config` resource differs from [`get_agent_self`](https://www.terraform.io/docs/providers/consul/d/agent_self.html),
    providing less information but utilizing stable APIs. `get_agent_self` will be
    deprecated in a future release.

    The `get_agent_config` data source returns
    [configuration data](https://www.consul.io/api/agent.html#read-configuration)
    from the agent specified in the `provider`.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_consul as consul

    remote_agent = consul.get_agent_config()
    pulumi.export("consulVersion", remote_agent.version)
    ```
    """
    ...
