# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetConfigEntryResult',
    'AwaitableGetConfigEntryResult',
    'get_config_entry',
    'get_config_entry_output',
]

@pulumi.output_type
class GetConfigEntryResult:
    """
    A collection of values returned by getConfigEntry.
    """
    def __init__(__self__, config_json=None, id=None, kind=None, name=None, namespace=None, partition=None):
        if config_json and not isinstance(config_json, str):
            raise TypeError("Expected argument 'config_json' to be a str")
        pulumi.set(__self__, "config_json", config_json)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if kind and not isinstance(kind, str):
            raise TypeError("Expected argument 'kind' to be a str")
        pulumi.set(__self__, "kind", kind)
        if name and not isinstance(name, str):
            raise TypeError("Expected argument 'name' to be a str")
        pulumi.set(__self__, "name", name)
        if namespace and not isinstance(namespace, str):
            raise TypeError("Expected argument 'namespace' to be a str")
        pulumi.set(__self__, "namespace", namespace)
        if partition and not isinstance(partition, str):
            raise TypeError("Expected argument 'partition' to be a str")
        pulumi.set(__self__, "partition", partition)

    @property
    @pulumi.getter(name="configJson")
    def config_json(self) -> str:
        """
        The configuration of the config entry.
        """
        return pulumi.get(self, "config_json")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def kind(self) -> str:
        """
        The kind of config entry to read.
        """
        return pulumi.get(self, "kind")

    @property
    @pulumi.getter
    def name(self) -> str:
        """
        The name of the config entry to read.
        """
        return pulumi.get(self, "name")

    @property
    @pulumi.getter
    def namespace(self) -> Optional[str]:
        """
        The namespace the config entry is associated with.
        """
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def partition(self) -> Optional[str]:
        """
        The partition the config entry is associated with.
        """
        return pulumi.get(self, "partition")


class AwaitableGetConfigEntryResult(GetConfigEntryResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetConfigEntryResult(
            config_json=self.config_json,
            id=self.id,
            kind=self.kind,
            name=self.name,
            namespace=self.namespace,
            partition=self.partition)


def get_config_entry(kind: Optional[str] = None,
                     name: Optional[str] = None,
                     namespace: Optional[str] = None,
                     partition: Optional[str] = None,
                     opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetConfigEntryResult:
    """
    Use this data source to access information about an existing resource.

    :param str kind: The kind of config entry to read.
    :param str name: The name of the config entry to read.
    :param str namespace: The namespace the config entry is associated with.
    :param str partition: The partition the config entry is associated with.
    """
    __args__ = dict()
    __args__['kind'] = kind
    __args__['name'] = name
    __args__['namespace'] = namespace
    __args__['partition'] = partition
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('consul:index/getConfigEntry:getConfigEntry', __args__, opts=opts, typ=GetConfigEntryResult).value

    return AwaitableGetConfigEntryResult(
        config_json=pulumi.get(__ret__, 'config_json'),
        id=pulumi.get(__ret__, 'id'),
        kind=pulumi.get(__ret__, 'kind'),
        name=pulumi.get(__ret__, 'name'),
        namespace=pulumi.get(__ret__, 'namespace'),
        partition=pulumi.get(__ret__, 'partition'))


@_utilities.lift_output_func(get_config_entry)
def get_config_entry_output(kind: Optional[pulumi.Input[str]] = None,
                            name: Optional[pulumi.Input[str]] = None,
                            namespace: Optional[pulumi.Input[Optional[str]]] = None,
                            partition: Optional[pulumi.Input[Optional[str]]] = None,
                            opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetConfigEntryResult]:
    """
    Use this data source to access information about an existing resource.

    :param str kind: The kind of config entry to read.
    :param str name: The name of the config entry to read.
    :param str namespace: The namespace the config entry is associated with.
    :param str partition: The partition the config entry is associated with.
    """
    ...
