# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = [
    'GetDatacentersResult',
    'AwaitableGetDatacentersResult',
    'get_datacenters',
    'get_datacenters_output',
]

@pulumi.output_type
class GetDatacentersResult:
    """
    A collection of values returned by getDatacenters.
    """
    def __init__(__self__, datacenters=None, id=None):
        if datacenters and not isinstance(datacenters, list):
            raise TypeError("Expected argument 'datacenters' to be a list")
        pulumi.set(__self__, "datacenters", datacenters)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)

    @property
    @pulumi.getter
    def datacenters(self) -> Sequence[str]:
        """
        The list of datacenters known. The datacenters will be sorted
        in ascending order based on the estimated median round trip time from the server
        to the servers in that datacenter.
        """
        return pulumi.get(self, "datacenters")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")


class AwaitableGetDatacentersResult(GetDatacentersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetDatacentersResult(
            datacenters=self.datacenters,
            id=self.id)


def get_datacenters(opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetDatacentersResult:
    """
    The `get_datacenters` data source returns the list of all knwown Consul
    datacenters.
    """
    __args__ = dict()
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('consul:index/getDatacenters:getDatacenters', __args__, opts=opts, typ=GetDatacentersResult).value

    return AwaitableGetDatacentersResult(
        datacenters=pulumi.get(__ret__, 'datacenters'),
        id=pulumi.get(__ret__, 'id'))


@_utilities.lift_output_func(get_datacenters)
def get_datacenters_output(opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetDatacentersResult]:
    """
    The `get_datacenters` data source returns the list of all knwown Consul
    datacenters.
    """
    ...
