# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from . import outputs

__all__ = [
    'GetNetworkAreaMembersResult',
    'AwaitableGetNetworkAreaMembersResult',
    'get_network_area_members',
    'get_network_area_members_output',
]

@pulumi.output_type
class GetNetworkAreaMembersResult:
    """
    A collection of values returned by getNetworkAreaMembers.
    """
    def __init__(__self__, datacenter=None, id=None, members=None, token=None, uuid=None):
        if datacenter and not isinstance(datacenter, str):
            raise TypeError("Expected argument 'datacenter' to be a str")
        pulumi.set(__self__, "datacenter", datacenter)
        if id and not isinstance(id, str):
            raise TypeError("Expected argument 'id' to be a str")
        pulumi.set(__self__, "id", id)
        if members and not isinstance(members, list):
            raise TypeError("Expected argument 'members' to be a list")
        pulumi.set(__self__, "members", members)
        if token and not isinstance(token, str):
            raise TypeError("Expected argument 'token' to be a str")
        pulumi.set(__self__, "token", token)
        if uuid and not isinstance(uuid, str):
            raise TypeError("Expected argument 'uuid' to be a str")
        pulumi.set(__self__, "uuid", uuid)

    @property
    @pulumi.getter
    def datacenter(self) -> str:
        """
        The node's Consul datacenter.
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter
    def id(self) -> str:
        """
        The provider-assigned unique ID for this managed resource.
        """
        return pulumi.get(self, "id")

    @property
    @pulumi.getter
    def members(self) -> Sequence['outputs.GetNetworkAreaMembersMemberResult']:
        """
        The list of Consul servers in this network area
        """
        return pulumi.get(self, "members")

    @property
    @pulumi.getter
    def token(self) -> Optional[str]:
        warnings.warn("""The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""", DeprecationWarning)
        pulumi.log.warn("""token is deprecated: The token argument has been deprecated and will be removed in a future release.
Please use the token argument in the provider configuration""")

        return pulumi.get(self, "token")

    @property
    @pulumi.getter
    def uuid(self) -> str:
        """
        The UUID of the Network Area being queried.
        """
        return pulumi.get(self, "uuid")


class AwaitableGetNetworkAreaMembersResult(GetNetworkAreaMembersResult):
    # pylint: disable=using-constant-test
    def __await__(self):
        if False:
            yield self
        return GetNetworkAreaMembersResult(
            datacenter=self.datacenter,
            id=self.id,
            members=self.members,
            token=self.token,
            uuid=self.uuid)


def get_network_area_members(datacenter: Optional[str] = None,
                             token: Optional[str] = None,
                             uuid: Optional[str] = None,
                             opts: Optional[pulumi.InvokeOptions] = None) -> AwaitableGetNetworkAreaMembersResult:
    """
    > **NOTE:** This feature requires [Consul Enterprise](https://www.consul.io/docs/enterprise/index.html).

    The `get_network_area_members` data source provides a list of the Consul
    servers present in a specific network area.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_consul as consul

    dc2_network_area = consul.NetworkArea("dc2",
        peer_datacenter="dc2",
        retry_joins=["1.2.3.4"],
        use_tls=True)
    dc2 = consul.get_network_area_members_output(uuid=dc2_network_area.id)
    pulumi.export("members", dc2.members)
    ```


    :param str datacenter: The datacenter to use. This overrides the
           agent's default datacenter and the datacenter in the provider setup.
    :param str token: The ACL token to use. This overrides the
           token that the agent provides by default.
    :param str uuid: The UUID of the area to list.
    """
    __args__ = dict()
    __args__['datacenter'] = datacenter
    __args__['token'] = token
    __args__['uuid'] = uuid
    opts = pulumi.InvokeOptions.merge(_utilities.get_invoke_opts_defaults(), opts)
    __ret__ = pulumi.runtime.invoke('consul:index/getNetworkAreaMembers:getNetworkAreaMembers', __args__, opts=opts, typ=GetNetworkAreaMembersResult).value

    return AwaitableGetNetworkAreaMembersResult(
        datacenter=pulumi.get(__ret__, 'datacenter'),
        id=pulumi.get(__ret__, 'id'),
        members=pulumi.get(__ret__, 'members'),
        token=pulumi.get(__ret__, 'token'),
        uuid=pulumi.get(__ret__, 'uuid'))


@_utilities.lift_output_func(get_network_area_members)
def get_network_area_members_output(datacenter: Optional[pulumi.Input[Optional[str]]] = None,
                                    token: Optional[pulumi.Input[Optional[str]]] = None,
                                    uuid: Optional[pulumi.Input[str]] = None,
                                    opts: Optional[pulumi.InvokeOptions] = None) -> pulumi.Output[GetNetworkAreaMembersResult]:
    """
    > **NOTE:** This feature requires [Consul Enterprise](https://www.consul.io/docs/enterprise/index.html).

    The `get_network_area_members` data source provides a list of the Consul
    servers present in a specific network area.

    ## Example Usage

    ```python
    import pulumi
    import pulumi_consul as consul

    dc2_network_area = consul.NetworkArea("dc2",
        peer_datacenter="dc2",
        retry_joins=["1.2.3.4"],
        use_tls=True)
    dc2 = consul.get_network_area_members_output(uuid=dc2_network_area.id)
    pulumi.export("members", dc2.members)
    ```


    :param str datacenter: The datacenter to use. This overrides the
           agent's default datacenter and the datacenter in the provider setup.
    :param str token: The ACL token to use. This overrides the
           token that the agent provides by default.
    :param str uuid: The UUID of the area to list.
    """
    ...
