# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities

__all__ = ['PeeringArgs', 'Peering']

@pulumi.input_type
class PeeringArgs:
    def __init__(__self__, *,
                 peer_name: pulumi.Input[str],
                 peering_token: pulumi.Input[str],
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 partition: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Peering resource.
        :param pulumi.Input[str] peer_name: The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        :param pulumi.Input[str] peering_token: The peering token fetched from the peer cluster.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] meta: Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        """
        pulumi.set(__self__, "peer_name", peer_name)
        pulumi.set(__self__, "peering_token", peering_token)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)

    @property
    @pulumi.getter(name="peerName")
    def peer_name(self) -> pulumi.Input[str]:
        """
        The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        """
        return pulumi.get(self, "peer_name")

    @peer_name.setter
    def peer_name(self, value: pulumi.Input[str]):
        pulumi.set(self, "peer_name", value)

    @property
    @pulumi.getter(name="peeringToken")
    def peering_token(self) -> pulumi.Input[str]:
        """
        The peering token fetched from the peer cluster.
        """
        return pulumi.get(self, "peering_token")

    @peering_token.setter
    def peering_token(self, value: pulumi.Input[str]):
        pulumi.set(self, "peering_token", value)

    @property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "meta", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition", value)


@pulumi.input_type
class _PeeringState:
    def __init__(__self__, *,
                 deleted_at: Optional[pulumi.Input[str]] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 peer_ca_pems: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 peer_id: Optional[pulumi.Input[str]] = None,
                 peer_name: Optional[pulumi.Input[str]] = None,
                 peer_server_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
                 peer_server_name: Optional[pulumi.Input[str]] = None,
                 peering_token: Optional[pulumi.Input[str]] = None,
                 state: Optional[pulumi.Input[str]] = None):
        """
        Input properties used for looking up and filtering Peering resources.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] meta: Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        :param pulumi.Input[str] peer_name: The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        :param pulumi.Input[str] peering_token: The peering token fetched from the peer cluster.
        """
        if deleted_at is not None:
            pulumi.set(__self__, "deleted_at", deleted_at)
        if meta is not None:
            pulumi.set(__self__, "meta", meta)
        if partition is not None:
            pulumi.set(__self__, "partition", partition)
        if peer_ca_pems is not None:
            pulumi.set(__self__, "peer_ca_pems", peer_ca_pems)
        if peer_id is not None:
            pulumi.set(__self__, "peer_id", peer_id)
        if peer_name is not None:
            pulumi.set(__self__, "peer_name", peer_name)
        if peer_server_addresses is not None:
            pulumi.set(__self__, "peer_server_addresses", peer_server_addresses)
        if peer_server_name is not None:
            pulumi.set(__self__, "peer_server_name", peer_server_name)
        if peering_token is not None:
            pulumi.set(__self__, "peering_token", peering_token)
        if state is not None:
            pulumi.set(__self__, "state", state)

    @property
    @pulumi.getter(name="deletedAt")
    def deleted_at(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "deleted_at")

    @deleted_at.setter
    def deleted_at(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "deleted_at", value)

    @property
    @pulumi.getter
    def meta(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]:
        """
        Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        """
        return pulumi.get(self, "meta")

    @meta.setter
    def meta(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]]):
        pulumi.set(self, "meta", value)

    @property
    @pulumi.getter
    def partition(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "partition")

    @partition.setter
    def partition(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "partition", value)

    @property
    @pulumi.getter(name="peerCaPems")
    def peer_ca_pems(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "peer_ca_pems")

    @peer_ca_pems.setter
    def peer_ca_pems(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "peer_ca_pems", value)

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "peer_id")

    @peer_id.setter
    def peer_id(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_id", value)

    @property
    @pulumi.getter(name="peerName")
    def peer_name(self) -> Optional[pulumi.Input[str]]:
        """
        The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        """
        return pulumi.get(self, "peer_name")

    @peer_name.setter
    def peer_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_name", value)

    @property
    @pulumi.getter(name="peerServerAddresses")
    def peer_server_addresses(self) -> Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]:
        return pulumi.get(self, "peer_server_addresses")

    @peer_server_addresses.setter
    def peer_server_addresses(self, value: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]]):
        pulumi.set(self, "peer_server_addresses", value)

    @property
    @pulumi.getter(name="peerServerName")
    def peer_server_name(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "peer_server_name")

    @peer_server_name.setter
    def peer_server_name(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peer_server_name", value)

    @property
    @pulumi.getter(name="peeringToken")
    def peering_token(self) -> Optional[pulumi.Input[str]]:
        """
        The peering token fetched from the peer cluster.
        """
        return pulumi.get(self, "peering_token")

    @peering_token.setter
    def peering_token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "peering_token", value)

    @property
    @pulumi.getter
    def state(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "state")

    @state.setter
    def state(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "state", value)


class Peering(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 peer_name: Optional[pulumi.Input[str]] = None,
                 peering_token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        [Cluster Peering](https://www.consul.io/docs/connect/cluster-peering) can be used to create connections between two or more independent clusters so that services deployed to different partitions or datacenters can communicate.

        The `cluster_peering` resource can be used to establish the peering after a peering token has been generated.

        > **Cluster peering is currently in technical preview:** Functionality associated with cluster peering is subject to change. You should never use the technical preview release in secure environments or production scenarios. Features in technical preview may have performance issues, scaling issues, and limited support.

        The functionality described here is available only in Consul version 1.13.0 and later.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        eu_us = consul.PeeringToken("eu-us", peer_name="eu-cluster")
        eu_us_peering = consul.Peering("eu-us",
            peer_name="eu-cluster",
            peering_token=token["peeringToken"],
            meta={
                "hello": "world",
            })
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] meta: Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        :param pulumi.Input[str] peer_name: The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        :param pulumi.Input[str] peering_token: The peering token fetched from the peer cluster.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: PeeringArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        [Cluster Peering](https://www.consul.io/docs/connect/cluster-peering) can be used to create connections between two or more independent clusters so that services deployed to different partitions or datacenters can communicate.

        The `cluster_peering` resource can be used to establish the peering after a peering token has been generated.

        > **Cluster peering is currently in technical preview:** Functionality associated with cluster peering is subject to change. You should never use the technical preview release in secure environments or production scenarios. Features in technical preview may have performance issues, scaling issues, and limited support.

        The functionality described here is available only in Consul version 1.13.0 and later.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_consul as consul

        eu_us = consul.PeeringToken("eu-us", peer_name="eu-cluster")
        eu_us_peering = consul.Peering("eu-us",
            peer_name="eu-cluster",
            peering_token=token["peeringToken"],
            meta={
                "hello": "world",
            })
        ```

        :param str resource_name: The name of the resource.
        :param PeeringArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(PeeringArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
                 partition: Optional[pulumi.Input[str]] = None,
                 peer_name: Optional[pulumi.Input[str]] = None,
                 peering_token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = PeeringArgs.__new__(PeeringArgs)

            __props__.__dict__["meta"] = meta
            __props__.__dict__["partition"] = partition
            if peer_name is None and not opts.urn:
                raise TypeError("Missing required property 'peer_name'")
            __props__.__dict__["peer_name"] = peer_name
            if peering_token is None and not opts.urn:
                raise TypeError("Missing required property 'peering_token'")
            __props__.__dict__["peering_token"] = None if peering_token is None else pulumi.Output.secret(peering_token)
            __props__.__dict__["deleted_at"] = None
            __props__.__dict__["peer_ca_pems"] = None
            __props__.__dict__["peer_id"] = None
            __props__.__dict__["peer_server_addresses"] = None
            __props__.__dict__["peer_server_name"] = None
            __props__.__dict__["state"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["peeringToken"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Peering, __self__).__init__(
            'consul:index/peering:Peering',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            deleted_at: Optional[pulumi.Input[str]] = None,
            meta: Optional[pulumi.Input[Mapping[str, pulumi.Input[str]]]] = None,
            partition: Optional[pulumi.Input[str]] = None,
            peer_ca_pems: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            peer_id: Optional[pulumi.Input[str]] = None,
            peer_name: Optional[pulumi.Input[str]] = None,
            peer_server_addresses: Optional[pulumi.Input[Sequence[pulumi.Input[str]]]] = None,
            peer_server_name: Optional[pulumi.Input[str]] = None,
            peering_token: Optional[pulumi.Input[str]] = None,
            state: Optional[pulumi.Input[str]] = None) -> 'Peering':
        """
        Get an existing Peering resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[str]]] meta: Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        :param pulumi.Input[str] peer_name: The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        :param pulumi.Input[str] peering_token: The peering token fetched from the peer cluster.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _PeeringState.__new__(_PeeringState)

        __props__.__dict__["deleted_at"] = deleted_at
        __props__.__dict__["meta"] = meta
        __props__.__dict__["partition"] = partition
        __props__.__dict__["peer_ca_pems"] = peer_ca_pems
        __props__.__dict__["peer_id"] = peer_id
        __props__.__dict__["peer_name"] = peer_name
        __props__.__dict__["peer_server_addresses"] = peer_server_addresses
        __props__.__dict__["peer_server_name"] = peer_server_name
        __props__.__dict__["peering_token"] = peering_token
        __props__.__dict__["state"] = state
        return Peering(resource_name, opts=opts, __props__=__props__)

    @property
    @pulumi.getter(name="deletedAt")
    def deleted_at(self) -> pulumi.Output[str]:
        return pulumi.get(self, "deleted_at")

    @property
    @pulumi.getter
    def meta(self) -> pulumi.Output[Optional[Mapping[str, str]]]:
        """
        Specifies KV metadata to associate with the peering. This parameter is not required and does not directly impact the cluster peering process.
        """
        return pulumi.get(self, "meta")

    @property
    @pulumi.getter
    def partition(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "partition")

    @property
    @pulumi.getter(name="peerCaPems")
    def peer_ca_pems(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "peer_ca_pems")

    @property
    @pulumi.getter(name="peerId")
    def peer_id(self) -> pulumi.Output[str]:
        return pulumi.get(self, "peer_id")

    @property
    @pulumi.getter(name="peerName")
    def peer_name(self) -> pulumi.Output[str]:
        """
        The name assigned to the peer cluster. The `peer_name` is used to reference the peer cluster in service discovery queries and configuration entries such as `service-intentions`. This field must be a valid DNS hostname label.
        """
        return pulumi.get(self, "peer_name")

    @property
    @pulumi.getter(name="peerServerAddresses")
    def peer_server_addresses(self) -> pulumi.Output[Sequence[str]]:
        return pulumi.get(self, "peer_server_addresses")

    @property
    @pulumi.getter(name="peerServerName")
    def peer_server_name(self) -> pulumi.Output[str]:
        return pulumi.get(self, "peer_server_name")

    @property
    @pulumi.getter(name="peeringToken")
    def peering_token(self) -> pulumi.Output[str]:
        """
        The peering token fetched from the peer cluster.
        """
        return pulumi.get(self, "peering_token")

    @property
    @pulumi.getter
    def state(self) -> pulumi.Output[str]:
        return pulumi.get(self, "state")

