# coding=utf-8
# *** WARNING: this file was generated by the Pulumi Terraform Bridge (tfgen) Tool. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import copy
import warnings
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
from . import _utilities
from ._inputs import *

__all__ = ['ProviderArgs', 'Provider']

@pulumi.input_type
class ProviderArgs:
    def __init__(__self__, *,
                 address: Optional[pulumi.Input[str]] = None,
                 auth_jwt: Optional[pulumi.Input['ProviderAuthJwtArgs']] = None,
                 ca_file: Optional[pulumi.Input[str]] = None,
                 ca_path: Optional[pulumi.Input[str]] = None,
                 ca_pem: Optional[pulumi.Input[str]] = None,
                 cert_file: Optional[pulumi.Input[str]] = None,
                 cert_pem: Optional[pulumi.Input[str]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]] = None,
                 http_auth: Optional[pulumi.Input[str]] = None,
                 insecure_https: Optional[pulumi.Input[bool]] = None,
                 key_file: Optional[pulumi.Input[str]] = None,
                 key_pem: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 scheme: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None):
        """
        The set of arguments for constructing a Provider resource.
        :param pulumi.Input[str] address: The HTTP(S) API address of the agent to use. Defaults to "127.0.0.1:8500".
        :param pulumi.Input['ProviderAuthJwtArgs'] auth_jwt: Authenticates to Consul using a JWT authentication method.
        :param pulumi.Input[str] ca_file: A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param pulumi.Input[str] ca_path: A path to a directory of PEM-encoded certificate authority files to use to check the authenticity of client and server
               connections. Can also be specified with the `CONSUL_CAPATH` environment variable.
        :param pulumi.Input[str] ca_pem: PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param pulumi.Input[str] cert_file: A path to a PEM-encoded certificate provided to the remote agent; requires use of `key_file` or `key_pem`.
        :param pulumi.Input[str] cert_pem: PEM-encoded certificate provided to the remote agent; requires use of `key_file` or `key_pem`.
        :param pulumi.Input[str] datacenter: The datacenter to use. Defaults to that of the agent.
        :param pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]] headers: A configuration block, described below, that provides additional headers to be sent along with all requests to the
               Consul server. This block can be specified multiple times.
        :param pulumi.Input[str] http_auth: HTTP Basic Authentication credentials to be used when communicating with Consul, in the format of either `user` or
               `user:pass`. This may also be specified using the `CONSUL_HTTP_AUTH` environment variable.
        :param pulumi.Input[bool] insecure_https: Boolean value to disable SSL certificate verification; setting this value to true is not recommended for production use.
               Only use this with scheme set to "https".
        :param pulumi.Input[str] key_file: A path to a PEM-encoded private key, required if `cert_file` or `cert_pem` is specified.
        :param pulumi.Input[str] key_pem: PEM-encoded private key, required if `cert_file` or `cert_pem` is specified.
        :param pulumi.Input[str] scheme: The URL scheme of the agent to use ("http" or "https"). Defaults to "http".
        :param pulumi.Input[str] token: The ACL token to use by default when making requests to the agent. Can also be specified with `CONSUL_HTTP_TOKEN` or
               `CONSUL_TOKEN` as an environment variable.
        """
        if address is not None:
            pulumi.set(__self__, "address", address)
        if auth_jwt is not None:
            pulumi.set(__self__, "auth_jwt", auth_jwt)
        if ca_file is not None:
            pulumi.set(__self__, "ca_file", ca_file)
        if ca_path is not None:
            pulumi.set(__self__, "ca_path", ca_path)
        if ca_pem is not None:
            pulumi.set(__self__, "ca_pem", ca_pem)
        if cert_file is not None:
            pulumi.set(__self__, "cert_file", cert_file)
        if cert_pem is not None:
            pulumi.set(__self__, "cert_pem", cert_pem)
        if datacenter is not None:
            pulumi.set(__self__, "datacenter", datacenter)
        if headers is not None:
            pulumi.set(__self__, "headers", headers)
        if http_auth is not None:
            pulumi.set(__self__, "http_auth", http_auth)
        if insecure_https is not None:
            pulumi.set(__self__, "insecure_https", insecure_https)
        if key_file is not None:
            pulumi.set(__self__, "key_file", key_file)
        if key_pem is not None:
            pulumi.set(__self__, "key_pem", key_pem)
        if namespace is not None:
            pulumi.set(__self__, "namespace", namespace)
        if scheme is not None:
            pulumi.set(__self__, "scheme", scheme)
        if token is not None:
            pulumi.set(__self__, "token", token)

    @property
    @pulumi.getter
    def address(self) -> Optional[pulumi.Input[str]]:
        """
        The HTTP(S) API address of the agent to use. Defaults to "127.0.0.1:8500".
        """
        return pulumi.get(self, "address")

    @address.setter
    def address(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "address", value)

    @property
    @pulumi.getter(name="authJwt")
    def auth_jwt(self) -> Optional[pulumi.Input['ProviderAuthJwtArgs']]:
        """
        Authenticates to Consul using a JWT authentication method.
        """
        return pulumi.get(self, "auth_jwt")

    @auth_jwt.setter
    def auth_jwt(self, value: Optional[pulumi.Input['ProviderAuthJwtArgs']]):
        pulumi.set(self, "auth_jwt", value)

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> Optional[pulumi.Input[str]]:
        """
        A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return pulumi.get(self, "ca_file")

    @ca_file.setter
    def ca_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_file", value)

    @property
    @pulumi.getter(name="caPath")
    def ca_path(self) -> Optional[pulumi.Input[str]]:
        """
        A path to a directory of PEM-encoded certificate authority files to use to check the authenticity of client and server
        connections. Can also be specified with the `CONSUL_CAPATH` environment variable.
        """
        return pulumi.get(self, "ca_path")

    @ca_path.setter
    def ca_path(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_path", value)

    @property
    @pulumi.getter(name="caPem")
    def ca_pem(self) -> Optional[pulumi.Input[str]]:
        """
        PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return pulumi.get(self, "ca_pem")

    @ca_pem.setter
    def ca_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "ca_pem", value)

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> Optional[pulumi.Input[str]]:
        """
        A path to a PEM-encoded certificate provided to the remote agent; requires use of `key_file` or `key_pem`.
        """
        return pulumi.get(self, "cert_file")

    @cert_file.setter
    def cert_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_file", value)

    @property
    @pulumi.getter(name="certPem")
    def cert_pem(self) -> Optional[pulumi.Input[str]]:
        """
        PEM-encoded certificate provided to the remote agent; requires use of `key_file` or `key_pem`.
        """
        return pulumi.get(self, "cert_pem")

    @cert_pem.setter
    def cert_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "cert_pem", value)

    @property
    @pulumi.getter
    def datacenter(self) -> Optional[pulumi.Input[str]]:
        """
        The datacenter to use. Defaults to that of the agent.
        """
        return pulumi.get(self, "datacenter")

    @datacenter.setter
    def datacenter(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "datacenter", value)

    @property
    @pulumi.getter
    def headers(self) -> Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]]:
        """
        A configuration block, described below, that provides additional headers to be sent along with all requests to the
        Consul server. This block can be specified multiple times.
        """
        return pulumi.get(self, "headers")

    @headers.setter
    def headers(self, value: Optional[pulumi.Input[Sequence[pulumi.Input['ProviderHeaderArgs']]]]):
        pulumi.set(self, "headers", value)

    @property
    @pulumi.getter(name="httpAuth")
    def http_auth(self) -> Optional[pulumi.Input[str]]:
        """
        HTTP Basic Authentication credentials to be used when communicating with Consul, in the format of either `user` or
        `user:pass`. This may also be specified using the `CONSUL_HTTP_AUTH` environment variable.
        """
        return pulumi.get(self, "http_auth")

    @http_auth.setter
    def http_auth(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "http_auth", value)

    @property
    @pulumi.getter(name="insecureHttps")
    def insecure_https(self) -> Optional[pulumi.Input[bool]]:
        """
        Boolean value to disable SSL certificate verification; setting this value to true is not recommended for production use.
        Only use this with scheme set to "https".
        """
        return pulumi.get(self, "insecure_https")

    @insecure_https.setter
    def insecure_https(self, value: Optional[pulumi.Input[bool]]):
        pulumi.set(self, "insecure_https", value)

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> Optional[pulumi.Input[str]]:
        """
        A path to a PEM-encoded private key, required if `cert_file` or `cert_pem` is specified.
        """
        return pulumi.get(self, "key_file")

    @key_file.setter
    def key_file(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_file", value)

    @property
    @pulumi.getter(name="keyPem")
    def key_pem(self) -> Optional[pulumi.Input[str]]:
        """
        PEM-encoded private key, required if `cert_file` or `cert_pem` is specified.
        """
        return pulumi.get(self, "key_pem")

    @key_pem.setter
    def key_pem(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "key_pem", value)

    @property
    @pulumi.getter
    def namespace(self) -> Optional[pulumi.Input[str]]:
        return pulumi.get(self, "namespace")

    @namespace.setter
    def namespace(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "namespace", value)

    @property
    @pulumi.getter
    def scheme(self) -> Optional[pulumi.Input[str]]:
        """
        The URL scheme of the agent to use ("http" or "https"). Defaults to "http".
        """
        return pulumi.get(self, "scheme")

    @scheme.setter
    def scheme(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "scheme", value)

    @property
    @pulumi.getter
    def token(self) -> Optional[pulumi.Input[str]]:
        """
        The ACL token to use by default when making requests to the agent. Can also be specified with `CONSUL_HTTP_TOKEN` or
        `CONSUL_TOKEN` as an environment variable.
        """
        return pulumi.get(self, "token")

    @token.setter
    def token(self, value: Optional[pulumi.Input[str]]):
        pulumi.set(self, "token", value)


class Provider(pulumi.ProviderResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 auth_jwt: Optional[pulumi.Input[pulumi.InputType['ProviderAuthJwtArgs']]] = None,
                 ca_file: Optional[pulumi.Input[str]] = None,
                 ca_path: Optional[pulumi.Input[str]] = None,
                 ca_pem: Optional[pulumi.Input[str]] = None,
                 cert_file: Optional[pulumi.Input[str]] = None,
                 cert_pem: Optional[pulumi.Input[str]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProviderHeaderArgs']]]]] = None,
                 http_auth: Optional[pulumi.Input[str]] = None,
                 insecure_https: Optional[pulumi.Input[bool]] = None,
                 key_file: Optional[pulumi.Input[str]] = None,
                 key_pem: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 scheme: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        """
        The provider type for the consul package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[str] address: The HTTP(S) API address of the agent to use. Defaults to "127.0.0.1:8500".
        :param pulumi.Input[pulumi.InputType['ProviderAuthJwtArgs']] auth_jwt: Authenticates to Consul using a JWT authentication method.
        :param pulumi.Input[str] ca_file: A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param pulumi.Input[str] ca_path: A path to a directory of PEM-encoded certificate authority files to use to check the authenticity of client and server
               connections. Can also be specified with the `CONSUL_CAPATH` environment variable.
        :param pulumi.Input[str] ca_pem: PEM-encoded certificate authority used to verify the remote agent's certificate.
        :param pulumi.Input[str] cert_file: A path to a PEM-encoded certificate provided to the remote agent; requires use of `key_file` or `key_pem`.
        :param pulumi.Input[str] cert_pem: PEM-encoded certificate provided to the remote agent; requires use of `key_file` or `key_pem`.
        :param pulumi.Input[str] datacenter: The datacenter to use. Defaults to that of the agent.
        :param pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProviderHeaderArgs']]]] headers: A configuration block, described below, that provides additional headers to be sent along with all requests to the
               Consul server. This block can be specified multiple times.
        :param pulumi.Input[str] http_auth: HTTP Basic Authentication credentials to be used when communicating with Consul, in the format of either `user` or
               `user:pass`. This may also be specified using the `CONSUL_HTTP_AUTH` environment variable.
        :param pulumi.Input[bool] insecure_https: Boolean value to disable SSL certificate verification; setting this value to true is not recommended for production use.
               Only use this with scheme set to "https".
        :param pulumi.Input[str] key_file: A path to a PEM-encoded private key, required if `cert_file` or `cert_pem` is specified.
        :param pulumi.Input[str] key_pem: PEM-encoded private key, required if `cert_file` or `cert_pem` is specified.
        :param pulumi.Input[str] scheme: The URL scheme of the agent to use ("http" or "https"). Defaults to "http".
        :param pulumi.Input[str] token: The ACL token to use by default when making requests to the agent. Can also be specified with `CONSUL_HTTP_TOKEN` or
               `CONSUL_TOKEN` as an environment variable.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: Optional[ProviderArgs] = None,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The provider type for the consul package. By default, resources use package-wide configuration
        settings, however an explicit `Provider` instance may be created and passed during resource
        construction to achieve fine-grained programmatic control over provider settings. See the
        [documentation](https://www.pulumi.com/docs/reference/programming-model/#providers) for more information.

        :param str resource_name: The name of the resource.
        :param ProviderArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(ProviderArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 address: Optional[pulumi.Input[str]] = None,
                 auth_jwt: Optional[pulumi.Input[pulumi.InputType['ProviderAuthJwtArgs']]] = None,
                 ca_file: Optional[pulumi.Input[str]] = None,
                 ca_path: Optional[pulumi.Input[str]] = None,
                 ca_pem: Optional[pulumi.Input[str]] = None,
                 cert_file: Optional[pulumi.Input[str]] = None,
                 cert_pem: Optional[pulumi.Input[str]] = None,
                 datacenter: Optional[pulumi.Input[str]] = None,
                 headers: Optional[pulumi.Input[Sequence[pulumi.Input[pulumi.InputType['ProviderHeaderArgs']]]]] = None,
                 http_auth: Optional[pulumi.Input[str]] = None,
                 insecure_https: Optional[pulumi.Input[bool]] = None,
                 key_file: Optional[pulumi.Input[str]] = None,
                 key_pem: Optional[pulumi.Input[str]] = None,
                 namespace: Optional[pulumi.Input[str]] = None,
                 scheme: Optional[pulumi.Input[str]] = None,
                 token: Optional[pulumi.Input[str]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = ProviderArgs.__new__(ProviderArgs)

            __props__.__dict__["address"] = address
            __props__.__dict__["auth_jwt"] = pulumi.Output.from_input(auth_jwt).apply(pulumi.runtime.to_json) if auth_jwt is not None else None
            __props__.__dict__["ca_file"] = ca_file
            __props__.__dict__["ca_path"] = ca_path
            __props__.__dict__["ca_pem"] = ca_pem
            __props__.__dict__["cert_file"] = cert_file
            __props__.__dict__["cert_pem"] = cert_pem
            __props__.__dict__["datacenter"] = datacenter
            __props__.__dict__["headers"] = pulumi.Output.secret(headers).apply(pulumi.runtime.to_json) if headers is not None else None
            __props__.__dict__["http_auth"] = http_auth
            __props__.__dict__["insecure_https"] = pulumi.Output.from_input(insecure_https).apply(pulumi.runtime.to_json) if insecure_https is not None else None
            __props__.__dict__["key_file"] = key_file
            __props__.__dict__["key_pem"] = key_pem
            __props__.__dict__["namespace"] = namespace
            __props__.__dict__["scheme"] = scheme
            __props__.__dict__["token"] = None if token is None else pulumi.Output.secret(token)
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["token"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(Provider, __self__).__init__(
            'consul',
            resource_name,
            __props__,
            opts)

    @property
    @pulumi.getter
    def address(self) -> pulumi.Output[Optional[str]]:
        """
        The HTTP(S) API address of the agent to use. Defaults to "127.0.0.1:8500".
        """
        return pulumi.get(self, "address")

    @property
    @pulumi.getter(name="caFile")
    def ca_file(self) -> pulumi.Output[Optional[str]]:
        """
        A path to a PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return pulumi.get(self, "ca_file")

    @property
    @pulumi.getter(name="caPath")
    def ca_path(self) -> pulumi.Output[Optional[str]]:
        """
        A path to a directory of PEM-encoded certificate authority files to use to check the authenticity of client and server
        connections. Can also be specified with the `CONSUL_CAPATH` environment variable.
        """
        return pulumi.get(self, "ca_path")

    @property
    @pulumi.getter(name="caPem")
    def ca_pem(self) -> pulumi.Output[Optional[str]]:
        """
        PEM-encoded certificate authority used to verify the remote agent's certificate.
        """
        return pulumi.get(self, "ca_pem")

    @property
    @pulumi.getter(name="certFile")
    def cert_file(self) -> pulumi.Output[Optional[str]]:
        """
        A path to a PEM-encoded certificate provided to the remote agent; requires use of `key_file` or `key_pem`.
        """
        return pulumi.get(self, "cert_file")

    @property
    @pulumi.getter(name="certPem")
    def cert_pem(self) -> pulumi.Output[Optional[str]]:
        """
        PEM-encoded certificate provided to the remote agent; requires use of `key_file` or `key_pem`.
        """
        return pulumi.get(self, "cert_pem")

    @property
    @pulumi.getter
    def datacenter(self) -> pulumi.Output[Optional[str]]:
        """
        The datacenter to use. Defaults to that of the agent.
        """
        return pulumi.get(self, "datacenter")

    @property
    @pulumi.getter(name="httpAuth")
    def http_auth(self) -> pulumi.Output[Optional[str]]:
        """
        HTTP Basic Authentication credentials to be used when communicating with Consul, in the format of either `user` or
        `user:pass`. This may also be specified using the `CONSUL_HTTP_AUTH` environment variable.
        """
        return pulumi.get(self, "http_auth")

    @property
    @pulumi.getter(name="keyFile")
    def key_file(self) -> pulumi.Output[Optional[str]]:
        """
        A path to a PEM-encoded private key, required if `cert_file` or `cert_pem` is specified.
        """
        return pulumi.get(self, "key_file")

    @property
    @pulumi.getter(name="keyPem")
    def key_pem(self) -> pulumi.Output[Optional[str]]:
        """
        PEM-encoded private key, required if `cert_file` or `cert_pem` is specified.
        """
        return pulumi.get(self, "key_pem")

    @property
    @pulumi.getter
    def namespace(self) -> pulumi.Output[Optional[str]]:
        return pulumi.get(self, "namespace")

    @property
    @pulumi.getter
    def scheme(self) -> pulumi.Output[Optional[str]]:
        """
        The URL scheme of the agent to use ("http" or "https"). Defaults to "http".
        """
        return pulumi.get(self, "scheme")

    @property
    @pulumi.getter
    def token(self) -> pulumi.Output[Optional[str]]:
        """
        The ACL token to use by default when making requests to the agent. Can also be specified with `CONSUL_HTTP_TOKEN` or
        `CONSUL_TOKEN` as an environment variable.
        """
        return pulumi.get(self, "token")

