"""ryo3-fnv types"""

import typing as t

from ry._types import Buffer
from ry.ryo3._bytes import Bytes

@t.final
class FnvHasher:
    name: t.Literal["fnv1a"]
    digest_size: t.Literal[8]
    block_size: t.Literal[1]

    def __init__(self, data: Buffer | None = None, key: int | None = None) -> None: ...
    def update(self, data: Buffer) -> None: ...
    def digest(self) -> Bytes: ...
    def intdigest(self) -> int: ...
    def hexdigest(self) -> str: ...
    def copy(self) -> FnvHasher: ...

def fnv1a(data: Buffer | None = None, key: int | None = None) -> FnvHasher: ...
