"""
Color Palettes and Colorscales used in trajectory analysis Figures.

References:

    - Default trace color palette, chosen for visual distinctiveness and colorblind friendliness:
        Wong, B. (2011), Points of View: Color Blindness. Nature Methods,
        8(6), 441. https://doi.org/10.1038/nmeth.1618

    - The parula colorscale from MATLAB, used here in plotly Heatmaps:
        https://github.com/BIDS/colormap/blob/master/parula.py

"""

DEFAULT_TRACE_COLOR_PALETTE = [
    '#E69F00', # orange
    '#56B4E9', # sky blue
    '#009E73', # bluish green
    '#F0E442', # light yellow
    '#0072B2', # blue
    '#D55E00', # vermillion
    '#CC79C5', # lilac
]
"""Default color palette used for traces in plotly figures."""

PARULA_COLORSCALE = [[0.0, 'rgb(53, 42, 134)'],
                     [0.003937007874015748, 'rgb(53, 43, 138)'],
                     [0.007874015748031496, 'rgb(53, 45, 141)'],
                     [0.011811023622047244, 'rgb(53, 46, 144)'],
                     [0.015748031496062992, 'rgb(53, 48, 147)'],
                     [0.01968503937007874, 'rgb(54, 49, 150)'],
                     [0.023622047244094488, 'rgb(54, 51, 153)'],
                     [0.027559055118110236, 'rgb(54, 52, 156)'],
                     [0.031496062992125984, 'rgb(54, 54, 159)'],
                     [0.03543307086614173, 'rgb(53, 55, 162)'],
                     [0.03937007874015748, 'rgb(53, 57, 165)'],
                     [0.04330708661417323, 'rgb(53, 59, 169)'],
                     [0.047244094488188976, 'rgb(53, 60, 172)'],
                     [0.051181102362204724, 'rgb(52, 62, 175)'],
                     [0.05511811023622047, 'rgb(51, 63, 178)'],
                     [0.05905511811023622, 'rgb(50, 65, 181)'],
                     [0.06299212598425197, 'rgb(50, 67, 185)'],
                     [0.06692913385826771, 'rgb(48, 68, 188)'],
                     [0.07086614173228346, 'rgb(47, 70, 191)'],
                     [0.07480314960629922, 'rgb(45, 72, 194)'],
                     [0.07874015748031496, 'rgb(43, 74, 197)'],
                     [0.0826771653543307, 'rgb(41, 75, 201)'],
                     [0.08661417322834646, 'rgb(38, 78, 204)'],
                     [0.09055118110236221, 'rgb(35, 80, 207)'],
                     [0.09448818897637795, 'rgb(32, 82, 210)'],
                     [0.09842519685039369, 'rgb(28, 84, 213)'],
                     [0.10236220472440945, 'rgb(24, 86, 215)'],
                     [0.1062992125984252, 'rgb(20, 88, 218)'],
                     [0.11023622047244094, 'rgb(16, 91, 220)'],
                     [0.11417322834645668, 'rgb(13, 92, 221)'],
                     [0.11811023622047244, 'rgb(10, 94, 222)'],
                     [0.1220472440944882, 'rgb(7, 96, 223)'],
                     [0.12598425196850394, 'rgb(4, 98, 224)'],
                     [0.12992125984251968, 'rgb(2, 99, 224)'],
                     [0.13385826771653542, 'rgb(2, 100, 224)'],
                     [0.1377952755905512, 'rgb(2, 102, 225)'],
                     [0.14173228346456693, 'rgb(1, 103, 225)'],
                     [0.14566929133858267, 'rgb(1, 104, 224)'],
                     [0.14960629921259844, 'rgb(2, 105, 224)'],
                     [0.15354330708661418, 'rgb(3, 107, 224)'],
                     [0.15748031496062992, 'rgb(3, 108, 224)'],
                     [0.16141732283464566, 'rgb(4, 109, 223)'],
                     [0.1653543307086614, 'rgb(5, 110, 223)'],
                     [0.16929133858267717, 'rgb(6, 111, 222)'],
                     [0.1732283464566929, 'rgb(7, 112, 222)'],
                     [0.17716535433070865, 'rgb(8, 113, 222)'],
                     [0.18110236220472442, 'rgb(9, 114, 221)'],
                     [0.18503937007874016, 'rgb(11, 115, 221)'],
                     [0.1889763779527559, 'rgb(12, 116, 220)'],
                     [0.19291338582677164, 'rgb(13, 117, 220)'],
                     [0.19685039370078738, 'rgb(13, 118, 219)'],
                     [0.20078740157480315, 'rgb(14, 119, 219)'],
                     [0.2047244094488189, 'rgb(15, 120, 218)'],
                     [0.20866141732283464, 'rgb(16, 121, 217)'],
                     [0.2125984251968504, 'rgb(16, 122, 217)'],
                     [0.21653543307086615, 'rgb(17, 123, 216)'],
                     [0.2204724409448819, 'rgb(18, 123, 216)'],
                     [0.22440944881889763, 'rgb(18, 124, 215)'],
                     [0.22834645669291337, 'rgb(18, 125, 215)'],
                     [0.23228346456692914, 'rgb(19, 126, 214)'],
                     [0.23622047244094488, 'rgb(19, 127, 214)'],
                     [0.24015748031496062, 'rgb(19, 128, 213)'],
                     [0.2440944881889764, 'rgb(19, 129, 213)'],
                     [0.24803149606299213, 'rgb(20, 130, 212)'],
                     [0.25196850393700787, 'rgb(20, 131, 212)'],
                     [0.2559055118110236, 'rgb(20, 132, 211)'],
                     [0.25984251968503935, 'rgb(19, 133, 211)'],
                     [0.2637795275590551, 'rgb(19, 135, 211)'],
                     [0.26771653543307083, 'rgb(19, 136, 210)'],
                     [0.27165354330708663, 'rgb(18, 137, 210)'],
                     [0.2755905511811024, 'rgb(18, 138, 210)'],
                     [0.2795275590551181, 'rgb(17, 139, 210)'],
                     [0.28346456692913385, 'rgb(16, 140, 210)'],
                     [0.2874015748031496, 'rgb(16, 142, 210)'],
                     [0.29133858267716534, 'rgb(15, 143, 210)'],
                     [0.2952755905511811, 'rgb(14, 144, 209)'],
                     [0.2992125984251969, 'rgb(13, 146, 209)'],
                     [0.3031496062992126, 'rgb(12, 147, 209)'],
                     [0.30708661417322836, 'rgb(11, 148, 209)'],
                     [0.3110236220472441, 'rgb(10, 149, 209)'],
                     [0.31496062992125984, 'rgb(9, 150, 209)'],
                     [0.3188976377952756, 'rgb(8, 152, 209)'],
                     [0.3228346456692913, 'rgb(8, 153, 208)'],
                     [0.32677165354330706, 'rgb(7, 154, 208)'],
                     [0.3307086614173228, 'rgb(7, 155, 207)'],
                     [0.3346456692913386, 'rgb(6, 156, 207)'],
                     [0.33858267716535434, 'rgb(6, 157, 206)'],
                     [0.3425196850393701, 'rgb(6, 158, 206)'],
                     [0.3464566929133858, 'rgb(6, 159, 205)'],
                     [0.35039370078740156, 'rgb(6, 160, 204)'],
                     [0.3543307086614173, 'rgb(6, 161, 204)'],
                     [0.35826771653543305, 'rgb(5, 161, 203)'],
                     [0.36220472440944884, 'rgb(5, 162, 202)'],
                     [0.3661417322834646, 'rgb(5, 163, 201)'],
                     [0.3700787401574803, 'rgb(5, 164, 200)'],
                     [0.37401574803149606, 'rgb(5, 165, 200)'],
                     [0.3779527559055118, 'rgb(5, 165, 199)'],
                     [0.38188976377952755, 'rgb(5, 166, 198)'],
                     [0.3858267716535433, 'rgb(6, 167, 197)'],
                     [0.38976377952755903, 'rgb(6, 167, 196)'],
                     [0.39370078740157477, 'rgb(6, 168, 195)'],
                     [0.39763779527559057, 'rgb(6, 169, 194)'],
                     [0.4015748031496063, 'rgb(7, 169, 193)'],
                     [0.40551181102362205, 'rgb(8, 170, 192)'],
                     [0.4094488188976378, 'rgb(8, 171, 190)'],
                     [0.41338582677165353, 'rgb(9, 171, 189)'],
                     [0.41732283464566927, 'rgb(10, 172, 188)'],
                     [0.421259842519685, 'rgb(12, 172, 187)'],
                     [0.4251968503937008, 'rgb(13, 173, 186)'],
                     [0.42913385826771655, 'rgb(14, 174, 185)'],
                     [0.4330708661417323, 'rgb(16, 174, 184)'],
                     [0.43700787401574803, 'rgb(17, 175, 182)'],
                     [0.4409448818897638, 'rgb(19, 175, 181)'],
                     [0.4448818897637795, 'rgb(20, 176, 180)'],
                     [0.44881889763779526, 'rgb(22, 177, 179)'],
                     [0.452755905511811, 'rgb(24, 177, 177)'],
                     [0.45669291338582674, 'rgb(26, 178, 176)'],
                     [0.46062992125984253, 'rgb(28, 178, 175)'],
                     [0.4645669291338583, 'rgb(30, 179, 174)'],
                     [0.468503937007874, 'rgb(32, 179, 172)'],
                     [0.47244094488188976, 'rgb(34, 180, 171)'],
                     [0.4763779527559055, 'rgb(36, 180, 170)'],
                     [0.48031496062992124, 'rgb(38, 181, 168)'],
                     [0.484251968503937, 'rgb(40, 181, 167)'],
                     [0.4881889763779528, 'rgb(42, 182, 165)'],
                     [0.4921259842519685, 'rgb(44, 182, 164)'],
                     [0.49606299212598426, 'rgb(47, 183, 163)'],
                     [0.5, 'rgb(51, 184, 160)'],
                     [0.5039370078740157, 'rgb(54, 184, 158)'],
                     [0.5078740157480315, 'rgb(56, 185, 157)'],
                     [0.5118110236220472, 'rgb(59, 185, 155)'],
                     [0.515748031496063, 'rgb(61, 185, 154)'],
                     [0.5196850393700787, 'rgb(64, 186, 152)'],
                     [0.5236220472440944, 'rgb(67, 186, 151)'],
                     [0.5275590551181102, 'rgb(69, 187, 149)'],
                     [0.5314960629921259, 'rgb(72, 187, 148)'],
                     [0.5354330708661417, 'rgb(75, 187, 146)'],
                     [0.5393700787401575, 'rgb(78, 188, 145)'],
                     [0.5433070866141733, 'rgb(81, 188, 143)'],
                     [0.547244094488189, 'rgb(83, 188, 142)'],
                     [0.5511811023622047, 'rgb(86, 189, 140)'],
                     [0.5551181102362205, 'rgb(89, 189, 139)'],
                     [0.5590551181102362, 'rgb(92, 189, 137)'],
                     [0.562992125984252, 'rgb(95, 189, 136)'],
                     [0.5669291338582677, 'rgb(98, 190, 134)'],
                     [0.5708661417322834, 'rgb(101, 190, 133)'],
                     [0.5748031496062992, 'rgb(104, 190, 132)'],
                     [0.5787401574803149, 'rgb(107, 190, 130)'],
                     [0.5826771653543307, 'rgb(110, 190, 129)'],
                     [0.5866141732283464, 'rgb(113, 190, 128)'],
                     [0.5905511811023622, 'rgb(116, 190, 126)'],
                     [0.5944881889763779, 'rgb(119, 190, 125)'],
                     [0.5984251968503937, 'rgb(121, 190, 124)'],
                     [0.6023622047244095, 'rgb(124, 191, 123)'],
                     [0.6062992125984252, 'rgb(127, 191, 122)'],
                     [0.610236220472441, 'rgb(130, 191, 120)'],
                     [0.6141732283464567, 'rgb(132, 191, 119)'],
                     [0.6181102362204725, 'rgb(135, 191, 118)'],
                     [0.6220472440944882, 'rgb(138, 190, 117)'],
                     [0.6259842519685039, 'rgb(140, 190, 116)'],
                     [0.6299212598425197, 'rgb(143, 190, 115)'],
                     [0.6338582677165354, 'rgb(145, 190, 114)'],
                     [0.6377952755905512, 'rgb(148, 190, 113)'],
                     [0.6417322834645669, 'rgb(150, 190, 112)'],
                     [0.6456692913385826, 'rgb(153, 190, 111)'],
                     [0.6496062992125984, 'rgb(155, 190, 110)'],
                     [0.6535433070866141, 'rgb(157, 190, 109)'],
                     [0.6574803149606299, 'rgb(160, 190, 108)'],
                     [0.6614173228346456, 'rgb(162, 190, 107)'],
                     [0.6653543307086615, 'rgb(165, 190, 106)'],
                     [0.6692913385826772, 'rgb(167, 189, 105)'],
                     [0.6732283464566929, 'rgb(169, 189, 104)'],
                     [0.6771653543307087, 'rgb(171, 189, 104)'],
                     [0.6811023622047244, 'rgb(174, 189, 103)'],
                     [0.6850393700787402, 'rgb(176, 189, 102)'],
                     [0.6889763779527559, 'rgb(178, 189, 101)'],
                     [0.6929133858267716, 'rgb(180, 189, 100)'],
                     [0.6968503937007874, 'rgb(182, 189, 99)'],
                     [0.7007874015748031, 'rgb(185, 188, 98)'],
                     [0.7047244094488189, 'rgb(187, 188, 97)'],
                     [0.7086614173228346, 'rgb(189, 188, 97)'],
                     [0.7125984251968503, 'rgb(191, 188, 96)'],
                     [0.7165354330708661, 'rgb(193, 188, 95)'],
                     [0.7204724409448818, 'rgb(195, 187, 94)'],
                     [0.7244094488188977, 'rgb(197, 187, 93)'],
                     [0.7283464566929134, 'rgb(199, 187, 92)'],
                     [0.7322834645669292, 'rgb(202, 187, 91)'],
                     [0.7362204724409449, 'rgb(204, 187, 91)'],
                     [0.7401574803149606, 'rgb(206, 187, 90)'],
                     [0.7440944881889764, 'rgb(208, 186, 89)'],
                     [0.7480314960629921, 'rgb(210, 186, 88)'],
                     [0.7519685039370079, 'rgb(212, 186, 87)'],
                     [0.7559055118110236, 'rgb(214, 186, 86)'],
                     [0.7598425196850394, 'rgb(216, 186, 85)'],
                     [0.7637795275590551, 'rgb(218, 186, 85)'],
                     [0.7677165354330708, 'rgb(220, 185, 84)'],
                     [0.7716535433070866, 'rgb(222, 185, 83)'],
                     [0.7755905511811023, 'rgb(224, 185, 82)'],
                     [0.7795275590551181, 'rgb(226, 185, 81)'],
                     [0.7834645669291338, 'rgb(228, 185, 80)'],
                     [0.7874015748031495, 'rgb(230, 185, 79)'],
                     [0.7913385826771654, 'rgb(232, 185, 78)'],
                     [0.7952755905511811, 'rgb(234, 185, 77)'],
                     [0.7992125984251969, 'rgb(236, 185, 76)'],
                     [0.8031496062992126, 'rgb(238, 185, 75)'],
                     [0.8070866141732284, 'rgb(240, 185, 74)'],
                     [0.8110236220472441, 'rgb(242, 185, 72)'],
                     [0.8149606299212598, 'rgb(243, 185, 71)'],
                     [0.8188976377952756, 'rgb(245, 186, 70)'],
                     [0.8228346456692913, 'rgb(247, 186, 68)'],
                     [0.8267716535433071, 'rgb(248, 186, 67)'],
                     [0.8307086614173228, 'rgb(250, 187, 65)'],
                     [0.8346456692913385, 'rgb(251, 188, 63)'],
                     [0.8385826771653543, 'rgb(252, 189, 62)'],
                     [0.84251968503937, 'rgb(253, 190, 60)'],
                     [0.8464566929133858, 'rgb(253, 191, 59)'],
                     [0.8503937007874016, 'rgb(254, 193, 57)'],
                     [0.8543307086614174, 'rgb(254, 194, 56)'],
                     [0.8582677165354331, 'rgb(254, 195, 54)'],
                     [0.8622047244094488, 'rgb(254, 197, 53)'],
                     [0.8661417322834646, 'rgb(254, 198, 52)'],
                     [0.8700787401574803, 'rgb(253, 199, 50)'],
                     [0.8740157480314961, 'rgb(253, 200, 49)'],
                     [0.8779527559055118, 'rgb(253, 202, 48)'],
                     [0.8818897637795275, 'rgb(252, 203, 47)'],
                     [0.8858267716535433, 'rgb(252, 204, 46)'],
                     [0.889763779527559, 'rgb(251, 206, 45)'],
                     [0.8937007874015748, 'rgb(251, 207, 44)'],
                     [0.8976377952755905, 'rgb(250, 208, 43)'],
                     [0.9015748031496063, 'rgb(250, 209, 42)'],
                     [0.905511811023622, 'rgb(249, 211, 41)'],
                     [0.9094488188976377, 'rgb(248, 212, 40)'],
                     [0.9133858267716535, 'rgb(248, 213, 39)'],
                     [0.9173228346456693, 'rgb(247, 215, 38)'],
                     [0.9212598425196851, 'rgb(247, 216, 37)'],
                     [0.9251968503937008, 'rgb(246, 218, 36)'],
                     [0.9291338582677166, 'rgb(246, 219, 35)'],
                     [0.9330708661417323, 'rgb(245, 220, 34)'],
                     [0.937007874015748, 'rgb(245, 222, 33)'],
                     [0.9409448818897638, 'rgb(245, 223, 32)'],
                     [0.9448818897637795, 'rgb(244, 225, 30)'],
                     [0.9488188976377953, 'rgb(244, 226, 29)'],
                     [0.952755905511811, 'rgb(244, 228, 28)'],
                     [0.9566929133858267, 'rgb(244, 230, 27)'],
                     [0.9606299212598425, 'rgb(244, 231, 26)'],
                     [0.9645669291338582, 'rgb(244, 233, 25)'],
                     [0.968503937007874, 'rgb(244, 235, 24)'],
                     [0.9724409448818897, 'rgb(245, 237, 22)'],
                     [0.9763779527559056, 'rgb(245, 238, 21)'],
                     [0.9803149606299213, 'rgb(245, 240, 20)'],
                     [0.984251968503937, 'rgb(246, 242, 19)'],
                     [0.9881889763779528, 'rgb(247, 244, 17)'],
                     [0.9921259842519685, 'rgb(247, 246, 16)'],
                     [0.9960629921259843, 'rgb(248, 248, 15)'],
                     [1.0, 'rgb(248, 250, 13)']]
"""Colorscale used in the plotly HeatMap figures."""