# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RandomPasswordArgs', 'RandomPassword']

@pulumi.input_type
class RandomPasswordArgs:
    def __init__(__self__, *,
                 length: pulumi.Input[_builtins.int],
                 keepers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 lower: Optional[pulumi.Input[_builtins.bool]] = None,
                 min_lower: Optional[pulumi.Input[_builtins.int]] = None,
                 min_numeric: Optional[pulumi.Input[_builtins.int]] = None,
                 min_special: Optional[pulumi.Input[_builtins.int]] = None,
                 min_upper: Optional[pulumi.Input[_builtins.int]] = None,
                 number: Optional[pulumi.Input[_builtins.bool]] = None,
                 numeric: Optional[pulumi.Input[_builtins.bool]] = None,
                 override_special: Optional[pulumi.Input[_builtins.str]] = None,
                 special: Optional[pulumi.Input[_builtins.bool]] = None,
                 upper: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        The set of arguments for constructing a RandomPassword resource.
        :param pulumi.Input[_builtins.int] length: The length of the string desired. The minimum value for length is 1 and, length must also be >= (`min_upper` + `min_lower` + `min_numeric` + `min_special`).
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] keepers: Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        :param pulumi.Input[_builtins.bool] lower: Include lowercase alphabet characters in the result. Default value is `true`.
        :param pulumi.Input[_builtins.int] min_lower: Minimum number of lowercase alphabet characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.int] min_numeric: Minimum number of numeric characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.int] min_special: Minimum number of special characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.int] min_upper: Minimum number of uppercase alphabet characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.bool] number: Include numeric characters in the result. Default value is `true`. If `number`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`. **NOTE**: This is deprecated, use `numeric` instead.
        :param pulumi.Input[_builtins.bool] numeric: Include numeric characters in the result. Default value is `true`. If `numeric`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`.
        :param pulumi.Input[_builtins.str] override_special: Supply your own list of special characters to use for string generation.  This overrides the default character list in the special argument.  The `special` argument must still be set to true for any overwritten characters to be used in generation.
        :param pulumi.Input[_builtins.bool] special: Include special characters in the result. These are `!@#$%&*()-_=+[]{}<>:?`. Default value is `true`.
        :param pulumi.Input[_builtins.bool] upper: Include uppercase alphabet characters in the result. Default value is `true`.
        """
        pulumi.set(__self__, "length", length)
        if keepers is not None:
            pulumi.set(__self__, "keepers", keepers)
        if lower is not None:
            pulumi.set(__self__, "lower", lower)
        if min_lower is not None:
            pulumi.set(__self__, "min_lower", min_lower)
        if min_numeric is not None:
            pulumi.set(__self__, "min_numeric", min_numeric)
        if min_special is not None:
            pulumi.set(__self__, "min_special", min_special)
        if min_upper is not None:
            pulumi.set(__self__, "min_upper", min_upper)
        if number is not None:
            warnings.warn("""**NOTE**: This is deprecated, use `numeric` instead.""", DeprecationWarning)
            pulumi.log.warn("""number is deprecated: **NOTE**: This is deprecated, use `numeric` instead.""")
        if number is not None:
            pulumi.set(__self__, "number", number)
        if numeric is not None:
            pulumi.set(__self__, "numeric", numeric)
        if override_special is not None:
            pulumi.set(__self__, "override_special", override_special)
        if special is not None:
            pulumi.set(__self__, "special", special)
        if upper is not None:
            pulumi.set(__self__, "upper", upper)

    @_builtins.property
    @pulumi.getter
    def length(self) -> pulumi.Input[_builtins.int]:
        """
        The length of the string desired. The minimum value for length is 1 and, length must also be >= (`min_upper` + `min_lower` + `min_numeric` + `min_special`).
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "length", value)

    @_builtins.property
    @pulumi.getter
    def keepers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        """
        return pulumi.get(self, "keepers")

    @keepers.setter
    def keepers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "keepers", value)

    @_builtins.property
    @pulumi.getter
    def lower(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include lowercase alphabet characters in the result. Default value is `true`.
        """
        return pulumi.get(self, "lower")

    @lower.setter
    def lower(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lower", value)

    @_builtins.property
    @pulumi.getter(name="minLower")
    def min_lower(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of lowercase alphabet characters in the result. Default value is `0`.
        """
        return pulumi.get(self, "min_lower")

    @min_lower.setter
    def min_lower(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_lower", value)

    @_builtins.property
    @pulumi.getter(name="minNumeric")
    def min_numeric(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of numeric characters in the result. Default value is `0`.
        """
        return pulumi.get(self, "min_numeric")

    @min_numeric.setter
    def min_numeric(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_numeric", value)

    @_builtins.property
    @pulumi.getter(name="minSpecial")
    def min_special(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of special characters in the result. Default value is `0`.
        """
        return pulumi.get(self, "min_special")

    @min_special.setter
    def min_special(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_special", value)

    @_builtins.property
    @pulumi.getter(name="minUpper")
    def min_upper(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of uppercase alphabet characters in the result. Default value is `0`.
        """
        return pulumi.get(self, "min_upper")

    @min_upper.setter
    def min_upper(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_upper", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""**NOTE**: This is deprecated, use `numeric` instead.""")
    def number(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include numeric characters in the result. Default value is `true`. If `number`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`. **NOTE**: This is deprecated, use `numeric` instead.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "number", value)

    @_builtins.property
    @pulumi.getter
    def numeric(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include numeric characters in the result. Default value is `true`. If `numeric`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`.
        """
        return pulumi.get(self, "numeric")

    @numeric.setter
    def numeric(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "numeric", value)

    @_builtins.property
    @pulumi.getter(name="overrideSpecial")
    def override_special(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Supply your own list of special characters to use for string generation.  This overrides the default character list in the special argument.  The `special` argument must still be set to true for any overwritten characters to be used in generation.
        """
        return pulumi.get(self, "override_special")

    @override_special.setter
    def override_special(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "override_special", value)

    @_builtins.property
    @pulumi.getter
    def special(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include special characters in the result. These are `!@#$%&*()-_=+[]{}<>:?`. Default value is `true`.
        """
        return pulumi.get(self, "special")

    @special.setter
    def special(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "special", value)

    @_builtins.property
    @pulumi.getter
    def upper(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include uppercase alphabet characters in the result. Default value is `true`.
        """
        return pulumi.get(self, "upper")

    @upper.setter
    def upper(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upper", value)


@pulumi.input_type
class _RandomPasswordState:
    def __init__(__self__, *,
                 bcrypt_hash: Optional[pulumi.Input[_builtins.str]] = None,
                 keepers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 length: Optional[pulumi.Input[_builtins.int]] = None,
                 lower: Optional[pulumi.Input[_builtins.bool]] = None,
                 min_lower: Optional[pulumi.Input[_builtins.int]] = None,
                 min_numeric: Optional[pulumi.Input[_builtins.int]] = None,
                 min_special: Optional[pulumi.Input[_builtins.int]] = None,
                 min_upper: Optional[pulumi.Input[_builtins.int]] = None,
                 number: Optional[pulumi.Input[_builtins.bool]] = None,
                 numeric: Optional[pulumi.Input[_builtins.bool]] = None,
                 override_special: Optional[pulumi.Input[_builtins.str]] = None,
                 result: Optional[pulumi.Input[_builtins.str]] = None,
                 special: Optional[pulumi.Input[_builtins.bool]] = None,
                 upper: Optional[pulumi.Input[_builtins.bool]] = None):
        """
        Input properties used for looking up and filtering RandomPassword resources.
        :param pulumi.Input[_builtins.str] bcrypt_hash: A bcrypt hash of the generated random string. **NOTE**: If the generated random string is greater than 72 bytes in length, `bcrypt_hash` will contain a hash of the first 72 bytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] keepers: Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        :param pulumi.Input[_builtins.int] length: The length of the string desired. The minimum value for length is 1 and, length must also be >= (`min_upper` + `min_lower` + `min_numeric` + `min_special`).
        :param pulumi.Input[_builtins.bool] lower: Include lowercase alphabet characters in the result. Default value is `true`.
        :param pulumi.Input[_builtins.int] min_lower: Minimum number of lowercase alphabet characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.int] min_numeric: Minimum number of numeric characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.int] min_special: Minimum number of special characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.int] min_upper: Minimum number of uppercase alphabet characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.bool] number: Include numeric characters in the result. Default value is `true`. If `number`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`. **NOTE**: This is deprecated, use `numeric` instead.
        :param pulumi.Input[_builtins.bool] numeric: Include numeric characters in the result. Default value is `true`. If `numeric`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`.
        :param pulumi.Input[_builtins.str] override_special: Supply your own list of special characters to use for string generation.  This overrides the default character list in the special argument.  The `special` argument must still be set to true for any overwritten characters to be used in generation.
        :param pulumi.Input[_builtins.str] result: The generated random string.
        :param pulumi.Input[_builtins.bool] special: Include special characters in the result. These are `!@#$%&*()-_=+[]{}<>:?`. Default value is `true`.
        :param pulumi.Input[_builtins.bool] upper: Include uppercase alphabet characters in the result. Default value is `true`.
        """
        if bcrypt_hash is not None:
            pulumi.set(__self__, "bcrypt_hash", bcrypt_hash)
        if keepers is not None:
            pulumi.set(__self__, "keepers", keepers)
        if length is not None:
            pulumi.set(__self__, "length", length)
        if lower is not None:
            pulumi.set(__self__, "lower", lower)
        if min_lower is not None:
            pulumi.set(__self__, "min_lower", min_lower)
        if min_numeric is not None:
            pulumi.set(__self__, "min_numeric", min_numeric)
        if min_special is not None:
            pulumi.set(__self__, "min_special", min_special)
        if min_upper is not None:
            pulumi.set(__self__, "min_upper", min_upper)
        if number is not None:
            warnings.warn("""**NOTE**: This is deprecated, use `numeric` instead.""", DeprecationWarning)
            pulumi.log.warn("""number is deprecated: **NOTE**: This is deprecated, use `numeric` instead.""")
        if number is not None:
            pulumi.set(__self__, "number", number)
        if numeric is not None:
            pulumi.set(__self__, "numeric", numeric)
        if override_special is not None:
            pulumi.set(__self__, "override_special", override_special)
        if result is not None:
            pulumi.set(__self__, "result", result)
        if special is not None:
            pulumi.set(__self__, "special", special)
        if upper is not None:
            pulumi.set(__self__, "upper", upper)

    @_builtins.property
    @pulumi.getter(name="bcryptHash")
    def bcrypt_hash(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        A bcrypt hash of the generated random string. **NOTE**: If the generated random string is greater than 72 bytes in length, `bcrypt_hash` will contain a hash of the first 72 bytes.
        """
        return pulumi.get(self, "bcrypt_hash")

    @bcrypt_hash.setter
    def bcrypt_hash(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "bcrypt_hash", value)

    @_builtins.property
    @pulumi.getter
    def keepers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        """
        return pulumi.get(self, "keepers")

    @keepers.setter
    def keepers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "keepers", value)

    @_builtins.property
    @pulumi.getter
    def length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The length of the string desired. The minimum value for length is 1 and, length must also be >= (`min_upper` + `min_lower` + `min_numeric` + `min_special`).
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "length", value)

    @_builtins.property
    @pulumi.getter
    def lower(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include lowercase alphabet characters in the result. Default value is `true`.
        """
        return pulumi.get(self, "lower")

    @lower.setter
    def lower(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "lower", value)

    @_builtins.property
    @pulumi.getter(name="minLower")
    def min_lower(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of lowercase alphabet characters in the result. Default value is `0`.
        """
        return pulumi.get(self, "min_lower")

    @min_lower.setter
    def min_lower(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_lower", value)

    @_builtins.property
    @pulumi.getter(name="minNumeric")
    def min_numeric(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of numeric characters in the result. Default value is `0`.
        """
        return pulumi.get(self, "min_numeric")

    @min_numeric.setter
    def min_numeric(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_numeric", value)

    @_builtins.property
    @pulumi.getter(name="minSpecial")
    def min_special(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of special characters in the result. Default value is `0`.
        """
        return pulumi.get(self, "min_special")

    @min_special.setter
    def min_special(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_special", value)

    @_builtins.property
    @pulumi.getter(name="minUpper")
    def min_upper(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        Minimum number of uppercase alphabet characters in the result. Default value is `0`.
        """
        return pulumi.get(self, "min_upper")

    @min_upper.setter
    def min_upper(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "min_upper", value)

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""**NOTE**: This is deprecated, use `numeric` instead.""")
    def number(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include numeric characters in the result. Default value is `true`. If `number`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`. **NOTE**: This is deprecated, use `numeric` instead.
        """
        return pulumi.get(self, "number")

    @number.setter
    def number(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "number", value)

    @_builtins.property
    @pulumi.getter
    def numeric(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include numeric characters in the result. Default value is `true`. If `numeric`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`.
        """
        return pulumi.get(self, "numeric")

    @numeric.setter
    def numeric(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "numeric", value)

    @_builtins.property
    @pulumi.getter(name="overrideSpecial")
    def override_special(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        Supply your own list of special characters to use for string generation.  This overrides the default character list in the special argument.  The `special` argument must still be set to true for any overwritten characters to be used in generation.
        """
        return pulumi.get(self, "override_special")

    @override_special.setter
    def override_special(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "override_special", value)

    @_builtins.property
    @pulumi.getter
    def result(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generated random string.
        """
        return pulumi.get(self, "result")

    @result.setter
    def result(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "result", value)

    @_builtins.property
    @pulumi.getter
    def special(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include special characters in the result. These are `!@#$%&*()-_=+[]{}<>:?`. Default value is `true`.
        """
        return pulumi.get(self, "special")

    @special.setter
    def special(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "special", value)

    @_builtins.property
    @pulumi.getter
    def upper(self) -> Optional[pulumi.Input[_builtins.bool]]:
        """
        Include uppercase alphabet characters in the result. Default value is `true`.
        """
        return pulumi.get(self, "upper")

    @upper.setter
    def upper(self, value: Optional[pulumi.Input[_builtins.bool]]):
        pulumi.set(self, "upper", value)


@pulumi.type_token("random:index/randomPassword:RandomPassword")
class RandomPassword(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 keepers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 length: Optional[pulumi.Input[_builtins.int]] = None,
                 lower: Optional[pulumi.Input[_builtins.bool]] = None,
                 min_lower: Optional[pulumi.Input[_builtins.int]] = None,
                 min_numeric: Optional[pulumi.Input[_builtins.int]] = None,
                 min_special: Optional[pulumi.Input[_builtins.int]] = None,
                 min_upper: Optional[pulumi.Input[_builtins.int]] = None,
                 number: Optional[pulumi.Input[_builtins.bool]] = None,
                 numeric: Optional[pulumi.Input[_builtins.bool]] = None,
                 override_special: Optional[pulumi.Input[_builtins.str]] = None,
                 special: Optional[pulumi.Input[_builtins.bool]] = None,
                 upper: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_random as random

        password = random.RandomPassword("password",
            length=16,
            special=True,
            override_special="!#$%&*()-_=+[]{}<>:?")
        example = aws.rds.Instance("example",
            instance_class=aws.rds.InstanceType.T3_MICRO,
            allocated_storage=64,
            engine="mysql",
            username="someone",
            password=password.result)
        ```

        ## Import

        You can import external passwords into your Pulumi programs as follows:

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] keepers: Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        :param pulumi.Input[_builtins.int] length: The length of the string desired. The minimum value for length is 1 and, length must also be >= (`min_upper` + `min_lower` + `min_numeric` + `min_special`).
        :param pulumi.Input[_builtins.bool] lower: Include lowercase alphabet characters in the result. Default value is `true`.
        :param pulumi.Input[_builtins.int] min_lower: Minimum number of lowercase alphabet characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.int] min_numeric: Minimum number of numeric characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.int] min_special: Minimum number of special characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.int] min_upper: Minimum number of uppercase alphabet characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.bool] number: Include numeric characters in the result. Default value is `true`. If `number`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`. **NOTE**: This is deprecated, use `numeric` instead.
        :param pulumi.Input[_builtins.bool] numeric: Include numeric characters in the result. Default value is `true`. If `numeric`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`.
        :param pulumi.Input[_builtins.str] override_special: Supply your own list of special characters to use for string generation.  This overrides the default character list in the special argument.  The `special` argument must still be set to true for any overwritten characters to be used in generation.
        :param pulumi.Input[_builtins.bool] special: Include special characters in the result. These are `!@#$%&*()-_=+[]{}<>:?`. Default value is `true`.
        :param pulumi.Input[_builtins.bool] upper: Include uppercase alphabet characters in the result. Default value is `true`.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RandomPasswordArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        ## Example Usage

        ```python
        import pulumi
        import pulumi_aws as aws
        import pulumi_random as random

        password = random.RandomPassword("password",
            length=16,
            special=True,
            override_special="!#$%&*()-_=+[]{}<>:?")
        example = aws.rds.Instance("example",
            instance_class=aws.rds.InstanceType.T3_MICRO,
            allocated_storage=64,
            engine="mysql",
            username="someone",
            password=password.result)
        ```

        ## Import

        You can import external passwords into your Pulumi programs as follows:

        :param str resource_name: The name of the resource.
        :param RandomPasswordArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RandomPasswordArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 keepers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 length: Optional[pulumi.Input[_builtins.int]] = None,
                 lower: Optional[pulumi.Input[_builtins.bool]] = None,
                 min_lower: Optional[pulumi.Input[_builtins.int]] = None,
                 min_numeric: Optional[pulumi.Input[_builtins.int]] = None,
                 min_special: Optional[pulumi.Input[_builtins.int]] = None,
                 min_upper: Optional[pulumi.Input[_builtins.int]] = None,
                 number: Optional[pulumi.Input[_builtins.bool]] = None,
                 numeric: Optional[pulumi.Input[_builtins.bool]] = None,
                 override_special: Optional[pulumi.Input[_builtins.str]] = None,
                 special: Optional[pulumi.Input[_builtins.bool]] = None,
                 upper: Optional[pulumi.Input[_builtins.bool]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RandomPasswordArgs.__new__(RandomPasswordArgs)

            __props__.__dict__["keepers"] = keepers
            if length is None and not opts.urn:
                raise TypeError("Missing required property 'length'")
            __props__.__dict__["length"] = length
            __props__.__dict__["lower"] = lower
            __props__.__dict__["min_lower"] = min_lower
            __props__.__dict__["min_numeric"] = min_numeric
            __props__.__dict__["min_special"] = min_special
            __props__.__dict__["min_upper"] = min_upper
            __props__.__dict__["number"] = number
            __props__.__dict__["numeric"] = numeric
            __props__.__dict__["override_special"] = override_special
            __props__.__dict__["special"] = special
            __props__.__dict__["upper"] = upper
            __props__.__dict__["bcrypt_hash"] = None
            __props__.__dict__["result"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["bcryptHash", "result"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RandomPassword, __self__).__init__(
            'random:index/randomPassword:RandomPassword',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            bcrypt_hash: Optional[pulumi.Input[_builtins.str]] = None,
            keepers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            length: Optional[pulumi.Input[_builtins.int]] = None,
            lower: Optional[pulumi.Input[_builtins.bool]] = None,
            min_lower: Optional[pulumi.Input[_builtins.int]] = None,
            min_numeric: Optional[pulumi.Input[_builtins.int]] = None,
            min_special: Optional[pulumi.Input[_builtins.int]] = None,
            min_upper: Optional[pulumi.Input[_builtins.int]] = None,
            number: Optional[pulumi.Input[_builtins.bool]] = None,
            numeric: Optional[pulumi.Input[_builtins.bool]] = None,
            override_special: Optional[pulumi.Input[_builtins.str]] = None,
            result: Optional[pulumi.Input[_builtins.str]] = None,
            special: Optional[pulumi.Input[_builtins.bool]] = None,
            upper: Optional[pulumi.Input[_builtins.bool]] = None) -> 'RandomPassword':
        """
        Get an existing RandomPassword resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] bcrypt_hash: A bcrypt hash of the generated random string. **NOTE**: If the generated random string is greater than 72 bytes in length, `bcrypt_hash` will contain a hash of the first 72 bytes.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] keepers: Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        :param pulumi.Input[_builtins.int] length: The length of the string desired. The minimum value for length is 1 and, length must also be >= (`min_upper` + `min_lower` + `min_numeric` + `min_special`).
        :param pulumi.Input[_builtins.bool] lower: Include lowercase alphabet characters in the result. Default value is `true`.
        :param pulumi.Input[_builtins.int] min_lower: Minimum number of lowercase alphabet characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.int] min_numeric: Minimum number of numeric characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.int] min_special: Minimum number of special characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.int] min_upper: Minimum number of uppercase alphabet characters in the result. Default value is `0`.
        :param pulumi.Input[_builtins.bool] number: Include numeric characters in the result. Default value is `true`. If `number`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`. **NOTE**: This is deprecated, use `numeric` instead.
        :param pulumi.Input[_builtins.bool] numeric: Include numeric characters in the result. Default value is `true`. If `numeric`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`.
        :param pulumi.Input[_builtins.str] override_special: Supply your own list of special characters to use for string generation.  This overrides the default character list in the special argument.  The `special` argument must still be set to true for any overwritten characters to be used in generation.
        :param pulumi.Input[_builtins.str] result: The generated random string.
        :param pulumi.Input[_builtins.bool] special: Include special characters in the result. These are `!@#$%&*()-_=+[]{}<>:?`. Default value is `true`.
        :param pulumi.Input[_builtins.bool] upper: Include uppercase alphabet characters in the result. Default value is `true`.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RandomPasswordState.__new__(_RandomPasswordState)

        __props__.__dict__["bcrypt_hash"] = bcrypt_hash
        __props__.__dict__["keepers"] = keepers
        __props__.__dict__["length"] = length
        __props__.__dict__["lower"] = lower
        __props__.__dict__["min_lower"] = min_lower
        __props__.__dict__["min_numeric"] = min_numeric
        __props__.__dict__["min_special"] = min_special
        __props__.__dict__["min_upper"] = min_upper
        __props__.__dict__["number"] = number
        __props__.__dict__["numeric"] = numeric
        __props__.__dict__["override_special"] = override_special
        __props__.__dict__["result"] = result
        __props__.__dict__["special"] = special
        __props__.__dict__["upper"] = upper
        return RandomPassword(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter(name="bcryptHash")
    def bcrypt_hash(self) -> pulumi.Output[_builtins.str]:
        """
        A bcrypt hash of the generated random string. **NOTE**: If the generated random string is greater than 72 bytes in length, `bcrypt_hash` will contain a hash of the first 72 bytes.
        """
        return pulumi.get(self, "bcrypt_hash")

    @_builtins.property
    @pulumi.getter
    def keepers(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        """
        return pulumi.get(self, "keepers")

    @_builtins.property
    @pulumi.getter
    def length(self) -> pulumi.Output[_builtins.int]:
        """
        The length of the string desired. The minimum value for length is 1 and, length must also be >= (`min_upper` + `min_lower` + `min_numeric` + `min_special`).
        """
        return pulumi.get(self, "length")

    @_builtins.property
    @pulumi.getter
    def lower(self) -> pulumi.Output[_builtins.bool]:
        """
        Include lowercase alphabet characters in the result. Default value is `true`.
        """
        return pulumi.get(self, "lower")

    @_builtins.property
    @pulumi.getter(name="minLower")
    def min_lower(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum number of lowercase alphabet characters in the result. Default value is `0`.
        """
        return pulumi.get(self, "min_lower")

    @_builtins.property
    @pulumi.getter(name="minNumeric")
    def min_numeric(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum number of numeric characters in the result. Default value is `0`.
        """
        return pulumi.get(self, "min_numeric")

    @_builtins.property
    @pulumi.getter(name="minSpecial")
    def min_special(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum number of special characters in the result. Default value is `0`.
        """
        return pulumi.get(self, "min_special")

    @_builtins.property
    @pulumi.getter(name="minUpper")
    def min_upper(self) -> pulumi.Output[_builtins.int]:
        """
        Minimum number of uppercase alphabet characters in the result. Default value is `0`.
        """
        return pulumi.get(self, "min_upper")

    @_builtins.property
    @pulumi.getter
    @_utilities.deprecated("""**NOTE**: This is deprecated, use `numeric` instead.""")
    def number(self) -> pulumi.Output[_builtins.bool]:
        """
        Include numeric characters in the result. Default value is `true`. If `number`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`. **NOTE**: This is deprecated, use `numeric` instead.
        """
        return pulumi.get(self, "number")

    @_builtins.property
    @pulumi.getter
    def numeric(self) -> pulumi.Output[_builtins.bool]:
        """
        Include numeric characters in the result. Default value is `true`. If `numeric`, `upper`, `lower`, and `special` are all configured, at least one of them must be set to `true`.
        """
        return pulumi.get(self, "numeric")

    @_builtins.property
    @pulumi.getter(name="overrideSpecial")
    def override_special(self) -> pulumi.Output[Optional[_builtins.str]]:
        """
        Supply your own list of special characters to use for string generation.  This overrides the default character list in the special argument.  The `special` argument must still be set to true for any overwritten characters to be used in generation.
        """
        return pulumi.get(self, "override_special")

    @_builtins.property
    @pulumi.getter
    def result(self) -> pulumi.Output[_builtins.str]:
        """
        The generated random string.
        """
        return pulumi.get(self, "result")

    @_builtins.property
    @pulumi.getter
    def special(self) -> pulumi.Output[_builtins.bool]:
        """
        Include special characters in the result. These are `!@#$%&*()-_=+[]{}<>:?`. Default value is `true`.
        """
        return pulumi.get(self, "special")

    @_builtins.property
    @pulumi.getter
    def upper(self) -> pulumi.Output[_builtins.bool]:
        """
        Include uppercase alphabet characters in the result. Default value is `true`.
        """
        return pulumi.get(self, "upper")

