# Configuration file for the Sphinx documentation builder.
#
# This file only contains a selection of the most common options. For a full
# list see the documentation:
# https://www.sphinx-doc.org/en/master/usage/configuration.html

# -- Path setup --------------------------------------------------------------

# If extensions (or modules to document with autodoc) are in another directory,
# add these directories to sys.path here. If the directory is relative to the
# documentation root, use os.path.abspath to make it absolute, like shown here.
#
import os
import sys
import subprocess
sys.path.insert(0, os.path.abspath('../../src'))
sys.path.insert(0, os.path.abspath('.'))


# -- Run Doxygen -------------------------------------------------------------
subprocess.call('doxygen Doxyfile.in', shell=True)

# -- Project information -----------------------------------------------------

project = 'simsopt'
copyright = '2020, Simsopt Development Team'
author = 'Simsopt Development Team'

# The full version, including alpha/beta/rc tags
from importlib.metadata import version
release = version('simsopt')
# for example take major/minor
version = '.'.join(release.split('.')[:2])
# release = '0.0.3'


# -- General configuration ---------------------------------------------------

# Add any Sphinx extension module names here, as strings. They can be
# extensions coming with Sphinx (named 'sphinx.ext.*') or your custom
# ones.
extensions = [
              'sphinx_rtd_theme',
              'sphinx.ext.autodoc',
              'sphinx.ext.napoleon',
              'sphinx.ext.mathjax',
              'sphinx.ext.intersphinx',
              'breathe',
              'link-roles',
]

autodoc_mock_imports=['mpi4py', 'pyoculus', 'py_spec']

# Add any paths that contain templates here, relative to this directory.
templates_path = ['_templates']

# List of patterns, relative to source directory, that match files and
# directories to ignore when looking for source files.
# This pattern also affects html_static_path and html_extra_path.
exclude_patterns = []

html_logo = 'logo.png'
# Logo was generated by m20210604_01_plotVMECWout_withFieldlineSeamAtBottom.m
# using /Users/mattland/Box Sync/work21/simsopt_nfp2_QA_20210328-01-020_000_000251/wout_simsopt_nfp2_QA_20210328-01-020_000_000251_scaled.nc

# -- Breathe configuration ---------------------------------------------------

breathe_projects = {"simsoptpp": os.path.abspath("./doxyxml")}
breathe_default_project = "simsoptpp"

# -- Options for HTML output -------------------------------------------------

# The theme to use for HTML and HTML Help pages.  See the documentation for
# a list of builtin themes.
#
html_theme = 'sphinx_rtd_theme'

# Add any paths that contain custom static files (such as style sheets) here,
# relative to this directory. They are copied after the builtin static files,
# so a file named "default.css" will overwrite the builtin "default.css".
html_static_path = ['_static']

html_css_files = [
    'css/parameter_linebreak.css',
    'css/equation_numbers.css',
    'css/tight_table.css'
]


# For configuration options of the Read The Docs theme, see
# https://sphinx-rtd-theme.readthedocs.io/en/latest/configuring.html

html_theme_options = {
    'collapse_navigation': False
    }

# -- Napolean extension configuration ----------------------------------------

napoleon_google_docstring = True
napoleon_numpy_docstring = True
napoleon_include_init_with_doc = True
napoleon_include_private_with_doc = True
napoleon_include_special_with_doc = True
napoleon_use_admonition_for_examples = False
napoleon_use_admonition_for_notes = True
napoleon_use_admonition_for_references = False
napoleon_use_ivar = False
napoleon_use_param = True
napoleon_use_rtype = True
napoleon_type_aliases = None
napoleon_attr_annotations = True

# Typehints for autodoc
#autodoc_typehints = "description"

# This next function is for fixing equation numbers.
# See links in _static/equation_numbers.css for details.

def setup(app):
    app.add_css_file('equation_numbers.css')
