"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.CheckpointTable = void 0;
// eslint-disable-next-line import/no-extraneous-dependencies
const aws_sdk_1 = require("aws-sdk");
const util_1 = require("./util");
class CheckpointTable {
    constructor(options = {}) {
        this.dynamodb = options.dynamodb || new aws_sdk_1.DynamoDB();
        this.tableName = options.tableName || util_1.getEnv('CHECKPOINT_TABLE_NAME');
        this.keyName = options.keyName || util_1.getEnv('CHECKPOINT_TABLE_KEY_NAME');
    }
    async getLastCheckpoint() {
        const req = {
            TableName: this.tableName,
            Key: {
                [this.keyName]: { S: 'max_id' },
            },
        };
        const response = await this.dynamodb.getItem(req).promise();
        if (!response.Item) {
            console.error('no max_id stored in database yet');
            return undefined; // not found
        }
        return Number.parseInt(response.Item.max_id.N);
    }
    async checkpoint(id) {
        const req = {
            TableName: this.tableName,
            Item: {
                [this.keyName]: { S: 'max_id' },
                max_id: { N: id.toString() },
            },
        };
        await this.dynamodb.putItem(req).promise();
    }
}
exports.CheckpointTable = CheckpointTable;
//# sourceMappingURL=data:application/json;base64,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