// Copyright 2025 EvoBandits
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

use std::time::Instant;

use rand_distr::{Distribution, Poisson};

use evobandits::evobandits::GMAB;

fn random_poisson(lambda: f64) -> i32 {
    let poi = Poisson::new(lambda).unwrap();
    let mut rng = rand::rng();
    poi.sample(&mut rng) as i32
}

fn get_true_objective_value(action_vector: &[i32]) -> f64 {
    let results = vec![
        218.435, 213.435, 208.435, 203.435, 198.435, 193.435, 188.435, 183.436, 178.437, 173.443,
        168.457, 163.494, 158.577, 153.751, 149.088, 144.692, 140.69, 137.227, 134.429, 132.373,
        131.056, 130.406, 130.273, 130.472, 130.833, 131.213, 131.47, 131.544, 131.383, 130.967,
        130.303, 129.393, 128.264, 126.948, 125.513, 124.04, 122.605, 121.257, 120.028, 118.926,
        117.965, 117.155, 116.511, 116.057, 115.789, 115.7, 115.77, 115.955, 116.218, 116.532,
        116.862, 117.16, 117.423, 117.633, 117.793, 117.892, 117.902, 117.8, 117.566, 117.223,
        116.818, 116.424, 116.104, 115.897, 115.809, 115.821, 115.888, 115.961, 116.027, 116.083,
        116.162, 116.304, 116.524, 116.827, 117.179, 117.525, 117.821, 118.039, 118.172, 118.262,
        118.368, 118.524, 118.78, 119.14, 119.573, 120.036, 120.487, 120.869, 121.138, 121.284,
        121.311, 121.234, 121.102, 120.969, 120.897, 120.923, 121.091, 121.421, 121.896, 122.498,
        213.435, 208.435, 203.435, 198.435, 193.435, 188.435, 183.436, 178.437, 173.441, 168.451,
        163.476, 158.533, 153.651, 148.884, 144.312, 140.047, 136.223, 132.984, 130.45, 128.687,
        127.672, 127.313, 127.446, 127.875, 128.424, 128.952, 129.319, 129.472, 129.367, 128.989,
        128.35, 127.457, 126.34, 125.035, 123.613, 122.158, 120.75, 119.438, 118.253, 117.204,
        116.301, 115.554, 114.977, 114.592, 114.395, 114.375, 114.511, 114.759, 115.077, 115.441,
        115.814, 116.148, 116.442, 116.678, 116.859, 116.976, 117.001, 116.911, 116.689, 116.358,
        115.968, 115.592, 115.295, 115.113, 115.053, 115.093, 115.188, 115.288, 115.381, 115.464,
        115.571, 115.74, 115.987, 116.314, 116.688, 117.054, 117.367, 117.6, 117.747, 117.851,
        117.972, 118.143, 118.414, 118.788, 119.233, 119.708, 120.169, 120.558, 120.837, 120.992,
        121.029, 120.963, 120.845, 120.728, 120.673, 120.717, 120.903, 121.251, 121.743, 122.359,
        208.435, 203.435, 198.435, 193.435, 188.435, 183.436, 178.437, 173.441, 168.45, 163.47,
        158.515, 153.607, 148.784, 144.109, 139.67, 135.587, 131.996, 129.035, 126.813, 125.375,
        124.676, 124.605, 124.985, 125.61, 126.307, 126.938, 127.373, 127.566, 127.481, 127.113,
        126.476, 125.584, 124.469, 123.169, 121.759, 120.326, 118.952, 117.686, 116.557, 115.572,
        114.741, 114.069, 113.57, 113.264, 113.143, 113.196, 113.398, 113.704, 114.074, 114.479,
        114.887, 115.248, 115.563, 115.814, 116.008, 116.134, 116.168, 116.085, 115.871, 115.551,
        115.175, 114.818, 114.545, 114.392, 114.363, 114.434, 114.561, 114.691, 114.815, 114.927,
        115.063, 115.259, 115.532, 115.883, 116.277, 116.659, 116.986, 117.23, 117.389, 117.504,
        117.637, 117.82, 118.104, 118.489, 118.946, 119.431, 119.9, 120.299, 120.586, 120.751,
        120.799, 120.747, 120.644, 120.543, 120.506, 120.568, 120.773, 121.139, 121.645, 122.275,
        203.435, 198.435, 193.435, 188.435, 183.436, 178.437, 173.441, 168.449, 163.469, 158.509,
        153.589, 148.74, 144.01, 139.469, 135.215, 131.371, 128.069, 125.436, 123.563, 122.468,
        122.085, 122.284, 122.875, 123.654, 124.451, 125.139, 125.598, 125.794, 125.7, 125.317,
        124.666, 123.764, 122.645, 121.35, 119.957, 118.553, 117.222, 116.013, 114.953, 114.047,
        113.299, 112.713, 112.302, 112.08, 112.039, 112.165, 112.431, 112.79, 113.203, 113.642,
        114.073, 114.452, 114.776, 115.035, 115.232, 115.361, 115.398, 115.319, 115.111, 114.801,
        114.44, 114.105, 113.86, 113.738, 113.743, 113.85, 114.01, 114.175, 114.33, 114.474,
        114.638, 114.861, 115.158, 115.53, 115.942, 116.337, 116.675, 116.927, 117.094, 117.217,
        117.359, 117.552, 117.846, 118.242, 118.709, 119.204, 119.683, 120.09, 120.388, 120.564,
        120.625, 120.586, 120.499, 120.415, 120.397, 120.478, 120.7, 121.083, 121.604, 122.246,
        198.435, 193.435, 188.435, 183.436, 178.437, 173.441, 168.449, 163.468, 158.507, 153.583,
        148.723, 143.966, 139.371, 135.018, 131.007, 127.46, 124.5, 122.237, 120.733, 119.983,
        119.899, 120.332, 121.091, 121.973, 122.821, 123.519, 123.964, 124.13, 124.002, 123.587,
        122.91, 121.993, 120.87, 119.583, 118.212, 116.848, 115.572, 114.433, 113.456, 112.64,
        111.987, 111.498, 111.18, 111.046, 111.086, 111.282, 111.607, 112.012, 112.459, 112.921,
        113.365, 113.75, 114.076, 114.332, 114.526, 114.653, 114.689, 114.611, 114.409, 114.11,
        113.766, 113.456, 113.242, 113.155, 113.198, 113.343, 113.541, 113.741, 113.93, 114.105,
        114.298, 114.546, 114.866, 115.255, 115.681, 116.087, 116.431, 116.688, 116.86, 116.988,
        117.137, 117.338, 117.641, 118.047, 118.523, 119.028, 119.517, 119.934, 120.243, 120.432,
        120.506, 120.483, 120.412, 120.346, 120.346, 120.445, 120.685, 121.083, 121.618, 122.27,
        193.435, 188.435, 183.436, 178.437, 173.441, 168.449, 163.468, 158.507, 153.582, 148.717,
        143.949, 139.328, 134.922, 130.814, 127.106, 123.912, 121.339, 119.47, 118.341, 117.923,
        118.102, 118.725, 119.597, 120.531, 121.38, 122.047, 122.443, 122.553, 122.372, 121.913,
        121.205, 120.27, 119.146, 117.875, 116.537, 115.223, 114.015, 112.961, 112.079, 111.365,
        110.817, 110.431, 110.211, 110.166, 110.285, 110.546, 110.921, 111.363, 111.833, 112.307,
        112.754, 113.135, 113.453, 113.7, 113.886, 114.006, 114.039, 113.962, 113.767, 113.48,
        113.157, 112.876, 112.696, 112.648, 112.732, 112.918, 113.156, 113.393, 113.616, 113.821,
        114.041, 114.313, 114.652, 115.056, 115.492, 115.904, 116.252, 116.511, 116.685, 116.816,
        116.969, 117.177, 117.488, 117.902, 118.388, 118.904, 119.403, 119.833, 120.154, 120.356,
        120.445, 120.438, 120.384, 120.336, 120.354, 120.471, 120.727, 121.139, 121.686, 122.347,
        188.435, 183.436, 178.437, 173.441, 168.449, 163.468, 158.507, 153.581, 148.715, 143.943,
        139.311, 134.879, 130.72, 126.919, 123.572, 120.777, 118.619, 117.153, 116.389, 116.268,
        116.667, 117.424, 118.356, 119.289, 120.095, 120.693, 121.012, 121.046, 120.799, 120.289,
        119.549, 118.601, 117.482, 116.236, 114.942, 113.693, 112.567, 111.61, 110.835, 110.233,
        109.798, 109.519, 109.398, 109.441, 109.633, 109.952, 110.368, 110.835, 111.318, 111.793,
        112.232, 112.6, 112.903, 113.135, 113.308, 113.419, 113.449, 113.373, 113.186, 112.916,
        112.618, 112.368, 112.226, 112.22, 112.349, 112.578, 112.856, 113.131, 113.387, 113.622,
        113.868, 114.16, 114.514, 114.93, 115.372, 115.787, 116.135, 116.394, 116.567, 116.698,
        116.855, 117.068, 117.387, 117.81, 118.307, 118.833, 119.345, 119.786, 120.121, 120.338,
        120.443, 120.452, 120.415, 120.385, 120.421, 120.555, 120.825, 121.251, 121.808, 122.476,
        183.436, 178.437, 173.441, 168.449, 163.468, 158.507, 153.581, 148.715, 143.942, 139.306,
        134.863, 130.679, 126.829, 123.393, 120.455, 118.091, 116.359, 115.289, 114.858, 114.991,
        115.554, 116.389, 117.326, 118.21, 118.934, 119.434, 119.654, 119.599, 119.279, 118.717,
        117.947, 116.991, 115.888, 114.679, 113.443, 112.272, 111.242, 110.393, 109.736, 109.255,
        108.937, 108.767, 108.743, 108.868, 109.126, 109.493, 109.939, 110.42, 110.904, 111.369,
        111.791, 112.139, 112.42, 112.633, 112.792, 112.893, 112.919, 112.847, 112.672, 112.422,
        112.151, 111.937, 111.837, 111.876, 112.051, 112.325, 112.644, 112.956, 113.245, 113.507,
        113.775, 114.084, 114.451, 114.874, 115.319, 115.734, 116.079, 116.334, 116.504, 116.635,
        116.794, 117.012, 117.339, 117.772, 118.279, 118.817, 119.342, 119.797, 120.146, 120.379,
        120.499, 120.525, 120.506, 120.494, 120.546, 120.695, 120.979, 121.416, 121.982, 122.656,
        178.437, 173.441, 168.449, 163.468, 158.507, 153.581, 148.715, 143.941, 139.304, 134.857,
        130.664, 126.79, 123.308, 120.287, 117.79, 115.871, 114.561, 113.858, 113.718, 114.051,
        114.72, 115.577, 116.469, 117.263, 117.873, 118.251, 118.358, 118.206, 117.811, 117.2,
        116.406, 115.453, 114.377, 113.218, 112.054, 110.974, 110.052, 109.323, 108.792, 108.435,
        108.236, 108.174, 108.243, 108.442, 108.756, 109.16, 109.625, 110.109, 110.583, 111.029,
        111.426, 111.747, 112.003, 112.193, 112.336, 112.428, 112.453, 112.387, 112.227, 112.001,
        111.763, 111.587, 111.532, 111.619, 111.841, 112.159, 112.519, 112.868, 113.187, 113.474,
        113.76, 114.083, 114.458, 114.884, 115.33, 115.741, 116.081, 116.33, 116.497, 116.626,
        116.787, 117.01, 117.344, 117.787, 118.306, 118.858, 119.396, 119.866, 120.231, 120.479,
        120.616, 120.659, 120.657, 120.661, 120.729, 120.892, 121.188, 121.634, 122.207, 122.886,
        173.441, 168.449, 163.468, 158.507, 153.581, 148.715, 143.941, 139.304, 134.856, 130.658,
        126.775, 123.272, 120.208, 117.636, 115.597, 114.12, 113.206, 112.829, 112.927, 113.402,
        114.12, 114.947, 115.75, 116.421, 116.892, 117.133, 117.119, 116.868, 116.4, 115.746,
        114.938, 113.999, 112.962, 111.868, 110.789, 109.813, 109.009, 108.409, 108.008, 107.779,
        107.697, 107.737, 107.891, 108.156, 108.516, 108.945, 109.416, 109.892, 110.347, 110.766,
        111.131, 111.422, 111.648, 111.816, 111.943, 112.027, 112.054, 111.998, 111.858, 111.659,
        111.456, 111.323, 111.315, 111.45, 111.72, 112.083, 112.483, 112.865, 113.211, 113.519,
        113.821, 114.154, 114.533, 114.96, 115.402, 115.807, 116.14, 116.382, 116.544, 116.671,
        116.833, 117.062, 117.405, 117.858, 118.39, 118.956, 119.509, 119.994, 120.375, 120.64,
        120.794, 120.853, 120.867, 120.887, 120.969, 121.144, 121.451, 121.905, 122.483, 123.164,
        168.449, 163.468, 158.507, 153.581, 148.715, 143.941, 139.304, 134.856, 130.657, 126.771,
        123.258, 120.174, 117.564, 115.458, 113.876, 112.817, 112.26, 112.159, 112.439, 112.998,
        113.712, 114.463, 115.143, 115.664, 115.98, 116.075, 115.936, 115.588, 115.054, 114.366,
        113.555, 112.643, 111.66, 110.643, 109.662, 108.8, 108.124, 107.657, 107.389, 107.285,
        107.316, 107.452, 107.682, 108.002, 108.395, 108.838, 109.305, 109.763, 110.189, 110.575,
        110.904, 111.16, 111.357, 111.502, 111.615, 111.695, 111.727, 111.685, 111.567, 111.4,
        111.236, 111.148, 111.188, 111.372, 111.689, 112.095, 112.532, 112.945, 113.316, 113.642,
        113.956, 114.294, 114.675, 115.099, 115.534, 115.931, 116.255, 116.489, 116.645, 116.771,
        116.935, 117.17, 117.521, 117.987, 118.532, 119.113, 119.681, 120.183, 120.58, 120.861,
        121.032, 121.107, 121.136, 121.17, 121.264, 121.451, 121.766, 122.226, 122.808, 123.491,
        163.468, 158.507, 153.581, 148.715, 143.941, 139.304, 134.856, 130.657, 126.769, 123.254,
        120.162, 117.535, 115.396, 113.756, 112.609, 111.931, 111.682, 111.801, 112.204, 112.793,
        113.457, 114.096, 114.624, 114.979, 115.13, 115.076, 114.815, 114.375, 113.784, 113.073,
        112.272, 111.401, 110.485, 109.557, 108.684, 107.946, 107.402, 107.071, 106.934, 106.952,
        107.089, 107.311, 107.606, 107.97, 108.385, 108.83, 109.283, 109.714, 110.106, 110.452,
        110.743, 110.963, 111.131, 111.255, 111.357, 111.435, 111.476, 111.452, 111.361, 111.228,
        111.105, 111.063, 111.151, 111.384, 111.748, 112.194, 112.666, 113.106, 113.498, 113.838,
        114.16, 114.5, 114.879, 115.297, 115.724, 116.112, 116.425, 116.652, 116.802, 116.926,
        117.093, 117.334, 117.696, 118.174, 118.734, 119.33, 119.914, 120.432, 120.846, 121.143,
        121.33, 121.42, 121.462, 121.509, 121.615, 121.811, 122.132, 122.598, 123.182, 123.866,
        158.507, 153.581, 148.715, 143.941, 139.304, 134.856, 130.657, 126.769, 123.253, 120.159,
        117.524, 115.371, 113.704, 112.509, 111.762, 111.418, 111.421, 111.703, 112.175, 112.748,
        113.324, 113.823, 114.182, 114.358, 114.341, 114.14, 113.763, 113.242, 112.604, 111.883,
        111.105, 110.287, 109.449, 108.622, 107.866, 107.257, 106.847, 106.651, 106.642, 106.774,
        107.007, 107.306, 107.655, 108.049, 108.475, 108.912, 109.342, 109.74, 110.092, 110.397,
        110.646, 110.832, 110.972, 111.078, 111.172, 111.253, 111.306, 111.303, 111.242, 111.146,
        111.066, 111.07, 111.207, 111.487, 111.894, 112.378, 112.881, 113.345, 113.754, 114.104,
        114.431, 114.771, 115.145, 115.555, 115.972, 116.348, 116.652, 116.87, 117.015, 117.138,
        117.308, 117.558, 117.93, 118.422, 118.996, 119.608, 120.208, 120.742, 121.173, 121.486,
        121.687, 121.791, 121.846, 121.904, 122.019, 122.222, 122.55, 123.018, 123.604, 124.287,
        153.581, 148.715, 143.941, 139.304, 134.856, 130.657, 126.769, 123.252, 120.158, 117.521,
        115.363, 113.685, 112.469, 111.686, 111.29, 111.225, 111.426, 111.817, 112.312, 112.83,
        113.289, 113.628, 113.806, 113.802, 113.619, 113.276, 112.792, 112.2, 111.53, 110.811,
        110.069, 109.315, 108.566, 107.847, 107.214, 106.736, 106.46, 106.395, 106.506, 106.744,
        107.063, 107.425, 107.817, 108.231, 108.657, 109.078, 109.478, 109.837, 110.147, 110.408,
        110.617, 110.769, 110.884, 110.975, 111.065, 111.152, 111.22, 111.242, 111.213, 111.156,
        111.119, 111.169, 111.353, 111.678, 112.126, 112.645, 113.175, 113.66, 114.082, 114.438,
        114.766, 115.103, 115.47, 115.871, 116.276, 116.641, 116.934, 117.144, 117.285, 117.409,
        117.583, 117.841, 118.225, 118.73, 119.319, 119.947, 120.564, 121.114, 121.56, 121.888,
        122.102, 122.219, 122.285, 122.353, 122.476, 122.685, 123.016, 123.487, 124.074, 124.755,
        148.715, 143.941, 139.304, 134.856, 130.657, 126.769, 123.253, 120.158, 117.521, 115.361,
        113.679, 112.456, 111.659, 111.239, 111.143, 111.302, 111.647, 112.099, 112.579, 113.012,
        113.334, 113.503, 113.497, 113.313, 112.97, 112.496, 111.916, 111.266, 110.575, 109.872,
        109.176, 108.497, 107.845, 107.239, 106.73, 106.383, 106.238, 106.296, 106.519, 106.852,
        107.246, 107.66, 108.081, 108.505, 108.923, 109.32, 109.685, 110.003, 110.269, 110.486,
        110.657, 110.779, 110.872, 110.952, 111.041, 111.137, 111.224, 111.273, 111.278, 111.259,
        111.265, 111.36, 111.589, 111.956, 112.441, 112.99, 113.544, 114.045, 114.477, 114.837,
        115.164, 115.495, 115.854, 116.243, 116.637, 116.991, 117.274, 117.476, 117.614, 117.739,
        117.918, 118.185, 118.581, 119.099, 119.704, 120.348, 120.98, 121.545, 122.006, 122.348,
        122.575, 122.702, 122.779, 122.854, 122.984, 123.198, 123.532, 124.004, 124.59, 125.269,
        143.941, 139.304, 134.856, 130.657, 126.769, 123.253, 120.158, 117.521, 115.361, 113.678,
        112.454, 111.652, 111.227, 111.119, 111.266, 111.597, 112.038, 112.514, 112.947, 113.276,
        113.45, 113.444, 113.255, 112.899, 112.406, 111.812, 111.15, 110.455, 109.755, 109.078,
        108.44, 107.843, 107.292, 106.801, 106.416, 106.196, 106.173, 106.347, 106.672, 107.087,
        107.543, 107.998, 108.439, 108.864, 109.267, 109.635, 109.962, 110.236, 110.458, 110.634,
        110.769, 110.864, 110.939, 111.011, 111.102, 111.211, 111.319, 111.396, 111.435, 111.455,
        111.503, 111.641, 111.911, 112.317, 112.835, 113.411, 113.985, 114.498, 114.937, 115.299,
        115.622, 115.945, 116.294, 116.672, 117.054, 117.397, 117.671, 117.867, 118.003, 118.129,
        118.314, 118.59, 118.998, 119.531, 120.151, 120.81, 121.457, 122.037, 122.511, 122.865,
        123.103, 123.24, 123.325, 123.407, 123.542, 123.759, 124.095, 124.567, 125.152, 125.829,
        139.304, 134.856, 130.657, 126.769, 123.253, 120.158, 117.521, 115.361, 113.679, 112.454,
        111.653, 111.227, 111.121, 111.27, 111.609, 112.064, 112.562, 113.03, 113.396, 113.608,
        113.63, 113.451, 113.087, 112.57, 111.939, 111.238, 110.508, 109.78, 109.083, 108.442,
        107.867, 107.357, 106.909, 106.532, 106.268, 106.167, 106.26, 106.538, 106.952, 107.438,
        107.945, 108.43, 108.882, 109.301, 109.683, 110.019, 110.306, 110.537, 110.716, 110.854,
        110.956, 111.027, 111.088, 111.156, 111.253, 111.376, 111.507, 111.613, 111.686, 111.744,
        111.83, 112.009, 112.317, 112.757, 113.304, 113.904, 114.493, 115.017, 115.459, 115.819,
        116.137, 116.452, 116.79, 117.157, 117.527, 117.86, 118.126, 118.317, 118.451, 118.58,
        118.771, 119.057, 119.478, 120.023, 120.658, 121.331, 121.993, 122.585, 123.072, 123.438,
        123.686, 123.831, 123.922, 124.01, 124.149, 124.368, 124.704, 125.176, 125.759, 126.434,
        134.856, 130.657, 126.769, 123.253, 120.158, 117.521, 115.361, 113.679, 112.455, 111.655,
        111.231, 111.129, 111.288, 111.641, 112.124, 112.663, 113.188, 113.626, 113.912, 114.002,
        113.872, 113.529, 113.001, 112.335, 111.581, 110.788, 110.002, 109.253, 108.57, 107.971,
        107.464, 107.042, 106.696, 106.43, 106.278, 106.289, 106.486, 106.856, 107.348, 107.893,
        108.439, 108.945, 109.401, 109.808, 110.165, 110.468, 110.715, 110.905, 111.045, 111.147,
        111.221, 111.272, 111.322, 111.389, 111.494, 111.633, 111.788, 111.922, 112.028, 112.121,
        112.245, 112.46, 112.802, 113.272, 113.845, 114.463, 115.065, 115.596, 116.04, 116.396,
        116.707, 117.013, 117.341, 117.697, 118.057, 118.38, 118.639, 118.826, 118.96, 119.092,
        119.29, 119.585, 120.017, 120.576, 121.224, 121.911, 122.585, 123.19, 123.688, 124.063,
        124.319, 124.471, 124.568, 124.66, 124.802, 125.023, 125.359, 125.83, 126.411, 127.083,
        130.657, 126.769, 123.253, 120.158, 117.521, 115.362, 113.68, 112.456, 111.656, 111.235,
        111.137, 111.304, 111.674, 112.185, 112.771, 113.363, 113.891, 114.285, 114.485, 114.453,
        114.18, 113.681, 113.004, 112.204, 111.342, 110.472, 109.642, 108.883, 108.22, 107.669,
        107.232, 106.897, 106.649, 106.486, 106.439, 106.55, 106.839, 107.29, 107.846, 108.44,
        109.016, 109.535, 109.988, 110.379, 110.711, 110.98, 111.189, 111.34, 111.445, 111.516,
        111.565, 111.601, 111.643, 111.711, 111.826, 111.982, 112.159, 112.321, 112.458, 112.584,
        112.741, 112.989, 113.361, 113.857, 114.451, 115.085, 115.697, 116.232, 116.675, 117.027,
        117.331, 117.628, 117.945, 118.291, 118.641, 118.957, 119.209, 119.393, 119.527, 119.663,
        119.868, 120.173, 120.616, 121.187, 121.847, 122.547, 123.232, 123.848, 124.355, 124.739,
        125.002, 125.159, 125.261, 125.356, 125.5, 125.721, 126.057, 126.526, 127.106, 127.776,
        126.769, 123.253, 120.158, 117.521, 115.362, 113.68, 112.456, 111.657, 111.237, 111.142,
        111.315, 111.698, 112.233, 112.859, 113.517, 114.137, 114.653, 114.995, 115.108, 114.96,
        114.553, 113.915, 113.103, 112.186, 111.232, 110.297, 109.435, 108.675, 108.037, 107.536,
        107.168, 106.915, 106.758, 106.69, 106.738, 106.938, 107.307, 107.826, 108.435, 109.067,
        109.665, 110.191, 110.638, 111.011, 111.316, 111.552, 111.727, 111.843, 111.916, 111.96,
        111.988, 112.012, 112.049, 112.121, 112.247, 112.419, 112.618, 112.806, 112.972, 113.127,
        113.314, 113.59, 113.988, 114.506, 115.119, 115.765, 116.384, 116.921, 117.362, 117.709,
        118.006, 118.293, 118.602, 118.938, 119.28, 119.589, 119.836, 120.017, 120.153, 120.292,
        120.504, 120.818, 121.271, 121.853, 122.524, 123.235, 123.931, 124.555, 125.071, 125.462,
        125.73, 125.893, 125.997, 126.095, 126.24, 126.461, 126.796, 127.265, 127.842, 128.51,
        123.253, 120.158, 117.521, 115.362, 113.68, 112.456, 111.657, 111.238, 111.144, 111.321,
        111.712, 112.264, 112.922, 113.632, 114.336, 114.967, 115.46, 115.748, 115.777, 115.523,
        114.996, 114.233, 113.303, 112.286, 111.253, 110.267, 109.384, 108.627, 108.018, 107.567,
        107.265, 107.088, 107.014, 107.031, 107.161, 107.439, 107.876, 108.451, 109.103, 109.764,
        110.377, 110.905, 111.343, 111.697, 111.977, 112.183, 112.326, 112.412, 112.457, 112.479,
        112.49, 112.504, 112.539, 112.616, 112.752, 112.94, 113.16, 113.372, 113.563, 113.745,
        113.957, 114.258, 114.678, 115.214, 115.841, 116.497, 117.12, 117.658, 118.097, 118.439,
        118.728, 119.008, 119.307, 119.635, 119.97, 120.273, 120.517, 120.697, 120.833, 120.977,
        121.194, 121.516, 121.979, 122.57, 123.252, 123.972, 124.676, 125.309, 125.832, 126.228,
        126.502, 126.668, 126.775, 126.874, 127.019, 127.24, 127.575, 128.042, 128.617, 129.283,
        120.158, 117.521, 115.362, 113.68, 112.456, 111.658, 111.238, 111.145, 111.324, 111.72,
        112.281, 112.96, 113.708, 114.475, 115.206, 115.837, 116.303, 116.538, 116.491, 116.142,
        115.509, 114.638, 113.607, 112.504, 111.409, 110.382, 109.484, 108.737, 108.158, 107.754,
        107.511, 107.404, 107.404, 107.495, 107.696, 108.038, 108.531, 109.152, 109.839, 110.521,
        111.145, 111.671, 112.098, 112.434, 112.69, 112.87, 112.985, 113.044, 113.066, 113.069,
        113.066, 113.074, 113.109, 113.191, 113.338, 113.541, 113.779, 114.012, 114.225, 114.429,
        114.664, 114.985, 115.424, 115.975, 116.613, 117.276, 117.902, 118.44, 118.876, 119.212,
        119.495, 119.767, 120.059, 120.38, 120.708, 121.007, 121.248, 121.427, 121.565, 121.713,
        121.936, 122.265, 122.736, 123.336, 124.026, 124.754, 125.466, 126.105, 126.633, 127.034,
        127.312, 127.481, 127.59, 127.689, 127.835, 128.056, 128.389, 128.855, 129.429, 130.093,
        117.521, 115.362, 113.68, 112.456, 111.658, 111.238, 111.146, 111.325, 111.723, 112.29,
        112.981, 113.752, 114.563, 115.368, 116.114, 116.737, 117.175, 117.361, 117.246, 116.815,
        116.091, 115.128, 114.012, 112.84, 111.694, 110.637, 109.73, 108.995, 108.444, 108.084,
        107.895, 107.848, 107.912, 108.066, 108.326, 108.722, 109.26, 109.918, 110.63, 111.329,
        111.958, 112.481, 112.896, 113.216, 113.451, 113.608, 113.699, 113.736, 113.739, 113.727,
        113.714, 113.717, 113.752, 113.84, 113.996, 114.213, 114.468, 114.719, 114.951, 115.174,
        115.426, 115.765, 116.219, 116.782, 117.428, 118.096, 118.725, 119.261, 119.694, 120.026,
        120.303, 120.568, 120.853, 121.168, 121.492, 121.787, 122.026, 122.204, 122.345, 122.496,
        122.723, 123.059, 123.537, 124.144, 124.841, 125.576, 126.294, 126.939, 127.472, 127.877,
        128.157, 128.328, 128.438, 128.538, 128.684, 128.904, 129.237, 129.701, 130.274, 130.937,
        115.362, 113.68, 112.456, 111.658, 111.238, 111.146, 111.326, 111.725, 112.294, 112.991,
        113.776, 114.614, 115.468, 116.296, 117.048, 117.661, 118.072, 118.215, 118.042, 117.54,
        116.74, 115.701, 114.516, 113.287, 112.101, 111.022, 110.111, 109.388, 108.865, 108.543,
        108.401, 108.406, 108.523, 108.728, 109.037, 109.477, 110.051, 110.737, 111.469, 112.179,
        112.811, 113.329, 113.734, 114.038, 114.255, 114.393, 114.464, 114.483, 114.471, 114.446,
        114.426, 114.426, 114.463, 114.555, 114.721, 114.949, 115.218, 115.484, 115.732, 115.97,
        116.238, 116.591, 117.056, 117.628, 118.281, 118.953, 119.582, 120.118, 120.548, 120.875,
        121.147, 121.406, 121.686, 121.996, 122.316, 122.609, 122.846, 123.024, 123.166, 123.32,
        123.552, 123.894, 124.377, 124.99, 125.693, 126.434, 127.157, 127.806, 128.343, 128.75,
        129.033, 129.205, 129.316, 129.416, 129.563, 129.782, 130.113, 130.577, 131.148, 131.81,
        113.68, 112.456, 111.658, 111.238, 111.146, 111.326, 111.725, 112.296, 112.995, 113.787,
        114.64, 115.523, 116.405, 117.247, 118.0, 118.602, 118.989, 119.095, 118.873, 118.314,
        117.451, 116.351, 115.11, 113.837, 112.621, 111.525, 110.614, 109.903, 109.404, 109.115,
        109.013, 109.06, 109.22, 109.469, 109.816, 110.29, 110.892, 111.6, 112.346, 113.063,
        113.696, 114.209, 114.605, 114.896, 115.098, 115.22, 115.275, 115.279, 115.255, 115.221,
        115.195, 115.194, 115.232, 115.329, 115.503, 115.741, 116.021, 116.3, 116.561, 116.812,
        117.092, 117.455, 117.929, 118.508, 119.166, 119.841, 120.47, 121.004, 121.432, 121.755,
        122.022, 122.277, 122.553, 122.859, 123.176, 123.467, 123.702, 123.881, 124.025, 124.182,
        124.417, 124.763, 125.252, 125.869, 126.577, 127.322, 128.049, 128.701, 129.241, 129.651,
        129.935, 130.108, 130.22, 130.32, 130.466, 130.685, 131.015, 131.478, 132.049, 132.71,
        112.456, 111.658, 111.238, 111.146, 111.326, 111.725, 112.297, 112.997, 113.792, 114.652,
        115.551, 116.465, 117.365, 118.215, 118.966, 119.557, 119.923, 119.999, 119.737, 119.131,
        118.219, 117.07, 115.786, 114.48, 113.24, 112.133, 111.222, 110.524, 110.046, 109.784,
        109.714, 109.796, 109.99, 110.272, 110.65, 111.15, 111.774, 112.497, 113.254, 113.976,
        114.609, 115.117, 115.505, 115.785, 115.975, 116.083, 116.126, 116.118, 116.086, 116.045,
        116.014, 116.013, 116.052, 116.154, 116.333, 116.58, 116.87, 117.158, 117.429, 117.691,
        117.98, 118.351, 118.832, 119.417, 120.078, 120.754, 121.384, 121.916, 122.341, 122.662,
        122.925, 123.177, 123.449, 123.752, 124.067, 124.356, 124.591, 124.77, 124.915, 125.074,
        125.312, 125.662, 126.154, 126.776, 127.487, 128.235, 128.965, 129.621, 130.163, 130.574,
        130.86, 131.033, 131.145, 131.245, 131.391, 131.609, 131.94, 132.402, 132.972, 133.632,
        111.658, 111.238, 111.146, 111.326, 111.725, 112.297, 112.998, 113.794, 114.657, 115.564,
        116.495, 117.429, 118.34, 119.193, 119.942, 120.523, 120.872, 120.923, 120.631, 119.988,
        119.037, 117.85, 116.534, 115.201, 113.945, 112.83, 111.922, 111.234, 110.773, 110.533,
        110.489, 110.598, 110.819, 111.126, 111.527, 112.047, 112.687, 113.422, 114.186, 114.911,
        115.543, 116.047, 116.428, 116.7, 116.88, 116.978, 117.011, 116.994, 116.955, 116.909,
        116.876, 116.874, 116.915, 117.02, 117.205, 117.457, 117.755, 118.052, 118.331, 118.599,
        118.895, 119.273, 119.759, 120.348, 121.012, 121.689, 122.318, 122.85, 123.273, 123.591,
        123.851, 124.099, 124.369, 124.67, 124.983, 125.271, 125.506, 125.686, 125.832, 125.992,
        126.233, 126.585, 127.081, 127.705, 128.419, 129.17, 129.903, 130.56, 131.103, 131.516,
        131.802, 131.976, 132.089, 132.188, 132.334, 132.552, 132.882, 133.343, 133.913, 134.572,
        111.238, 111.146, 111.326, 111.725, 112.297, 112.998, 113.794, 114.659, 115.57, 116.509,
        117.46, 118.406, 119.324, 120.179, 120.925, 121.498, 121.833, 121.865, 121.549, 120.878,
        119.898, 118.683, 117.341, 115.989, 114.721, 113.601, 112.696, 112.016, 111.569, 111.347,
        111.323, 111.452, 111.694, 112.02, 112.439, 112.973, 113.624, 114.368, 115.137, 115.864,
        116.494, 116.995, 117.37, 117.635, 117.808, 117.899, 117.924, 117.901, 117.857, 117.807,
        117.772, 117.77, 117.812, 117.92, 118.109, 118.367, 118.67, 118.973, 119.258, 119.532,
        119.834, 120.216, 120.705, 121.297, 121.963, 122.64, 123.269, 123.8, 124.222, 124.538,
        124.796, 125.042, 125.31, 125.609, 125.921, 126.208, 126.442, 126.622, 126.77, 126.932,
        127.174, 127.528, 128.026, 128.652, 129.369, 130.122, 130.856, 131.515, 132.06, 132.473,
        132.76, 132.934, 133.047, 133.146, 133.292, 133.509, 133.839, 134.3, 134.869, 135.528,
        111.146, 111.326, 111.725, 112.297, 112.998, 113.795, 114.66, 115.571, 116.514, 117.474,
        118.439, 119.393, 120.314, 121.169, 121.912, 122.479, 122.804, 122.821, 122.487, 121.795,
        120.794, 119.557, 118.198, 116.832, 115.555, 114.432, 113.53, 112.857, 112.421, 112.212,
        112.202, 112.347, 112.604, 112.945, 113.376, 113.921, 114.58, 115.329, 116.102, 116.83,
        117.459, 117.957, 118.328, 118.588, 118.755, 118.84, 118.86, 118.832, 118.784, 118.732,
        118.696, 118.694, 118.737, 118.847, 119.04, 119.301, 119.609, 119.916, 120.205, 120.484,
        120.789, 121.174, 121.667, 122.26, 122.927, 123.605, 124.234, 124.764, 125.184, 125.499,
        125.755, 126.0, 126.266, 126.564, 126.875, 127.162, 127.396, 127.577, 127.724, 127.887,
        128.131, 128.487, 128.986, 129.614, 130.332, 131.087, 131.822, 132.482, 133.028, 133.442,
        133.729, 133.904, 134.016, 134.115, 134.261, 134.478, 134.807, 135.268, 135.837, 136.496,
        111.326, 111.725, 112.297, 112.998, 113.795, 114.66, 115.572, 116.516, 117.48, 118.453,
        119.426, 120.385, 121.308, 122.163, 122.903, 123.465, 123.783, 123.789, 123.441, 122.735,
        121.717, 120.466, 119.093, 117.718, 116.436, 115.311, 114.41, 113.743, 113.315, 113.116,
        113.117, 113.273, 113.541, 113.892, 114.332, 114.884, 115.549, 116.303, 117.077, 117.806,
        118.434, 118.93, 119.298, 119.554, 119.717, 119.798, 119.813, 119.782, 119.732, 119.678,
        119.641, 119.639, 119.684, 119.796, 119.99, 120.255, 120.565, 120.875, 121.168, 121.45,
        121.757, 122.145, 122.639, 123.234, 123.902, 124.58, 125.208, 125.738, 126.157, 126.471,
        126.726, 126.969, 127.235, 127.532, 127.843, 128.129, 128.363, 128.544, 128.692, 128.856,
        129.1, 129.458, 129.958, 130.587, 131.306, 132.062, 132.798, 133.459, 134.005, 134.42,
        134.707, 134.882, 134.994, 135.093, 135.239, 135.456, 135.785, 136.246, 136.814, 137.473,
        111.725, 112.297, 112.998, 113.795, 114.66, 115.572, 116.517, 117.482, 118.459, 119.441,
        120.419, 121.38, 122.304, 123.159, 123.897, 124.455, 124.767, 124.766, 124.409, 123.692,
        122.663, 121.401, 120.019, 118.637, 117.351, 116.225, 115.327, 114.663, 114.241, 114.049,
        114.058, 114.223, 114.498, 114.856, 115.302, 115.86, 116.529, 117.285, 118.06, 118.789,
        119.417, 119.91, 120.276, 120.53, 120.69, 120.768, 120.781, 120.747, 120.695, 120.64,
        120.602, 120.601, 120.646, 120.759, 120.956, 121.222, 121.535, 121.847, 122.142, 122.426,
        122.736, 123.125, 123.62, 124.216, 124.885, 125.563, 126.191, 126.72, 127.139, 127.452,
        127.706, 127.948, 128.213, 128.51, 128.82, 129.106, 129.34, 129.521, 129.669, 129.834,
        130.079, 130.437, 130.939, 131.568, 132.288, 133.045, 133.782, 134.443, 134.99, 135.404,
        135.692, 135.866, 135.979, 136.078, 136.223, 136.44, 136.769, 137.23, 137.798, 138.457,
        112.297, 112.998, 113.795, 114.66, 115.572, 116.517, 117.482, 118.461, 119.447, 120.434,
        121.414, 122.377, 123.302, 124.156, 124.893, 125.449, 125.756, 125.75, 125.386, 124.661,
        123.625, 122.355, 120.967, 119.581, 118.293, 117.166, 116.269, 115.609, 115.191, 115.004,
        115.018, 115.188, 115.469, 115.832, 116.283, 116.843, 117.515, 118.272, 119.049, 119.778,
        120.405, 120.897, 121.262, 121.513, 121.672, 121.747, 121.758, 121.723, 121.67, 121.614,
        121.576, 121.575, 121.621, 121.735, 121.932, 122.2, 122.514, 122.828, 123.125, 123.41,
        123.721, 124.111, 124.608, 125.204, 125.873, 126.551, 127.179, 127.707, 128.126, 128.438,
        128.692, 128.933, 129.198, 129.494, 129.804, 130.09, 130.324, 130.505, 130.654, 130.819,
        131.065, 131.423, 131.925, 132.556, 133.276, 134.033, 134.771, 135.432, 135.979, 136.394,
        136.682, 136.856, 136.968, 137.067, 137.213, 137.429, 137.759, 138.219, 138.787, 139.445,
        112.998, 113.795, 114.66, 115.572, 116.517, 117.483, 118.462, 119.449, 120.44, 121.43,
        122.412, 123.376, 124.3, 125.154, 125.89, 126.444, 126.749, 126.739, 126.371, 125.641,
        124.599, 123.325, 121.932, 120.543, 119.253, 118.126, 117.23, 116.572, 116.157, 115.974,
        115.992, 116.165, 116.45, 116.816, 117.27, 117.833, 118.506, 119.265, 120.042, 120.77,
        121.397, 121.889, 122.252, 122.502, 122.659, 122.733, 122.743, 122.707, 122.653, 122.596,
        122.558, 122.558, 122.604, 122.718, 122.916, 123.185, 123.501, 123.816, 124.113, 124.399,
        124.711, 125.102, 125.599, 126.196, 126.865, 127.543, 128.171, 128.699, 129.117, 129.429,
        129.682, 129.924, 130.188, 130.484, 130.794, 131.08, 131.314, 131.494, 131.644, 131.808,
        132.055, 132.414, 132.916, 133.547, 134.268, 135.025, 135.763, 136.425, 136.972, 137.387,
        137.675, 137.849, 137.961, 138.06, 138.205, 138.422, 138.752, 139.212, 139.78, 140.438,
        113.795, 114.66, 115.572, 116.517, 117.483, 118.462, 119.449, 120.442, 121.435, 122.427,
        123.411, 124.375, 125.3, 126.153, 126.888, 127.441, 127.744, 127.732, 127.361, 126.627,
        125.582, 124.304, 122.909, 121.518, 120.227, 119.1, 118.205, 117.548, 117.135, 116.954,
        116.974, 117.151, 117.437, 117.806, 118.261, 118.826, 119.5, 120.259, 121.037, 121.765,
        122.392, 122.883, 123.245, 123.495, 123.651, 123.724, 123.733, 123.696, 123.642, 123.585,
        123.547, 123.546, 123.592, 123.708, 123.906, 124.176, 124.492, 124.808, 125.106, 125.392,
        125.705, 126.096, 126.593, 127.191, 127.86, 128.538, 129.165, 129.694, 130.112, 130.423,
        130.676, 130.917, 131.181, 131.477, 131.787, 132.073, 132.307, 132.488, 132.637, 132.802,
        133.049, 133.408, 133.911, 134.541, 135.263, 136.02, 136.758, 137.42, 137.967, 138.382,
        138.67, 138.844, 138.956, 139.055, 139.201, 139.418, 139.747, 140.207, 140.775, 141.433,
        114.66, 115.572, 116.517, 117.483, 118.462, 119.45, 120.442, 121.438, 122.433, 123.426,
        124.41, 125.374, 126.299, 127.152, 127.887, 128.439, 128.741, 128.727, 128.354, 127.618,
        126.571, 125.291, 123.894, 122.502, 121.21, 120.083, 119.188, 118.533, 118.121, 117.942,
        117.963, 118.141, 118.43, 118.8, 119.256, 119.821, 120.496, 121.256, 122.034, 122.762,
        123.388, 123.879, 124.241, 124.49, 124.645, 124.718, 124.726, 124.689, 124.635, 124.578,
        124.539, 124.539, 124.585, 124.701, 124.899, 125.17, 125.486, 125.802, 126.101, 126.388,
        126.701, 127.093, 127.59, 128.187, 128.856, 129.535, 130.162, 130.69, 131.108, 131.42,
        131.672, 131.913, 132.177, 132.473, 132.782, 133.068, 133.302, 133.483, 133.633, 133.798,
        134.045, 134.404, 134.907, 135.538, 136.259, 137.017, 137.755, 138.417, 138.964, 139.379,
        139.667, 139.842, 139.954, 140.052, 140.198, 140.415, 140.744, 141.204, 141.772, 142.43,
        115.572, 116.517, 117.483, 118.462, 119.45, 120.442, 121.438, 122.435, 123.432, 124.425,
        125.41, 126.374, 127.299, 128.152, 128.886, 129.438, 129.739, 129.724, 129.35, 128.612,
        127.563, 126.283, 124.885, 123.491, 122.2, 121.073, 120.178, 119.523, 119.112, 118.934,
        118.957, 119.135, 119.425, 119.796, 120.253, 120.819, 121.494, 122.254, 123.032, 123.761,
        124.386, 124.877, 125.239, 125.487, 125.642, 125.714, 125.722, 125.685, 125.63, 125.573,
        125.534, 125.534, 125.581, 125.696, 125.895, 126.166, 126.483, 126.799, 127.098, 127.385,
        127.698, 128.09, 128.588, 129.185, 129.854, 130.533, 131.16, 131.688, 132.106, 132.417,
        132.669, 132.91, 133.174, 133.47, 133.78, 134.066, 134.3, 134.48, 134.63, 134.795, 135.042,
        135.402, 135.905, 136.536, 137.257, 138.015, 138.753, 139.415, 139.962, 140.378, 140.665,
        140.84, 140.952, 141.051, 141.196, 141.413, 141.742, 142.202, 142.77, 143.428, 116.517,
        117.483, 118.462, 119.45, 120.442, 121.438, 122.436, 123.434, 124.431, 125.425, 126.409,
        127.374, 128.299, 129.152, 129.886, 130.437, 130.737, 130.722, 130.347, 129.609, 128.559,
        127.277, 125.879, 124.485, 123.193, 122.066, 121.172, 120.518, 120.107, 119.929, 119.952,
        120.132, 120.422, 120.793, 121.251, 121.817, 122.493, 123.253, 124.031, 124.759, 125.385,
        125.875, 126.237, 126.485, 126.64, 126.712, 126.72, 126.682, 126.628, 126.57, 126.531,
        126.531, 126.578, 126.694, 126.893, 127.163, 127.48, 127.797, 128.096, 128.384, 128.697,
        129.089, 129.586, 130.184, 130.853, 131.531, 132.159, 132.687, 133.105, 133.416, 133.668,
        133.909, 134.173, 134.468, 134.778, 135.064, 135.298, 135.479, 135.628, 135.793, 136.04,
        136.4, 136.903, 137.534, 138.256, 139.014, 139.752, 140.414, 140.961, 141.376, 141.664,
        141.839, 141.951, 142.049, 142.195, 142.412, 142.741, 143.201, 143.769, 144.427, 117.483,
        118.462, 119.45, 120.442, 121.438, 122.436, 123.435, 124.433, 125.431, 126.425, 127.409,
        128.374, 129.299, 130.151, 130.886, 131.436, 131.737, 131.721, 131.345, 130.607, 129.556,
        128.274, 126.875, 125.481, 124.189, 123.062, 122.168, 121.514, 121.104, 120.926, 120.95,
        121.13, 121.42, 121.792, 122.25, 122.816, 123.492, 124.252, 125.03, 125.759, 126.384,
        126.875, 127.236, 127.484, 127.639, 127.711, 127.718, 127.681, 127.626, 127.568, 127.53,
        127.53, 127.576, 127.692, 127.891, 128.162, 128.479, 128.796, 129.095, 129.383, 129.696,
        130.088, 130.586, 131.183, 131.852, 132.531, 133.158, 133.686, 134.104, 134.415, 134.667,
        134.908, 135.172, 135.467, 135.777, 136.063, 136.297, 136.478, 136.627, 136.792, 137.04,
        137.399, 137.902, 138.533, 139.255, 140.013, 140.751, 141.413, 141.961, 142.376, 142.664,
        142.838, 142.95, 143.049, 143.194, 143.411, 143.74, 144.2, 144.768, 145.426, 118.462,
        119.45, 120.442, 121.438, 122.436, 123.435, 124.434, 125.433, 126.431, 127.425, 128.409,
        129.374, 130.299, 131.151, 131.885, 132.436, 132.736, 132.72, 132.344, 131.605, 130.555,
        129.272, 127.873, 126.479, 125.187, 124.06, 123.166, 122.512, 122.102, 121.924, 121.948,
        122.129, 122.419, 122.791, 123.249, 123.816, 124.491, 125.252, 126.03, 126.758, 127.384,
        127.874, 128.235, 128.483, 128.638, 128.71, 128.717, 128.68, 128.625, 128.567, 128.529,
        128.529, 128.575, 128.691, 128.89, 129.161, 129.478, 129.795, 130.095, 130.382, 130.695,
        131.087, 131.585, 132.183, 132.852, 133.53, 134.157, 134.685, 135.103, 135.414, 135.666,
        135.907, 136.171, 136.467, 136.776, 137.062, 137.296, 137.477, 137.627, 137.792, 138.039,
        138.399, 138.902, 139.533, 140.255, 141.013, 141.751, 142.413, 142.96, 143.375, 143.663,
        143.838, 143.949, 144.048, 144.194, 144.411, 144.74, 145.2, 145.767, 146.426, 119.45,
        120.442, 121.438, 122.436, 123.435, 124.434, 125.434, 126.433, 127.431, 128.425, 129.409,
        130.374, 131.298, 132.151, 132.885, 133.436, 133.736, 133.72, 133.344, 132.604, 131.554,
        130.271, 128.872, 127.478, 126.185, 125.059, 124.165, 123.511, 123.101, 122.923, 122.948,
        123.128, 123.419, 123.791, 124.249, 124.815, 125.491, 126.252, 127.03, 127.758, 128.383,
        128.874, 129.235, 129.483, 129.638, 129.709, 129.717, 129.679, 129.624, 129.567, 129.528,
        129.528, 129.575, 129.69, 129.89, 130.161, 130.478, 130.795, 131.094, 131.382, 131.695,
        132.087, 132.585, 133.183, 133.852, 134.53, 135.157, 135.685, 136.103, 136.414, 136.666,
        136.907, 137.171, 137.466, 137.776, 138.062, 138.296, 138.477, 138.626, 138.792, 139.039,
        139.399, 139.902, 140.533, 141.254, 142.012, 142.751, 143.413, 143.96, 144.375, 144.663,
        144.837, 144.949, 145.048, 145.194, 145.41, 145.74, 146.199, 146.767, 147.426, 120.442,
        121.438, 122.436, 123.435, 124.434, 125.434, 126.434, 127.433, 128.431, 129.425, 130.409,
        131.374, 132.298, 133.151, 133.885, 134.436, 134.736, 134.719, 134.343, 133.604, 132.553,
        131.27, 129.871, 128.477, 127.185, 126.058, 125.164, 124.51, 124.1, 123.923, 123.947,
        124.127, 124.418, 124.79, 125.248, 125.815, 126.491, 127.252, 128.029, 128.758, 129.383,
        129.874, 130.235, 130.483, 130.637, 130.709, 130.716, 130.679, 130.624, 130.566, 130.528,
        130.528, 130.575, 130.69, 130.89, 131.16, 131.478, 131.795, 132.094, 132.382, 132.695,
        133.087, 133.585, 134.182, 134.852, 135.53, 136.157, 136.685, 137.103, 137.414, 137.666,
        137.907, 138.171, 138.466, 138.776, 139.062, 139.296, 139.476, 139.626, 139.791, 140.038,
        140.398, 140.901, 141.533, 142.254, 143.012, 143.75, 144.413, 144.96, 145.375, 145.663,
        145.837, 145.949, 146.048, 146.193, 146.41, 146.74, 147.199, 147.767, 148.426, 121.438,
        122.436, 123.435, 124.434, 125.434, 126.434, 127.434, 128.433, 129.431, 130.425, 131.409,
        132.374, 133.298, 134.151, 134.885, 135.436, 135.736, 135.719, 135.343, 134.604, 133.553,
        132.27, 130.871, 129.476, 128.184, 127.057, 126.163, 125.51, 125.1, 124.923, 124.947,
        125.127, 125.418, 125.79, 126.248, 126.815, 127.491, 128.251, 129.029, 129.758, 130.383,
        130.874, 131.235, 131.482, 131.637, 131.709, 131.716, 131.679, 131.624, 131.566, 131.528,
        131.527, 131.574, 131.69, 131.889, 132.16, 132.477, 132.794, 133.094, 133.382, 133.695,
        134.087, 134.585, 135.182, 135.852, 136.53, 137.157, 137.685, 138.103, 138.414, 138.666,
        138.907, 139.17, 139.466, 139.776, 140.062, 140.296, 140.476, 140.626, 140.791, 141.038,
        141.398, 141.901, 142.532, 143.254, 144.012, 144.75, 145.413, 145.96, 146.375, 146.663,
        146.837, 146.949, 147.048, 147.193, 147.41, 147.739, 148.199, 148.767, 149.426, 122.436,
        123.435, 124.434, 125.434, 126.434, 127.434, 128.433, 129.433, 130.431, 131.425, 132.409,
        133.374, 134.298, 135.151, 135.885, 136.436, 136.736, 136.719, 136.343, 135.604, 134.553,
        133.27, 131.871, 130.476, 129.184, 128.057, 127.163, 126.509, 126.099, 125.922, 125.947,
        126.127, 126.418, 126.79, 127.248, 127.815, 128.491, 129.251, 130.029, 130.758, 131.383,
        131.874, 132.235, 132.482, 132.637, 132.709, 132.716, 132.678, 132.624, 132.566, 132.528,
        132.527, 132.574, 132.69, 132.889, 133.16, 133.477, 133.794, 134.094, 134.381, 134.695,
        135.087, 135.585, 136.182, 136.852, 137.53, 138.157, 138.685, 139.103, 139.414, 139.666,
        139.907, 140.17, 140.466, 140.776, 141.062, 141.295, 141.476, 141.626, 141.791, 142.038,
        142.398, 142.901, 143.532, 144.254, 145.012, 145.75, 146.413, 146.96, 147.375, 147.663,
        147.837, 147.949, 148.048, 148.193, 148.41, 148.739, 149.199, 149.767, 150.426, 123.435,
        124.434, 125.434, 126.434, 127.434, 128.434, 129.433, 130.433, 131.431, 132.425, 133.409,
        134.374, 135.298, 136.151, 136.885, 137.436, 137.736, 137.719, 137.343, 136.604, 135.553,
        134.27, 132.87, 131.476, 130.184, 129.057, 128.163, 127.509, 127.099, 126.922, 126.947,
        127.127, 127.418, 127.79, 128.248, 128.815, 129.491, 130.251, 131.029, 131.758, 132.383,
        132.874, 133.235, 133.482, 133.637, 133.709, 133.716, 133.678, 133.624, 133.566, 133.527,
        133.527, 133.574, 133.69, 133.889, 134.16, 134.477, 134.794, 135.094, 135.381, 135.695,
        136.087, 136.585, 137.182, 137.852, 138.53, 139.157, 139.685, 140.103, 140.414, 140.666,
        140.907, 141.17, 141.466, 141.776, 142.062, 142.295, 142.476, 142.626, 142.791, 143.038,
        143.398, 143.901, 144.532, 145.254, 146.012, 146.75, 147.412, 147.96, 148.375, 148.663,
        148.837, 148.949, 149.048, 149.193, 149.41, 149.739, 150.199, 150.767, 151.426, 124.434,
        125.434, 126.434, 127.434, 128.434, 129.434, 130.433, 131.433, 132.431, 133.425, 134.409,
        135.374, 136.298, 137.151, 137.885, 138.436, 138.736, 138.719, 138.343, 137.604, 136.553,
        135.27, 133.87, 132.476, 131.184, 130.057, 129.163, 128.509, 128.099, 127.922, 127.947,
        128.127, 128.418, 128.79, 129.248, 129.815, 130.491, 131.251, 132.029, 132.758, 133.383,
        133.873, 134.235, 134.482, 134.637, 134.709, 134.716, 134.678, 134.624, 134.566, 134.527,
        134.527, 134.574, 134.69, 134.889, 135.16, 135.477, 135.794, 136.094, 136.381, 136.695,
        137.087, 137.585, 138.182, 138.852, 139.53, 140.157, 140.685, 141.103, 141.414, 141.666,
        141.907, 142.17, 142.466, 142.776, 143.062, 143.295, 143.476, 143.626, 143.791, 144.038,
        144.398, 144.901, 145.532, 146.254, 147.012, 147.75, 148.412, 148.96, 149.375, 149.663,
        149.837, 149.949, 150.048, 150.193, 150.41, 150.739, 151.199, 151.767, 152.426, 125.434,
        126.434, 127.434, 128.434, 129.434, 130.434, 131.433, 132.433, 133.431, 134.425, 135.409,
        136.374, 137.298, 138.151, 138.885, 139.436, 139.736, 139.719, 139.343, 138.604, 137.553,
        136.27, 134.87, 133.476, 132.184, 131.057, 130.163, 129.509, 129.099, 128.922, 128.947,
        129.127, 129.418, 129.79, 130.248, 130.815, 131.491, 132.251, 133.029, 133.758, 134.383,
        134.873, 135.235, 135.482, 135.637, 135.709, 135.716, 135.678, 135.624, 135.566, 135.527,
        135.527, 135.574, 135.69, 135.889, 136.16, 136.477, 136.794, 137.094, 137.381, 137.695,
        138.087, 138.585, 139.182, 139.852, 140.53, 141.157, 141.685, 142.103, 142.414, 142.666,
        142.907, 143.17, 143.466, 143.776, 144.062, 144.295, 144.476, 144.626, 144.791, 145.038,
        145.398, 145.901, 146.532, 147.254, 148.012, 148.75, 149.412, 149.96, 150.375, 150.663,
        150.837, 150.949, 151.048, 151.193, 151.41, 151.739, 152.199, 152.767, 153.425, 126.434,
        127.434, 128.434, 129.434, 130.434, 131.434, 132.433, 133.433, 134.431, 135.425, 136.409,
        137.374, 138.298, 139.151, 139.885, 140.436, 140.736, 140.719, 140.343, 139.604, 138.553,
        137.27, 135.87, 134.476, 133.184, 132.057, 131.163, 130.509, 130.099, 129.922, 129.947,
        130.127, 130.418, 130.79, 131.248, 131.815, 132.491, 133.251, 134.029, 134.758, 135.383,
        135.873, 136.235, 136.482, 136.637, 136.709, 136.716, 136.678, 136.624, 136.566, 136.527,
        136.527, 136.574, 136.69, 136.889, 137.16, 137.477, 137.794, 138.094, 138.381, 138.695,
        139.087, 139.585, 140.182, 140.851, 141.53, 142.157, 142.685, 143.103, 143.414, 143.666,
        143.907, 144.17, 144.466, 144.776, 145.062, 145.295, 145.476, 145.626, 145.791, 146.038,
        146.398, 146.901, 147.532, 148.254, 149.012, 149.75, 150.412, 150.96, 151.375, 151.663,
        151.837, 151.949, 152.048, 152.193, 152.41, 152.739, 153.199, 153.767, 154.425, 127.434,
        128.434, 129.434, 130.434, 131.434, 132.434, 133.433, 134.433, 135.431, 136.425, 137.409,
        138.374, 139.298, 140.151, 140.885, 141.436, 141.736, 141.719, 141.343, 140.604, 139.553,
        138.27, 136.87, 135.476, 134.184, 133.057, 132.163, 131.509, 131.099, 130.922, 130.947,
        131.127, 131.418, 131.79, 132.248, 132.815, 133.491, 134.251, 135.029, 135.758, 136.383,
        136.873, 137.235, 137.482, 137.637, 137.709, 137.716, 137.678, 137.624, 137.566, 137.527,
        137.527, 137.574, 137.69, 137.889, 138.16, 138.477, 138.794, 139.094, 139.381, 139.695,
        140.087, 140.585, 141.182, 141.851, 142.53, 143.157, 143.685, 144.103, 144.414, 144.666,
        144.907, 145.17, 145.466, 145.776, 146.062, 146.295, 146.476, 146.626, 146.791, 147.038,
        147.398, 147.901, 148.532, 149.254, 150.012, 150.75, 151.412, 151.96, 152.375, 152.663,
        152.837, 152.949, 153.048, 153.193, 153.41, 153.739, 154.199, 154.767, 155.425, 128.434,
        129.434, 130.434, 131.434, 132.434, 133.434, 134.433, 135.433, 136.431, 137.425, 138.409,
        139.374, 140.298, 141.151, 141.885, 142.436, 142.736, 142.719, 142.343, 141.604, 140.553,
        139.27, 137.87, 136.476, 135.184, 134.057, 133.163, 132.509, 132.099, 131.922, 131.947,
        132.127, 132.418, 132.79, 133.248, 133.815, 134.491, 135.251, 136.029, 136.758, 137.383,
        137.873, 138.235, 138.482, 138.637, 138.709, 138.716, 138.678, 138.624, 138.566, 138.527,
        138.527, 138.574, 138.69, 138.889, 139.16, 139.477, 139.794, 140.094, 140.381, 140.695,
        141.087, 141.585, 142.182, 142.851, 143.53, 144.157, 144.685, 145.103, 145.414, 145.666,
        145.907, 146.17, 146.466, 146.776, 147.062, 147.295, 147.476, 147.626, 147.791, 148.038,
        148.398, 148.901, 149.532, 150.254, 151.012, 151.75, 152.412, 152.96, 153.375, 153.663,
        153.837, 153.949, 154.048, 154.193, 154.41, 154.739, 155.199, 155.767, 156.425, 129.434,
        130.434, 131.434, 132.434, 133.434, 134.434, 135.433, 136.433, 137.431, 138.425, 139.409,
        140.374, 141.298, 142.151, 142.885, 143.436, 143.736, 143.719, 143.343, 142.604, 141.553,
        140.27, 138.87, 137.476, 136.184, 135.057, 134.163, 133.509, 133.099, 132.922, 132.947,
        133.127, 133.418, 133.79, 134.248, 134.815, 135.491, 136.251, 137.029, 137.758, 138.383,
        138.873, 139.235, 139.482, 139.637, 139.709, 139.716, 139.678, 139.624, 139.566, 139.527,
        139.527, 139.574, 139.69, 139.889, 140.16, 140.477, 140.794, 141.094, 141.381, 141.695,
        142.087, 142.585, 143.182, 143.851, 144.53, 145.157, 145.685, 146.103, 146.414, 146.666,
        146.907, 147.17, 147.466, 147.776, 148.062, 148.295, 148.476, 148.626, 148.791, 149.038,
        149.398, 149.901, 150.532, 151.254, 152.012, 152.75, 153.412, 153.96, 154.375, 154.663,
        154.837, 154.949, 155.048, 155.193, 155.41, 155.739, 156.199, 156.767, 157.425, 130.434,
        131.434, 132.434, 133.434, 134.434, 135.434, 136.433, 137.433, 138.431, 139.425, 140.409,
        141.374, 142.298, 143.151, 143.885, 144.436, 144.736, 144.719, 144.343, 143.604, 142.553,
        141.27, 139.87, 138.476, 137.184, 136.057, 135.163, 134.509, 134.099, 133.922, 133.947,
        134.127, 134.418, 134.79, 135.248, 135.815, 136.491, 137.251, 138.029, 138.758, 139.383,
        139.873, 140.235, 140.482, 140.637, 140.709, 140.716, 140.678, 140.624, 140.566, 140.527,
        140.527, 140.574, 140.69, 140.889, 141.16, 141.477, 141.794, 142.094, 142.381, 142.695,
        143.087, 143.585, 144.182, 144.851, 145.53, 146.157, 146.685, 147.103, 147.414, 147.666,
        147.907, 148.17, 148.466, 148.776, 149.062, 149.295, 149.476, 149.626, 149.791, 150.038,
        150.398, 150.901, 151.532, 152.254, 153.012, 153.75, 154.412, 154.96, 155.375, 155.663,
        155.837, 155.949, 156.048, 156.193, 156.41, 156.739, 157.199, 157.767, 158.425, 131.434,
        132.434, 133.434, 134.434, 135.434, 136.434, 137.433, 138.433, 139.431, 140.425, 141.409,
        142.374, 143.298, 144.151, 144.885, 145.436, 145.736, 145.719, 145.343, 144.604, 143.553,
        142.27, 140.87, 139.476, 138.184, 137.057, 136.163, 135.509, 135.099, 134.922, 134.947,
        135.127, 135.418, 135.79, 136.248, 136.815, 137.491, 138.251, 139.029, 139.758, 140.383,
        140.873, 141.235, 141.482, 141.637, 141.709, 141.716, 141.678, 141.624, 141.566, 141.527,
        141.527, 141.574, 141.69, 141.889, 142.16, 142.477, 142.794, 143.094, 143.381, 143.695,
        144.087, 144.585, 145.182, 145.851, 146.53, 147.157, 147.685, 148.103, 148.414, 148.666,
        148.907, 149.17, 149.466, 149.776, 150.062, 150.295, 150.476, 150.626, 150.791, 151.038,
        151.398, 151.901, 152.532, 153.254, 154.012, 154.75, 155.412, 155.96, 156.375, 156.663,
        156.837, 156.949, 157.048, 157.193, 157.41, 157.739, 158.199, 158.767, 159.425, 132.434,
        133.434, 134.434, 135.434, 136.434, 137.434, 138.433, 139.433, 140.431, 141.425, 142.409,
        143.374, 144.298, 145.151, 145.885, 146.436, 146.736, 146.719, 146.343, 145.604, 144.553,
        143.27, 141.87, 140.476, 139.184, 138.057, 137.163, 136.509, 136.099, 135.922, 135.947,
        136.127, 136.418, 136.79, 137.248, 137.815, 138.491, 139.251, 140.029, 140.758, 141.383,
        141.873, 142.235, 142.482, 142.637, 142.709, 142.716, 142.678, 142.624, 142.566, 142.527,
        142.527, 142.574, 142.69, 142.889, 143.16, 143.477, 143.794, 144.094, 144.381, 144.695,
        145.087, 145.585, 146.182, 146.851, 147.53, 148.157, 148.685, 149.103, 149.414, 149.666,
        149.907, 150.17, 150.466, 150.776, 151.062, 151.295, 151.476, 151.626, 151.791, 152.038,
        152.398, 152.901, 153.532, 154.254, 155.012, 155.75, 156.412, 156.96, 157.375, 157.663,
        157.837, 157.949, 158.048, 158.193, 158.41, 158.739, 159.199, 159.767, 160.425, 133.434,
        134.434, 135.434, 136.434, 137.434, 138.434, 139.433, 140.433, 141.431, 142.425, 143.409,
        144.374, 145.298, 146.151, 146.885, 147.436, 147.736, 147.719, 147.343, 146.604, 145.553,
        144.27, 142.87, 141.476, 140.184, 139.057, 138.163, 137.509, 137.099, 136.922, 136.947,
        137.127, 137.418, 137.79, 138.248, 138.815, 139.491, 140.251, 141.029, 141.758, 142.383,
        142.873, 143.235, 143.482, 143.637, 143.709, 143.716, 143.678, 143.624, 143.566, 143.527,
        143.527, 143.574, 143.69, 143.889, 144.16, 144.477, 144.794, 145.094, 145.381, 145.695,
        146.087, 146.585, 147.182, 147.851, 148.53, 149.157, 149.685, 150.103, 150.414, 150.666,
        150.907, 151.17, 151.466, 151.776, 152.062, 152.295, 152.476, 152.626, 152.791, 153.038,
        153.398, 153.901, 154.532, 155.254, 156.012, 156.75, 157.412, 157.96, 158.375, 158.663,
        158.837, 158.949, 159.048, 159.193, 159.41, 159.739, 160.199, 160.767, 161.425, 134.434,
        135.434, 136.434, 137.434, 138.434, 139.434, 140.433, 141.433, 142.431, 143.425, 144.409,
        145.374, 146.298, 147.151, 147.885, 148.436, 148.736, 148.719, 148.343, 147.604, 146.553,
        145.27, 143.87, 142.476, 141.184, 140.057, 139.163, 138.509, 138.099, 137.922, 137.947,
        138.127, 138.418, 138.79, 139.248, 139.815, 140.491, 141.251, 142.029, 142.758, 143.383,
        143.873, 144.235, 144.482, 144.637, 144.709, 144.716, 144.678, 144.624, 144.566, 144.527,
        144.527, 144.574, 144.69, 144.889, 145.16, 145.477, 145.794, 146.094, 146.381, 146.695,
        147.087, 147.585, 148.182, 148.851, 149.53, 150.157, 150.685, 151.103, 151.414, 151.666,
        151.907, 152.17, 152.466, 152.776, 153.062, 153.295, 153.476, 153.626, 153.791, 154.038,
        154.398, 154.901, 155.532, 156.254, 157.012, 157.75, 158.412, 158.96, 159.375, 159.663,
        159.837, 159.949, 160.048, 160.193, 160.41, 160.739, 161.199, 161.767, 162.425, 135.434,
        136.434, 137.434, 138.434, 139.434, 140.434, 141.433, 142.433, 143.431, 144.425, 145.409,
        146.374, 147.298, 148.151, 148.885, 149.436, 149.736, 149.719, 149.343, 148.604, 147.553,
        146.27, 144.87, 143.476, 142.184, 141.057, 140.163, 139.509, 139.099, 138.922, 138.947,
        139.127, 139.418, 139.79, 140.248, 140.815, 141.491, 142.251, 143.029, 143.758, 144.383,
        144.873, 145.235, 145.482, 145.637, 145.709, 145.716, 145.678, 145.624, 145.566, 145.527,
        145.527, 145.574, 145.69, 145.889, 146.16, 146.477, 146.794, 147.094, 147.381, 147.695,
        148.087, 148.585, 149.182, 149.851, 150.53, 151.157, 151.685, 152.103, 152.414, 152.666,
        152.907, 153.17, 153.466, 153.776, 154.062, 154.295, 154.476, 154.626, 154.791, 155.038,
        155.398, 155.901, 156.532, 157.254, 158.012, 158.75, 159.412, 159.96, 160.375, 160.663,
        160.837, 160.949, 161.048, 161.193, 161.41, 161.739, 162.199, 162.767, 163.425, 136.434,
        137.434, 138.434, 139.434, 140.434, 141.434, 142.433, 143.433, 144.431, 145.425, 146.409,
        147.374, 148.298, 149.151, 149.885, 150.436, 150.736, 150.719, 150.343, 149.604, 148.553,
        147.27, 145.87, 144.476, 143.184, 142.057, 141.163, 140.509, 140.099, 139.922, 139.947,
        140.127, 140.418, 140.79, 141.248, 141.815, 142.491, 143.251, 144.029, 144.758, 145.383,
        145.873, 146.235, 146.482, 146.637, 146.709, 146.716, 146.678, 146.624, 146.566, 146.527,
        146.527, 146.574, 146.69, 146.889, 147.16, 147.477, 147.794, 148.094, 148.381, 148.695,
        149.087, 149.585, 150.182, 150.851, 151.53, 152.157, 152.685, 153.103, 153.414, 153.666,
        153.907, 154.17, 154.466, 154.776, 155.062, 155.295, 155.476, 155.626, 155.791, 156.038,
        156.398, 156.901, 157.532, 158.254, 159.012, 159.75, 160.412, 160.96, 161.375, 161.663,
        161.837, 161.949, 162.048, 162.193, 162.41, 162.739, 163.199, 163.767, 164.425, 137.434,
        138.434, 139.434, 140.434, 141.434, 142.434, 143.433, 144.433, 145.431, 146.425, 147.409,
        148.374, 149.298, 150.151, 150.885, 151.436, 151.736, 151.719, 151.343, 150.604, 149.553,
        148.27, 146.87, 145.476, 144.184, 143.057, 142.163, 141.509, 141.099, 140.922, 140.947,
        141.127, 141.418, 141.79, 142.248, 142.815, 143.491, 144.251, 145.029, 145.758, 146.383,
        146.873, 147.235, 147.482, 147.637, 147.709, 147.716, 147.678, 147.624, 147.566, 147.527,
        147.527, 147.574, 147.69, 147.889, 148.16, 148.477, 148.794, 149.094, 149.381, 149.695,
        150.087, 150.585, 151.182, 151.851, 152.53, 153.157, 153.685, 154.103, 154.414, 154.666,
        154.907, 155.17, 155.466, 155.776, 156.062, 156.295, 156.476, 156.626, 156.791, 157.038,
        157.398, 157.901, 158.532, 159.254, 160.012, 160.75, 161.412, 161.96, 162.375, 162.663,
        162.837, 162.949, 163.048, 163.193, 163.41, 163.739, 164.199, 164.767, 165.425, 138.434,
        139.434, 140.434, 141.434, 142.434, 143.434, 144.433, 145.433, 146.431, 147.425, 148.409,
        149.374, 150.298, 151.151, 151.885, 152.436, 152.736, 152.719, 152.343, 151.604, 150.553,
        149.27, 147.87, 146.476, 145.184, 144.057, 143.163, 142.509, 142.099, 141.922, 141.947,
        142.127, 142.418, 142.79, 143.248, 143.815, 144.491, 145.251, 146.029, 146.758, 147.383,
        147.873, 148.235, 148.482, 148.637, 148.709, 148.716, 148.678, 148.624, 148.566, 148.527,
        148.527, 148.574, 148.69, 148.889, 149.16, 149.477, 149.794, 150.094, 150.381, 150.695,
        151.087, 151.585, 152.182, 152.851, 153.53, 154.157, 154.685, 155.103, 155.414, 155.666,
        155.907, 156.17, 156.466, 156.776, 157.062, 157.295, 157.476, 157.626, 157.791, 158.038,
        158.398, 158.901, 159.532, 160.254, 161.012, 161.75, 162.412, 162.96, 163.375, 163.663,
        163.837, 163.949, 164.048, 164.193, 164.41, 164.739, 165.199, 165.767, 166.425, 139.434,
        140.434, 141.434, 142.434, 143.434, 144.434, 145.433, 146.433, 147.431, 148.425, 149.409,
        150.374, 151.298, 152.151, 152.885, 153.436, 153.736, 153.719, 153.343, 152.604, 151.553,
        150.27, 148.87, 147.476, 146.184, 145.057, 144.163, 143.509, 143.099, 142.922, 142.947,
        143.127, 143.418, 143.79, 144.248, 144.815, 145.491, 146.251, 147.029, 147.758, 148.383,
        148.873, 149.235, 149.482, 149.637, 149.709, 149.716, 149.678, 149.624, 149.566, 149.527,
        149.527, 149.574, 149.69, 149.889, 150.16, 150.477, 150.794, 151.094, 151.381, 151.695,
        152.087, 152.585, 153.182, 153.851, 154.53, 155.157, 155.685, 156.103, 156.414, 156.666,
        156.907, 157.17, 157.466, 157.776, 158.062, 158.295, 158.476, 158.626, 158.791, 159.038,
        159.398, 159.901, 160.532, 161.254, 162.012, 162.75, 163.412, 163.96, 164.375, 164.663,
        164.837, 164.949, 165.048, 165.193, 165.41, 165.739, 166.199, 166.767, 167.425, 140.434,
        141.434, 142.434, 143.434, 144.434, 145.434, 146.433, 147.433, 148.431, 149.425, 150.409,
        151.374, 152.298, 153.151, 153.885, 154.436, 154.736, 154.719, 154.343, 153.604, 152.553,
        151.27, 149.87, 148.476, 147.184, 146.057, 145.163, 144.509, 144.099, 143.922, 143.947,
        144.127, 144.418, 144.79, 145.248, 145.815, 146.491, 147.251, 148.029, 148.758, 149.383,
        149.873, 150.235, 150.482, 150.637, 150.709, 150.716, 150.678, 150.624, 150.566, 150.527,
        150.527, 150.574, 150.69, 150.889, 151.16, 151.477, 151.794, 152.094, 152.381, 152.695,
        153.087, 153.585, 154.182, 154.851, 155.53, 156.157, 156.685, 157.103, 157.414, 157.666,
        157.907, 158.17, 158.466, 158.776, 159.062, 159.295, 159.476, 159.626, 159.791, 160.038,
        160.398, 160.901, 161.532, 162.254, 163.012, 163.75, 164.412, 164.96, 165.375, 165.663,
        165.837, 165.949, 166.048, 166.193, 166.41, 166.739, 167.199, 167.767, 168.425, 141.434,
        142.434, 143.434, 144.434, 145.434, 146.434, 147.433, 148.433, 149.431, 150.425, 151.409,
        152.374, 153.298, 154.151, 154.885, 155.436, 155.736, 155.719, 155.343, 154.604, 153.553,
        152.27, 150.87, 149.476, 148.184, 147.057, 146.163, 145.509, 145.099, 144.922, 144.947,
        145.127, 145.418, 145.79, 146.248, 146.815, 147.491, 148.251, 149.029, 149.758, 150.383,
        150.873, 151.235, 151.482, 151.637, 151.709, 151.716, 151.678, 151.624, 151.566, 151.527,
        151.527, 151.574, 151.69, 151.889, 152.16, 152.477, 152.794, 153.094, 153.381, 153.695,
        154.087, 154.585, 155.182, 155.851, 156.53, 157.157, 157.685, 158.103, 158.414, 158.666,
        158.907, 159.17, 159.466, 159.776, 160.062, 160.295, 160.476, 160.626, 160.791, 161.038,
        161.398, 161.901, 162.532, 163.254, 164.012, 164.75, 165.412, 165.96, 166.375, 166.663,
        166.837, 166.949, 167.048, 167.193, 167.41, 167.739, 168.199, 168.767, 169.425, 142.434,
        143.434, 144.434, 145.434, 146.434, 147.434, 148.433, 149.433, 150.431, 151.425, 152.409,
        153.374, 154.298, 155.151, 155.885, 156.436, 156.736, 156.719, 156.343, 155.604, 154.553,
        153.27, 151.87, 150.476, 149.184, 148.057, 147.163, 146.509, 146.099, 145.922, 145.947,
        146.127, 146.418, 146.79, 147.248, 147.815, 148.491, 149.251, 150.029, 150.758, 151.383,
        151.873, 152.235, 152.482, 152.637, 152.709, 152.716, 152.678, 152.624, 152.566, 152.527,
        152.527, 152.574, 152.69, 152.889, 153.16, 153.477, 153.794, 154.094, 154.381, 154.695,
        155.087, 155.585, 156.182, 156.851, 157.53, 158.157, 158.685, 159.103, 159.414, 159.666,
        159.907, 160.17, 160.466, 160.776, 161.062, 161.295, 161.476, 161.626, 161.791, 162.038,
        162.398, 162.901, 163.532, 164.254, 165.012, 165.75, 166.412, 166.96, 167.375, 167.663,
        167.837, 167.949, 168.048, 168.193, 168.41, 168.739, 169.199, 169.767, 170.425, 143.434,
        144.434, 145.434, 146.434, 147.434, 148.434, 149.433, 150.433, 151.431, 152.425, 153.409,
        154.374, 155.298, 156.151, 156.885, 157.436, 157.736, 157.719, 157.343, 156.604, 155.553,
        154.27, 152.87, 151.476, 150.184, 149.057, 148.163, 147.509, 147.099, 146.922, 146.947,
        147.127, 147.418, 147.79, 148.248, 148.815, 149.491, 150.251, 151.029, 151.758, 152.383,
        152.873, 153.235, 153.482, 153.637, 153.709, 153.716, 153.678, 153.624, 153.566, 153.527,
        153.527, 153.574, 153.69, 153.889, 154.16, 154.477, 154.794, 155.094, 155.381, 155.695,
        156.087, 156.585, 157.182, 157.851, 158.53, 159.157, 159.685, 160.103, 160.414, 160.666,
        160.907, 161.17, 161.466, 161.776, 162.062, 162.295, 162.476, 162.626, 162.791, 163.038,
        163.398, 163.901, 164.532, 165.254, 166.012, 166.75, 167.412, 167.96, 168.375, 168.663,
        168.837, 168.949, 169.048, 169.193, 169.41, 169.739, 170.199, 170.767, 171.425, 144.434,
        145.434, 146.434, 147.434, 148.434, 149.434, 150.433, 151.433, 152.431, 153.425, 154.409,
        155.374, 156.298, 157.151, 157.885, 158.436, 158.736, 158.719, 158.343, 157.604, 156.553,
        155.27, 153.87, 152.476, 151.184, 150.057, 149.163, 148.509, 148.099, 147.922, 147.947,
        148.127, 148.418, 148.79, 149.248, 149.815, 150.491, 151.251, 152.029, 152.758, 153.383,
        153.873, 154.235, 154.482, 154.637, 154.709, 154.716, 154.678, 154.624, 154.566, 154.527,
        154.527, 154.574, 154.69, 154.889, 155.16, 155.477, 155.794, 156.094, 156.381, 156.695,
        157.087, 157.585, 158.182, 158.851, 159.53, 160.157, 160.685, 161.103, 161.414, 161.666,
        161.907, 162.17, 162.466, 162.776, 163.062, 163.295, 163.476, 163.626, 163.791, 164.038,
        164.398, 164.901, 165.532, 166.254, 167.012, 167.75, 168.412, 168.96, 169.375, 169.663,
        169.837, 169.949, 170.048, 170.193, 170.41, 170.739, 171.199, 171.767, 172.425, 145.434,
        146.434, 147.434, 148.434, 149.434, 150.434, 151.433, 152.433, 153.431, 154.425, 155.409,
        156.374, 157.298, 158.151, 158.885, 159.436, 159.736, 159.719, 159.343, 158.604, 157.553,
        156.27, 154.87, 153.476, 152.184, 151.057, 150.163, 149.509, 149.099, 148.922, 148.947,
        149.127, 149.418, 149.79, 150.248, 150.815, 151.491, 152.251, 153.029, 153.758, 154.383,
        154.873, 155.235, 155.482, 155.637, 155.709, 155.716, 155.678, 155.624, 155.566, 155.527,
        155.527, 155.574, 155.69, 155.889, 156.16, 156.477, 156.794, 157.094, 157.381, 157.695,
        158.087, 158.585, 159.182, 159.851, 160.53, 161.157, 161.685, 162.103, 162.414, 162.666,
        162.907, 163.17, 163.466, 163.776, 164.062, 164.295, 164.476, 164.626, 164.791, 165.038,
        165.398, 165.901, 166.532, 167.254, 168.012, 168.75, 169.412, 169.96, 170.375, 170.663,
        170.837, 170.949, 171.048, 171.193, 171.41, 171.739, 172.199, 172.767, 173.425, 146.434,
        147.434, 148.434, 149.434, 150.434, 151.434, 152.433, 153.433, 154.431, 155.425, 156.409,
        157.374, 158.298, 159.151, 159.885, 160.436, 160.736, 160.719, 160.343, 159.604, 158.553,
        157.27, 155.87, 154.476, 153.184, 152.057, 151.163, 150.509, 150.099, 149.922, 149.947,
        150.127, 150.418, 150.79, 151.248, 151.815, 152.491, 153.251, 154.029, 154.758, 155.383,
        155.873, 156.235, 156.482, 156.637, 156.709, 156.716, 156.678, 156.624, 156.566, 156.527,
        156.527, 156.574, 156.69, 156.889, 157.16, 157.477, 157.794, 158.094, 158.381, 158.695,
        159.087, 159.585, 160.182, 160.851, 161.53, 162.157, 162.685, 163.103, 163.414, 163.666,
        163.907, 164.17, 164.466, 164.776, 165.062, 165.295, 165.476, 165.626, 165.791, 166.038,
        166.398, 166.901, 167.532, 168.254, 169.012, 169.75, 170.412, 170.96, 171.375, 171.663,
        171.837, 171.949, 172.048, 172.193, 172.41, 172.739, 173.199, 173.767, 174.425, 147.434,
        148.434, 149.434, 150.434, 151.434, 152.434, 153.433, 154.433, 155.431, 156.425, 157.409,
        158.374, 159.298, 160.151, 160.885, 161.436, 161.736, 161.719, 161.343, 160.604, 159.553,
        158.27, 156.87, 155.476, 154.184, 153.057, 152.163, 151.509, 151.099, 150.922, 150.947,
        151.127, 151.418, 151.79, 152.248, 152.815, 153.491, 154.251, 155.029, 155.758, 156.383,
        156.873, 157.235, 157.482, 157.637, 157.709, 157.716, 157.678, 157.624, 157.566, 157.527,
        157.527, 157.574, 157.69, 157.889, 158.16, 158.477, 158.794, 159.094, 159.381, 159.695,
        160.087, 160.585, 161.182, 161.851, 162.53, 163.157, 163.685, 164.103, 164.414, 164.666,
        164.907, 165.17, 165.466, 165.776, 166.062, 166.295, 166.476, 166.626, 166.791, 167.038,
        167.398, 167.901, 168.532, 169.254, 170.012, 170.75, 171.412, 171.96, 172.375, 172.663,
        172.837, 172.949, 173.048, 173.193, 173.41, 173.739, 174.199, 174.767, 175.425, 148.434,
        149.434, 150.434, 151.434, 152.434, 153.434, 154.433, 155.433, 156.431, 157.425, 158.409,
        159.374, 160.298, 161.151, 161.885, 162.436, 162.736, 162.719, 162.343, 161.604, 160.553,
        159.27, 157.87, 156.476, 155.184, 154.057, 153.163, 152.509, 152.099, 151.922, 151.947,
        152.127, 152.418, 152.79, 153.248, 153.815, 154.491, 155.251, 156.029, 156.758, 157.383,
        157.873, 158.235, 158.482, 158.637, 158.709, 158.716, 158.678, 158.624, 158.566, 158.527,
        158.527, 158.574, 158.69, 158.889, 159.16, 159.477, 159.794, 160.094, 160.381, 160.695,
        161.087, 161.585, 162.182, 162.851, 163.53, 164.157, 164.685, 165.103, 165.414, 165.666,
        165.907, 166.17, 166.466, 166.776, 167.062, 167.295, 167.476, 167.626, 167.791, 168.038,
        168.398, 168.901, 169.532, 170.254, 171.012, 171.75, 172.412, 172.96, 173.375, 173.663,
        173.837, 173.949, 174.048, 174.193, 174.41, 174.739, 175.199, 175.767, 176.425, 149.434,
        150.434, 151.434, 152.434, 153.434, 154.434, 155.433, 156.433, 157.431, 158.425, 159.409,
        160.374, 161.298, 162.151, 162.885, 163.436, 163.736, 163.719, 163.343, 162.604, 161.553,
        160.27, 158.87, 157.476, 156.184, 155.057, 154.163, 153.509, 153.099, 152.922, 152.947,
        153.127, 153.418, 153.79, 154.248, 154.815, 155.491, 156.251, 157.029, 157.758, 158.383,
        158.873, 159.235, 159.482, 159.637, 159.709, 159.716, 159.678, 159.624, 159.566, 159.527,
        159.527, 159.574, 159.69, 159.889, 160.16, 160.477, 160.794, 161.094, 161.381, 161.695,
        162.087, 162.585, 163.182, 163.851, 164.53, 165.157, 165.685, 166.103, 166.414, 166.666,
        166.907, 167.17, 167.466, 167.776, 168.062, 168.295, 168.476, 168.626, 168.791, 169.038,
        169.398, 169.901, 170.532, 171.254, 172.012, 172.75, 173.412, 173.96, 174.375, 174.663,
        174.837, 174.949, 175.048, 175.193, 175.41, 175.739, 176.199, 176.767, 177.425, 150.434,
        151.434, 152.434, 153.434, 154.434, 155.434, 156.433, 157.433, 158.431, 159.425, 160.409,
        161.374, 162.298, 163.151, 163.885, 164.436, 164.736, 164.719, 164.343, 163.604, 162.553,
        161.27, 159.87, 158.476, 157.184, 156.057, 155.163, 154.509, 154.099, 153.922, 153.947,
        154.127, 154.418, 154.79, 155.248, 155.815, 156.491, 157.251, 158.029, 158.758, 159.383,
        159.873, 160.235, 160.482, 160.637, 160.709, 160.716, 160.678, 160.624, 160.566, 160.527,
        160.527, 160.574, 160.69, 160.889, 161.16, 161.477, 161.794, 162.094, 162.381, 162.695,
        163.087, 163.585, 164.182, 164.851, 165.53, 166.157, 166.685, 167.103, 167.414, 167.666,
        167.907, 168.17, 168.466, 168.776, 169.062, 169.295, 169.476, 169.626, 169.791, 170.038,
        170.398, 170.901, 171.532, 172.254, 173.012, 173.75, 174.412, 174.96, 175.375, 175.663,
        175.837, 175.949, 176.048, 176.193, 176.41, 176.739, 177.199, 177.767, 178.425, 151.434,
        152.434, 153.434, 154.434, 155.434, 156.434, 157.433, 158.433, 159.431, 160.425, 161.409,
        162.374, 163.298, 164.151, 164.885, 165.436, 165.736, 165.719, 165.343, 164.604, 163.553,
        162.27, 160.87, 159.476, 158.184, 157.057, 156.163, 155.509, 155.099, 154.922, 154.947,
        155.127, 155.418, 155.79, 156.248, 156.815, 157.491, 158.251, 159.029, 159.758, 160.383,
        160.873, 161.235, 161.482, 161.637, 161.709, 161.716, 161.678, 161.624, 161.566, 161.527,
        161.527, 161.574, 161.69, 161.889, 162.16, 162.477, 162.794, 163.094, 163.381, 163.695,
        164.087, 164.585, 165.182, 165.851, 166.53, 167.157, 167.685, 168.103, 168.414, 168.666,
        168.907, 169.17, 169.466, 169.776, 170.062, 170.295, 170.476, 170.626, 170.791, 171.038,
        171.398, 171.901, 172.532, 173.254, 174.012, 174.75, 175.412, 175.96, 176.375, 176.663,
        176.837, 176.949, 177.048, 177.193, 177.41, 177.739, 178.199, 178.767, 179.425, 152.434,
        153.434, 154.434, 155.434, 156.434, 157.434, 158.433, 159.433, 160.431, 161.425, 162.409,
        163.374, 164.298, 165.151, 165.885, 166.436, 166.736, 166.719, 166.343, 165.604, 164.553,
        163.27, 161.87, 160.476, 159.184, 158.057, 157.163, 156.509, 156.099, 155.922, 155.947,
        156.127, 156.418, 156.79, 157.248, 157.815, 158.491, 159.251, 160.029, 160.758, 161.383,
        161.873, 162.235, 162.482, 162.637, 162.709, 162.716, 162.678, 162.624, 162.566, 162.527,
        162.527, 162.574, 162.69, 162.889, 163.16, 163.477, 163.794, 164.094, 164.381, 164.695,
        165.087, 165.585, 166.182, 166.851, 167.53, 168.157, 168.685, 169.103, 169.414, 169.666,
        169.907, 170.17, 170.466, 170.776, 171.062, 171.295, 171.476, 171.626, 171.791, 172.038,
        172.398, 172.901, 173.532, 174.254, 175.012, 175.75, 176.412, 176.96, 177.375, 177.663,
        177.837, 177.949, 178.048, 178.193, 178.41, 178.739, 179.199, 179.767, 180.425, 153.434,
        154.434, 155.434, 156.434, 157.434, 158.434, 159.433, 160.433, 161.431, 162.425, 163.409,
        164.374, 165.298, 166.151, 166.885, 167.436, 167.736, 167.719, 167.343, 166.604, 165.553,
        164.27, 162.87, 161.476, 160.184, 159.057, 158.163, 157.509, 157.099, 156.922, 156.947,
        157.127, 157.418, 157.79, 158.248, 158.815, 159.491, 160.251, 161.029, 161.758, 162.383,
        162.873, 163.235, 163.482, 163.637, 163.709, 163.716, 163.678, 163.624, 163.566, 163.527,
        163.527, 163.574, 163.69, 163.889, 164.16, 164.477, 164.794, 165.094, 165.381, 165.695,
        166.087, 166.585, 167.182, 167.851, 168.53, 169.157, 169.685, 170.103, 170.414, 170.666,
        170.907, 171.17, 171.466, 171.776, 172.062, 172.295, 172.476, 172.626, 172.791, 173.038,
        173.398, 173.901, 174.532, 175.254, 176.012, 176.75, 177.412, 177.96, 178.375, 178.663,
        178.837, 178.949, 179.048, 179.193, 179.41, 179.739, 180.199, 180.767, 181.425, 154.434,
        155.434, 156.434, 157.434, 158.434, 159.434, 160.433, 161.433, 162.431, 163.425, 164.409,
        165.374, 166.298, 167.151, 167.885, 168.436, 168.736, 168.719, 168.343, 167.604, 166.553,
        165.27, 163.87, 162.476, 161.184, 160.057, 159.163, 158.509, 158.099, 157.922, 157.947,
        158.127, 158.418, 158.79, 159.248, 159.815, 160.491, 161.251, 162.029, 162.758, 163.383,
        163.873, 164.235, 164.482, 164.637, 164.709, 164.716, 164.678, 164.624, 164.566, 164.527,
        164.527, 164.574, 164.69, 164.889, 165.16, 165.477, 165.794, 166.094, 166.381, 166.695,
        167.087, 167.585, 168.182, 168.851, 169.53, 170.157, 170.685, 171.103, 171.414, 171.666,
        171.907, 172.17, 172.466, 172.776, 173.062, 173.295, 173.476, 173.626, 173.791, 174.038,
        174.398, 174.901, 175.532, 176.254, 177.012, 177.75, 178.412, 178.96, 179.375, 179.663,
        179.837, 179.949, 180.048, 180.193, 180.41, 180.739, 181.199, 181.767, 182.425, 155.434,
        156.434, 157.434, 158.434, 159.434, 160.434, 161.433, 162.433, 163.431, 164.425, 165.409,
        166.374, 167.298, 168.151, 168.885, 169.436, 169.736, 169.719, 169.343, 168.604, 167.553,
        166.27, 164.87, 163.476, 162.184, 161.057, 160.163, 159.509, 159.099, 158.922, 158.947,
        159.127, 159.418, 159.79, 160.248, 160.815, 161.491, 162.251, 163.029, 163.758, 164.383,
        164.873, 165.235, 165.482, 165.637, 165.709, 165.716, 165.678, 165.624, 165.566, 165.527,
        165.527, 165.574, 165.69, 165.889, 166.16, 166.477, 166.794, 167.094, 167.381, 167.695,
        168.087, 168.585, 169.182, 169.851, 170.53, 171.157, 171.685, 172.103, 172.414, 172.666,
        172.907, 173.17, 173.466, 173.776, 174.062, 174.295, 174.476, 174.626, 174.791, 175.038,
        175.398, 175.901, 176.532, 177.254, 178.012, 178.75, 179.412, 179.96, 180.375, 180.663,
        180.837, 180.949, 181.048, 181.193, 181.41, 181.739, 182.199, 182.767, 183.425, 156.434,
        157.434, 158.434, 159.434, 160.434, 161.434, 162.433, 163.433, 164.431, 165.425, 166.409,
        167.374, 168.298, 169.151, 169.885, 170.436, 170.736, 170.719, 170.343, 169.604, 168.553,
        167.27, 165.87, 164.476, 163.184, 162.057, 161.163, 160.509, 160.099, 159.922, 159.947,
        160.127, 160.418, 160.79, 161.248, 161.815, 162.491, 163.251, 164.029, 164.758, 165.383,
        165.873, 166.235, 166.482, 166.637, 166.709, 166.716, 166.678, 166.624, 166.566, 166.527,
        166.527, 166.574, 166.69, 166.889, 167.16, 167.477, 167.794, 168.094, 168.381, 168.695,
        169.087, 169.585, 170.182, 170.851, 171.53, 172.157, 172.685, 173.103, 173.414, 173.666,
        173.907, 174.17, 174.466, 174.776, 175.062, 175.295, 175.476, 175.626, 175.791, 176.038,
        176.398, 176.901, 177.532, 178.254, 179.012, 179.75, 180.412, 180.96, 181.375, 181.663,
        181.837, 181.949, 182.048, 182.193, 182.41, 182.739, 183.199, 183.767, 184.425, 157.434,
        158.434, 159.434, 160.434, 161.434, 162.434, 163.433, 164.433, 165.431, 166.425, 167.409,
        168.374, 169.298, 170.151, 170.885, 171.436, 171.736, 171.719, 171.343, 170.604, 169.553,
        168.27, 166.87, 165.476, 164.184, 163.057, 162.163, 161.509, 161.099, 160.922, 160.947,
        161.127, 161.418, 161.79, 162.248, 162.815, 163.491, 164.251, 165.029, 165.758, 166.383,
        166.873, 167.235, 167.482, 167.637, 167.709, 167.716, 167.678, 167.624, 167.566, 167.527,
        167.527, 167.574, 167.69, 167.889, 168.16, 168.477, 168.794, 169.094, 169.381, 169.695,
        170.087, 170.585, 171.182, 171.851, 172.53, 173.157, 173.685, 174.103, 174.414, 174.666,
        174.907, 175.17, 175.466, 175.776, 176.062, 176.295, 176.476, 176.626, 176.791, 177.038,
        177.398, 177.901, 178.532, 179.254, 180.012, 180.75, 181.412, 181.96, 182.375, 182.663,
        182.837, 182.949, 183.048, 183.193, 183.41, 183.739, 184.199, 184.767, 185.425, 158.434,
        159.434, 160.434, 161.434, 162.434, 163.434, 164.433, 165.433, 166.431, 167.425, 168.409,
        169.374, 170.298, 171.151, 171.885, 172.436, 172.736, 172.719, 172.343, 171.604, 170.553,
        169.27, 167.87, 166.476, 165.184, 164.057, 163.163, 162.509, 162.099, 161.922, 161.947,
        162.127, 162.418, 162.79, 163.248, 163.815, 164.491, 165.251, 166.029, 166.758, 167.383,
        167.873, 168.235, 168.482, 168.637, 168.709, 168.716, 168.678, 168.624, 168.566, 168.527,
        168.527, 168.574, 168.69, 168.889, 169.16, 169.477, 169.794, 170.094, 170.381, 170.695,
        171.087, 171.585, 172.182, 172.851, 173.53, 174.157, 174.685, 175.103, 175.414, 175.666,
        175.907, 176.17, 176.466, 176.776, 177.062, 177.295, 177.476, 177.626, 177.791, 178.038,
        178.398, 178.901, 179.532, 180.254, 181.012, 181.75, 182.412, 182.96, 183.375, 183.663,
        183.837, 183.949, 184.048, 184.193, 184.41, 184.739, 185.199, 185.767, 186.425, 159.434,
        160.434, 161.434, 162.434, 163.434, 164.434, 165.433, 166.433, 167.431, 168.425, 169.409,
        170.374, 171.298, 172.151, 172.885, 173.436, 173.736, 173.719, 173.343, 172.604, 171.553,
        170.27, 168.87, 167.476, 166.184, 165.057, 164.163, 163.509, 163.099, 162.922, 162.947,
        163.127, 163.418, 163.79, 164.248, 164.815, 165.491, 166.251, 167.029, 167.758, 168.383,
        168.873, 169.235, 169.482, 169.637, 169.709, 169.716, 169.678, 169.624, 169.566, 169.527,
        169.527, 169.574, 169.69, 169.889, 170.16, 170.477, 170.794, 171.094, 171.381, 171.695,
        172.087, 172.585, 173.182, 173.851, 174.53, 175.157, 175.685, 176.103, 176.414, 176.666,
        176.907, 177.17, 177.466, 177.776, 178.062, 178.295, 178.476, 178.626, 178.791, 179.038,
        179.398, 179.901, 180.532, 181.254, 182.012, 182.75, 183.412, 183.96, 184.375, 184.663,
        184.837, 184.949, 185.048, 185.193, 185.41, 185.739, 186.199, 186.767, 187.425, 160.434,
        161.434, 162.434, 163.434, 164.434, 165.434, 166.433, 167.433, 168.431, 169.425, 170.409,
        171.374, 172.298, 173.151, 173.885, 174.436, 174.736, 174.719, 174.343, 173.604, 172.553,
        171.27, 169.87, 168.476, 167.184, 166.057, 165.163, 164.509, 164.099, 163.922, 163.947,
        164.127, 164.418, 164.79, 165.248, 165.815, 166.491, 167.251, 168.029, 168.758, 169.383,
        169.873, 170.235, 170.482, 170.637, 170.709, 170.716, 170.678, 170.624, 170.566, 170.527,
        170.527, 170.574, 170.69, 170.889, 171.16, 171.477, 171.794, 172.094, 172.381, 172.695,
        173.087, 173.585, 174.182, 174.851, 175.53, 176.157, 176.685, 177.103, 177.414, 177.666,
        177.907, 178.17, 178.466, 178.776, 179.062, 179.295, 179.476, 179.626, 179.791, 180.038,
        180.398, 180.901, 181.532, 182.254, 183.012, 183.75, 184.412, 184.96, 185.375, 185.663,
        185.837, 185.949, 186.048, 186.193, 186.41, 186.739, 187.199, 187.767, 188.425, 161.434,
        162.434, 163.434, 164.434, 165.434, 166.434, 167.433, 168.433, 169.431, 170.425, 171.409,
        172.374, 173.298, 174.151, 174.885, 175.436, 175.736, 175.719, 175.343, 174.604, 173.553,
        172.27, 170.87, 169.476, 168.184, 167.057, 166.163, 165.509, 165.099, 164.922, 164.947,
        165.127, 165.418, 165.79, 166.248, 166.815, 167.491, 168.251, 169.029, 169.758, 170.383,
        170.873, 171.235, 171.482, 171.637, 171.709, 171.716, 171.678, 171.624, 171.566, 171.527,
        171.527, 171.574, 171.69, 171.889, 172.16, 172.477, 172.794, 173.094, 173.381, 173.695,
        174.087, 174.585, 175.182, 175.851, 176.53, 177.157, 177.685, 178.103, 178.414, 178.666,
        178.907, 179.17, 179.466, 179.776, 180.062, 180.295, 180.476, 180.626, 180.791, 181.038,
        181.398, 181.901, 182.532, 183.254, 184.012, 184.75, 185.412, 185.96, 186.375, 186.663,
        186.837, 186.949, 187.048, 187.193, 187.41, 187.739, 188.199, 188.767, 189.425, 162.434,
        163.434, 164.434, 165.434, 166.434, 167.434, 168.433, 169.433, 170.431, 171.425, 172.409,
        173.374, 174.298, 175.151, 175.885, 176.436, 176.736, 176.719, 176.343, 175.604, 174.553,
        173.27, 171.87, 170.476, 169.184, 168.057, 167.163, 166.509, 166.099, 165.922, 165.947,
        166.127, 166.418, 166.79, 167.248, 167.815, 168.491, 169.251, 170.029, 170.758, 171.383,
        171.873, 172.235, 172.482, 172.637, 172.709, 172.716, 172.678, 172.624, 172.566, 172.527,
        172.527, 172.574, 172.69, 172.889, 173.16, 173.477, 173.794, 174.094, 174.381, 174.695,
        175.087, 175.585, 176.182, 176.851, 177.53, 178.157, 178.685, 179.103, 179.414, 179.666,
        179.907, 180.17, 180.466, 180.776, 181.062, 181.295, 181.476, 181.626, 181.791, 182.038,
        182.398, 182.901, 183.532, 184.254, 185.012, 185.75, 186.412, 186.96, 187.375, 187.663,
        187.837, 187.949, 188.048, 188.193, 188.41, 188.739, 189.199, 189.767, 190.425, 163.434,
        164.434, 165.434, 166.434, 167.434, 168.434, 169.433, 170.433, 171.431, 172.425, 173.409,
        174.374, 175.298, 176.151, 176.885, 177.436, 177.736, 177.719, 177.343, 176.604, 175.553,
        174.27, 172.87, 171.476, 170.184, 169.057, 168.163, 167.509, 167.099, 166.922, 166.947,
        167.127, 167.418, 167.79, 168.248, 168.815, 169.491, 170.251, 171.029, 171.758, 172.383,
        172.873, 173.235, 173.482, 173.637, 173.709, 173.716, 173.678, 173.624, 173.566, 173.527,
        173.527, 173.574, 173.69, 173.889, 174.16, 174.477, 174.794, 175.094, 175.381, 175.695,
        176.087, 176.585, 177.182, 177.851, 178.53, 179.157, 179.685, 180.103, 180.414, 180.666,
        180.907, 181.17, 181.466, 181.776, 182.062, 182.295, 182.476, 182.626, 182.791, 183.038,
        183.398, 183.901, 184.532, 185.254, 186.012, 186.75, 187.412, 187.96, 188.375, 188.663,
        188.837, 188.949, 189.048, 189.193, 189.41, 189.739, 190.199, 190.767, 191.425, 164.434,
        165.434, 166.434, 167.434, 168.434, 169.434, 170.433, 171.433, 172.431, 173.425, 174.409,
        175.374, 176.298, 177.151, 177.885, 178.436, 178.736, 178.719, 178.343, 177.604, 176.553,
        175.27, 173.87, 172.476, 171.184, 170.057, 169.163, 168.509, 168.099, 167.922, 167.947,
        168.127, 168.418, 168.79, 169.248, 169.815, 170.491, 171.251, 172.029, 172.758, 173.383,
        173.873, 174.235, 174.482, 174.637, 174.709, 174.716, 174.678, 174.624, 174.566, 174.527,
        174.527, 174.574, 174.69, 174.889, 175.16, 175.477, 175.794, 176.094, 176.381, 176.695,
        177.087, 177.585, 178.182, 178.851, 179.53, 180.157, 180.685, 181.103, 181.414, 181.666,
        181.907, 182.17, 182.466, 182.776, 183.062, 183.295, 183.476, 183.626, 183.791, 184.038,
        184.398, 184.901, 185.532, 186.254, 187.012, 187.75, 188.412, 188.96, 189.375, 189.663,
        189.837, 189.949, 190.048, 190.193, 190.41, 190.739, 191.199, 191.767, 192.425, 165.434,
        166.434, 167.434, 168.434, 169.434, 170.434, 171.433, 172.433, 173.431, 174.425, 175.409,
        176.374, 177.298, 178.151, 178.885, 179.436, 179.736, 179.719, 179.343, 178.604, 177.553,
        176.27, 174.87, 173.476, 172.184, 171.057, 170.163, 169.509, 169.099, 168.922, 168.947,
        169.127, 169.418, 169.79, 170.248, 170.815, 171.491, 172.251, 173.029, 173.758, 174.383,
        174.873, 175.235, 175.482, 175.637, 175.709, 175.716, 175.678, 175.624, 175.566, 175.527,
        175.527, 175.574, 175.69, 175.889, 176.16, 176.477, 176.794, 177.094, 177.381, 177.695,
        178.087, 178.585, 179.182, 179.851, 180.53, 181.157, 181.685, 182.103, 182.414, 182.666,
        182.907, 183.17, 183.466, 183.776, 184.062, 184.295, 184.476, 184.626, 184.791, 185.038,
        185.398, 185.901, 186.532, 187.254, 188.012, 188.75, 189.412, 189.96, 190.375, 190.663,
        190.837, 190.949, 191.048, 191.193, 191.41, 191.739, 192.199, 192.767, 193.425, 166.434,
        167.434, 168.434, 169.434, 170.434, 171.434, 172.433, 173.433, 174.431, 175.425, 176.409,
        177.374, 178.298, 179.151, 179.885, 180.436, 180.736, 180.719, 180.343, 179.604, 178.553,
        177.27, 175.87, 174.476, 173.184, 172.057, 171.163, 170.509, 170.099, 169.922, 169.947,
        170.127, 170.418, 170.79, 171.248, 171.815, 172.491, 173.251, 174.029, 174.758, 175.383,
        175.873, 176.235, 176.482, 176.637, 176.709, 176.716, 176.678, 176.624, 176.566, 176.527,
        176.527, 176.574, 176.69, 176.889, 177.16, 177.477, 177.794, 178.094, 178.381, 178.695,
        179.087, 179.585, 180.182, 180.851, 181.53, 182.157, 182.685, 183.103, 183.414, 183.666,
        183.907, 184.17, 184.466, 184.776, 185.062, 185.295, 185.476, 185.626, 185.791, 186.038,
        186.398, 186.901, 187.532, 188.254, 189.012, 189.75, 190.412, 190.96, 191.375, 191.663,
        191.837, 191.949, 192.048, 192.193, 192.41, 192.739, 193.199, 193.767, 194.425, 167.434,
        168.434, 169.434, 170.434, 171.434, 172.434, 173.433, 174.433, 175.431, 176.425, 177.409,
        178.374, 179.298, 180.151, 180.885, 181.436, 181.736, 181.719, 181.343, 180.604, 179.553,
        178.27, 176.87, 175.476, 174.184, 173.057, 172.163, 171.509, 171.099, 170.922, 170.947,
        171.127, 171.418, 171.79, 172.248, 172.815, 173.491, 174.251, 175.029, 175.758, 176.383,
        176.873, 177.235, 177.482, 177.637, 177.709, 177.716, 177.678, 177.624, 177.566, 177.527,
        177.527, 177.574, 177.69, 177.889, 178.16, 178.477, 178.794, 179.094, 179.381, 179.695,
        180.087, 180.585, 181.182, 181.851, 182.53, 183.157, 183.685, 184.103, 184.414, 184.666,
        184.907, 185.17, 185.466, 185.776, 186.062, 186.295, 186.476, 186.626, 186.791, 187.038,
        187.398, 187.901, 188.532, 189.254, 190.012, 190.75, 191.412, 191.96, 192.375, 192.663,
        192.837, 192.949, 193.048, 193.193, 193.41, 193.739, 194.199, 194.767, 195.425, 168.434,
        169.434, 170.434, 171.434, 172.434, 173.434, 174.433, 175.433, 176.431, 177.425, 178.409,
        179.374, 180.298, 181.151, 181.885, 182.436, 182.736, 182.719, 182.343, 181.604, 180.553,
        179.27, 177.87, 176.476, 175.184, 174.057, 173.163, 172.509, 172.099, 171.922, 171.947,
        172.127, 172.418, 172.79, 173.248, 173.815, 174.491, 175.251, 176.029, 176.758, 177.383,
        177.873, 178.235, 178.482, 178.637, 178.709, 178.716, 178.678, 178.624, 178.566, 178.527,
        178.527, 178.574, 178.69, 178.889, 179.16, 179.477, 179.794, 180.094, 180.381, 180.695,
        181.087, 181.585, 182.182, 182.851, 183.53, 184.157, 184.685, 185.103, 185.414, 185.666,
        185.907, 186.17, 186.466, 186.776, 187.062, 187.295, 187.476, 187.626, 187.791, 188.038,
        188.398, 188.901, 189.532, 190.254, 191.012, 191.75, 192.412, 192.96, 193.375, 193.663,
        193.837, 193.949, 194.048, 194.193, 194.41, 194.739, 195.199, 195.767, 196.425, 169.434,
        170.434, 171.434, 172.434, 173.434, 174.434, 175.433, 176.433, 177.431, 178.425, 179.409,
        180.374, 181.298, 182.151, 182.885, 183.436, 183.736, 183.719, 183.343, 182.604, 181.553,
        180.27, 178.87, 177.476, 176.184, 175.057, 174.163, 173.509, 173.099, 172.922, 172.947,
        173.127, 173.418, 173.79, 174.248, 174.815, 175.491, 176.251, 177.029, 177.758, 178.383,
        178.873, 179.235, 179.482, 179.637, 179.709, 179.716, 179.678, 179.624, 179.566, 179.527,
        179.527, 179.574, 179.69, 179.889, 180.16, 180.477, 180.794, 181.094, 181.381, 181.695,
        182.087, 182.585, 183.182, 183.851, 184.53, 185.157, 185.685, 186.103, 186.414, 186.666,
        186.907, 187.17, 187.466, 187.776, 188.062, 188.295, 188.476, 188.626, 188.791, 189.038,
        189.398, 189.901, 190.532, 191.254, 192.012, 192.75, 193.412, 193.96, 194.375, 194.663,
        194.837, 194.949, 195.048, 195.193, 195.41, 195.739, 196.199, 196.767, 197.425, 170.434,
        171.434, 172.434, 173.434, 174.434, 175.434, 176.433, 177.433, 178.431, 179.425, 180.409,
        181.374, 182.298, 183.151, 183.885, 184.436, 184.736, 184.719, 184.343, 183.604, 182.553,
        181.27, 179.87, 178.476, 177.184, 176.057, 175.163, 174.509, 174.099, 173.922, 173.947,
        174.127, 174.418, 174.79, 175.248, 175.815, 176.491, 177.251, 178.029, 178.758, 179.383,
        179.873, 180.235, 180.482, 180.637, 180.709, 180.716, 180.678, 180.624, 180.566, 180.527,
        180.527, 180.574, 180.69, 180.889, 181.16, 181.477, 181.794, 182.094, 182.381, 182.695,
        183.087, 183.585, 184.182, 184.851, 185.53, 186.157, 186.685, 187.103, 187.414, 187.666,
        187.907, 188.17, 188.466, 188.776, 189.062, 189.295, 189.476, 189.626, 189.791, 190.038,
        190.398, 190.901, 191.532, 192.254, 193.012, 193.75, 194.412, 194.96, 195.375, 195.663,
        195.837, 195.949, 196.048, 196.193, 196.41, 196.739, 197.199, 197.767, 198.425, 171.434,
        172.434, 173.434, 174.434, 175.434, 176.434, 177.433, 178.433, 179.431, 180.425, 181.409,
        182.374, 183.298, 184.151, 184.885, 185.436, 185.736, 185.719, 185.343, 184.604, 183.553,
        182.27, 180.87, 179.476, 178.184, 177.057, 176.163, 175.509, 175.099, 174.922, 174.947,
        175.127, 175.418, 175.79, 176.248, 176.815, 177.491, 178.251, 179.029, 179.758, 180.383,
        180.873, 181.235, 181.482, 181.637, 181.709, 181.716, 181.678, 181.624, 181.566, 181.527,
        181.527, 181.574, 181.69, 181.889, 182.16, 182.477, 182.794, 183.094, 183.381, 183.695,
        184.087, 184.585, 185.182, 185.851, 186.53, 187.157, 187.685, 188.103, 188.414, 188.666,
        188.907, 189.17, 189.466, 189.776, 190.062, 190.295, 190.476, 190.626, 190.791, 191.038,
        191.398, 191.901, 192.532, 193.254, 194.012, 194.75, 195.412, 195.96, 196.375, 196.663,
        196.837, 196.949, 197.048, 197.193, 197.41, 197.739, 198.199, 198.767, 199.425, 172.434,
        173.434, 174.434, 175.434, 176.434, 177.434, 178.433, 179.433, 180.431, 181.425, 182.409,
        183.374, 184.298, 185.151, 185.885, 186.436, 186.736, 186.719, 186.343, 185.604, 184.553,
        183.27, 181.87, 180.476, 179.184, 178.057, 177.163, 176.509, 176.099, 175.922, 175.947,
        176.127, 176.418, 176.79, 177.248, 177.815, 178.491, 179.251, 180.029, 180.758, 181.383,
        181.873, 182.235, 182.482, 182.637, 182.709, 182.716, 182.678, 182.624, 182.566, 182.527,
        182.527, 182.574, 182.69, 182.889, 183.16, 183.477, 183.794, 184.094, 184.381, 184.695,
        185.087, 185.585, 186.182, 186.851, 187.53, 188.157, 188.685, 189.103, 189.414, 189.666,
        189.907, 190.17, 190.466, 190.776, 191.062, 191.295, 191.476, 191.626, 191.791, 192.038,
        192.398, 192.901, 193.532, 194.254, 195.012, 195.75, 196.412, 196.96, 197.375, 197.663,
        197.837, 197.949, 198.048, 198.193, 198.41, 198.739, 199.199, 199.767, 200.425, 173.434,
        174.434, 175.434, 176.434, 177.434, 178.434, 179.433, 180.433, 181.431, 182.425, 183.409,
        184.374, 185.298, 186.151, 186.885, 187.436, 187.736, 187.719, 187.343, 186.604, 185.553,
        184.27, 182.87, 181.476, 180.184, 179.057, 178.163, 177.509, 177.099, 176.922, 176.947,
        177.127, 177.418, 177.79, 178.248, 178.815, 179.491, 180.251, 181.029, 181.758, 182.383,
        182.873, 183.235, 183.482, 183.637, 183.709, 183.716, 183.678, 183.624, 183.566, 183.527,
        183.527, 183.574, 183.69, 183.889, 184.16, 184.477, 184.794, 185.094, 185.381, 185.695,
        186.087, 186.585, 187.182, 187.851, 188.53, 189.157, 189.685, 190.103, 190.414, 190.666,
        190.907, 191.17, 191.466, 191.776, 192.062, 192.295, 192.476, 192.626, 192.791, 193.038,
        193.398, 193.901, 194.532, 195.254, 196.012, 196.75, 197.412, 197.96, 198.375, 198.663,
        198.837, 198.949, 199.048, 199.193, 199.41, 199.739, 200.199, 200.767, 201.425, 174.434,
        175.434, 176.434, 177.434, 178.434, 179.434, 180.433, 181.433, 182.431, 183.425, 184.409,
        185.374, 186.298, 187.151, 187.885, 188.436, 188.736, 188.719, 188.343, 187.604, 186.553,
        185.27, 183.87, 182.476, 181.184, 180.057, 179.163, 178.509, 178.099, 177.922, 177.947,
        178.127, 178.418, 178.79, 179.248, 179.815, 180.491, 181.251, 182.029, 182.758, 183.383,
        183.873, 184.235, 184.482, 184.637, 184.709, 184.716, 184.678, 184.624, 184.566, 184.527,
        184.527, 184.574, 184.69, 184.889, 185.16, 185.477, 185.794, 186.094, 186.381, 186.695,
        187.087, 187.585, 188.182, 188.851, 189.53, 190.157, 190.685, 191.103, 191.414, 191.666,
        191.907, 192.17, 192.466, 192.776, 193.062, 193.295, 193.476, 193.626, 193.791, 194.038,
        194.398, 194.901, 195.532, 196.254, 197.012, 197.75, 198.412, 198.96, 199.375, 199.663,
        199.837, 199.949, 200.048, 200.193, 200.41, 200.739, 201.199, 201.767, 202.425, 175.434,
        176.434, 177.434, 178.434, 179.434, 180.434, 181.433, 182.433, 183.431, 184.425, 185.409,
        186.374, 187.298, 188.151, 188.885, 189.436, 189.736, 189.719, 189.343, 188.604, 187.553,
        186.27, 184.87, 183.476, 182.184, 181.057, 180.163, 179.509, 179.099, 178.922, 178.947,
        179.127, 179.418, 179.79, 180.248, 180.815, 181.491, 182.251, 183.029, 183.758, 184.383,
        184.873, 185.235, 185.482, 185.637, 185.709, 185.716, 185.678, 185.624, 185.566, 185.527,
        185.527, 185.574, 185.69, 185.889, 186.16, 186.477, 186.794, 187.094, 187.381, 187.695,
        188.087, 188.585, 189.182, 189.851, 190.53, 191.157, 191.685, 192.103, 192.414, 192.666,
        192.907, 193.17, 193.466, 193.776, 194.062, 194.295, 194.476, 194.626, 194.791, 195.038,
        195.398, 195.901, 196.532, 197.254, 198.012, 198.75, 199.412, 199.96, 200.375, 200.663,
        200.837, 200.949, 201.048, 201.193, 201.41, 201.739, 202.199, 202.767, 203.425, 176.434,
        177.434, 178.434, 179.434, 180.434, 181.434, 182.433, 183.433, 184.431, 185.425, 186.409,
        187.374, 188.298, 189.151, 189.885, 190.436, 190.736, 190.719, 190.343, 189.604, 188.553,
        187.27, 185.87, 184.476, 183.184, 182.057, 181.163, 180.509, 180.099, 179.922, 179.947,
        180.127, 180.418, 180.79, 181.248, 181.815, 182.491, 183.251, 184.029, 184.758, 185.383,
        185.873, 186.235, 186.482, 186.637, 186.709, 186.716, 186.678, 186.624, 186.566, 186.527,
        186.527, 186.574, 186.69, 186.889, 187.16, 187.477, 187.794, 188.094, 188.381, 188.695,
        189.087, 189.585, 190.182, 190.851, 191.53, 192.157, 192.685, 193.103, 193.414, 193.666,
        193.907, 194.17, 194.466, 194.776, 195.062, 195.295, 195.476, 195.626, 195.791, 196.038,
        196.398, 196.901, 197.532, 198.254, 199.012, 199.75, 200.412, 200.96, 201.375, 201.663,
        201.837, 201.949, 202.048, 202.193, 202.41, 202.739, 203.199, 203.767, 204.425, 177.434,
        178.434, 179.434, 180.434, 181.434, 182.434, 183.433, 184.433, 185.431, 186.425, 187.409,
        188.374, 189.298, 190.151, 190.885, 191.436, 191.736, 191.719, 191.343, 190.604, 189.553,
        188.27, 186.87, 185.476, 184.184, 183.057, 182.163, 181.509, 181.099, 180.922, 180.947,
        181.127, 181.418, 181.79, 182.248, 182.815, 183.491, 184.251, 185.029, 185.758, 186.383,
        186.873, 187.235, 187.482, 187.637, 187.709, 187.716, 187.678, 187.624, 187.566, 187.527,
        187.527, 187.574, 187.69, 187.889, 188.16, 188.477, 188.794, 189.094, 189.381, 189.695,
        190.087, 190.585, 191.182, 191.851, 192.53, 193.157, 193.685, 194.103, 194.414, 194.666,
        194.907, 195.17, 195.466, 195.776, 196.062, 196.295, 196.476, 196.626, 196.791, 197.038,
        197.398, 197.901, 198.532, 199.254, 200.012, 200.75, 201.412, 201.96, 202.375, 202.663,
        202.837, 202.949, 203.048, 203.193, 203.41, 203.739, 204.199, 204.767, 205.425, 178.434,
        179.434, 180.434, 181.434, 182.434, 183.434, 184.433, 185.433, 186.431, 187.425, 188.409,
        189.374, 190.298, 191.151, 191.885, 192.436, 192.736, 192.719, 192.343, 191.604, 190.553,
        189.27, 187.87, 186.476, 185.184, 184.057, 183.163, 182.509, 182.099, 181.922, 181.947,
        182.127, 182.418, 182.79, 183.248, 183.815, 184.491, 185.251, 186.029, 186.758, 187.383,
        187.873, 188.235, 188.482, 188.637, 188.709, 188.716, 188.678, 188.624, 188.566, 188.527,
        188.527, 188.574, 188.69, 188.889, 189.16, 189.477, 189.794, 190.094, 190.381, 190.695,
        191.087, 191.585, 192.182, 192.851, 193.53, 194.157, 194.685, 195.103, 195.414, 195.666,
        195.907, 196.17, 196.466, 196.776, 197.062, 197.295, 197.476, 197.626, 197.791, 198.038,
        198.398, 198.901, 199.532, 200.254, 201.012, 201.75, 202.412, 202.96, 203.375, 203.663,
        203.837, 203.949, 204.048, 204.193, 204.41, 204.739, 205.199, 205.767, 206.425, 179.434,
        180.434, 181.434, 182.434, 183.434, 184.434, 185.433, 186.433, 187.431, 188.425, 189.409,
        190.374, 191.298, 192.151, 192.885, 193.436, 193.736, 193.719, 193.343, 192.604, 191.553,
        190.27, 188.87, 187.476, 186.184, 185.057, 184.163, 183.509, 183.099, 182.922, 182.947,
        183.127, 183.418, 183.79, 184.248, 184.815, 185.491, 186.251, 187.029, 187.758, 188.383,
        188.873, 189.235, 189.482, 189.637, 189.709, 189.716, 189.678, 189.624, 189.566, 189.527,
        189.527, 189.574, 189.69, 189.889, 190.16, 190.477, 190.794, 191.094, 191.381, 191.695,
        192.087, 192.585, 193.182, 193.851, 194.53, 195.157, 195.685, 196.103, 196.414, 196.666,
        196.907, 197.17, 197.466, 197.776, 198.062, 198.295, 198.476, 198.626, 198.791, 199.038,
        199.398, 199.901, 200.532, 201.254, 202.012, 202.75, 203.412, 203.96, 204.375, 204.663,
        204.837, 204.949, 205.048, 205.193, 205.41, 205.739, 206.199, 206.767, 207.425,
    ];
    return results[((action_vector[0] - 1) * 100 + (action_vector[1] - 1)) as usize];
}

fn inventory(action_vector: &[i32]) -> f64 {
    let noise_level = 1;
    let s = action_vector[0];
    let big_s = action_vector[1] + s;
    let mut inventory_before_ordering = big_s;
    let mut inventory_after_ordering;
    let mut order;
    let mut costs = 0.0;

    let t = 30;

    for _i in 1..=t {
        if inventory_before_ordering <= s {
            order = big_s - inventory_before_ordering;
            costs = costs + (32.0 + 3.0 * order as f64);
            inventory_after_ordering = big_s;
        } else {
            inventory_after_ordering = inventory_before_ordering;
        }

        inventory_after_ordering = inventory_after_ordering - random_poisson(25.0);

        if inventory_after_ordering >= 0 {
            costs = costs + 1.0 * inventory_after_ordering as f64;
        } else {
            costs = costs + 5.0 * (-inventory_after_ordering) as f64;
        }

        inventory_before_ordering = inventory_after_ordering;
    }

    costs = costs / 30.0;

    return get_true_objective_value(&action_vector)
        + noise_level as f64 * (costs - get_true_objective_value(&action_vector));
}

fn main() {
    let num_runs = 1;
    let mut total_value = 0.0;
    let mut total_time = 0.0; // To keep track of the total time

    for i in 0..num_runs {
        let start_time = Instant::now(); // Record the start time
        let bounds = vec![(1, 100), (1, 100)]; // Set the bounds for the problem
        let mut gmab = GMAB::new(Default::default()); // Initialize a default GMAB Instance
        let best_arms = gmab.optimize(inventory, bounds, 10000, 1, None); // Optimize inventory, unseeded, with constraints (bounds, n_trials)

        let elapsed_time = start_time.elapsed().as_secs_f64(); // Record the elapsed time
        total_time += elapsed_time; // Add the elapsed time to the total

        let action_vector = best_arms[0].get_action_vector().to_vec();
        let true_objective_value = get_true_objective_value(&action_vector);
        total_value += true_objective_value;

        // Print the counter, the true objective value, and the time for every 10 runs
        if (i + 1) % 10 == 0 {
            println!(
                "Run {}: True Objective Value for This Run: {}, Time: {}s",
                i + 1,
                true_objective_value,
                elapsed_time
            );
        }
    }

    let average_value = total_value / num_runs as f64;
    let average_time = total_time / num_runs as f64; // Calculate the average time

    println!("Average Objective Value: {}", average_value);
    println!("Average Time: {}s", average_time); // Print the average time
}
