/*
 * Decompiled with CFR 0.152.
 */
package py5.core;

import com.jogamp.newt.Display;
import com.jogamp.newt.Screen;
import com.jogamp.newt.Window;
import com.jogamp.newt.event.KeyListener;
import com.jogamp.newt.event.MouseListener;
import com.jogamp.newt.event.WindowListener;
import com.jogamp.newt.opengl.GLWindow;
import java.io.File;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import jogamp.newt.driver.macosx.WindowDriver;
import jogamp.opengl.macosx.cgl.MacOSXOnscreenCGLDrawable;
import processing.awt.PSurfaceAWT;
import processing.core.PApplet;
import processing.core.PConstants;
import processing.core.PMatrix2D;
import processing.core.PShape;
import processing.core.PSurface;
import processing.event.Event;
import processing.event.KeyEvent;
import processing.event.MouseEvent;
import processing.opengl.PGraphicsOpenGL;
import processing.opengl.PJOGL;
import py5.core.PrintUtils;
import py5.core.Py5Bridge;
import py5.core.Py5GraphicsHelper;
import py5.util.KeyEventUtilities;
import py5.util.OpenSimplex2S;

public class Sketch
extends PApplet {
    protected Py5Bridge py5Bridge;
    protected Set<String> py5RegisteredEvents;
    protected Map<String, Integer> py5RegisteredEventParamCounts;
    protected boolean success = false;
    protected int exitActualCallCount = 0;
    protected String py5IconPath;
    protected int[] pixelCapture = null;
    protected long osNoiseSeed = (long)(Math.random() * 9.223372036854776E18);
    public Integer lastWindowX;
    public Integer lastWindowY;
    public static final char CODED = '\uffff';
    public static final String HIDDEN = "py5.core.graphics.HiddenPy5GraphicsJava2D";

    public Sketch() {
        useNativeSelect = platform == 2;
    }

    public void setPy5IconPath(String py5IconPath) {
        this.py5IconPath = py5IconPath;
    }

    public static void setJOGLProperties(String py5Path) {
        if (System.getProperty("jogamp.gluegen.UseTempJarCache") == null) {
            System.setProperty("jogamp.gluegen.UseTempJarCache", "false");
        }
        String variant = PConstants.platformNames[PApplet.platform] + "-" + System.getProperty("os.arch");
        String joglPath = py5Path + File.separator + "natives" + File.separator + variant;
        String javaLibraryPath = System.getProperty("java.library.path");
        if (javaLibraryPath == null) {
            System.setProperty("java.library.path", joglPath);
        } else if (!javaLibraryPath.contains(joglPath)) {
            System.setProperty("java.library.path", javaLibraryPath + File.pathSeparator + joglPath);
        }
    }

    public void buildPy5Bridge(Py5Bridge py5Bridge) {
        this.py5Bridge = py5Bridge;
        this.py5RegisteredEvents = new HashSet<String>();
        this.py5RegisteredEventParamCounts = new HashMap<String, Integer>();
        for (String f : py5Bridge.get_function_list()) {
            String[] nameParamCountPairs = f.split(":");
            this.py5RegisteredEvents.add(nameParamCountPairs[0]);
            this.py5RegisteredEventParamCounts.put(nameParamCountPairs[0], Integer.parseInt(nameParamCountPairs[1]));
        }
        this.success = true;
    }

    public boolean getSuccess() {
        return this.success;
    }

    public void _terminateSketch(boolean error) {
        this.success = !error;
        this.py5Bridge.terminate_sketch();
    }

    public Object callFunction(String key, Object ... params) {
        Object retVal = this.py5Bridge.call_function(key, params);
        if (retVal instanceof RuntimeException) {
            throw (RuntimeException)retVal;
        }
        return retVal;
    }

    public void py5Println(String text) {
        this.py5Bridge.py5_println(text, false);
    }

    public void py5Println(String text, boolean stderr) {
        this.py5Bridge.py5_println(text, stderr);
    }

    public String getRendererName() {
        switch (this.sketchRenderer()) {
            case "processing.awt.PGraphicsJava2D": {
                return "JAVA2D";
            }
            case "processing.opengl.PGraphics2D": {
                return "P2D";
            }
            case "processing.opengl.PGraphics3D": {
                return "P3D";
            }
            case "py5.core.graphics.HiddenPy5GraphicsJava2D": {
                return "HIDDEN";
            }
            case "processing.javafx.PGraphicsFX2D": {
                return "FX2D";
            }
            case "processing.pdf.PGraphicsPDF": {
                return "PDF";
            }
            case "processing.svg.PGraphicsSVG": {
                return "SVG";
            }
            case "processing.dxf.RawDXF": {
                return "DXF";
            }
        }
        return null;
    }

    public void settings() {
        if (this.py5IconPath != null) {
            try {
                PJOGL.setIcon((String[])new String[]{this.py5IconPath});
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        if (this.success) {
            if (this.py5RegisteredEvents.contains("settings")) {
                this.success = this.py5Bridge.run_method("settings", new Object[0]);
            } else {
                super.settings();
            }
        }
    }

    public void setup() {
        if (this.success) {
            PSurface surface = this.getSurface();
            if ((platform == 2 || platform == 1) && this.sketchRenderer().equals("processing.awt.PGraphicsJava2D")) {
                surface.setAlwaysOnTop(true);
                surface.setAlwaysOnTop(false);
            }
            if (this.py5IconPath != null && !(this.g instanceof PGraphicsOpenGL)) {
                try {
                    surface.setIcon(this.loadImage(this.py5IconPath));
                }
                catch (Exception exception) {
                    // empty catch block
                }
            }
            if (this.py5RegisteredEvents.contains("setup")) {
                this.success = this.py5Bridge.run_method("setup", new Object[0]);
            } else {
                super.setup();
            }
            if (platform == 1 && (this.sketchRenderer().equals("processing.opengl.PGraphics2D") || this.sketchRenderer().equals("processing.opengl.PGraphics3D"))) {
                this.capturePixels(true);
            }
        }
    }

    public void draw() {
        if (this.pixelCapture != null) {
            this.restorePixels();
        }
        if (this.success && this.py5RegisteredEvents.contains("draw")) {
            this.success = this.py5Bridge.run_method("draw", new Object[0]);
        }
        if (this.frameCount == 1 && platform == 1 && (this.sketchRenderer().equals("processing.opengl.PGraphics2D") || this.sketchRenderer().equals("processing.opengl.PGraphics3D"))) {
            this.capturePixels(false);
        }
    }

    public void preDraw() {
        if (this.success && this.py5RegisteredEvents.contains("pre_draw")) {
            this.success = this.py5Bridge.run_method("pre_draw", new Object[0]);
        }
    }

    public void postDraw() {
        if (this.success && this.py5RegisteredEvents.contains("post_draw")) {
            this.success = this.py5Bridge.run_method("post_draw", new Object[0]);
        }
    }

    public void windowMoved() {
        if (this.success && this.py5RegisteredEvents.contains("window_moved")) {
            this.success = this.py5Bridge.run_method("window_moved", new Object[0]);
        }
    }

    public void windowResized() {
        if (this.success && this.py5RegisteredEvents.contains("window_resized")) {
            this.success = this.py5Bridge.run_method("window_resized", new Object[0]);
        }
    }

    protected boolean handleInputEventOneParam(String eventName, Event event) {
        if (this.success && this.py5RegisteredEvents.contains(eventName) && this.py5RegisteredEventParamCounts.get(eventName) == 1) {
            this.py5Bridge.run_method(eventName, event);
            return true;
        }
        return false;
    }

    protected void handleInputEventNoParams(String eventName) {
        if (this.success && this.py5RegisteredEvents.contains(eventName) && this.py5RegisteredEventParamCounts.get(eventName) == 0) {
            this.py5Bridge.run_method(eventName, new Object[0]);
        }
    }

    public void mousePressed(MouseEvent event) {
        if (!this.handleInputEventOneParam("mouse_pressed", (Event)event)) {
            this.mousePressed();
        }
    }

    public void mousePressed() {
        this.handleInputEventNoParams("mouse_pressed");
    }

    public void mouseReleased(MouseEvent event) {
        if (!this.handleInputEventOneParam("mouse_released", (Event)event)) {
            this.mouseReleased();
        }
    }

    public void mouseReleased() {
        this.handleInputEventNoParams("mouse_released");
    }

    public void mouseClicked(MouseEvent event) {
        if (!this.handleInputEventOneParam("mouse_clicked", (Event)event)) {
            this.mouseClicked();
        }
    }

    public void mouseClicked() {
        this.handleInputEventNoParams("mouse_clicked");
    }

    public void mouseDragged(MouseEvent event) {
        if (!this.handleInputEventOneParam("mouse_dragged", (Event)event)) {
            this.mouseDragged();
        }
    }

    public void mouseDragged() {
        this.handleInputEventNoParams("mouse_dragged");
    }

    public void mouseMoved(MouseEvent event) {
        if (!this.handleInputEventOneParam("mouse_moved", (Event)event)) {
            this.mouseMoved();
        }
    }

    public void mouseMoved() {
        this.handleInputEventNoParams("mouse_moved");
    }

    public void mouseEntered(MouseEvent event) {
        if (!this.handleInputEventOneParam("mouse_entered", (Event)event)) {
            this.mouseEntered();
        }
    }

    public void mouseEntered() {
        this.handleInputEventNoParams("mouse_entered");
    }

    public void mouseExited(MouseEvent event) {
        if (!this.handleInputEventOneParam("mouse_exited", (Event)event)) {
            this.mouseExited();
        }
    }

    public void mouseExited() {
        this.handleInputEventNoParams("mouse_exited");
    }

    public void mouseWheel(MouseEvent event) {
        if (!this.handleInputEventOneParam("mouse_wheel", (Event)event)) {
            this.mouseWheel();
        }
    }

    public void mouseWheel() {
        this.handleInputEventNoParams("mouse_wheel");
    }

    public void keyPressed(KeyEvent event) {
        if (!this.handleInputEventOneParam("key_pressed", (Event)event)) {
            this.keyPressed();
        }
    }

    public void keyPressed() {
        this.handleInputEventNoParams("key_pressed");
    }

    public void keyReleased(KeyEvent event) {
        if (!this.handleInputEventOneParam("key_released", (Event)event)) {
            this.keyReleased();
        }
    }

    public void keyReleased() {
        this.handleInputEventNoParams("key_released");
    }

    public void keyTyped(KeyEvent event) {
        if (!this.handleInputEventOneParam("key_typed", (Event)event)) {
            this.keyTyped();
        }
    }

    public void keyTyped() {
        this.handleInputEventNoParams("key_typed");
    }

    public void movieEvent(Object movie) {
        if (this.success && this.py5RegisteredEvents.contains("movie_event") && this.py5RegisteredEventParamCounts.get("movie_event") == 1) {
            this.success = this.py5Bridge.run_method("movie_event", movie);
        }
    }

    public void fakeMouseEvent(int action, int modifiers, int x, int y, int button, int count) {
        this.postEvent((Event)new MouseEvent(null, System.currentTimeMillis(), action, modifiers, x, y, button, count));
    }

    public void fakeKeyEvent(int action, int modifiers, String input, boolean isAutoRepeat) {
        char keyCode;
        char key = KeyEventUtilities.getASCIIKey(input);
        if (key > '\u0000') {
            keyCode = key;
        } else {
            key = '\uffff';
            char c = keyCode = this.g.isGL() ? KeyEventUtilities.getJogampKeyCode(input) : KeyEventUtilities.getAWTKeyCode(input);
            if (keyCode < '\u0000') {
                this.py5Println("py5 is unable to map '" + input + "' to a proper key_code value. Your renderer is " + this.getRendererName() + " and your platform is " + PConstants.platformNames[PApplet.platform] + ". Please open an issue on github to report this bug.", true);
            }
        }
        this.postEvent((Event)new KeyEvent(null, System.currentTimeMillis(), action, modifiers, key, (int)keyCode, isAutoRepeat));
    }

    public void postWindowMoved(int newX, int newY) {
        if (!this.sketchFullScreen()) {
            this.lastWindowX = newX;
            this.lastWindowY = newY;
        }
        super.postWindowMoved(newX, newY);
    }

    public void exit() {
        if (platform == 2 && this.g.isGL() && !this.isLooping()) {
            this.loop();
        }
        super.exit();
    }

    public void exitActual() {
        GLWindow window;
        ++this.exitActualCallCount;
        if (this.py5RegisteredEvents.contains("exiting")) {
            this.py5Bridge.run_method("exiting", new Object[0]);
        }
        this.py5Bridge.shutdown();
        Object nativeWindow = this.surface.getNative();
        if (nativeWindow instanceof GLWindow) {
            window = (GLWindow)nativeWindow;
            for (int i = 0; i < window.getGLEventListenerCount(); ++i) {
                window.disposeGLEventListener(window.getGLEventListener(i), true);
            }
            if (platform == 2 && this.exitActualCallCount == 1) {
                try {
                    MacOSXOnscreenCGLDrawable drawable = (MacOSXOnscreenCGLDrawable)window.getDelegatedDrawable();
                    WindowDriver driver = (WindowDriver)drawable.getNativeSurface();
                    driver.destroy();
                }
                catch (NullPointerException drawable) {
                    // empty catch block
                }
            }
        }
        if (nativeWindow instanceof Window) {
            window = (Window)nativeWindow;
            for (WindowListener windowListener : window.getWindowListeners()) {
                window.removeWindowListener(windowListener);
            }
            for (WindowListener windowListener : window.getKeyListeners()) {
                window.removeKeyListener((KeyListener)windowListener);
            }
            for (WindowListener windowListener : window.getMouseListeners()) {
                window.removeMouseListener((MouseListener)windowListener);
            }
            if (platform == 1 || platform == 2) {
                Screen screen = window.getScreen();
                Display display = screen.getDisplay();
                display.destroy();
                screen.destroy();
            }
            try {
                window.destroy();
            }
            catch (RuntimeException runtimeException) {}
        } else if (nativeWindow instanceof PSurfaceAWT.SmoothCanvas) {
            window = (PSurfaceAWT.SmoothCanvas)nativeWindow;
            window.getFrame().dispose();
        } else {
            this.surface.setVisible(false);
        }
        --this.exitActualCallCount;
    }

    public float getFrameRate() {
        return this.frameRate;
    }

    public boolean isKeyPressed() {
        return this.keyPressed;
    }

    public boolean isMousePressed() {
        return this.mousePressed;
    }

    public void py5SelectFolder(String key, String prompt, String defaultFolder) {
        SelectCallback sc = new SelectCallback(this, key);
        File defaultSelection = defaultFolder == null ? null : new File(defaultFolder);
        this.selectFolder(prompt, "callback", defaultSelection, sc);
    }

    public void py5SelectInput(String key, String prompt, String defaultFile) {
        SelectCallback sc = new SelectCallback(this, key);
        File defaultSelection = defaultFile == null ? null : new File(defaultFile);
        this.selectInput(prompt, "callback", defaultSelection, sc);
    }

    public void py5SelectOutput(String key, String prompt, String defaultFile) {
        SelectCallback sc = new SelectCallback(this, key);
        File defaultSelection = defaultFile == null ? null : new File(defaultFile);
        this.selectOutput(prompt, "callback", defaultSelection, sc);
    }

    public PShape createShape(int kind, float ... p) {
        if (p.length == 0) {
            return super.createShape(kind);
        }
        return super.createShape(kind, p);
    }

    public void points(float[][] coordinates) {
        if (this.recorder != null) {
            Py5GraphicsHelper.points(this.recorder, coordinates);
        }
        Py5GraphicsHelper.points(this.g, coordinates);
    }

    public void lines(float[][] coordinates) {
        if (this.recorder != null) {
            Py5GraphicsHelper.lines(this.recorder, coordinates);
        }
        Py5GraphicsHelper.lines(this.g, coordinates);
    }

    public void vertices(float[][] coordinates) {
        if (this.recorder != null) {
            Py5GraphicsHelper.vertices(this.recorder, coordinates);
        }
        Py5GraphicsHelper.vertices(this.g, coordinates);
    }

    public void bezierVertices(float[][] coordinates) {
        if (this.recorder != null) {
            Py5GraphicsHelper.bezierVertices(this.recorder, coordinates);
        }
        Py5GraphicsHelper.bezierVertices(this.g, coordinates);
    }

    public void curveVertices(float[][] coordinates) {
        if (this.recorder != null) {
            Py5GraphicsHelper.curveVertices(this.recorder, coordinates);
        }
        Py5GraphicsHelper.curveVertices(this.g, coordinates);
    }

    public void quadraticVertices(float[][] coordinates) {
        if (this.recorder != null) {
            Py5GraphicsHelper.quadraticVertices(this.recorder, coordinates);
        }
        Py5GraphicsHelper.quadraticVertices(this.g, coordinates);
    }

    public void printMatrix() {
        if (this.g instanceof PGraphicsOpenGL) {
            this.py5Println(PrintUtils.toString(((PGraphicsOpenGL)this.g).modelview));
        } else {
            this.py5Println(PrintUtils.toString(this.g.getMatrix((PMatrix2D)null)));
        }
    }

    public void printCamera() {
        if (this.g instanceof PGraphicsOpenGL) {
            this.py5Println(PrintUtils.toString(((PGraphicsOpenGL)this.g).camera));
        } else {
            this.py5Println("print_camera() is not available with this renderer.");
        }
    }

    public void printProjection() {
        if (this.g instanceof PGraphicsOpenGL) {
            this.py5Println(PrintUtils.toString(((PGraphicsOpenGL)this.g).projection));
        } else {
            this.py5Println("print_projection() is not available with this renderer.");
        }
    }

    public float[] noiseArray(float[] x) {
        float[] out = new float[x.length];
        for (int i = 0; i < x.length; ++i) {
            out[i] = this.noise(x[i]);
        }
        return out;
    }

    public float[] noiseArray(float[] x, float[] y) {
        float[] out = new float[x.length];
        for (int i = 0; i < x.length; ++i) {
            out[i] = this.noise(x[i], y[i]);
        }
        return out;
    }

    public float[] noiseArray(float[] x, float[] y, float[] z) {
        float[] out = new float[x.length];
        for (int i = 0; i < x.length; ++i) {
            out[i] = this.noise(x[i], y[i], z[i]);
        }
        return out;
    }

    public void osNoiseSeed(long seed) {
        this.osNoiseSeed = seed;
    }

    public float osNoise(float x, float y) {
        return OpenSimplex2S.noise2(this.osNoiseSeed, x, y);
    }

    public float osNoise(float x, float y, float z) {
        return OpenSimplex2S.noise3_Fallback(this.osNoiseSeed, x, y, z);
    }

    public float osNoise(float x, float y, float z, float w) {
        return OpenSimplex2S.noise4_Fallback(this.osNoiseSeed, x, y, z, w);
    }

    public float[] osNoiseArray(float[] x, float[] y) {
        float[] out = new float[x.length];
        for (int i = 0; i < x.length; ++i) {
            out[i] = OpenSimplex2S.noise2(this.osNoiseSeed, x[i], y[i]);
        }
        return out;
    }

    public float[] osNoiseArray(float[] x, float[] y, float[] z) {
        float[] out = new float[x.length];
        for (int i = 0; i < x.length; ++i) {
            out[i] = OpenSimplex2S.noise3_Fallback(this.osNoiseSeed, x[i], y[i], y[i]);
        }
        return out;
    }

    public float[] osNoiseArray(float[] x, float[] y, float[] z, float[] w) {
        float[] out = new float[x.length];
        for (int i = 0; i < x.length; ++i) {
            out[i] = OpenSimplex2S.noise4_Fallback(this.osNoiseSeed, x[i], y[i], y[i], w[i]);
        }
        return out;
    }

    protected void capturePixels(boolean alwaysOnTop) {
        this.surface.setAlwaysOnTop(alwaysOnTop);
        this.loadPixels();
        this.pixelCapture = new int[this.pixels.length];
        System.arraycopy(this.pixels, 0, this.pixelCapture, 0, this.pixels.length);
    }

    protected void restorePixels() {
        this.loadPixels();
        System.arraycopy(this.pixelCapture, 0, this.pixels, 0, this.pixels.length);
        this.pixelCapture = null;
        this.updatePixels();
    }

    public class SelectCallback {
        protected Sketch sketch;
        protected String callback;

        public SelectCallback(Sketch sketch, String callback) {
            this.sketch = sketch;
            this.callback = callback;
        }

        public void callback(File selection) {
            try {
                this.sketch.callFunction(this.callback, selection == null ? null : selection.getAbsolutePath());
            }
            catch (Exception e) {
                Sketch.this._terminateSketch(true);
            }
        }
    }
}

