import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface AlertChannelConfig extends cdktf.TerraformMetaArguments {
    /**
    * The New Relic account ID where you want to create alert channels.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#account_id AlertChannel#account_id}
    */
    readonly accountId?: number;
    /**
    * (Required) The name of the channel.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#name AlertChannel#name}
    */
    readonly name: string;
    /**
    * (Required) The type of channel. One of: (webhook, email, opsgenie, pagerduty, slack, user, victorops).
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#type AlertChannel#type}
    */
    readonly type: string;
    /**
    * config block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#config AlertChannel#config}
    */
    readonly config?: AlertChannelConfigA;
}
export interface AlertChannelConfigA {
    /**
    * The API key for integrating with OpsGenie.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#api_key AlertChannel#api_key}
    */
    readonly apiKey?: string;
    /**
    * Specifies an authentication password for use with a channel. Supported by the webhook channel type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#auth_password AlertChannel#auth_password}
    */
    readonly authPassword?: string;
    /**
    * Specifies an authentication method for use with a channel. Supported by the webhook channel type. Only HTTP basic authentication is currently supported via the value BASIC.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#auth_type AlertChannel#auth_type}
    */
    readonly authType?: string;
    /**
    * Specifies an authentication username for use with a channel. Supported by the webhook channel type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#auth_username AlertChannel#auth_username}
    */
    readonly authUsername?: string;
    /**
    * The base URL of the webhook destination.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#base_url AlertChannel#base_url}
    */
    readonly baseUrl?: string;
    /**
    * The Slack channel to send notifications to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#channel AlertChannel#channel}
    */
    readonly channel?: string;
    /**
    * A map of key/value pairs that represents extra HTTP headers to be sent along with the webhook payload.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#headers AlertChannel#headers}
    */
    readonly headers?: {
        [key: string]: string;
    };
    /**
    * Use instead of headers if the desired payload is more complex than a list of key/value pairs (e.g. a set of headers that makes use of nested objects). The value provided should be a valid JSON string with escaped double quotes. Conflicts with headers.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#headers_string AlertChannel#headers_string}
    */
    readonly headersString?: string;
    /**
    * true or false. Flag for whether or not to attach a JSON document containing information about the associated alert to the email that is sent to recipients.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#include_json_attachment AlertChannel#include_json_attachment}
    */
    readonly includeJsonAttachment?: string;
    /**
    * The key for integrating with VictorOps.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#key AlertChannel#key}
    */
    readonly key?: string;
    /**
    * A map of key/value pairs that represents the webhook payload. Must provide payload_type if setting this argument.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#payload AlertChannel#payload}
    */
    readonly payload?: {
        [key: string]: string;
    };
    /**
    * Use instead of payload if the desired payload is more complex than a list of key/value pairs (e.g. a payload that makes use of nested objects). The value provided should be a valid JSON string with escaped double quotes. Conflicts with payload.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#payload_string AlertChannel#payload_string}
    */
    readonly payloadString?: string;
    /**
    * Can either be application/json or application/x-www-form-urlencoded. The payload_type argument is required if payload is set.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#payload_type AlertChannel#payload_type}
    */
    readonly payloadType?: string;
    /**
    * A set of recipients for targeting notifications. Multiple values are comma separated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#recipients AlertChannel#recipients}
    */
    readonly recipients?: string;
    /**
    * The data center region to store your data. Valid values are US and EU. Default is US.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#region AlertChannel#region}
    */
    readonly region?: string;
    /**
    * The route key for integrating with VictorOps.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#route_key AlertChannel#route_key}
    */
    readonly routeKey?: string;
    /**
    * Specifies the service key for integrating with Pagerduty.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#service_key AlertChannel#service_key}
    */
    readonly serviceKey?: string;
    /**
    * A set of tags for targeting notifications. Multiple values are comma separated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#tags AlertChannel#tags}
    */
    readonly tags?: string;
    /**
    * A set of teams for targeting notifications. Multiple values are comma separated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#teams AlertChannel#teams}
    */
    readonly teams?: string;
    /**
    * Your organization's Slack URL.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#url AlertChannel#url}
    */
    readonly url?: string;
    /**
    * The user ID for use with the user channel type.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel#user_id AlertChannel#user_id}
    */
    readonly userId?: string;
}
export declare function alertChannelConfigAToTerraform(struct?: AlertChannelConfigAOutputReference | AlertChannelConfigA): any;
export declare class AlertChannelConfigAOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): AlertChannelConfigA | undefined;
    set internalValue(value: AlertChannelConfigA | undefined);
    private _apiKey?;
    get apiKey(): string;
    set apiKey(value: string);
    resetApiKey(): void;
    get apiKeyInput(): string | undefined;
    private _authPassword?;
    get authPassword(): string;
    set authPassword(value: string);
    resetAuthPassword(): void;
    get authPasswordInput(): string | undefined;
    private _authType?;
    get authType(): string;
    set authType(value: string);
    resetAuthType(): void;
    get authTypeInput(): string | undefined;
    private _authUsername?;
    get authUsername(): string;
    set authUsername(value: string);
    resetAuthUsername(): void;
    get authUsernameInput(): string | undefined;
    private _baseUrl?;
    get baseUrl(): string;
    set baseUrl(value: string);
    resetBaseUrl(): void;
    get baseUrlInput(): string | undefined;
    private _channel?;
    get channel(): string;
    set channel(value: string);
    resetChannel(): void;
    get channelInput(): string | undefined;
    private _headers?;
    get headers(): {
        [key: string]: string;
    };
    set headers(value: {
        [key: string]: string;
    });
    resetHeaders(): void;
    get headersInput(): {
        [key: string]: string;
    } | undefined;
    private _headersString?;
    get headersString(): string;
    set headersString(value: string);
    resetHeadersString(): void;
    get headersStringInput(): string | undefined;
    private _includeJsonAttachment?;
    get includeJsonAttachment(): string;
    set includeJsonAttachment(value: string);
    resetIncludeJsonAttachment(): void;
    get includeJsonAttachmentInput(): string | undefined;
    private _key?;
    get key(): string;
    set key(value: string);
    resetKey(): void;
    get keyInput(): string | undefined;
    private _payload?;
    get payload(): {
        [key: string]: string;
    };
    set payload(value: {
        [key: string]: string;
    });
    resetPayload(): void;
    get payloadInput(): {
        [key: string]: string;
    } | undefined;
    private _payloadString?;
    get payloadString(): string;
    set payloadString(value: string);
    resetPayloadString(): void;
    get payloadStringInput(): string | undefined;
    private _payloadType?;
    get payloadType(): string;
    set payloadType(value: string);
    resetPayloadType(): void;
    get payloadTypeInput(): string | undefined;
    private _recipients?;
    get recipients(): string;
    set recipients(value: string);
    resetRecipients(): void;
    get recipientsInput(): string | undefined;
    private _region?;
    get region(): string;
    set region(value: string);
    resetRegion(): void;
    get regionInput(): string | undefined;
    private _routeKey?;
    get routeKey(): string;
    set routeKey(value: string);
    resetRouteKey(): void;
    get routeKeyInput(): string | undefined;
    private _serviceKey?;
    get serviceKey(): string;
    set serviceKey(value: string);
    resetServiceKey(): void;
    get serviceKeyInput(): string | undefined;
    private _tags?;
    get tags(): string;
    set tags(value: string);
    resetTags(): void;
    get tagsInput(): string | undefined;
    private _teams?;
    get teams(): string;
    set teams(value: string);
    resetTeams(): void;
    get teamsInput(): string | undefined;
    private _url?;
    get url(): string;
    set url(value: string);
    resetUrl(): void;
    get urlInput(): string | undefined;
    private _userId?;
    get userId(): string;
    set userId(value: string);
    resetUserId(): void;
    get userIdInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel newrelic_alert_channel}
*/
export declare class AlertChannel extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/alert_channel newrelic_alert_channel} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AlertChannelConfig
    */
    constructor(scope: Construct, id: string, config: AlertChannelConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _type?;
    get type(): string;
    set type(value: string);
    get typeInput(): string | undefined;
    private _config;
    get config(): AlertChannelConfigAOutputReference;
    putConfig(value: AlertChannelConfigA): void;
    resetConfig(): void;
    get configInput(): AlertChannelConfigA | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
