"use strict";
var _a;
Object.defineProperty(exports, "__esModule", { value: true });
exports.AlertCondition = exports.alertConditionTermToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function alertConditionTermToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        duration: cdktf.numberToTerraform(struct.duration),
        operator: cdktf.stringToTerraform(struct.operator),
        priority: cdktf.stringToTerraform(struct.priority),
        threshold: cdktf.numberToTerraform(struct.threshold),
        time_function: cdktf.stringToTerraform(struct.timeFunction),
    };
}
exports.alertConditionTermToTerraform = alertConditionTermToTerraform;
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition newrelic_alert_condition}
*/
class AlertCondition extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/alert_condition newrelic_alert_condition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options AlertConditionConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'newrelic_alert_condition',
            terraformGeneratorMetadata: {
                providerName: 'newrelic'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        this._conditionScope = config.conditionScope;
        this._enabled = config.enabled;
        this._entities = config.entities;
        this._gcMetric = config.gcMetric;
        this._metric = config.metric;
        this._name = config.name;
        this._policyId = config.policyId;
        this._runbookUrl = config.runbookUrl;
        this._type = config.type;
        this._userDefinedMetric = config.userDefinedMetric;
        this._userDefinedValueFunction = config.userDefinedValueFunction;
        this._violationCloseTimer = config.violationCloseTimer;
        this._term = config.term;
    }
    get conditionScope() {
        return this.getStringAttribute('condition_scope');
    }
    set conditionScope(value) {
        this._conditionScope = value;
    }
    resetConditionScope() {
        this._conditionScope = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get conditionScopeInput() {
        return this._conditionScope;
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get entities() {
        return cdktf.Token.asNumberList(cdktf.Fn.tolist(this.getNumberListAttribute('entities')));
    }
    set entities(value) {
        this._entities = value;
    }
    // Temporarily expose input value. Use with caution.
    get entitiesInput() {
        return this._entities;
    }
    get gcMetric() {
        return this.getStringAttribute('gc_metric');
    }
    set gcMetric(value) {
        this._gcMetric = value;
    }
    resetGcMetric() {
        this._gcMetric = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get gcMetricInput() {
        return this._gcMetric;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get metric() {
        return this.getStringAttribute('metric');
    }
    set metric(value) {
        this._metric = value;
    }
    // Temporarily expose input value. Use with caution.
    get metricInput() {
        return this._metric;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get policyId() {
        return this.getNumberAttribute('policy_id');
    }
    set policyId(value) {
        this._policyId = value;
    }
    // Temporarily expose input value. Use with caution.
    get policyIdInput() {
        return this._policyId;
    }
    get runbookUrl() {
        return this.getStringAttribute('runbook_url');
    }
    set runbookUrl(value) {
        this._runbookUrl = value;
    }
    resetRunbookUrl() {
        this._runbookUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runbookUrlInput() {
        return this._runbookUrl;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    get userDefinedMetric() {
        return this.getStringAttribute('user_defined_metric');
    }
    set userDefinedMetric(value) {
        this._userDefinedMetric = value;
    }
    resetUserDefinedMetric() {
        this._userDefinedMetric = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userDefinedMetricInput() {
        return this._userDefinedMetric;
    }
    get userDefinedValueFunction() {
        return this.getStringAttribute('user_defined_value_function');
    }
    set userDefinedValueFunction(value) {
        this._userDefinedValueFunction = value;
    }
    resetUserDefinedValueFunction() {
        this._userDefinedValueFunction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get userDefinedValueFunctionInput() {
        return this._userDefinedValueFunction;
    }
    get violationCloseTimer() {
        return this.getNumberAttribute('violation_close_timer');
    }
    set violationCloseTimer(value) {
        this._violationCloseTimer = value;
    }
    resetViolationCloseTimer() {
        this._violationCloseTimer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get violationCloseTimerInput() {
        return this._violationCloseTimer;
    }
    get term() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('term')));
    }
    set term(value) {
        this._term = value;
    }
    // Temporarily expose input value. Use with caution.
    get termInput() {
        return this._term;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            condition_scope: cdktf.stringToTerraform(this._conditionScope),
            enabled: cdktf.booleanToTerraform(this._enabled),
            entities: cdktf.listMapper(cdktf.numberToTerraform)(this._entities),
            gc_metric: cdktf.stringToTerraform(this._gcMetric),
            metric: cdktf.stringToTerraform(this._metric),
            name: cdktf.stringToTerraform(this._name),
            policy_id: cdktf.numberToTerraform(this._policyId),
            runbook_url: cdktf.stringToTerraform(this._runbookUrl),
            type: cdktf.stringToTerraform(this._type),
            user_defined_metric: cdktf.stringToTerraform(this._userDefinedMetric),
            user_defined_value_function: cdktf.stringToTerraform(this._userDefinedValueFunction),
            violation_close_timer: cdktf.numberToTerraform(this._violationCloseTimer),
            term: cdktf.listMapper(alertConditionTermToTerraform)(this._term),
        };
    }
}
exports.AlertCondition = AlertCondition;
_a = JSII_RTTI_SYMBOL_1;
AlertCondition[_a] = { fqn: "@cdktf/provider-newrelic.AlertCondition", version: "0.3.375" };
// =================
// STATIC PROPERTIES
// =================
AlertCondition.tfResourceType = "newrelic_alert_condition";
//# sourceMappingURL=data:application/json;base64,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