import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface CloudAwsLinkAccountConfig extends cdktf.TerraformMetaArguments {
    /**
    * The New Relic account ID where you want to link the AWS account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_link_account#account_id CloudAwsLinkAccount#account_id}
    */
    readonly accountId?: number;
    /**
    * The AWS role ARN.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_link_account#arn CloudAwsLinkAccount#arn}
    */
    readonly arn: string;
    /**
    * How metrics will be collected. Defaults to `PULL` if empty.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_link_account#metric_collection_mode CloudAwsLinkAccount#metric_collection_mode}
    */
    readonly metricCollectionMode?: string;
    /**
    * The name of the linked account.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_link_account#name CloudAwsLinkAccount#name}
    */
    readonly name: string;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_link_account#timeouts CloudAwsLinkAccount#timeouts}
    */
    readonly timeouts?: CloudAwsLinkAccountTimeouts;
}
export interface CloudAwsLinkAccountTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_link_account#create CloudAwsLinkAccount#create}
    */
    readonly create?: string;
}
export declare function cloudAwsLinkAccountTimeoutsToTerraform(struct?: CloudAwsLinkAccountTimeoutsOutputReference | CloudAwsLinkAccountTimeouts | cdktf.IResolvable): any;
export declare class CloudAwsLinkAccountTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): CloudAwsLinkAccountTimeouts | undefined;
    set internalValue(value: CloudAwsLinkAccountTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_link_account newrelic_cloud_aws_link_account}
*/
export declare class CloudAwsLinkAccount extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/cloud_aws_link_account newrelic_cloud_aws_link_account} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options CloudAwsLinkAccountConfig
    */
    constructor(scope: Construct, id: string, config: CloudAwsLinkAccountConfig);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    resetAccountId(): void;
    get accountIdInput(): number | undefined;
    private _arn?;
    get arn(): string;
    set arn(value: string);
    get arnInput(): string | undefined;
    get id(): string;
    private _metricCollectionMode?;
    get metricCollectionMode(): string;
    set metricCollectionMode(value: string);
    resetMetricCollectionMode(): void;
    get metricCollectionModeInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _timeouts;
    get timeouts(): CloudAwsLinkAccountTimeoutsOutputReference;
    putTimeouts(value: CloudAwsLinkAccountTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): CloudAwsLinkAccountTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
