import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface DataNewrelicPluginComponentConfig extends cdktf.TerraformMetaArguments {
    /**
    * The name of the plugin component.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/plugin_component#name DataNewrelicPluginComponent#name}
    */
    readonly name: string;
    /**
    * The ID of the plugin instance this component belongs to.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/d/plugin_component#plugin_id DataNewrelicPluginComponent#plugin_id}
    */
    readonly pluginId: number;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/d/plugin_component newrelic_plugin_component}
*/
export declare class DataNewrelicPluginComponent extends cdktf.TerraformDataSource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/d/plugin_component newrelic_plugin_component} Data Source
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options DataNewrelicPluginComponentConfig
    */
    constructor(scope: Construct, id: string, config: DataNewrelicPluginComponentConfig);
    get healthStatus(): string;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pluginId?;
    get pluginId(): number;
    set pluginId(value: number);
    get pluginIdInput(): number | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
