import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface EntityTagsConfig extends cdktf.TerraformMetaArguments {
    /**
    * The guid of the entity to tag.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags#guid EntityTags#guid}
    */
    readonly guid: string;
    /**
    * tag block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags#tag EntityTags#tag}
    */
    readonly tag: EntityTagsTag[] | cdktf.IResolvable;
    /**
    * timeouts block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags#timeouts EntityTags#timeouts}
    */
    readonly timeouts?: EntityTagsTimeouts;
}
export interface EntityTagsTag {
    /**
    * The tag key.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags#key EntityTags#key}
    */
    readonly key: string;
    /**
    * The tag values.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags#values EntityTags#values}
    */
    readonly values: string[];
}
export declare function entityTagsTagToTerraform(struct?: EntityTagsTag | cdktf.IResolvable): any;
export interface EntityTagsTimeouts {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags#create EntityTags#create}
    */
    readonly create?: string;
}
export declare function entityTagsTimeoutsToTerraform(struct?: EntityTagsTimeoutsOutputReference | EntityTagsTimeouts | cdktf.IResolvable): any;
export declare class EntityTagsTimeoutsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): EntityTagsTimeouts | undefined;
    set internalValue(value: EntityTagsTimeouts | undefined);
    private _create?;
    get create(): string;
    set create(value: string);
    resetCreate(): void;
    get createInput(): string | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags newrelic_entity_tags}
*/
export declare class EntityTags extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/entity_tags newrelic_entity_tags} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options EntityTagsConfig
    */
    constructor(scope: Construct, id: string, config: EntityTagsConfig);
    private _guid?;
    get guid(): string;
    set guid(value: string);
    get guidInput(): string | undefined;
    get id(): string;
    private _tag?;
    get tag(): EntityTagsTag[] | cdktf.IResolvable;
    set tag(value: EntityTagsTag[] | cdktf.IResolvable);
    get tagInput(): cdktf.IResolvable | EntityTagsTag[] | undefined;
    private _timeouts;
    get timeouts(): EntityTagsTimeoutsOutputReference;
    putTimeouts(value: EntityTagsTimeouts): void;
    resetTimeouts(): void;
    get timeoutsInput(): EntityTagsTimeouts | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
