"use strict";
var _a, _b, _c, _d;
Object.defineProperty(exports, "__esModule", { value: true });
exports.NrqlAlertCondition = exports.NrqlAlertConditionWarningOutputReference = exports.nrqlAlertConditionWarningToTerraform = exports.nrqlAlertConditionTermToTerraform = exports.NrqlAlertConditionNrqlOutputReference = exports.nrqlAlertConditionNrqlToTerraform = exports.NrqlAlertConditionCriticalOutputReference = exports.nrqlAlertConditionCriticalToTerraform = void 0;
const JSII_RTTI_SYMBOL_1 = Symbol.for("jsii.rtti");
const cdktf = require("cdktf");
function nrqlAlertConditionCriticalToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        duration: cdktf.numberToTerraform(struct.duration),
        operator: cdktf.stringToTerraform(struct.operator),
        threshold: cdktf.numberToTerraform(struct.threshold),
        threshold_duration: cdktf.numberToTerraform(struct.thresholdDuration),
        threshold_occurrences: cdktf.stringToTerraform(struct.thresholdOccurrences),
        time_function: cdktf.stringToTerraform(struct.timeFunction),
    };
}
exports.nrqlAlertConditionCriticalToTerraform = nrqlAlertConditionCriticalToTerraform;
class NrqlAlertConditionCriticalOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._duration !== undefined) {
            hasAnyValues = true;
            internalValueResult.duration = this._duration;
        }
        if (this._operator !== undefined) {
            hasAnyValues = true;
            internalValueResult.operator = this._operator;
        }
        if (this._threshold !== undefined) {
            hasAnyValues = true;
            internalValueResult.threshold = this._threshold;
        }
        if (this._thresholdDuration !== undefined) {
            hasAnyValues = true;
            internalValueResult.thresholdDuration = this._thresholdDuration;
        }
        if (this._thresholdOccurrences !== undefined) {
            hasAnyValues = true;
            internalValueResult.thresholdOccurrences = this._thresholdOccurrences;
        }
        if (this._timeFunction !== undefined) {
            hasAnyValues = true;
            internalValueResult.timeFunction = this._timeFunction;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._duration = undefined;
            this._operator = undefined;
            this._threshold = undefined;
            this._thresholdDuration = undefined;
            this._thresholdOccurrences = undefined;
            this._timeFunction = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._duration = value.duration;
            this._operator = value.operator;
            this._threshold = value.threshold;
            this._thresholdDuration = value.thresholdDuration;
            this._thresholdOccurrences = value.thresholdOccurrences;
            this._timeFunction = value.timeFunction;
        }
    }
    get duration() {
        return this.getNumberAttribute('duration');
    }
    set duration(value) {
        this._duration = value;
    }
    resetDuration() {
        this._duration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get durationInput() {
        return this._duration;
    }
    get operator() {
        return this.getStringAttribute('operator');
    }
    set operator(value) {
        this._operator = value;
    }
    resetOperator() {
        this._operator = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operatorInput() {
        return this._operator;
    }
    get threshold() {
        return this.getNumberAttribute('threshold');
    }
    set threshold(value) {
        this._threshold = value;
    }
    // Temporarily expose input value. Use with caution.
    get thresholdInput() {
        return this._threshold;
    }
    get thresholdDuration() {
        return this.getNumberAttribute('threshold_duration');
    }
    set thresholdDuration(value) {
        this._thresholdDuration = value;
    }
    resetThresholdDuration() {
        this._thresholdDuration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get thresholdDurationInput() {
        return this._thresholdDuration;
    }
    get thresholdOccurrences() {
        return this.getStringAttribute('threshold_occurrences');
    }
    set thresholdOccurrences(value) {
        this._thresholdOccurrences = value;
    }
    resetThresholdOccurrences() {
        this._thresholdOccurrences = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get thresholdOccurrencesInput() {
        return this._thresholdOccurrences;
    }
    get timeFunction() {
        return this.getStringAttribute('time_function');
    }
    set timeFunction(value) {
        this._timeFunction = value;
    }
    resetTimeFunction() {
        this._timeFunction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeFunctionInput() {
        return this._timeFunction;
    }
}
exports.NrqlAlertConditionCriticalOutputReference = NrqlAlertConditionCriticalOutputReference;
_a = JSII_RTTI_SYMBOL_1;
NrqlAlertConditionCriticalOutputReference[_a] = { fqn: "@cdktf/provider-newrelic.NrqlAlertConditionCriticalOutputReference", version: "0.3.375" };
function nrqlAlertConditionNrqlToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        evaluation_offset: cdktf.numberToTerraform(struct.evaluationOffset),
        query: cdktf.stringToTerraform(struct.query),
        since_value: cdktf.stringToTerraform(struct.sinceValue),
    };
}
exports.nrqlAlertConditionNrqlToTerraform = nrqlAlertConditionNrqlToTerraform;
class NrqlAlertConditionNrqlOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._evaluationOffset !== undefined) {
            hasAnyValues = true;
            internalValueResult.evaluationOffset = this._evaluationOffset;
        }
        if (this._query !== undefined) {
            hasAnyValues = true;
            internalValueResult.query = this._query;
        }
        if (this._sinceValue !== undefined) {
            hasAnyValues = true;
            internalValueResult.sinceValue = this._sinceValue;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._evaluationOffset = undefined;
            this._query = undefined;
            this._sinceValue = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._evaluationOffset = value.evaluationOffset;
            this._query = value.query;
            this._sinceValue = value.sinceValue;
        }
    }
    get evaluationOffset() {
        return this.getNumberAttribute('evaluation_offset');
    }
    set evaluationOffset(value) {
        this._evaluationOffset = value;
    }
    resetEvaluationOffset() {
        this._evaluationOffset = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get evaluationOffsetInput() {
        return this._evaluationOffset;
    }
    get query() {
        return this.getStringAttribute('query');
    }
    set query(value) {
        this._query = value;
    }
    // Temporarily expose input value. Use with caution.
    get queryInput() {
        return this._query;
    }
    get sinceValue() {
        return this.getStringAttribute('since_value');
    }
    set sinceValue(value) {
        this._sinceValue = value;
    }
    resetSinceValue() {
        this._sinceValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get sinceValueInput() {
        return this._sinceValue;
    }
}
exports.NrqlAlertConditionNrqlOutputReference = NrqlAlertConditionNrqlOutputReference;
_b = JSII_RTTI_SYMBOL_1;
NrqlAlertConditionNrqlOutputReference[_b] = { fqn: "@cdktf/provider-newrelic.NrqlAlertConditionNrqlOutputReference", version: "0.3.375" };
function nrqlAlertConditionTermToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        duration: cdktf.numberToTerraform(struct.duration),
        operator: cdktf.stringToTerraform(struct.operator),
        priority: cdktf.stringToTerraform(struct.priority),
        threshold: cdktf.numberToTerraform(struct.threshold),
        threshold_duration: cdktf.numberToTerraform(struct.thresholdDuration),
        threshold_occurrences: cdktf.stringToTerraform(struct.thresholdOccurrences),
        time_function: cdktf.stringToTerraform(struct.timeFunction),
    };
}
exports.nrqlAlertConditionTermToTerraform = nrqlAlertConditionTermToTerraform;
function nrqlAlertConditionWarningToTerraform(struct) {
    if (!cdktf.canInspect(struct) || cdktf.Tokenization.isResolvable(struct)) {
        return struct;
    }
    if (cdktf.isComplexElement(struct)) {
        throw new Error("A complex element was used as configuration, this is not supported: https://cdk.tf/complex-object-as-configuration");
    }
    return {
        duration: cdktf.numberToTerraform(struct.duration),
        operator: cdktf.stringToTerraform(struct.operator),
        threshold: cdktf.numberToTerraform(struct.threshold),
        threshold_duration: cdktf.numberToTerraform(struct.thresholdDuration),
        threshold_occurrences: cdktf.stringToTerraform(struct.thresholdOccurrences),
        time_function: cdktf.stringToTerraform(struct.timeFunction),
    };
}
exports.nrqlAlertConditionWarningToTerraform = nrqlAlertConditionWarningToTerraform;
class NrqlAlertConditionWarningOutputReference extends cdktf.ComplexObject {
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource, terraformAttribute, isSingleItem) {
        super(terraformResource, terraformAttribute, isSingleItem);
        this.isEmptyObject = false;
    }
    get internalValue() {
        let hasAnyValues = this.isEmptyObject;
        const internalValueResult = {};
        if (this._duration !== undefined) {
            hasAnyValues = true;
            internalValueResult.duration = this._duration;
        }
        if (this._operator !== undefined) {
            hasAnyValues = true;
            internalValueResult.operator = this._operator;
        }
        if (this._threshold !== undefined) {
            hasAnyValues = true;
            internalValueResult.threshold = this._threshold;
        }
        if (this._thresholdDuration !== undefined) {
            hasAnyValues = true;
            internalValueResult.thresholdDuration = this._thresholdDuration;
        }
        if (this._thresholdOccurrences !== undefined) {
            hasAnyValues = true;
            internalValueResult.thresholdOccurrences = this._thresholdOccurrences;
        }
        if (this._timeFunction !== undefined) {
            hasAnyValues = true;
            internalValueResult.timeFunction = this._timeFunction;
        }
        return hasAnyValues ? internalValueResult : undefined;
    }
    set internalValue(value) {
        if (value === undefined) {
            this.isEmptyObject = false;
            this._duration = undefined;
            this._operator = undefined;
            this._threshold = undefined;
            this._thresholdDuration = undefined;
            this._thresholdOccurrences = undefined;
            this._timeFunction = undefined;
        }
        else {
            this.isEmptyObject = Object.keys(value).length === 0;
            this._duration = value.duration;
            this._operator = value.operator;
            this._threshold = value.threshold;
            this._thresholdDuration = value.thresholdDuration;
            this._thresholdOccurrences = value.thresholdOccurrences;
            this._timeFunction = value.timeFunction;
        }
    }
    get duration() {
        return this.getNumberAttribute('duration');
    }
    set duration(value) {
        this._duration = value;
    }
    resetDuration() {
        this._duration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get durationInput() {
        return this._duration;
    }
    get operator() {
        return this.getStringAttribute('operator');
    }
    set operator(value) {
        this._operator = value;
    }
    resetOperator() {
        this._operator = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get operatorInput() {
        return this._operator;
    }
    get threshold() {
        return this.getNumberAttribute('threshold');
    }
    set threshold(value) {
        this._threshold = value;
    }
    // Temporarily expose input value. Use with caution.
    get thresholdInput() {
        return this._threshold;
    }
    get thresholdDuration() {
        return this.getNumberAttribute('threshold_duration');
    }
    set thresholdDuration(value) {
        this._thresholdDuration = value;
    }
    resetThresholdDuration() {
        this._thresholdDuration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get thresholdDurationInput() {
        return this._thresholdDuration;
    }
    get thresholdOccurrences() {
        return this.getStringAttribute('threshold_occurrences');
    }
    set thresholdOccurrences(value) {
        this._thresholdOccurrences = value;
    }
    resetThresholdOccurrences() {
        this._thresholdOccurrences = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get thresholdOccurrencesInput() {
        return this._thresholdOccurrences;
    }
    get timeFunction() {
        return this.getStringAttribute('time_function');
    }
    set timeFunction(value) {
        this._timeFunction = value;
    }
    resetTimeFunction() {
        this._timeFunction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get timeFunctionInput() {
        return this._timeFunction;
    }
}
exports.NrqlAlertConditionWarningOutputReference = NrqlAlertConditionWarningOutputReference;
_c = JSII_RTTI_SYMBOL_1;
NrqlAlertConditionWarningOutputReference[_c] = { fqn: "@cdktf/provider-newrelic.NrqlAlertConditionWarningOutputReference", version: "0.3.375" };
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition newrelic_nrql_alert_condition}
*/
class NrqlAlertCondition extends cdktf.TerraformResource {
    // ===========
    // INITIALIZER
    // ===========
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/nrql_alert_condition newrelic_nrql_alert_condition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options NrqlAlertConditionConfig
    */
    constructor(scope, id, config) {
        super(scope, id, {
            terraformResourceType: 'newrelic_nrql_alert_condition',
            terraformGeneratorMetadata: {
                providerName: 'newrelic'
            },
            provider: config.provider,
            dependsOn: config.dependsOn,
            count: config.count,
            lifecycle: config.lifecycle
        });
        // critical - computed: false, optional: true, required: false
        this._critical = new NrqlAlertConditionCriticalOutputReference(this, "critical", true);
        // nrql - computed: false, optional: false, required: true
        this._nrql = new NrqlAlertConditionNrqlOutputReference(this, "nrql", true);
        // warning - computed: false, optional: true, required: false
        this._warning = new NrqlAlertConditionWarningOutputReference(this, "warning", true);
        this._accountId = config.accountId;
        this._aggregationDelay = config.aggregationDelay;
        this._aggregationMethod = config.aggregationMethod;
        this._aggregationTimer = config.aggregationTimer;
        this._aggregationWindow = config.aggregationWindow;
        this._baselineDirection = config.baselineDirection;
        this._closeViolationsOnExpiration = config.closeViolationsOnExpiration;
        this._description = config.description;
        this._enabled = config.enabled;
        this._expectedGroups = config.expectedGroups;
        this._expirationDuration = config.expirationDuration;
        this._fillOption = config.fillOption;
        this._fillValue = config.fillValue;
        this._ignoreOverlap = config.ignoreOverlap;
        this._name = config.name;
        this._openViolationOnExpiration = config.openViolationOnExpiration;
        this._openViolationOnGroupOverlap = config.openViolationOnGroupOverlap;
        this._policyId = config.policyId;
        this._runbookUrl = config.runbookUrl;
        this._slideBy = config.slideBy;
        this._type = config.type;
        this._valueFunction = config.valueFunction;
        this._violationTimeLimit = config.violationTimeLimit;
        this._violationTimeLimitSeconds = config.violationTimeLimitSeconds;
        this._critical.internalValue = config.critical;
        this._nrql.internalValue = config.nrql;
        this._term = config.term;
        this._warning.internalValue = config.warning;
    }
    get accountId() {
        return this.getNumberAttribute('account_id');
    }
    set accountId(value) {
        this._accountId = value;
    }
    resetAccountId() {
        this._accountId = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get accountIdInput() {
        return this._accountId;
    }
    get aggregationDelay() {
        return this.getStringAttribute('aggregation_delay');
    }
    set aggregationDelay(value) {
        this._aggregationDelay = value;
    }
    resetAggregationDelay() {
        this._aggregationDelay = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aggregationDelayInput() {
        return this._aggregationDelay;
    }
    get aggregationMethod() {
        return this.getStringAttribute('aggregation_method');
    }
    set aggregationMethod(value) {
        this._aggregationMethod = value;
    }
    resetAggregationMethod() {
        this._aggregationMethod = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aggregationMethodInput() {
        return this._aggregationMethod;
    }
    get aggregationTimer() {
        return this.getStringAttribute('aggregation_timer');
    }
    set aggregationTimer(value) {
        this._aggregationTimer = value;
    }
    resetAggregationTimer() {
        this._aggregationTimer = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aggregationTimerInput() {
        return this._aggregationTimer;
    }
    get aggregationWindow() {
        return this.getNumberAttribute('aggregation_window');
    }
    set aggregationWindow(value) {
        this._aggregationWindow = value;
    }
    resetAggregationWindow() {
        this._aggregationWindow = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get aggregationWindowInput() {
        return this._aggregationWindow;
    }
    get baselineDirection() {
        return this.getStringAttribute('baseline_direction');
    }
    set baselineDirection(value) {
        this._baselineDirection = value;
    }
    resetBaselineDirection() {
        this._baselineDirection = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get baselineDirectionInput() {
        return this._baselineDirection;
    }
    get closeViolationsOnExpiration() {
        return this.getBooleanAttribute('close_violations_on_expiration');
    }
    set closeViolationsOnExpiration(value) {
        this._closeViolationsOnExpiration = value;
    }
    resetCloseViolationsOnExpiration() {
        this._closeViolationsOnExpiration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get closeViolationsOnExpirationInput() {
        return this._closeViolationsOnExpiration;
    }
    get description() {
        return this.getStringAttribute('description');
    }
    set description(value) {
        this._description = value;
    }
    resetDescription() {
        this._description = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get descriptionInput() {
        return this._description;
    }
    get enabled() {
        return this.getBooleanAttribute('enabled');
    }
    set enabled(value) {
        this._enabled = value;
    }
    resetEnabled() {
        this._enabled = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get enabledInput() {
        return this._enabled;
    }
    get expectedGroups() {
        return this.getNumberAttribute('expected_groups');
    }
    set expectedGroups(value) {
        this._expectedGroups = value;
    }
    resetExpectedGroups() {
        this._expectedGroups = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expectedGroupsInput() {
        return this._expectedGroups;
    }
    get expirationDuration() {
        return this.getNumberAttribute('expiration_duration');
    }
    set expirationDuration(value) {
        this._expirationDuration = value;
    }
    resetExpirationDuration() {
        this._expirationDuration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get expirationDurationInput() {
        return this._expirationDuration;
    }
    get fillOption() {
        return this.getStringAttribute('fill_option');
    }
    set fillOption(value) {
        this._fillOption = value;
    }
    resetFillOption() {
        this._fillOption = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fillOptionInput() {
        return this._fillOption;
    }
    get fillValue() {
        return this.getNumberAttribute('fill_value');
    }
    set fillValue(value) {
        this._fillValue = value;
    }
    resetFillValue() {
        this._fillValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get fillValueInput() {
        return this._fillValue;
    }
    // id - computed: true, optional: true, required: false
    get id() {
        return this.getStringAttribute('id');
    }
    get ignoreOverlap() {
        return this.getBooleanAttribute('ignore_overlap');
    }
    set ignoreOverlap(value) {
        this._ignoreOverlap = value;
    }
    resetIgnoreOverlap() {
        this._ignoreOverlap = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get ignoreOverlapInput() {
        return this._ignoreOverlap;
    }
    get name() {
        return this.getStringAttribute('name');
    }
    set name(value) {
        this._name = value;
    }
    // Temporarily expose input value. Use with caution.
    get nameInput() {
        return this._name;
    }
    get openViolationOnExpiration() {
        return this.getBooleanAttribute('open_violation_on_expiration');
    }
    set openViolationOnExpiration(value) {
        this._openViolationOnExpiration = value;
    }
    resetOpenViolationOnExpiration() {
        this._openViolationOnExpiration = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get openViolationOnExpirationInput() {
        return this._openViolationOnExpiration;
    }
    get openViolationOnGroupOverlap() {
        return this.getBooleanAttribute('open_violation_on_group_overlap');
    }
    set openViolationOnGroupOverlap(value) {
        this._openViolationOnGroupOverlap = value;
    }
    resetOpenViolationOnGroupOverlap() {
        this._openViolationOnGroupOverlap = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get openViolationOnGroupOverlapInput() {
        return this._openViolationOnGroupOverlap;
    }
    get policyId() {
        return this.getNumberAttribute('policy_id');
    }
    set policyId(value) {
        this._policyId = value;
    }
    // Temporarily expose input value. Use with caution.
    get policyIdInput() {
        return this._policyId;
    }
    get runbookUrl() {
        return this.getStringAttribute('runbook_url');
    }
    set runbookUrl(value) {
        this._runbookUrl = value;
    }
    resetRunbookUrl() {
        this._runbookUrl = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get runbookUrlInput() {
        return this._runbookUrl;
    }
    get slideBy() {
        return this.getNumberAttribute('slide_by');
    }
    set slideBy(value) {
        this._slideBy = value;
    }
    resetSlideBy() {
        this._slideBy = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get slideByInput() {
        return this._slideBy;
    }
    get type() {
        return this.getStringAttribute('type');
    }
    set type(value) {
        this._type = value;
    }
    resetType() {
        this._type = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get typeInput() {
        return this._type;
    }
    get valueFunction() {
        return this.getStringAttribute('value_function');
    }
    set valueFunction(value) {
        this._valueFunction = value;
    }
    resetValueFunction() {
        this._valueFunction = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get valueFunctionInput() {
        return this._valueFunction;
    }
    get violationTimeLimit() {
        return this.getStringAttribute('violation_time_limit');
    }
    set violationTimeLimit(value) {
        this._violationTimeLimit = value;
    }
    resetViolationTimeLimit() {
        this._violationTimeLimit = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get violationTimeLimitInput() {
        return this._violationTimeLimit;
    }
    get violationTimeLimitSeconds() {
        return this.getNumberAttribute('violation_time_limit_seconds');
    }
    set violationTimeLimitSeconds(value) {
        this._violationTimeLimitSeconds = value;
    }
    resetViolationTimeLimitSeconds() {
        this._violationTimeLimitSeconds = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get violationTimeLimitSecondsInput() {
        return this._violationTimeLimitSeconds;
    }
    get critical() {
        return this._critical;
    }
    putCritical(value) {
        this._critical.internalValue = value;
    }
    resetCritical() {
        this._critical.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get criticalInput() {
        return this._critical.internalValue;
    }
    get nrql() {
        return this._nrql;
    }
    putNrql(value) {
        this._nrql.internalValue = value;
    }
    // Temporarily expose input value. Use with caution.
    get nrqlInput() {
        return this._nrql.internalValue;
    }
    get term() {
        // Getting the computed value is not yet implemented
        return cdktf.Token.asAny(cdktf.Fn.tolist(this.interpolationForAttribute('term')));
    }
    set term(value) {
        this._term = value;
    }
    resetTerm() {
        this._term = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get termInput() {
        return this._term;
    }
    get warning() {
        return this._warning;
    }
    putWarning(value) {
        this._warning.internalValue = value;
    }
    resetWarning() {
        this._warning.internalValue = undefined;
    }
    // Temporarily expose input value. Use with caution.
    get warningInput() {
        return this._warning.internalValue;
    }
    // =========
    // SYNTHESIS
    // =========
    synthesizeAttributes() {
        return {
            account_id: cdktf.numberToTerraform(this._accountId),
            aggregation_delay: cdktf.stringToTerraform(this._aggregationDelay),
            aggregation_method: cdktf.stringToTerraform(this._aggregationMethod),
            aggregation_timer: cdktf.stringToTerraform(this._aggregationTimer),
            aggregation_window: cdktf.numberToTerraform(this._aggregationWindow),
            baseline_direction: cdktf.stringToTerraform(this._baselineDirection),
            close_violations_on_expiration: cdktf.booleanToTerraform(this._closeViolationsOnExpiration),
            description: cdktf.stringToTerraform(this._description),
            enabled: cdktf.booleanToTerraform(this._enabled),
            expected_groups: cdktf.numberToTerraform(this._expectedGroups),
            expiration_duration: cdktf.numberToTerraform(this._expirationDuration),
            fill_option: cdktf.stringToTerraform(this._fillOption),
            fill_value: cdktf.numberToTerraform(this._fillValue),
            ignore_overlap: cdktf.booleanToTerraform(this._ignoreOverlap),
            name: cdktf.stringToTerraform(this._name),
            open_violation_on_expiration: cdktf.booleanToTerraform(this._openViolationOnExpiration),
            open_violation_on_group_overlap: cdktf.booleanToTerraform(this._openViolationOnGroupOverlap),
            policy_id: cdktf.numberToTerraform(this._policyId),
            runbook_url: cdktf.stringToTerraform(this._runbookUrl),
            slide_by: cdktf.numberToTerraform(this._slideBy),
            type: cdktf.stringToTerraform(this._type),
            value_function: cdktf.stringToTerraform(this._valueFunction),
            violation_time_limit: cdktf.stringToTerraform(this._violationTimeLimit),
            violation_time_limit_seconds: cdktf.numberToTerraform(this._violationTimeLimitSeconds),
            critical: nrqlAlertConditionCriticalToTerraform(this._critical.internalValue),
            nrql: nrqlAlertConditionNrqlToTerraform(this._nrql.internalValue),
            term: cdktf.listMapper(nrqlAlertConditionTermToTerraform)(this._term),
            warning: nrqlAlertConditionWarningToTerraform(this._warning.internalValue),
        };
    }
}
exports.NrqlAlertCondition = NrqlAlertCondition;
_d = JSII_RTTI_SYMBOL_1;
NrqlAlertCondition[_d] = { fqn: "@cdktf/provider-newrelic.NrqlAlertCondition", version: "0.3.375" };
// =================
// STATIC PROPERTIES
// =================
NrqlAlertCondition.tfResourceType = "newrelic_nrql_alert_condition";
//# sourceMappingURL=data:application/json;base64,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