import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface PluginsAlertConditionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Whether or not this condition is enabled.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#enabled PluginsAlertCondition#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The plugin component IDs to target.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#entities PluginsAlertCondition#entities}
    */
    readonly entities: number[];
    /**
    * The plugin metric to evaluate.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#metric PluginsAlertCondition#metric}
    */
    readonly metric: string;
    /**
    * The metric description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#metric_description PluginsAlertCondition#metric_description}
    */
    readonly metricDescription: string;
    /**
    * The title of the condition. Must be between 1 and 64 characters, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#name PluginsAlertCondition#name}
    */
    readonly name: string;
    /**
    * The GUID of the plugin which produces the metric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#plugin_guid PluginsAlertCondition#plugin_guid}
    */
    readonly pluginGuid: string;
    /**
    * The ID of the installed plugin instance which produces the metric.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#plugin_id PluginsAlertCondition#plugin_id}
    */
    readonly pluginId: string;
    /**
    * The ID of the policy where this condition should be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#policy_id PluginsAlertCondition#policy_id}
    */
    readonly policyId: number;
    /**
    * Runbook URL to display in notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#runbook_url PluginsAlertCondition#runbook_url}
    */
    readonly runbookUrl?: string;
    /**
    * The value function to apply to the metric data.  One of `min`, `max`, `average`, `sample_size`, `total`, or `percent`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#value_function PluginsAlertCondition#value_function}
    */
    readonly valueFunction: string;
    /**
    * term block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#term PluginsAlertCondition#term}
    */
    readonly term: PluginsAlertConditionTerm[] | cdktf.IResolvable;
}
export interface PluginsAlertConditionTerm {
    /**
    * In minutes, must be in the range of 5 to 120, inclusive.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#duration PluginsAlertCondition#duration}
    */
    readonly duration: number;
    /**
    * One of `above`, `below`, or `equal`. Defaults to equal.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#operator PluginsAlertCondition#operator}
    */
    readonly operator?: string;
    /**
    * One of `critical` or `warning`. Defaults to critical.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#priority PluginsAlertCondition#priority}
    */
    readonly priority?: string;
    /**
    * Must be 0 or greater.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#threshold PluginsAlertCondition#threshold}
    */
    readonly threshold: number;
    /**
    * One of `all` or `any`.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition#time_function PluginsAlertCondition#time_function}
    */
    readonly timeFunction: string;
}
export declare function pluginsAlertConditionTermToTerraform(struct?: PluginsAlertConditionTerm | cdktf.IResolvable): any;
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition newrelic_plugins_alert_condition}
*/
export declare class PluginsAlertCondition extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/plugins_alert_condition newrelic_plugins_alert_condition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options PluginsAlertConditionConfig
    */
    constructor(scope: Construct, id: string, config: PluginsAlertConditionConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _entities?;
    get entities(): number[];
    set entities(value: number[]);
    get entitiesInput(): number[] | undefined;
    get id(): string;
    private _metric?;
    get metric(): string;
    set metric(value: string);
    get metricInput(): string | undefined;
    private _metricDescription?;
    get metricDescription(): string;
    set metricDescription(value: string);
    get metricDescriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _pluginGuid?;
    get pluginGuid(): string;
    set pluginGuid(value: string);
    get pluginGuidInput(): string | undefined;
    private _pluginId?;
    get pluginId(): string;
    set pluginId(value: string);
    get pluginIdInput(): string | undefined;
    private _policyId?;
    get policyId(): number;
    set policyId(value: number);
    get policyIdInput(): number | undefined;
    private _runbookUrl?;
    get runbookUrl(): string;
    set runbookUrl(value: string);
    resetRunbookUrl(): void;
    get runbookUrlInput(): string | undefined;
    private _valueFunction?;
    get valueFunction(): string;
    set valueFunction(value: string);
    get valueFunctionInput(): string | undefined;
    private _term?;
    get term(): PluginsAlertConditionTerm[] | cdktf.IResolvable;
    set term(value: PluginsAlertConditionTerm[] | cdktf.IResolvable);
    get termInput(): cdktf.IResolvable | PluginsAlertConditionTerm[] | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
