import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface ServiceLevelConfig extends cdktf.TerraformMetaArguments {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#description ServiceLevel#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#guid ServiceLevel#guid}
    */
    readonly guid: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#name ServiceLevel#name}
    */
    readonly name: string;
    /**
    * events block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#events ServiceLevel#events}
    */
    readonly events: ServiceLevelEvents;
    /**
    * objective block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#objective ServiceLevel#objective}
    */
    readonly objective: ServiceLevelObjective;
}
export interface ServiceLevelEventsBadEvents {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#from ServiceLevel#from}
    */
    readonly from: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#where ServiceLevel#where}
    */
    readonly where?: string;
}
export declare function serviceLevelEventsBadEventsToTerraform(struct?: ServiceLevelEventsBadEventsOutputReference | ServiceLevelEventsBadEvents): any;
export declare class ServiceLevelEventsBadEventsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ServiceLevelEventsBadEvents | undefined;
    set internalValue(value: ServiceLevelEventsBadEvents | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    get fromInput(): string | undefined;
    private _where?;
    get where(): string;
    set where(value: string);
    resetWhere(): void;
    get whereInput(): string | undefined;
}
export interface ServiceLevelEventsGoodEvents {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#from ServiceLevel#from}
    */
    readonly from: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#where ServiceLevel#where}
    */
    readonly where?: string;
}
export declare function serviceLevelEventsGoodEventsToTerraform(struct?: ServiceLevelEventsGoodEventsOutputReference | ServiceLevelEventsGoodEvents): any;
export declare class ServiceLevelEventsGoodEventsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ServiceLevelEventsGoodEvents | undefined;
    set internalValue(value: ServiceLevelEventsGoodEvents | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    get fromInput(): string | undefined;
    private _where?;
    get where(): string;
    set where(value: string);
    resetWhere(): void;
    get whereInput(): string | undefined;
}
export interface ServiceLevelEventsValidEvents {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#from ServiceLevel#from}
    */
    readonly from: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#where ServiceLevel#where}
    */
    readonly where?: string;
}
export declare function serviceLevelEventsValidEventsToTerraform(struct?: ServiceLevelEventsValidEventsOutputReference | ServiceLevelEventsValidEvents): any;
export declare class ServiceLevelEventsValidEventsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ServiceLevelEventsValidEvents | undefined;
    set internalValue(value: ServiceLevelEventsValidEvents | undefined);
    private _from?;
    get from(): string;
    set from(value: string);
    get fromInput(): string | undefined;
    private _where?;
    get where(): string;
    set where(value: string);
    resetWhere(): void;
    get whereInput(): string | undefined;
}
export interface ServiceLevelEvents {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#account_id ServiceLevel#account_id}
    */
    readonly accountId: number;
    /**
    * bad_events block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#bad_events ServiceLevel#bad_events}
    */
    readonly badEvents?: ServiceLevelEventsBadEvents;
    /**
    * good_events block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#good_events ServiceLevel#good_events}
    */
    readonly goodEvents?: ServiceLevelEventsGoodEvents;
    /**
    * valid_events block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#valid_events ServiceLevel#valid_events}
    */
    readonly validEvents: ServiceLevelEventsValidEvents;
}
export declare function serviceLevelEventsToTerraform(struct?: ServiceLevelEventsOutputReference | ServiceLevelEvents): any;
export declare class ServiceLevelEventsOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ServiceLevelEvents | undefined;
    set internalValue(value: ServiceLevelEvents | undefined);
    private _accountId?;
    get accountId(): number;
    set accountId(value: number);
    get accountIdInput(): number | undefined;
    private _badEvents;
    get badEvents(): ServiceLevelEventsBadEventsOutputReference;
    putBadEvents(value: ServiceLevelEventsBadEvents): void;
    resetBadEvents(): void;
    get badEventsInput(): ServiceLevelEventsBadEvents | undefined;
    private _goodEvents;
    get goodEvents(): ServiceLevelEventsGoodEventsOutputReference;
    putGoodEvents(value: ServiceLevelEventsGoodEvents): void;
    resetGoodEvents(): void;
    get goodEventsInput(): ServiceLevelEventsGoodEvents | undefined;
    private _validEvents;
    get validEvents(): ServiceLevelEventsValidEventsOutputReference;
    putValidEvents(value: ServiceLevelEventsValidEvents): void;
    get validEventsInput(): ServiceLevelEventsValidEvents | undefined;
}
export interface ServiceLevelObjectiveTimeWindowRolling {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#count ServiceLevel#count}
    */
    readonly count: number;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#unit ServiceLevel#unit}
    */
    readonly unit: string;
}
export declare function serviceLevelObjectiveTimeWindowRollingToTerraform(struct?: ServiceLevelObjectiveTimeWindowRollingOutputReference | ServiceLevelObjectiveTimeWindowRolling): any;
export declare class ServiceLevelObjectiveTimeWindowRollingOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ServiceLevelObjectiveTimeWindowRolling | undefined;
    set internalValue(value: ServiceLevelObjectiveTimeWindowRolling | undefined);
    private _count?;
    get count(): number;
    set count(value: number);
    get countInput(): number | undefined;
    private _unit?;
    get unit(): string;
    set unit(value: string);
    get unitInput(): string | undefined;
}
export interface ServiceLevelObjectiveTimeWindow {
    /**
    * rolling block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#rolling ServiceLevel#rolling}
    */
    readonly rolling: ServiceLevelObjectiveTimeWindowRolling;
}
export declare function serviceLevelObjectiveTimeWindowToTerraform(struct?: ServiceLevelObjectiveTimeWindowOutputReference | ServiceLevelObjectiveTimeWindow): any;
export declare class ServiceLevelObjectiveTimeWindowOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ServiceLevelObjectiveTimeWindow | undefined;
    set internalValue(value: ServiceLevelObjectiveTimeWindow | undefined);
    private _rolling;
    get rolling(): ServiceLevelObjectiveTimeWindowRollingOutputReference;
    putRolling(value: ServiceLevelObjectiveTimeWindowRolling): void;
    get rollingInput(): ServiceLevelObjectiveTimeWindowRolling | undefined;
}
export interface ServiceLevelObjective {
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#description ServiceLevel#description}
    */
    readonly description?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#name ServiceLevel#name}
    */
    readonly name?: string;
    /**
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#target ServiceLevel#target}
    */
    readonly target: number;
    /**
    * time_window block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/service_level#time_window ServiceLevel#time_window}
    */
    readonly timeWindow: ServiceLevelObjectiveTimeWindow;
}
export declare function serviceLevelObjectiveToTerraform(struct?: ServiceLevelObjectiveOutputReference | ServiceLevelObjective | cdktf.IResolvable): any;
export declare class ServiceLevelObjectiveOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): ServiceLevelObjective | undefined;
    set internalValue(value: ServiceLevelObjective | undefined);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _name?;
    get name(): string;
    set name(value: string);
    resetName(): void;
    get nameInput(): string | undefined;
    private _target?;
    get target(): number;
    set target(value: number);
    get targetInput(): number | undefined;
    private _timeWindow;
    get timeWindow(): ServiceLevelObjectiveTimeWindowOutputReference;
    putTimeWindow(value: ServiceLevelObjectiveTimeWindow): void;
    get timeWindowInput(): ServiceLevelObjectiveTimeWindow | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/service_level newrelic_service_level}
*/
export declare class ServiceLevel extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/service_level newrelic_service_level} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options ServiceLevelConfig
    */
    constructor(scope: Construct, id: string, config: ServiceLevelConfig);
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    private _guid?;
    get guid(): string;
    set guid(value: string);
    get guidInput(): string | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    get sliGuid(): string;
    get sliId(): string;
    private _events;
    get events(): ServiceLevelEventsOutputReference;
    putEvents(value: ServiceLevelEvents): void;
    get eventsInput(): ServiceLevelEvents | undefined;
    private _objective;
    get objective(): ServiceLevelObjectiveOutputReference;
    putObjective(value: ServiceLevelObjective): void;
    get objectiveInput(): ServiceLevelObjective | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
