import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SyntheticsMultilocationAlertConditionConfig extends cdktf.TerraformMetaArguments {
    /**
    * Set whether to enable the alert condition. Defaults to true.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_multilocation_alert_condition#enabled SyntheticsMultilocationAlertCondition#enabled}
    */
    readonly enabled?: boolean | cdktf.IResolvable;
    /**
    * The GUIDs of the Synthetics monitors to alert on.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_multilocation_alert_condition#entities SyntheticsMultilocationAlertCondition#entities}
    */
    readonly entities: string[];
    /**
    * The title of this condition.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_multilocation_alert_condition#name SyntheticsMultilocationAlertCondition#name}
    */
    readonly name: string;
    /**
    * The ID of the policy where this condition will be used.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_multilocation_alert_condition#policy_id SyntheticsMultilocationAlertCondition#policy_id}
    */
    readonly policyId: number;
    /**
    * Runbook URL to display in notifications.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_multilocation_alert_condition#runbook_url SyntheticsMultilocationAlertCondition#runbook_url}
    */
    readonly runbookUrl?: string;
    /**
    * The maximum number of seconds a violation can remain open before being closed by the system.  Must be one of: 0, 3600, 7200, 14400, 28800, 43200, 86400
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_multilocation_alert_condition#violation_time_limit_seconds SyntheticsMultilocationAlertCondition#violation_time_limit_seconds}
    */
    readonly violationTimeLimitSeconds: number;
    /**
    * critical block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_multilocation_alert_condition#critical SyntheticsMultilocationAlertCondition#critical}
    */
    readonly critical: SyntheticsMultilocationAlertConditionCritical;
    /**
    * warning block
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_multilocation_alert_condition#warning SyntheticsMultilocationAlertCondition#warning}
    */
    readonly warning?: SyntheticsMultilocationAlertConditionWarning;
}
export interface SyntheticsMultilocationAlertConditionCritical {
    /**
    * The minimum number of monitor locations that must be concurrently failing before a violation is opened.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_multilocation_alert_condition#threshold SyntheticsMultilocationAlertCondition#threshold}
    */
    readonly threshold: number;
}
export declare function syntheticsMultilocationAlertConditionCriticalToTerraform(struct?: SyntheticsMultilocationAlertConditionCriticalOutputReference | SyntheticsMultilocationAlertConditionCritical): any;
export declare class SyntheticsMultilocationAlertConditionCriticalOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SyntheticsMultilocationAlertConditionCritical | undefined;
    set internalValue(value: SyntheticsMultilocationAlertConditionCritical | undefined);
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
}
export interface SyntheticsMultilocationAlertConditionWarning {
    /**
    * The minimum number of monitor locations that must be concurrently failing before a violation is opened.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_multilocation_alert_condition#threshold SyntheticsMultilocationAlertCondition#threshold}
    */
    readonly threshold: number;
}
export declare function syntheticsMultilocationAlertConditionWarningToTerraform(struct?: SyntheticsMultilocationAlertConditionWarningOutputReference | SyntheticsMultilocationAlertConditionWarning): any;
export declare class SyntheticsMultilocationAlertConditionWarningOutputReference extends cdktf.ComplexObject {
    private isEmptyObject;
    /**
    * @param terraformResource The parent resource
    * @param terraformAttribute The attribute on the parent resource this class is referencing
    * @param isSingleItem True if this is a block, false if it's a list
    */
    constructor(terraformResource: cdktf.IInterpolatingParent, terraformAttribute: string, isSingleItem: boolean);
    get internalValue(): SyntheticsMultilocationAlertConditionWarning | undefined;
    set internalValue(value: SyntheticsMultilocationAlertConditionWarning | undefined);
    private _threshold?;
    get threshold(): number;
    set threshold(value: number);
    get thresholdInput(): number | undefined;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_multilocation_alert_condition newrelic_synthetics_multilocation_alert_condition}
*/
export declare class SyntheticsMultilocationAlertCondition extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_multilocation_alert_condition newrelic_synthetics_multilocation_alert_condition} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SyntheticsMultilocationAlertConditionConfig
    */
    constructor(scope: Construct, id: string, config: SyntheticsMultilocationAlertConditionConfig);
    private _enabled?;
    get enabled(): boolean | cdktf.IResolvable;
    set enabled(value: boolean | cdktf.IResolvable);
    resetEnabled(): void;
    get enabledInput(): boolean | cdktf.IResolvable | undefined;
    private _entities?;
    get entities(): string[];
    set entities(value: string[]);
    get entitiesInput(): string[] | undefined;
    get id(): string;
    private _name?;
    get name(): string;
    set name(value: string);
    get nameInput(): string | undefined;
    private _policyId?;
    get policyId(): number;
    set policyId(value: number);
    get policyIdInput(): number | undefined;
    private _runbookUrl?;
    get runbookUrl(): string;
    set runbookUrl(value: string);
    resetRunbookUrl(): void;
    get runbookUrlInput(): string | undefined;
    private _violationTimeLimitSeconds?;
    get violationTimeLimitSeconds(): number;
    set violationTimeLimitSeconds(value: number);
    get violationTimeLimitSecondsInput(): number | undefined;
    private _critical;
    get critical(): SyntheticsMultilocationAlertConditionCriticalOutputReference;
    putCritical(value: SyntheticsMultilocationAlertConditionCritical): void;
    get criticalInput(): SyntheticsMultilocationAlertConditionCritical | undefined;
    private _warning;
    get warning(): SyntheticsMultilocationAlertConditionWarningOutputReference;
    putWarning(value: SyntheticsMultilocationAlertConditionWarning): void;
    resetWarning(): void;
    get warningInput(): SyntheticsMultilocationAlertConditionWarning | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
