import { Construct } from 'constructs';
import * as cdktf from 'cdktf';
export interface SyntheticsSecureCredentialConfig extends cdktf.TerraformMetaArguments {
    /**
    * The time the secure credential was created.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_secure_credential#created_at SyntheticsSecureCredential#created_at}
    */
    readonly createdAt?: string;
    /**
    * The secure credential's description.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_secure_credential#description SyntheticsSecureCredential#description}
    */
    readonly description?: string;
    /**
    * The secure credential's key name. Regardless of the case used in the configuration, the provider will provide an upcased key to the underlying API.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_secure_credential#key SyntheticsSecureCredential#key}
    */
    readonly key: string;
    /**
    * The time the secure credential was last updated.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_secure_credential#last_updated SyntheticsSecureCredential#last_updated}
    */
    readonly lastUpdated?: string;
    /**
    * The secure credential's value.
    *
    * Docs at Terraform Registry: {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_secure_credential#value SyntheticsSecureCredential#value}
    */
    readonly value: string;
}
/**
* Represents a {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_secure_credential newrelic_synthetics_secure_credential}
*/
export declare class SyntheticsSecureCredential extends cdktf.TerraformResource {
    static readonly tfResourceType: string;
    /**
    * Create a new {@link https://www.terraform.io/docs/providers/newrelic/r/synthetics_secure_credential newrelic_synthetics_secure_credential} Resource
    *
    * @param scope The scope in which to define this construct
    * @param id The scoped construct ID. Must be unique amongst siblings in the same scope
    * @param options SyntheticsSecureCredentialConfig
    */
    constructor(scope: Construct, id: string, config: SyntheticsSecureCredentialConfig);
    private _createdAt?;
    get createdAt(): string;
    set createdAt(value: string);
    resetCreatedAt(): void;
    get createdAtInput(): string | undefined;
    private _description?;
    get description(): string;
    set description(value: string);
    resetDescription(): void;
    get descriptionInput(): string | undefined;
    get id(): string;
    private _key?;
    get key(): string;
    set key(value: string);
    get keyInput(): string | undefined;
    private _lastUpdated?;
    get lastUpdated(): string;
    set lastUpdated(value: string);
    resetLastUpdated(): void;
    get lastUpdatedInput(): string | undefined;
    private _value?;
    get value(): string;
    set value(value: string);
    get valueInput(): string | undefined;
    protected synthesizeAttributes(): {
        [name: string]: any;
    };
}
