# coding=utf-8
# *** WARNING: this file was generated by pulumi-language-python. ***
# *** Do not edit by hand unless you're certain you know what you are doing! ***

import builtins as _builtins
import warnings
import sys
import pulumi
import pulumi.runtime
from typing import Any, Mapping, Optional, Sequence, Union, overload
if sys.version_info >= (3, 11):
    from typing import NotRequired, TypedDict, TypeAlias
else:
    from typing_extensions import NotRequired, TypedDict, TypeAlias
from . import _utilities

__all__ = ['RandomBytesArgs', 'RandomBytes']

@pulumi.input_type
class RandomBytesArgs:
    def __init__(__self__, *,
                 length: pulumi.Input[_builtins.int],
                 keepers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None):
        """
        The set of arguments for constructing a RandomBytes resource.
        :param pulumi.Input[_builtins.int] length: The number of bytes requested. The minimum value for length is 1.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] keepers: Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        """
        pulumi.set(__self__, "length", length)
        if keepers is not None:
            pulumi.set(__self__, "keepers", keepers)

    @_builtins.property
    @pulumi.getter
    def length(self) -> pulumi.Input[_builtins.int]:
        """
        The number of bytes requested. The minimum value for length is 1.
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: pulumi.Input[_builtins.int]):
        pulumi.set(self, "length", value)

    @_builtins.property
    @pulumi.getter
    def keepers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        """
        return pulumi.get(self, "keepers")

    @keepers.setter
    def keepers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "keepers", value)


@pulumi.input_type
class _RandomBytesState:
    def __init__(__self__, *,
                 base64: Optional[pulumi.Input[_builtins.str]] = None,
                 hex: Optional[pulumi.Input[_builtins.str]] = None,
                 keepers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 length: Optional[pulumi.Input[_builtins.int]] = None):
        """
        Input properties used for looking up and filtering RandomBytes resources.
        :param pulumi.Input[_builtins.str] base64: The generated bytes presented in base64 string format.
        :param pulumi.Input[_builtins.str] hex: The generated bytes presented in lowercase hexadecimal string format. The length of the encoded string is exactly twice the `length` parameter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] keepers: Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        :param pulumi.Input[_builtins.int] length: The number of bytes requested. The minimum value for length is 1.
        """
        if base64 is not None:
            pulumi.set(__self__, "base64", base64)
        if hex is not None:
            pulumi.set(__self__, "hex", hex)
        if keepers is not None:
            pulumi.set(__self__, "keepers", keepers)
        if length is not None:
            pulumi.set(__self__, "length", length)

    @_builtins.property
    @pulumi.getter
    def base64(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generated bytes presented in base64 string format.
        """
        return pulumi.get(self, "base64")

    @base64.setter
    def base64(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "base64", value)

    @_builtins.property
    @pulumi.getter
    def hex(self) -> Optional[pulumi.Input[_builtins.str]]:
        """
        The generated bytes presented in lowercase hexadecimal string format. The length of the encoded string is exactly twice the `length` parameter.
        """
        return pulumi.get(self, "hex")

    @hex.setter
    def hex(self, value: Optional[pulumi.Input[_builtins.str]]):
        pulumi.set(self, "hex", value)

    @_builtins.property
    @pulumi.getter
    def keepers(self) -> Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]:
        """
        Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        """
        return pulumi.get(self, "keepers")

    @keepers.setter
    def keepers(self, value: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]]):
        pulumi.set(self, "keepers", value)

    @_builtins.property
    @pulumi.getter
    def length(self) -> Optional[pulumi.Input[_builtins.int]]:
        """
        The number of bytes requested. The minimum value for length is 1.
        """
        return pulumi.get(self, "length")

    @length.setter
    def length(self, value: Optional[pulumi.Input[_builtins.int]]):
        pulumi.set(self, "length", value)


@pulumi.type_token("random:index/randomBytes:RandomBytes")
class RandomBytes(pulumi.CustomResource):
    @overload
    def __init__(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 keepers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 length: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        """
        The resource `RandomBytes` generates random bytes that are intended to be used as a secret, or key. Use this in preference to `RandomId` when the output is considered sensitive, and should not be displayed in the CLI.

        This resource *does* use a cryptographic random number generator.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azurerm as azurerm
        import pulumi_random as random

        jwt_secret = random.RandomBytes("jwt_secret", length=64)
        jwt_secret_key_vault_secret = azurerm.index.KeyVaultSecret("jwt_secret",
            key_vault_id=some-azure-key-vault-id,
            name=JwtSecret,
            value=jwt_secret.base64)
        ```

        ## Import

        Random bytes can be imported by specifying the value as base64 string.

        ```sh
        $ pulumi import random:index/randomBytes:RandomBytes basic "8/fu3q+2DcgSJ19i0jZ5Cw=="
        ```

        :param str resource_name: The name of the resource.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] keepers: Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        :param pulumi.Input[_builtins.int] length: The number of bytes requested. The minimum value for length is 1.
        """
        ...
    @overload
    def __init__(__self__,
                 resource_name: str,
                 args: RandomBytesArgs,
                 opts: Optional[pulumi.ResourceOptions] = None):
        """
        The resource `RandomBytes` generates random bytes that are intended to be used as a secret, or key. Use this in preference to `RandomId` when the output is considered sensitive, and should not be displayed in the CLI.

        This resource *does* use a cryptographic random number generator.

        ## Example Usage

        ```python
        import pulumi
        import pulumi_azurerm as azurerm
        import pulumi_random as random

        jwt_secret = random.RandomBytes("jwt_secret", length=64)
        jwt_secret_key_vault_secret = azurerm.index.KeyVaultSecret("jwt_secret",
            key_vault_id=some-azure-key-vault-id,
            name=JwtSecret,
            value=jwt_secret.base64)
        ```

        ## Import

        Random bytes can be imported by specifying the value as base64 string.

        ```sh
        $ pulumi import random:index/randomBytes:RandomBytes basic "8/fu3q+2DcgSJ19i0jZ5Cw=="
        ```

        :param str resource_name: The name of the resource.
        :param RandomBytesArgs args: The arguments to use to populate this resource's properties.
        :param pulumi.ResourceOptions opts: Options for the resource.
        """
        ...
    def __init__(__self__, resource_name: str, *args, **kwargs):
        resource_args, opts = _utilities.get_resource_args_opts(RandomBytesArgs, pulumi.ResourceOptions, *args, **kwargs)
        if resource_args is not None:
            __self__._internal_init(resource_name, opts, **resource_args.__dict__)
        else:
            __self__._internal_init(resource_name, *args, **kwargs)

    def _internal_init(__self__,
                 resource_name: str,
                 opts: Optional[pulumi.ResourceOptions] = None,
                 keepers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
                 length: Optional[pulumi.Input[_builtins.int]] = None,
                 __props__=None):
        opts = pulumi.ResourceOptions.merge(_utilities.get_resource_opts_defaults(), opts)
        if not isinstance(opts, pulumi.ResourceOptions):
            raise TypeError('Expected resource options to be a ResourceOptions instance')
        if opts.id is None:
            if __props__ is not None:
                raise TypeError('__props__ is only valid when passed in combination with a valid opts.id to get an existing resource')
            __props__ = RandomBytesArgs.__new__(RandomBytesArgs)

            __props__.__dict__["keepers"] = keepers
            if length is None and not opts.urn:
                raise TypeError("Missing required property 'length'")
            __props__.__dict__["length"] = length
            __props__.__dict__["base64"] = None
            __props__.__dict__["hex"] = None
        secret_opts = pulumi.ResourceOptions(additional_secret_outputs=["base64", "hex"])
        opts = pulumi.ResourceOptions.merge(opts, secret_opts)
        super(RandomBytes, __self__).__init__(
            'random:index/randomBytes:RandomBytes',
            resource_name,
            __props__,
            opts)

    @staticmethod
    def get(resource_name: str,
            id: pulumi.Input[str],
            opts: Optional[pulumi.ResourceOptions] = None,
            base64: Optional[pulumi.Input[_builtins.str]] = None,
            hex: Optional[pulumi.Input[_builtins.str]] = None,
            keepers: Optional[pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]]] = None,
            length: Optional[pulumi.Input[_builtins.int]] = None) -> 'RandomBytes':
        """
        Get an existing RandomBytes resource's state with the given name, id, and optional extra
        properties used to qualify the lookup.

        :param str resource_name: The unique name of the resulting resource.
        :param pulumi.Input[str] id: The unique provider ID of the resource to lookup.
        :param pulumi.ResourceOptions opts: Options for the resource.
        :param pulumi.Input[_builtins.str] base64: The generated bytes presented in base64 string format.
        :param pulumi.Input[_builtins.str] hex: The generated bytes presented in lowercase hexadecimal string format. The length of the encoded string is exactly twice the `length` parameter.
        :param pulumi.Input[Mapping[str, pulumi.Input[_builtins.str]]] keepers: Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        :param pulumi.Input[_builtins.int] length: The number of bytes requested. The minimum value for length is 1.
        """
        opts = pulumi.ResourceOptions.merge(opts, pulumi.ResourceOptions(id=id))

        __props__ = _RandomBytesState.__new__(_RandomBytesState)

        __props__.__dict__["base64"] = base64
        __props__.__dict__["hex"] = hex
        __props__.__dict__["keepers"] = keepers
        __props__.__dict__["length"] = length
        return RandomBytes(resource_name, opts=opts, __props__=__props__)

    @_builtins.property
    @pulumi.getter
    def base64(self) -> pulumi.Output[_builtins.str]:
        """
        The generated bytes presented in base64 string format.
        """
        return pulumi.get(self, "base64")

    @_builtins.property
    @pulumi.getter
    def hex(self) -> pulumi.Output[_builtins.str]:
        """
        The generated bytes presented in lowercase hexadecimal string format. The length of the encoded string is exactly twice the `length` parameter.
        """
        return pulumi.get(self, "hex")

    @_builtins.property
    @pulumi.getter
    def keepers(self) -> pulumi.Output[Optional[Mapping[str, _builtins.str]]]:
        """
        Arbitrary map of values that, when changed, will trigger recreation of resource. See the main provider documentation for more information.
        """
        return pulumi.get(self, "keepers")

    @_builtins.property
    @pulumi.getter
    def length(self) -> pulumi.Output[_builtins.int]:
        """
        The number of bytes requested. The minimum value for length is 1.
        """
        return pulumi.get(self, "length")

