# ShowMeReqs

A lightweight command-line tool that generates requirements.txt by analyzing import statements in your Python projects.

## Features

-   Intelligent third-party import detection
-   Automatic requirements.txt generation with versions in current env
-   Display missing packages in current environment
-   Display import names that differ from PyPI package names for manual review
-   Generate a clean requirements.txt file or a detail one

## Installation

Install via pip:

```bash
pip install showmereqs
```

## Usage

Generate requirements.txt for current directory:

```bash
showmereqs .
```

Or specify a project path:

```bash
showmereqs path/to/your/project
```

## Examples

-   #### Detail Output

```
# generated by showmereqs
# python version: 3.11.7
# pypi server: https://pypi.org/pypi

# package with version in environment
# [package]         [import name]
Requests==2.32.3  # requests
click==8.1.7
pytest==8.3.4

# package without version
# [package]         [import name]
Pillow            # PIL
Theano            # theano
aiohttp
numpy
pandas
scipy
tensorflow
torch
typing-extensions # typing_extensions

# can not get package name and version
# [package]         [import name]
# None              # guidoooo
```

-   #### Normal Output

```
# generated by showmereqs
# python version: 3.11.7
# pypi server: https://pypi.org/pypi

Requests==2.32.3
click==8.1.7
pytest==8.3.4

Pillow
Theano
aiohttp
numpy
pandas
scipy
tensorflow
torch
typing-extensions

# can not get package name and version
# [package]         [import name]
# None              # guidoooo

```

## Command Line Options

```bash
$ showmereqs --help
Usage: showmereqs [OPTIONS] [PATH]

Analyze Python project dependencies and generate requirements.txt

Options:
  -f, --force        Force overwrite output file if it exists
  -nd, --no-detail   Generate cleaner requirements.txt with less comments
  -o, --outdir TEXT  Path to output directory, default is the path you give
  -p, --pypi-server TEXT  the custom PyPI server URL

  -h, --help        Show this message and exit
```

### Examples:

```bash
# Generate requirements.txt in current directory
showmereqs .
# Generate in specific output directory
showmereqs . -o /path/to/output
# Force overwrite existing requirements.txt
showmereqs . -f
# Generate clean requirements.txt without comments
showmereqs . --nd
# Specify custom PyPI mirror server (useful for slow or blocked networks)
showmereqs . -p https://mirrors.aliyun.com/pypi/simple/
```

## Why ShowMeReqs?

Traditional approaches like `pip freeze` capture all environment dependencies, while modern tools like Poetry can be overly complex for simple needs. ShowMeReqs bridges this gap by offering a streamlined solution that identifies only the dependencies your project actually uses.

Additionally, once ShowMeReqs generates the initial requirements.txt, you can easily migrate to modern package management tools for more comprehensive dependency management.

## Acknowledgments & License

This project is licensed under the Apache License, Version 2.0 - see the [LICENSE](LICENSE) file for details.

ShowMeReqs uses package mapping and stdlib data from [pipreqs](https://github.com/bndr/pipreqs/) under the Apache 2.0 license. As pipreqs development has slowed, ShowMeReqs aims to provide an actively maintained alternative for the Python community.

## Roadmap

Future releases will include:

-   Additional CLI options for customization
-   Support for excluding specific packages or directories
-   Analyze dependencies between missing packages to determine their versions
-   Version range specifications
-   Integration with other package management tools

Feel free to open issues for feature requests or bug reports.
