"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = exports.DomainProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const directmail_generated_1 = require("./directmail.generated");
Object.defineProperty(exports, "DomainProperty", { enumerable: true, get: function () { return directmail_generated_1.RosDomain; } });
/**
 * This class encapsulates and extends the ROS resource type `DATASOURCE::DirectMail::Domain`, which is used to query the information about a domain name.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDomain`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/datasource-directmail-domain
 */
class Domain extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDomain = new directmail_generated_1.RosDomain(this, id, {
            domainId: props.domainId,
            refreshOptions: props.refreshOptions === undefined || props.refreshOptions === null ? 'Never' : props.refreshOptions,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDomain;
        this.attrCnameAuthStatus = rosDomain.attrCnameAuthStatus;
        this.attrCnameConfirmStatus = rosDomain.attrCnameConfirmStatus;
        this.attrCnameRecord = rosDomain.attrCnameRecord;
        this.attrCreateTime = rosDomain.attrCreateTime;
        this.attrDefaultDomain = rosDomain.attrDefaultDomain;
        this.attrDnsMx = rosDomain.attrDnsMx;
        this.attrDnsSpf = rosDomain.attrDnsSpf;
        this.attrDnsTxt = rosDomain.attrDnsTxt;
        this.attrDomainId = rosDomain.attrDomainId;
        this.attrDomainName = rosDomain.attrDomainName;
        this.attrDomainType = rosDomain.attrDomainType;
        this.attrIcpStatus = rosDomain.attrIcpStatus;
        this.attrMxAuthStatus = rosDomain.attrMxAuthStatus;
        this.attrMxRecord = rosDomain.attrMxRecord;
        this.attrSpfAuthStatus = rosDomain.attrSpfAuthStatus;
        this.attrSpfRecord = rosDomain.attrSpfRecord;
        this.attrTlDomainName = rosDomain.attrTlDomainName;
        this.attrTracefRecord = rosDomain.attrTracefRecord;
    }
}
exports.Domain = Domain;
//# sourceMappingURL=data:application/json;base64,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