"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.Domain = exports.DomainProperty = void 0;
const ros = require("@alicloud/ros-cdk-core");
const directmail_generated_1 = require("./directmail.generated");
Object.defineProperty(exports, "DomainProperty", { enumerable: true, get: function () { return directmail_generated_1.RosDomain; } });
/**
 * This class encapsulates and extends the ROS resource type `ALIYUN::DirectMail::Domain`, which is used to create a domain name in Direct Mail.
 * @Note This class may have some new functions to facilitate development, so it is recommended to use this class instead of `RosDomain`for a more convenient development experience.
 * See https://www.alibabacloud.com/help/ros/developer-reference/aliyun-directmail-domain
 */
class Domain extends ros.Resource {
    /**
     * Param scope - scope in which this resource is defined
     * Param id    - scoped id of the resource
     * Param props - resource properties
     */
    constructor(scope, id, props, enableResourcePropertyConstraint = true) {
        super(scope, id);
        this.scope = scope;
        this.id = id;
        this.props = props;
        this.enableResourcePropertyConstraint = enableResourcePropertyConstraint;
        const rosDomain = new directmail_generated_1.RosDomain(this, id, {
            domainName: props.domainName,
        }, enableResourcePropertyConstraint && this.stack.enableResourcePropertyConstraint);
        this.resource = rosDomain;
        this.attrCnameAuthStatus = rosDomain.attrCnameAuthStatus;
        this.attrCnameConfirmStatus = rosDomain.attrCnameConfirmStatus;
        this.attrCnameRecord = rosDomain.attrCnameRecord;
        this.attrCreateTime = rosDomain.attrCreateTime;
        this.attrDefaultDomain = rosDomain.attrDefaultDomain;
        this.attrDnsMx = rosDomain.attrDnsMx;
        this.attrDnsSpf = rosDomain.attrDnsSpf;
        this.attrDnsTxt = rosDomain.attrDnsTxt;
        this.attrDomainId = rosDomain.attrDomainId;
        this.attrDomainName = rosDomain.attrDomainName;
        this.attrDomainType = rosDomain.attrDomainType;
        this.attrIcpStatus = rosDomain.attrIcpStatus;
        this.attrMxAuthStatus = rosDomain.attrMxAuthStatus;
        this.attrMxRecord = rosDomain.attrMxRecord;
        this.attrSpfAuthStatus = rosDomain.attrSpfAuthStatus;
        this.attrSpfRecord = rosDomain.attrSpfRecord;
        this.attrTlDomainName = rosDomain.attrTlDomainName;
        this.attrTracefRecord = rosDomain.attrTracefRecord;
    }
}
exports.Domain = Domain;
//# sourceMappingURL=data:application/json;base64,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