# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional
from typing_extensions import Literal

from .._models import BaseModel
from .shared.logprobs import Logprobs
from .shared.graph_data import GraphData
from .chat_completion_usage import ChatCompletionUsage
from .chat_completion_message import ChatCompletionMessage
from .shared.tool_call_streaming import ToolCallStreaming

__all__ = ["ChatCompletionChunk", "Choice", "ChoiceDelta", "ChoiceDeltaLlmData", "ChoiceDeltaTranslationData"]


class ChoiceDeltaLlmData(BaseModel):
    model: str
    """The model used by the tool."""

    prompt: str
    """The prompt processed by the model."""


class ChoiceDeltaTranslationData(BaseModel):
    source_language_code: str
    """The language code of the source text."""

    source_text: str
    """The text the tool translated."""

    target_language_code: str
    """The language code of the target text."""


class ChoiceDelta(BaseModel):
    content: Optional[str] = None
    """The text content produced by the model.

    This field contains the actual output generated, reflecting the model's response
    to the input query or command.
    """

    graph_data: Optional[GraphData] = None

    llm_data: Optional[ChoiceDeltaLlmData] = None

    refusal: Optional[str] = None

    role: Optional[Literal["user", "assistant", "system"]] = None
    """
    Specifies the role associated with the content, indicating whether the message
    is from the 'assistant' or another defined role, helping to contextualize the
    output within the interaction flow.
    """

    tool_calls: Optional[List[ToolCallStreaming]] = None

    translation_data: Optional[ChoiceDeltaTranslationData] = None


class Choice(BaseModel):
    delta: ChoiceDelta
    """A chat completion delta generated by streamed model responses."""

    finish_reason: Optional[Literal["stop", "length", "content_filter", "tool_calls"]] = None
    """Describes the condition under which the model ceased generating content.

    Common reasons include 'length' (reached the maximum output size), 'stop'
    (encountered a stop sequence), 'content_filter' (harmful content filtered out),
    or 'tool_calls' (encountered tool calls).
    """

    index: int
    """The index of the choice in the list of completions generated by the model."""

    logprobs: Optional[Logprobs] = None
    """Log probability information for the choice."""

    message: Optional[ChatCompletionMessage] = None
    """The chat completion message from the model.

    Note: this field is deprecated for streaming. Use `delta` instead.
    """


class ChatCompletionChunk(BaseModel):
    id: str
    """A globally unique identifier (UUID) for the response generated by the API.

    This ID can be used to reference the specific operation or transaction within
    the system for tracking or debugging purposes.
    """

    choices: List[Choice]
    """
    An array of objects representing the different outcomes or results produced by
    the model based on the input provided.
    """

    created: int
    """The Unix timestamp (in seconds) when the response was created.

    This timestamp can be used to verify the timing of the response relative to
    other events or operations.
    """

    model: str
    """Identifies the specific model used to generate the response."""

    object: Literal["chat.completion.chunk"]
    """
    The type of object returned, which is always `chat.completion.chunk` for
    streaming chat responses.
    """

    service_tier: Optional[str] = None

    system_fingerprint: Optional[str] = None

    usage: Optional[ChatCompletionUsage] = None
    """Usage information for the chat completion response.

    Please note that at this time Knowledge Graph tool usage is not included in this
    object.
    """
