# File generated from our OpenAPI spec by Stainless. See CONTRIBUTING.md for details.

from typing import List, Optional

from .._models import BaseModel
from .shared.logprobs import Logprobs

__all__ = ["Completion", "Choice"]


class Choice(BaseModel):
    text: str
    """
    The generated text output from the model, which forms the main content of the
    response.
    """

    log_probs: Optional[Logprobs] = None


class Completion(BaseModel):
    choices: List[Choice]
    """
    A list of choices generated by the model, each containing the text of the
    completion and associated metadata such as log probabilities.
    """

    model: Optional[str] = None
    """
    The identifier of the model that was used to generate the responses in the
    'choices' array.
    """
