# 🔍 VulnScan

**VulnScan** is a powerful and lightweight **Web Penetration Testing Toolkit** developed over 3 years of research, crafted to assist ethical hackers, security researchers, and developers in identifying web application vulnerabilities quickly and efficiently.

> ⚡ Built with passion. Backed by real-world interviews. Recognized by industry leaders.

---

## 🚀 Features

VulnScan currently includes **14 powerful modules**:

1. 🌐 Change Target Domain  
2. 🔌 Port Scanning  
3. 🕵️ Domain Enumeration  
4. 🧬 Domain Fingerprinting  
5. 🧪 SQL Injection Testing  
6. 💉 Cross-Site Scripting (XSS) Testing  
7. 🛡️ CSRF Detection  
8. 🔒 SSL/TLS Certificate Detection  
9. 🗺️ Server Geolocation  
10. 📂 Directory Enumeration  
11. 🧱 Web Application Vulnerability Scanning  
12. 🕸️ Crawling and Spidering  
13. 🔥 WAF Detection

### Advanced Modules

14. 🚀 **Advanced Domain Enumeration** - Multi-technique subdomain discovery with passive and active methods
15. ☁️ **Cloud Vulnerability Scan** - Detect misconfigurations in AWS, Azure, and GCP environments
16. 🌐 **Advanced Web Application Scan** - Comprehensive testing for modern web applications
17. 🔌 **API Security Testing** - GraphQL and REST API vulnerability detection
18. 🤖 **AI-Powered Vulnerability Detection** - Machine learning-based vulnerability identification
19. 🔍 **Comprehensive Security Scan** - All-in-one automated security assessment
20. 🛡️ **Security Tool Integration** - Export findings to DefectDojo, Jira, Slack, and more
21. 📊 **Advanced Report Generation** - Multi-format reports with visualizations and risk scoring


> Each module is plug-and-play and optimized for fast, accurate results.

---


## 📦 Installation

```bash
git clone https://github.com/yourusername/vulnscan.git
cd vulnscan
pip install -r requirements.txt
python pdf_vulnscan_updated.py


