# This file was auto-generated by Fern from our API Definition.

import typing
from json.decoder import JSONDecodeError

from ..core.api_error import ApiError
from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.http_response import AsyncHttpResponse, HttpResponse
from ..core.jsonable_encoder import jsonable_encoder
from ..core.pydantic_utilities import parse_obj_as
from ..core.request_options import RequestOptions
from ..errors.unprocessable_entity_error import UnprocessableEntityError
from ..types.client_facing_blood_oxygen_timeseries import ClientFacingBloodOxygenTimeseries
from ..types.client_facing_blood_pressure_timeseries import ClientFacingBloodPressureTimeseries
from ..types.client_facing_body_fat_timeseries import ClientFacingBodyFatTimeseries
from ..types.client_facing_body_weight_timeseries import ClientFacingBodyWeightTimeseries
from ..types.client_facing_caffeine_timeseries import ClientFacingCaffeineTimeseries
from ..types.client_facing_calories_active_timeseries import ClientFacingCaloriesActiveTimeseries
from ..types.client_facing_calories_basal_timeseries import ClientFacingCaloriesBasalTimeseries
from ..types.client_facing_cholesterol_timeseries import ClientFacingCholesterolTimeseries
from ..types.client_facing_distance_timeseries import ClientFacingDistanceTimeseries
from ..types.client_facing_electrocardiogram_voltage_timeseries import ClientFacingElectrocardiogramVoltageTimeseries
from ..types.client_facing_floors_climbed_timeseries import ClientFacingFloorsClimbedTimeseries
from ..types.client_facing_glucose_timeseries import ClientFacingGlucoseTimeseries
from ..types.client_facing_heart_rate_timeseries import ClientFacingHeartRateTimeseries
from ..types.client_facing_hrv_timeseries import ClientFacingHrvTimeseries
from ..types.client_facing_hypnogram_timeseries import ClientFacingHypnogramTimeseries
from ..types.client_facing_ige_timeseries import ClientFacingIgeTimeseries
from ..types.client_facing_igg_timeseries import ClientFacingIggTimeseries
from ..types.client_facing_mindfulness_minutes_timeseries import ClientFacingMindfulnessMinutesTimeseries
from ..types.client_facing_respiratory_rate_timeseries import ClientFacingRespiratoryRateTimeseries
from ..types.client_facing_steps_timeseries import ClientFacingStepsTimeseries
from ..types.client_facing_stress_level_timeseries import ClientFacingStressLevelTimeseries
from ..types.client_facing_vo_2_max_timeseries import ClientFacingVo2MaxTimeseries
from ..types.client_facing_water_timeseries import ClientFacingWaterTimeseries
from ..types.grouped_a_fib_burden_response import GroupedAFibBurdenResponse
from ..types.grouped_basal_body_temperature_response import GroupedBasalBodyTemperatureResponse
from ..types.grouped_blood_oxygen_response import GroupedBloodOxygenResponse
from ..types.grouped_blood_pressure_response import GroupedBloodPressureResponse
from ..types.grouped_body_fat_response import GroupedBodyFatResponse
from ..types.grouped_body_mass_index_response import GroupedBodyMassIndexResponse
from ..types.grouped_body_temperature_delta_response import GroupedBodyTemperatureDeltaResponse
from ..types.grouped_body_temperature_response import GroupedBodyTemperatureResponse
from ..types.grouped_body_weight_response import GroupedBodyWeightResponse
from ..types.grouped_caffeine_response import GroupedCaffeineResponse
from ..types.grouped_calories_active_response import GroupedCaloriesActiveResponse
from ..types.grouped_calories_basal_response import GroupedCaloriesBasalResponse
from ..types.grouped_carbohydrates_response import GroupedCarbohydratesResponse
from ..types.grouped_cholesterol_response import GroupedCholesterolResponse
from ..types.grouped_daylight_exposure_response import GroupedDaylightExposureResponse
from ..types.grouped_distance_response import GroupedDistanceResponse
from ..types.grouped_electrocardiogram_voltage_response import GroupedElectrocardiogramVoltageResponse
from ..types.grouped_fall_response import GroupedFallResponse
from ..types.grouped_floors_climbed_response import GroupedFloorsClimbedResponse
from ..types.grouped_forced_expiratory_volume_1_response import GroupedForcedExpiratoryVolume1Response
from ..types.grouped_forced_vital_capacity_response import GroupedForcedVitalCapacityResponse
from ..types.grouped_glucose_response import GroupedGlucoseResponse
from ..types.grouped_handwashing_response import GroupedHandwashingResponse
from ..types.grouped_heart_rate_alert_response import GroupedHeartRateAlertResponse
from ..types.grouped_heart_rate_recovery_one_minute_response import GroupedHeartRateRecoveryOneMinuteResponse
from ..types.grouped_heart_rate_response import GroupedHeartRateResponse
from ..types.grouped_hrv_response import GroupedHrvResponse
from ..types.grouped_hypnogram_response import GroupedHypnogramResponse
from ..types.grouped_ige_response import GroupedIgeResponse
from ..types.grouped_igg_response import GroupedIggResponse
from ..types.grouped_inhaler_usage_response import GroupedInhalerUsageResponse
from ..types.grouped_insulin_injection_response import GroupedInsulinInjectionResponse
from ..types.grouped_lean_body_mass_response import GroupedLeanBodyMassResponse
from ..types.grouped_mindfulness_minutes_response import GroupedMindfulnessMinutesResponse
from ..types.grouped_note_response import GroupedNoteResponse
from ..types.grouped_peak_expiratory_flow_rate_response import GroupedPeakExpiratoryFlowRateResponse
from ..types.grouped_respiratory_rate_response import GroupedRespiratoryRateResponse
from ..types.grouped_sleep_apnea_alert_response import GroupedSleepApneaAlertResponse
from ..types.grouped_sleep_breathing_disturbance_response import GroupedSleepBreathingDisturbanceResponse
from ..types.grouped_stand_duration_response import GroupedStandDurationResponse
from ..types.grouped_stand_hour_response import GroupedStandHourResponse
from ..types.grouped_steps_response import GroupedStepsResponse
from ..types.grouped_stress_level_response import GroupedStressLevelResponse
from ..types.grouped_uv_exposure_response import GroupedUvExposureResponse
from ..types.grouped_vo_2_max_response import GroupedVo2MaxResponse
from ..types.grouped_waist_circumference_response import GroupedWaistCircumferenceResponse
from ..types.grouped_water_response import GroupedWaterResponse
from ..types.grouped_wheelchair_push_response import GroupedWheelchairPushResponse
from ..types.grouped_workout_distance_response import GroupedWorkoutDistanceResponse
from ..types.grouped_workout_duration_response import GroupedWorkoutDurationResponse
from ..types.grouped_workout_swimming_stroke_response import GroupedWorkoutSwimmingStrokeResponse
from ..types.http_validation_error import HttpValidationError


class RawVitalsClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._client_wrapper = client_wrapper

    def workout_swimming_stroke_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedWorkoutSwimmingStrokeResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedWorkoutSwimmingStrokeResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/workout_swimming_stroke/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedWorkoutSwimmingStrokeResponse,
                    parse_obj_as(
                        type_=GroupedWorkoutSwimmingStrokeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def workout_distance_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedWorkoutDistanceResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedWorkoutDistanceResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/workout_distance/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedWorkoutDistanceResponse,
                    parse_obj_as(
                        type_=GroupedWorkoutDistanceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def heart_rate_recovery_one_minute_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedHeartRateRecoveryOneMinuteResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedHeartRateRecoveryOneMinuteResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/heart_rate_recovery_one_minute/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedHeartRateRecoveryOneMinuteResponse,
                    parse_obj_as(
                        type_=GroupedHeartRateRecoveryOneMinuteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def waist_circumference_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedWaistCircumferenceResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedWaistCircumferenceResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/waist_circumference/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedWaistCircumferenceResponse,
                    parse_obj_as(
                        type_=GroupedWaistCircumferenceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def lean_body_mass_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedLeanBodyMassResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedLeanBodyMassResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/lean_body_mass/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedLeanBodyMassResponse,
                    parse_obj_as(
                        type_=GroupedLeanBodyMassResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def body_mass_index_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedBodyMassIndexResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedBodyMassIndexResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_mass_index/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBodyMassIndexResponse,
                    parse_obj_as(
                        type_=GroupedBodyMassIndexResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def basal_body_temperature_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedBasalBodyTemperatureResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedBasalBodyTemperatureResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/basal_body_temperature/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBasalBodyTemperatureResponse,
                    parse_obj_as(
                        type_=GroupedBasalBodyTemperatureResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def handwashing_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedHandwashingResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedHandwashingResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/handwashing/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedHandwashingResponse,
                    parse_obj_as(
                        type_=GroupedHandwashingResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def daylight_exposure_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedDaylightExposureResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedDaylightExposureResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/daylight_exposure/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedDaylightExposureResponse,
                    parse_obj_as(
                        type_=GroupedDaylightExposureResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def uv_exposure_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedUvExposureResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedUvExposureResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/uv_exposure/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedUvExposureResponse,
                    parse_obj_as(
                        type_=GroupedUvExposureResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def fall_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedFallResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedFallResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/fall/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedFallResponse,
                    parse_obj_as(
                        type_=GroupedFallResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def inhaler_usage_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedInhalerUsageResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedInhalerUsageResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/inhaler_usage/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedInhalerUsageResponse,
                    parse_obj_as(
                        type_=GroupedInhalerUsageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def peak_expiratory_flow_rate_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedPeakExpiratoryFlowRateResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedPeakExpiratoryFlowRateResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/peak_expiratory_flow_rate/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedPeakExpiratoryFlowRateResponse,
                    parse_obj_as(
                        type_=GroupedPeakExpiratoryFlowRateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def forced_vital_capacity_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedForcedVitalCapacityResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedForcedVitalCapacityResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/forced_vital_capacity/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedForcedVitalCapacityResponse,
                    parse_obj_as(
                        type_=GroupedForcedVitalCapacityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def forced_expiratory_volume_1_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedForcedExpiratoryVolume1Response]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedForcedExpiratoryVolume1Response]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/forced_expiratory_volume_1/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedForcedExpiratoryVolume1Response,
                    parse_obj_as(
                        type_=GroupedForcedExpiratoryVolume1Response,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def wheelchair_push_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedWheelchairPushResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedWheelchairPushResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/wheelchair_push/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedWheelchairPushResponse,
                    parse_obj_as(
                        type_=GroupedWheelchairPushResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def sleep_breathing_disturbance_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedSleepBreathingDisturbanceResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedSleepBreathingDisturbanceResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/sleep_breathing_disturbance/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedSleepBreathingDisturbanceResponse,
                    parse_obj_as(
                        type_=GroupedSleepBreathingDisturbanceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def sleep_apnea_alert_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedSleepApneaAlertResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedSleepApneaAlertResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/sleep_apnea_alert/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedSleepApneaAlertResponse,
                    parse_obj_as(
                        type_=GroupedSleepApneaAlertResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def stand_duration_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedStandDurationResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedStandDurationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/stand_duration/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedStandDurationResponse,
                    parse_obj_as(
                        type_=GroupedStandDurationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def stand_hour_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedStandHourResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedStandHourResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/stand_hour/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedStandHourResponse,
                    parse_obj_as(
                        type_=GroupedStandHourResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def heart_rate_alert_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedHeartRateAlertResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedHeartRateAlertResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/heart_rate_alert/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedHeartRateAlertResponse,
                    parse_obj_as(
                        type_=GroupedHeartRateAlertResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def afib_burden_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedAFibBurdenResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedAFibBurdenResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/afib_burden/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedAFibBurdenResponse,
                    parse_obj_as(
                        type_=GroupedAFibBurdenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def workout_duration_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedWorkoutDurationResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedWorkoutDurationResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/workout_duration/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedWorkoutDurationResponse,
                    parse_obj_as(
                        type_=GroupedWorkoutDurationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def vo_2_max_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedVo2MaxResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedVo2MaxResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/vo2_max/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedVo2MaxResponse,
                    parse_obj_as(
                        type_=GroupedVo2MaxResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def stress_level_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedStressLevelResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedStressLevelResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/stress_level/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedStressLevelResponse,
                    parse_obj_as(
                        type_=GroupedStressLevelResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def mindfulness_minutes_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedMindfulnessMinutesResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedMindfulnessMinutesResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/mindfulness_minutes/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedMindfulnessMinutesResponse,
                    parse_obj_as(
                        type_=GroupedMindfulnessMinutesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def caffeine_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedCaffeineResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedCaffeineResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/caffeine/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedCaffeineResponse,
                    parse_obj_as(
                        type_=GroupedCaffeineResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def water_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedWaterResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedWaterResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/water/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedWaterResponse,
                    parse_obj_as(
                        type_=GroupedWaterResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def steps_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedStepsResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedStepsResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/steps/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedStepsResponse,
                    parse_obj_as(
                        type_=GroupedStepsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def floors_climbed_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedFloorsClimbedResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedFloorsClimbedResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/floors_climbed/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedFloorsClimbedResponse,
                    parse_obj_as(
                        type_=GroupedFloorsClimbedResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def distance_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedDistanceResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedDistanceResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/distance/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedDistanceResponse,
                    parse_obj_as(
                        type_=GroupedDistanceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def calories_basal_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedCaloriesBasalResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedCaloriesBasalResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/calories_basal/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedCaloriesBasalResponse,
                    parse_obj_as(
                        type_=GroupedCaloriesBasalResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def calories_active_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedCaloriesActiveResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedCaloriesActiveResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/calories_active/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedCaloriesActiveResponse,
                    parse_obj_as(
                        type_=GroupedCaloriesActiveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def respiratory_rate_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedRespiratoryRateResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedRespiratoryRateResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/respiratory_rate/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedRespiratoryRateResponse,
                    parse_obj_as(
                        type_=GroupedRespiratoryRateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def note_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedNoteResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedNoteResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/note/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedNoteResponse,
                    parse_obj_as(
                        type_=GroupedNoteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def insulin_injection_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedInsulinInjectionResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedInsulinInjectionResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/insulin_injection/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedInsulinInjectionResponse,
                    parse_obj_as(
                        type_=GroupedInsulinInjectionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def ige_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedIgeResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedIgeResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/ige/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedIgeResponse,
                    parse_obj_as(
                        type_=GroupedIgeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def igg_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedIggResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedIggResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/igg/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedIggResponse,
                    parse_obj_as(
                        type_=GroupedIggResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def hypnogram_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedHypnogramResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedHypnogramResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/hypnogram/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedHypnogramResponse,
                    parse_obj_as(
                        type_=GroupedHypnogramResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def hrv_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedHrvResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedHrvResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/hrv/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedHrvResponse,
                    parse_obj_as(
                        type_=GroupedHrvResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def heartrate_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedHeartRateResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedHeartRateResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/heartrate/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedHeartRateResponse,
                    parse_obj_as(
                        type_=GroupedHeartRateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def glucose_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedGlucoseResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedGlucoseResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/glucose/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedGlucoseResponse,
                    parse_obj_as(
                        type_=GroupedGlucoseResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cholesterol_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedCholesterolResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedCholesterolResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/cholesterol/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedCholesterolResponse,
                    parse_obj_as(
                        type_=GroupedCholesterolResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def carbohydrates_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedCarbohydratesResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedCarbohydratesResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/carbohydrates/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedCarbohydratesResponse,
                    parse_obj_as(
                        type_=GroupedCarbohydratesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def body_temperature_delta_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedBodyTemperatureDeltaResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedBodyTemperatureDeltaResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_temperature_delta/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBodyTemperatureDeltaResponse,
                    parse_obj_as(
                        type_=GroupedBodyTemperatureDeltaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def body_temperature_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedBodyTemperatureResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedBodyTemperatureResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_temperature/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBodyTemperatureResponse,
                    parse_obj_as(
                        type_=GroupedBodyTemperatureResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def body_weight_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedBodyWeightResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedBodyWeightResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_weight/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBodyWeightResponse,
                    parse_obj_as(
                        type_=GroupedBodyWeightResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def body_fat_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedBodyFatResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedBodyFatResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_fat/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBodyFatResponse,
                    parse_obj_as(
                        type_=GroupedBodyFatResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def blood_oxygen_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedBloodOxygenResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedBloodOxygenResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/blood_oxygen/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBloodOxygenResponse,
                    parse_obj_as(
                        type_=GroupedBloodOxygenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def electrocardiogram_voltage_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedElectrocardiogramVoltageResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedElectrocardiogramVoltageResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/electrocardiogram_voltage/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedElectrocardiogramVoltageResponse,
                    parse_obj_as(
                        type_=GroupedElectrocardiogramVoltageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def blood_pressure_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[GroupedBloodPressureResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[GroupedBloodPressureResponse]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/blood_pressure/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBloodPressureResponse,
                    parse_obj_as(
                        type_=GroupedBloodPressureResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def vo_2_max(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingVo2MaxTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingVo2MaxTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/vo2_max",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingVo2MaxTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingVo2MaxTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def stress_level(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingStressLevelTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingStressLevelTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/stress_level",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingStressLevelTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingStressLevelTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def mindfulness_minutes(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingMindfulnessMinutesTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingMindfulnessMinutesTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/mindfulness_minutes",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingMindfulnessMinutesTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingMindfulnessMinutesTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def caffeine(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingCaffeineTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingCaffeineTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/caffeine",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCaffeineTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCaffeineTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def water(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingWaterTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingWaterTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/water",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingWaterTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingWaterTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def steps(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingStepsTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingStepsTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/steps",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingStepsTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingStepsTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def floors_climbed(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingFloorsClimbedTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingFloorsClimbedTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/floors_climbed",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingFloorsClimbedTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingFloorsClimbedTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def distance(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingDistanceTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingDistanceTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/distance",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingDistanceTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingDistanceTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def calories_basal(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingCaloriesBasalTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingCaloriesBasalTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/calories_basal",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCaloriesBasalTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCaloriesBasalTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def calories_active(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingCaloriesActiveTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingCaloriesActiveTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/calories_active",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCaloriesActiveTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCaloriesActiveTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def respiratory_rate(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingRespiratoryRateTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingRespiratoryRateTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/respiratory_rate",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingRespiratoryRateTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingRespiratoryRateTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def ige(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingIgeTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingIgeTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/ige",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingIgeTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingIgeTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def igg(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingIggTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingIggTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/igg",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingIggTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingIggTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def hypnogram(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingHypnogramTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingHypnogramTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/hypnogram",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingHypnogramTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingHypnogramTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def hrv(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingHrvTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingHrvTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/hrv",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingHrvTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingHrvTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def heartrate(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingHeartRateTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingHeartRateTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/heartrate",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingHeartRateTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingHeartRateTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def glucose(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingGlucoseTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingGlucoseTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/glucose",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingGlucoseTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingGlucoseTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cholesterol_triglycerides(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingCholesterolTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingCholesterolTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/cholesterol/triglycerides",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCholesterolTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCholesterolTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cholesterol_total(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingCholesterolTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingCholesterolTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/cholesterol/total",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCholesterolTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCholesterolTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cholesterol_ldl(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingCholesterolTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingCholesterolTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/cholesterol/ldl",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCholesterolTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCholesterolTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cholesterol_hdl(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingCholesterolTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingCholesterolTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/cholesterol/hdl",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCholesterolTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCholesterolTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def cholesterol(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingCholesterolTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingCholesterolTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/cholesterol",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCholesterolTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCholesterolTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def body_weight(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingBodyWeightTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingBodyWeightTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_weight",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingBodyWeightTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingBodyWeightTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def body_fat(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingBodyFatTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingBodyFatTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_fat",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingBodyFatTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingBodyFatTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def blood_oxygen(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingBloodOxygenTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingBloodOxygenTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/blood_oxygen",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingBloodOxygenTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingBloodOxygenTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def electrocardiogram_voltage(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingElectrocardiogramVoltageTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingElectrocardiogramVoltageTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/electrocardiogram_voltage",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingElectrocardiogramVoltageTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingElectrocardiogramVoltageTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    def blood_pressure(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> HttpResponse[typing.List[ClientFacingBloodPressureTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        HttpResponse[typing.List[ClientFacingBloodPressureTimeseries]]
            Successful Response
        """
        _response = self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/blood_pressure",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingBloodPressureTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingBloodPressureTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return HttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)


class AsyncRawVitalsClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._client_wrapper = client_wrapper

    async def workout_swimming_stroke_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedWorkoutSwimmingStrokeResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedWorkoutSwimmingStrokeResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/workout_swimming_stroke/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedWorkoutSwimmingStrokeResponse,
                    parse_obj_as(
                        type_=GroupedWorkoutSwimmingStrokeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def workout_distance_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedWorkoutDistanceResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedWorkoutDistanceResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/workout_distance/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedWorkoutDistanceResponse,
                    parse_obj_as(
                        type_=GroupedWorkoutDistanceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def heart_rate_recovery_one_minute_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedHeartRateRecoveryOneMinuteResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedHeartRateRecoveryOneMinuteResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/heart_rate_recovery_one_minute/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedHeartRateRecoveryOneMinuteResponse,
                    parse_obj_as(
                        type_=GroupedHeartRateRecoveryOneMinuteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def waist_circumference_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedWaistCircumferenceResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedWaistCircumferenceResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/waist_circumference/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedWaistCircumferenceResponse,
                    parse_obj_as(
                        type_=GroupedWaistCircumferenceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def lean_body_mass_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedLeanBodyMassResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedLeanBodyMassResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/lean_body_mass/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedLeanBodyMassResponse,
                    parse_obj_as(
                        type_=GroupedLeanBodyMassResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def body_mass_index_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedBodyMassIndexResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedBodyMassIndexResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_mass_index/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBodyMassIndexResponse,
                    parse_obj_as(
                        type_=GroupedBodyMassIndexResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def basal_body_temperature_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedBasalBodyTemperatureResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedBasalBodyTemperatureResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/basal_body_temperature/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBasalBodyTemperatureResponse,
                    parse_obj_as(
                        type_=GroupedBasalBodyTemperatureResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def handwashing_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedHandwashingResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedHandwashingResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/handwashing/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedHandwashingResponse,
                    parse_obj_as(
                        type_=GroupedHandwashingResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def daylight_exposure_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedDaylightExposureResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedDaylightExposureResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/daylight_exposure/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedDaylightExposureResponse,
                    parse_obj_as(
                        type_=GroupedDaylightExposureResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def uv_exposure_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedUvExposureResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedUvExposureResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/uv_exposure/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedUvExposureResponse,
                    parse_obj_as(
                        type_=GroupedUvExposureResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def fall_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedFallResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedFallResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/fall/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedFallResponse,
                    parse_obj_as(
                        type_=GroupedFallResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def inhaler_usage_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedInhalerUsageResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedInhalerUsageResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/inhaler_usage/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedInhalerUsageResponse,
                    parse_obj_as(
                        type_=GroupedInhalerUsageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def peak_expiratory_flow_rate_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedPeakExpiratoryFlowRateResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedPeakExpiratoryFlowRateResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/peak_expiratory_flow_rate/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedPeakExpiratoryFlowRateResponse,
                    parse_obj_as(
                        type_=GroupedPeakExpiratoryFlowRateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def forced_vital_capacity_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedForcedVitalCapacityResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedForcedVitalCapacityResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/forced_vital_capacity/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedForcedVitalCapacityResponse,
                    parse_obj_as(
                        type_=GroupedForcedVitalCapacityResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def forced_expiratory_volume_1_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedForcedExpiratoryVolume1Response]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedForcedExpiratoryVolume1Response]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/forced_expiratory_volume_1/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedForcedExpiratoryVolume1Response,
                    parse_obj_as(
                        type_=GroupedForcedExpiratoryVolume1Response,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def wheelchair_push_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedWheelchairPushResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedWheelchairPushResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/wheelchair_push/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedWheelchairPushResponse,
                    parse_obj_as(
                        type_=GroupedWheelchairPushResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def sleep_breathing_disturbance_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedSleepBreathingDisturbanceResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedSleepBreathingDisturbanceResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/sleep_breathing_disturbance/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedSleepBreathingDisturbanceResponse,
                    parse_obj_as(
                        type_=GroupedSleepBreathingDisturbanceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def sleep_apnea_alert_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedSleepApneaAlertResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedSleepApneaAlertResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/sleep_apnea_alert/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedSleepApneaAlertResponse,
                    parse_obj_as(
                        type_=GroupedSleepApneaAlertResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def stand_duration_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedStandDurationResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedStandDurationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/stand_duration/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedStandDurationResponse,
                    parse_obj_as(
                        type_=GroupedStandDurationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def stand_hour_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedStandHourResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedStandHourResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/stand_hour/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedStandHourResponse,
                    parse_obj_as(
                        type_=GroupedStandHourResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def heart_rate_alert_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedHeartRateAlertResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedHeartRateAlertResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/heart_rate_alert/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedHeartRateAlertResponse,
                    parse_obj_as(
                        type_=GroupedHeartRateAlertResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def afib_burden_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedAFibBurdenResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedAFibBurdenResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/afib_burden/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedAFibBurdenResponse,
                    parse_obj_as(
                        type_=GroupedAFibBurdenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def workout_duration_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedWorkoutDurationResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedWorkoutDurationResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/workout_duration/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedWorkoutDurationResponse,
                    parse_obj_as(
                        type_=GroupedWorkoutDurationResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def vo_2_max_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedVo2MaxResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedVo2MaxResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/vo2_max/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedVo2MaxResponse,
                    parse_obj_as(
                        type_=GroupedVo2MaxResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def stress_level_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedStressLevelResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedStressLevelResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/stress_level/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedStressLevelResponse,
                    parse_obj_as(
                        type_=GroupedStressLevelResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def mindfulness_minutes_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedMindfulnessMinutesResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedMindfulnessMinutesResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/mindfulness_minutes/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedMindfulnessMinutesResponse,
                    parse_obj_as(
                        type_=GroupedMindfulnessMinutesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def caffeine_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedCaffeineResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedCaffeineResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/caffeine/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedCaffeineResponse,
                    parse_obj_as(
                        type_=GroupedCaffeineResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def water_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedWaterResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedWaterResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/water/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedWaterResponse,
                    parse_obj_as(
                        type_=GroupedWaterResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def steps_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedStepsResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedStepsResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/steps/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedStepsResponse,
                    parse_obj_as(
                        type_=GroupedStepsResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def floors_climbed_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedFloorsClimbedResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedFloorsClimbedResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/floors_climbed/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedFloorsClimbedResponse,
                    parse_obj_as(
                        type_=GroupedFloorsClimbedResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def distance_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedDistanceResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedDistanceResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/distance/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedDistanceResponse,
                    parse_obj_as(
                        type_=GroupedDistanceResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def calories_basal_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedCaloriesBasalResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedCaloriesBasalResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/calories_basal/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedCaloriesBasalResponse,
                    parse_obj_as(
                        type_=GroupedCaloriesBasalResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def calories_active_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedCaloriesActiveResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedCaloriesActiveResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/calories_active/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedCaloriesActiveResponse,
                    parse_obj_as(
                        type_=GroupedCaloriesActiveResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def respiratory_rate_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedRespiratoryRateResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedRespiratoryRateResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/respiratory_rate/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedRespiratoryRateResponse,
                    parse_obj_as(
                        type_=GroupedRespiratoryRateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def note_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedNoteResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedNoteResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/note/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedNoteResponse,
                    parse_obj_as(
                        type_=GroupedNoteResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def insulin_injection_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedInsulinInjectionResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedInsulinInjectionResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/insulin_injection/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedInsulinInjectionResponse,
                    parse_obj_as(
                        type_=GroupedInsulinInjectionResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def ige_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedIgeResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedIgeResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/ige/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedIgeResponse,
                    parse_obj_as(
                        type_=GroupedIgeResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def igg_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedIggResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedIggResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/igg/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedIggResponse,
                    parse_obj_as(
                        type_=GroupedIggResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def hypnogram_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedHypnogramResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedHypnogramResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/hypnogram/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedHypnogramResponse,
                    parse_obj_as(
                        type_=GroupedHypnogramResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def hrv_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedHrvResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedHrvResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/hrv/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedHrvResponse,
                    parse_obj_as(
                        type_=GroupedHrvResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def heartrate_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedHeartRateResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedHeartRateResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/heartrate/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedHeartRateResponse,
                    parse_obj_as(
                        type_=GroupedHeartRateResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def glucose_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedGlucoseResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedGlucoseResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/glucose/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedGlucoseResponse,
                    parse_obj_as(
                        type_=GroupedGlucoseResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cholesterol_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedCholesterolResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedCholesterolResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/cholesterol/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedCholesterolResponse,
                    parse_obj_as(
                        type_=GroupedCholesterolResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def carbohydrates_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedCarbohydratesResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedCarbohydratesResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/carbohydrates/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedCarbohydratesResponse,
                    parse_obj_as(
                        type_=GroupedCarbohydratesResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def body_temperature_delta_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedBodyTemperatureDeltaResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedBodyTemperatureDeltaResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_temperature_delta/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBodyTemperatureDeltaResponse,
                    parse_obj_as(
                        type_=GroupedBodyTemperatureDeltaResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def body_temperature_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedBodyTemperatureResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedBodyTemperatureResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_temperature/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBodyTemperatureResponse,
                    parse_obj_as(
                        type_=GroupedBodyTemperatureResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def body_weight_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedBodyWeightResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedBodyWeightResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_weight/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBodyWeightResponse,
                    parse_obj_as(
                        type_=GroupedBodyWeightResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def body_fat_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedBodyFatResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedBodyFatResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_fat/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBodyFatResponse,
                    parse_obj_as(
                        type_=GroupedBodyFatResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def blood_oxygen_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedBloodOxygenResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedBloodOxygenResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/blood_oxygen/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBloodOxygenResponse,
                    parse_obj_as(
                        type_=GroupedBloodOxygenResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def electrocardiogram_voltage_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedElectrocardiogramVoltageResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedElectrocardiogramVoltageResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/electrocardiogram_voltage/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedElectrocardiogramVoltageResponse,
                    parse_obj_as(
                        type_=GroupedElectrocardiogramVoltageResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def blood_pressure_grouped(
        self,
        user_id: str,
        *,
        start_date: str,
        cursor: typing.Optional[str] = None,
        next_cursor: typing.Optional[str] = None,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[GroupedBloodPressureResponse]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        next_cursor : typing.Optional[str]
            The cursor for fetching the next page, or `null` to fetch the first page.

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[GroupedBloodPressureResponse]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/blood_pressure/grouped",
            method="GET",
            params={
                "cursor": cursor,
                "next_cursor": next_cursor,
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    GroupedBloodPressureResponse,
                    parse_obj_as(
                        type_=GroupedBloodPressureResponse,  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def vo_2_max(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingVo2MaxTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingVo2MaxTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/vo2_max",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingVo2MaxTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingVo2MaxTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def stress_level(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingStressLevelTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingStressLevelTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/stress_level",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingStressLevelTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingStressLevelTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def mindfulness_minutes(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingMindfulnessMinutesTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingMindfulnessMinutesTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/mindfulness_minutes",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingMindfulnessMinutesTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingMindfulnessMinutesTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def caffeine(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingCaffeineTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingCaffeineTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/caffeine",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCaffeineTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCaffeineTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def water(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingWaterTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingWaterTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/water",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingWaterTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingWaterTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def steps(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingStepsTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingStepsTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/steps",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingStepsTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingStepsTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def floors_climbed(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingFloorsClimbedTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingFloorsClimbedTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/floors_climbed",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingFloorsClimbedTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingFloorsClimbedTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def distance(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingDistanceTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingDistanceTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/distance",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingDistanceTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingDistanceTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def calories_basal(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingCaloriesBasalTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingCaloriesBasalTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/calories_basal",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCaloriesBasalTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCaloriesBasalTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def calories_active(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingCaloriesActiveTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingCaloriesActiveTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/calories_active",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCaloriesActiveTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCaloriesActiveTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def respiratory_rate(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingRespiratoryRateTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingRespiratoryRateTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/respiratory_rate",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingRespiratoryRateTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingRespiratoryRateTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def ige(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingIgeTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingIgeTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/ige",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingIgeTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingIgeTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def igg(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingIggTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingIggTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/igg",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingIggTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingIggTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def hypnogram(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingHypnogramTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingHypnogramTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/hypnogram",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingHypnogramTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingHypnogramTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def hrv(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingHrvTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingHrvTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/hrv",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingHrvTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingHrvTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def heartrate(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingHeartRateTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingHeartRateTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/heartrate",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingHeartRateTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingHeartRateTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def glucose(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingGlucoseTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingGlucoseTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/glucose",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingGlucoseTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingGlucoseTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cholesterol_triglycerides(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingCholesterolTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingCholesterolTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/cholesterol/triglycerides",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCholesterolTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCholesterolTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cholesterol_total(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingCholesterolTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingCholesterolTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/cholesterol/total",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCholesterolTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCholesterolTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cholesterol_ldl(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingCholesterolTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingCholesterolTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/cholesterol/ldl",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCholesterolTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCholesterolTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cholesterol_hdl(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingCholesterolTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingCholesterolTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/cholesterol/hdl",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCholesterolTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCholesterolTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def cholesterol(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingCholesterolTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingCholesterolTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/cholesterol",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingCholesterolTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingCholesterolTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def body_weight(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingBodyWeightTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingBodyWeightTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_weight",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingBodyWeightTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingBodyWeightTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def body_fat(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingBodyFatTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingBodyFatTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/body_fat",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingBodyFatTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingBodyFatTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def blood_oxygen(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingBloodOxygenTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingBloodOxygenTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/blood_oxygen",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingBloodOxygenTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingBloodOxygenTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def electrocardiogram_voltage(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingElectrocardiogramVoltageTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingElectrocardiogramVoltageTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/electrocardiogram_voltage",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingElectrocardiogramVoltageTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingElectrocardiogramVoltageTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)

    async def blood_pressure(
        self,
        user_id: str,
        *,
        start_date: str,
        provider: typing.Optional[str] = None,
        end_date: typing.Optional[str] = None,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> AsyncHttpResponse[typing.List[ClientFacingBloodPressureTimeseries]]:
        """
        Parameters
        ----------
        user_id : str

        start_date : str
            Date from in YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 00:00:00

        provider : typing.Optional[str]
            Provider oura/strava etc

        end_date : typing.Optional[str]
            Date to YYYY-MM-DD or ISO formatted date time. If a date is provided without a time, the time will be set to 23:59:59

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        AsyncHttpResponse[typing.List[ClientFacingBloodPressureTimeseries]]
            Successful Response
        """
        _response = await self._client_wrapper.httpx_client.request(
            f"v2/timeseries/{jsonable_encoder(user_id)}/blood_pressure",
            method="GET",
            params={
                "provider": provider,
                "start_date": start_date,
                "end_date": end_date,
            },
            request_options=request_options,
        )
        try:
            if 200 <= _response.status_code < 300:
                _data = typing.cast(
                    typing.List[ClientFacingBloodPressureTimeseries],
                    parse_obj_as(
                        type_=typing.List[ClientFacingBloodPressureTimeseries],  # type: ignore
                        object_=_response.json(),
                    ),
                )
                return AsyncHttpResponse(response=_response, data=_data)
            if _response.status_code == 422:
                raise UnprocessableEntityError(
                    headers=dict(_response.headers),
                    body=typing.cast(
                        HttpValidationError,
                        parse_obj_as(
                            type_=HttpValidationError,  # type: ignore
                            object_=_response.json(),
                        ),
                    ),
                )
            _response_json = _response.json()
        except JSONDecodeError:
            raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response.text)
        raise ApiError(status_code=_response.status_code, headers=dict(_response.headers), body=_response_json)
