# This file was auto-generated by Fern from our API Definition.

import typing

from ..core.client_wrapper import AsyncClientWrapper, SyncClientWrapper
from ..core.request_options import RequestOptions
from ..types.welcome_wizard_tracking import WelcomeWizardTracking
from .raw_client import AsyncRawWelcomeWizardClient, RawWelcomeWizardClient

# this is used as the default value for optional parameters
OMIT = typing.cast(typing.Any, ...)


class WelcomeWizardClient:
    def __init__(self, *, client_wrapper: SyncClientWrapper):
        self._raw_client = RawWelcomeWizardClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> RawWelcomeWizardClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        RawWelcomeWizardClient
        """
        return self._raw_client

    def get_welcome_wizard_status(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WelcomeWizardTracking:
        """
        Get welcome wizard tracking status for the current workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WelcomeWizardTracking
            Welcome wizard tracking status

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.welcome_wizard.get_welcome_wizard_status()
        """
        _response = self._raw_client.get_welcome_wizard_status(request_options=request_options)
        return _response.data

    def submit_welcome_wizard(
        self,
        *,
        role: typing.Optional[str] = OMIT,
        integrations: typing.Optional[typing.Sequence[str]] = OMIT,
        email: typing.Optional[str] = OMIT,
        join_beta_program: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Submit welcome wizard with user information

        Parameters
        ----------
        role : typing.Optional[str]
            Optional user role

        integrations : typing.Optional[typing.Sequence[str]]
            List of integrations the user selected

        email : typing.Optional[str]
            Optional user email

        join_beta_program : typing.Optional[bool]
            Whether user wants to join beta programs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import OpikApi
        client = OpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        client.welcome_wizard.submit_welcome_wizard()
        """
        _response = self._raw_client.submit_welcome_wizard(
            role=role,
            integrations=integrations,
            email=email,
            join_beta_program=join_beta_program,
            request_options=request_options,
        )
        return _response.data


class AsyncWelcomeWizardClient:
    def __init__(self, *, client_wrapper: AsyncClientWrapper):
        self._raw_client = AsyncRawWelcomeWizardClient(client_wrapper=client_wrapper)

    @property
    def with_raw_response(self) -> AsyncRawWelcomeWizardClient:
        """
        Retrieves a raw implementation of this client that returns raw responses.

        Returns
        -------
        AsyncRawWelcomeWizardClient
        """
        return self._raw_client

    async def get_welcome_wizard_status(
        self, *, request_options: typing.Optional[RequestOptions] = None
    ) -> WelcomeWizardTracking:
        """
        Get welcome wizard tracking status for the current workspace

        Parameters
        ----------
        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        WelcomeWizardTracking
            Welcome wizard tracking status

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.welcome_wizard.get_welcome_wizard_status()
        asyncio.run(main())
        """
        _response = await self._raw_client.get_welcome_wizard_status(request_options=request_options)
        return _response.data

    async def submit_welcome_wizard(
        self,
        *,
        role: typing.Optional[str] = OMIT,
        integrations: typing.Optional[typing.Sequence[str]] = OMIT,
        email: typing.Optional[str] = OMIT,
        join_beta_program: typing.Optional[bool] = OMIT,
        request_options: typing.Optional[RequestOptions] = None,
    ) -> None:
        """
        Submit welcome wizard with user information

        Parameters
        ----------
        role : typing.Optional[str]
            Optional user role

        integrations : typing.Optional[typing.Sequence[str]]
            List of integrations the user selected

        email : typing.Optional[str]
            Optional user email

        join_beta_program : typing.Optional[bool]
            Whether user wants to join beta programs

        request_options : typing.Optional[RequestOptions]
            Request-specific configuration.

        Returns
        -------
        None

        Examples
        --------
        from Opik import AsyncOpikApi
        import asyncio
        client = AsyncOpikApi(api_key="YOUR_API_KEY", workspace_name="YOUR_WORKSPACE_NAME", )
        async def main() -> None:
            await client.welcome_wizard.submit_welcome_wizard()
        asyncio.run(main())
        """
        _response = await self._raw_client.submit_welcome_wizard(
            role=role,
            integrations=integrations,
            email=email,
            join_beta_program=join_beta_program,
            request_options=request_options,
        )
        return _response.data
