# pyesi-openapi
This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

This Python package is automatically generated by the [OpenAPI Generator](https://openapi-generator.tech) project:

- API version: 2020-01-01
- Package version: 0.1.1
- Generator version: 7.15.0
- Build package: org.openapitools.codegen.languages.PythonClientCodegen
For more information, please visit [https://github.com/arxbombus](https://github.com/arxbombus)

## Requirements.

Python 3.9+

## Installation & Usage
### pip install

If the python package is hosted on a repository, you can install directly using:

```sh
pip install git+https://github.com/arxbombus/pyesi-openapi.git
```
(you may need to run `pip` with root permission: `sudo pip install git+https://github.com/arxbombus/pyesi-openapi.git`)

Then import the package:
```python
import pyesi_openapi
```

### Setuptools

Install via [Setuptools](http://pypi.python.org/pypi/setuptools).

```sh
python setup.py install --user
```
(or `sudo python setup.py install` to install the package for all users)

Then import the package:
```python
import pyesi_openapi
```

### Tests

Execute `pytest` to run the tests.

## Getting Started

Please follow the [installation procedure](#installation--usage) and then run the following:

```python

import pyesi_openapi
from pyesi_openapi.rest import ApiException
from pprint import pprint

# Defining the host is optional and defaults to https://esi.evetech.net
# See configuration.py for a list of all supported configuration parameters.
configuration = pyesi_openapi.Configuration(
    host = "https://esi.evetech.net"
)



# Enter a context with an instance of the API client
with pyesi_openapi.ApiClient(configuration) as api_client:
    # Create an instance of the API class
    api_instance = pyesi_openapi.AllianceApi(api_client)
    accept_language = en # str | The language to use for the response. (optional) (default to en)
    if_none_match = 'if_none_match_example' # str | The ETag of the previous request. A 304 will be returned if this matches the current ETag. (optional)
    x_compatibility_date = '2013-10-20' # date | The compatibility date for the request. (optional)
    x_tenant = 'tranquility' # str | The tenant ID for the request. (optional) (default to 'tranquility')

    try:
        # List all alliances
        api_response = api_instance.get_alliances(accept_language=accept_language, if_none_match=if_none_match, x_compatibility_date=x_compatibility_date, x_tenant=x_tenant)
        print("The response of AllianceApi->get_alliances:\n")
        pprint(api_response)
    except ApiException as e:
        print("Exception when calling AllianceApi->get_alliances: %s\n" % e)

```

## Documentation for API Endpoints

All URIs are relative to *https://esi.evetech.net*

Class | Method | HTTP request | Description
------------ | ------------- | ------------- | -------------
*AllianceApi* | [**get_alliances**](docs/AllianceApi.md#get_alliances) | **GET** /alliances | List all alliances
*AllianceApi* | [**get_alliances_alliance_id**](docs/AllianceApi.md#get_alliances_alliance_id) | **GET** /alliances/{alliance_id} | Get alliance information
*AllianceApi* | [**get_alliances_alliance_id_corporations**](docs/AllianceApi.md#get_alliances_alliance_id_corporations) | **GET** /alliances/{alliance_id}/corporations | List alliance&#39;s corporations
*AllianceApi* | [**get_alliances_alliance_id_icons**](docs/AllianceApi.md#get_alliances_alliance_id_icons) | **GET** /alliances/{alliance_id}/icons | Get alliance icon
*AssetsApi* | [**get_characters_character_id_assets**](docs/AssetsApi.md#get_characters_character_id_assets) | **GET** /characters/{character_id}/assets | Get character assets
*AssetsApi* | [**get_corporations_corporation_id_assets**](docs/AssetsApi.md#get_corporations_corporation_id_assets) | **GET** /corporations/{corporation_id}/assets | Get corporation assets
*AssetsApi* | [**post_characters_character_id_assets_locations**](docs/AssetsApi.md#post_characters_character_id_assets_locations) | **POST** /characters/{character_id}/assets/locations | Get character asset locations
*AssetsApi* | [**post_characters_character_id_assets_names**](docs/AssetsApi.md#post_characters_character_id_assets_names) | **POST** /characters/{character_id}/assets/names | Get character asset names
*AssetsApi* | [**post_corporations_corporation_id_assets_locations**](docs/AssetsApi.md#post_corporations_corporation_id_assets_locations) | **POST** /corporations/{corporation_id}/assets/locations | Get corporation asset locations
*AssetsApi* | [**post_corporations_corporation_id_assets_names**](docs/AssetsApi.md#post_corporations_corporation_id_assets_names) | **POST** /corporations/{corporation_id}/assets/names | Get corporation asset names
*CalendarApi* | [**get_characters_character_id_calendar**](docs/CalendarApi.md#get_characters_character_id_calendar) | **GET** /characters/{character_id}/calendar | List calendar event summaries
*CalendarApi* | [**get_characters_character_id_calendar_event_id**](docs/CalendarApi.md#get_characters_character_id_calendar_event_id) | **GET** /characters/{character_id}/calendar/{event_id} | Get an event
*CalendarApi* | [**get_characters_character_id_calendar_event_id_attendees**](docs/CalendarApi.md#get_characters_character_id_calendar_event_id_attendees) | **GET** /characters/{character_id}/calendar/{event_id}/attendees | Get attendees
*CalendarApi* | [**put_characters_character_id_calendar_event_id**](docs/CalendarApi.md#put_characters_character_id_calendar_event_id) | **PUT** /characters/{character_id}/calendar/{event_id} | Respond to an event
*CharacterApi* | [**get_characters_character_id**](docs/CharacterApi.md#get_characters_character_id) | **GET** /characters/{character_id} | Get character&#39;s public information
*CharacterApi* | [**get_characters_character_id_agents_research**](docs/CharacterApi.md#get_characters_character_id_agents_research) | **GET** /characters/{character_id}/agents_research | Get agents research
*CharacterApi* | [**get_characters_character_id_blueprints**](docs/CharacterApi.md#get_characters_character_id_blueprints) | **GET** /characters/{character_id}/blueprints | Get blueprints
*CharacterApi* | [**get_characters_character_id_corporationhistory**](docs/CharacterApi.md#get_characters_character_id_corporationhistory) | **GET** /characters/{character_id}/corporationhistory | Get corporation history
*CharacterApi* | [**get_characters_character_id_fatigue**](docs/CharacterApi.md#get_characters_character_id_fatigue) | **GET** /characters/{character_id}/fatigue | Get jump fatigue
*CharacterApi* | [**get_characters_character_id_medals**](docs/CharacterApi.md#get_characters_character_id_medals) | **GET** /characters/{character_id}/medals | Get medals
*CharacterApi* | [**get_characters_character_id_notifications**](docs/CharacterApi.md#get_characters_character_id_notifications) | **GET** /characters/{character_id}/notifications | Get character notifications
*CharacterApi* | [**get_characters_character_id_notifications_contacts**](docs/CharacterApi.md#get_characters_character_id_notifications_contacts) | **GET** /characters/{character_id}/notifications/contacts | Get new contact notifications
*CharacterApi* | [**get_characters_character_id_portrait**](docs/CharacterApi.md#get_characters_character_id_portrait) | **GET** /characters/{character_id}/portrait | Get character portraits
*CharacterApi* | [**get_characters_character_id_roles**](docs/CharacterApi.md#get_characters_character_id_roles) | **GET** /characters/{character_id}/roles | Get character corporation roles
*CharacterApi* | [**get_characters_character_id_standings**](docs/CharacterApi.md#get_characters_character_id_standings) | **GET** /characters/{character_id}/standings | Get standings
*CharacterApi* | [**get_characters_character_id_titles**](docs/CharacterApi.md#get_characters_character_id_titles) | **GET** /characters/{character_id}/titles | Get character corporation titles
*CharacterApi* | [**post_characters_affiliation**](docs/CharacterApi.md#post_characters_affiliation) | **POST** /characters/affiliation | Character affiliation
*CharacterApi* | [**post_characters_character_id_cspa**](docs/CharacterApi.md#post_characters_character_id_cspa) | **POST** /characters/{character_id}/cspa | Calculate a CSPA charge cost
*ClonesApi* | [**get_characters_character_id_clones**](docs/ClonesApi.md#get_characters_character_id_clones) | **GET** /characters/{character_id}/clones | Get clones
*ClonesApi* | [**get_characters_character_id_implants**](docs/ClonesApi.md#get_characters_character_id_implants) | **GET** /characters/{character_id}/implants | Get active implants
*ContactsApi* | [**delete_characters_character_id_contacts**](docs/ContactsApi.md#delete_characters_character_id_contacts) | **DELETE** /characters/{character_id}/contacts | Delete contacts
*ContactsApi* | [**get_alliances_alliance_id_contacts**](docs/ContactsApi.md#get_alliances_alliance_id_contacts) | **GET** /alliances/{alliance_id}/contacts | Get alliance contacts
*ContactsApi* | [**get_alliances_alliance_id_contacts_labels**](docs/ContactsApi.md#get_alliances_alliance_id_contacts_labels) | **GET** /alliances/{alliance_id}/contacts/labels | Get alliance contact labels
*ContactsApi* | [**get_characters_character_id_contacts**](docs/ContactsApi.md#get_characters_character_id_contacts) | **GET** /characters/{character_id}/contacts | Get contacts
*ContactsApi* | [**get_characters_character_id_contacts_labels**](docs/ContactsApi.md#get_characters_character_id_contacts_labels) | **GET** /characters/{character_id}/contacts/labels | Get contact labels
*ContactsApi* | [**get_corporations_corporation_id_contacts**](docs/ContactsApi.md#get_corporations_corporation_id_contacts) | **GET** /corporations/{corporation_id}/contacts | Get corporation contacts
*ContactsApi* | [**get_corporations_corporation_id_contacts_labels**](docs/ContactsApi.md#get_corporations_corporation_id_contacts_labels) | **GET** /corporations/{corporation_id}/contacts/labels | Get corporation contact labels
*ContactsApi* | [**post_characters_character_id_contacts**](docs/ContactsApi.md#post_characters_character_id_contacts) | **POST** /characters/{character_id}/contacts | Add contacts
*ContactsApi* | [**put_characters_character_id_contacts**](docs/ContactsApi.md#put_characters_character_id_contacts) | **PUT** /characters/{character_id}/contacts | Edit contacts
*ContractsApi* | [**get_characters_character_id_contracts**](docs/ContractsApi.md#get_characters_character_id_contracts) | **GET** /characters/{character_id}/contracts | Get contracts
*ContractsApi* | [**get_characters_character_id_contracts_contract_id_bids**](docs/ContractsApi.md#get_characters_character_id_contracts_contract_id_bids) | **GET** /characters/{character_id}/contracts/{contract_id}/bids | Get contract bids
*ContractsApi* | [**get_characters_character_id_contracts_contract_id_items**](docs/ContractsApi.md#get_characters_character_id_contracts_contract_id_items) | **GET** /characters/{character_id}/contracts/{contract_id}/items | Get contract items
*ContractsApi* | [**get_contracts_public_bids_contract_id**](docs/ContractsApi.md#get_contracts_public_bids_contract_id) | **GET** /contracts/public/bids/{contract_id} | Get public contract bids
*ContractsApi* | [**get_contracts_public_items_contract_id**](docs/ContractsApi.md#get_contracts_public_items_contract_id) | **GET** /contracts/public/items/{contract_id} | Get public contract items
*ContractsApi* | [**get_contracts_public_region_id**](docs/ContractsApi.md#get_contracts_public_region_id) | **GET** /contracts/public/{region_id} | Get public contracts
*ContractsApi* | [**get_corporations_corporation_id_contracts**](docs/ContractsApi.md#get_corporations_corporation_id_contracts) | **GET** /corporations/{corporation_id}/contracts | Get corporation contracts
*ContractsApi* | [**get_corporations_corporation_id_contracts_contract_id_bids**](docs/ContractsApi.md#get_corporations_corporation_id_contracts_contract_id_bids) | **GET** /corporations/{corporation_id}/contracts/{contract_id}/bids | Get corporation contract bids
*ContractsApi* | [**get_corporations_corporation_id_contracts_contract_id_items**](docs/ContractsApi.md#get_corporations_corporation_id_contracts_contract_id_items) | **GET** /corporations/{corporation_id}/contracts/{contract_id}/items | Get corporation contract items
*CorporationApi* | [**get_corporations_corporation_id**](docs/CorporationApi.md#get_corporations_corporation_id) | **GET** /corporations/{corporation_id} | Get corporation information
*CorporationApi* | [**get_corporations_corporation_id_alliancehistory**](docs/CorporationApi.md#get_corporations_corporation_id_alliancehistory) | **GET** /corporations/{corporation_id}/alliancehistory | Get alliance history
*CorporationApi* | [**get_corporations_corporation_id_blueprints**](docs/CorporationApi.md#get_corporations_corporation_id_blueprints) | **GET** /corporations/{corporation_id}/blueprints | Get corporation blueprints
*CorporationApi* | [**get_corporations_corporation_id_containers_logs**](docs/CorporationApi.md#get_corporations_corporation_id_containers_logs) | **GET** /corporations/{corporation_id}/containers/logs | Get all corporation ALSC logs
*CorporationApi* | [**get_corporations_corporation_id_divisions**](docs/CorporationApi.md#get_corporations_corporation_id_divisions) | **GET** /corporations/{corporation_id}/divisions | Get corporation divisions
*CorporationApi* | [**get_corporations_corporation_id_facilities**](docs/CorporationApi.md#get_corporations_corporation_id_facilities) | **GET** /corporations/{corporation_id}/facilities | Get corporation facilities
*CorporationApi* | [**get_corporations_corporation_id_icons**](docs/CorporationApi.md#get_corporations_corporation_id_icons) | **GET** /corporations/{corporation_id}/icons | Get corporation icon
*CorporationApi* | [**get_corporations_corporation_id_medals**](docs/CorporationApi.md#get_corporations_corporation_id_medals) | **GET** /corporations/{corporation_id}/medals | Get corporation medals
*CorporationApi* | [**get_corporations_corporation_id_medals_issued**](docs/CorporationApi.md#get_corporations_corporation_id_medals_issued) | **GET** /corporations/{corporation_id}/medals/issued | Get corporation issued medals
*CorporationApi* | [**get_corporations_corporation_id_members**](docs/CorporationApi.md#get_corporations_corporation_id_members) | **GET** /corporations/{corporation_id}/members | Get corporation members
*CorporationApi* | [**get_corporations_corporation_id_members_limit**](docs/CorporationApi.md#get_corporations_corporation_id_members_limit) | **GET** /corporations/{corporation_id}/members/limit | Get corporation member limit
*CorporationApi* | [**get_corporations_corporation_id_members_titles**](docs/CorporationApi.md#get_corporations_corporation_id_members_titles) | **GET** /corporations/{corporation_id}/members/titles | Get corporation&#39;s members&#39; titles
*CorporationApi* | [**get_corporations_corporation_id_membertracking**](docs/CorporationApi.md#get_corporations_corporation_id_membertracking) | **GET** /corporations/{corporation_id}/membertracking | Track corporation members
*CorporationApi* | [**get_corporations_corporation_id_roles**](docs/CorporationApi.md#get_corporations_corporation_id_roles) | **GET** /corporations/{corporation_id}/roles | Get corporation member roles
*CorporationApi* | [**get_corporations_corporation_id_roles_history**](docs/CorporationApi.md#get_corporations_corporation_id_roles_history) | **GET** /corporations/{corporation_id}/roles/history | Get corporation member roles history
*CorporationApi* | [**get_corporations_corporation_id_shareholders**](docs/CorporationApi.md#get_corporations_corporation_id_shareholders) | **GET** /corporations/{corporation_id}/shareholders | Get corporation shareholders
*CorporationApi* | [**get_corporations_corporation_id_standings**](docs/CorporationApi.md#get_corporations_corporation_id_standings) | **GET** /corporations/{corporation_id}/standings | Get corporation standings
*CorporationApi* | [**get_corporations_corporation_id_starbases**](docs/CorporationApi.md#get_corporations_corporation_id_starbases) | **GET** /corporations/{corporation_id}/starbases | Get corporation starbases (POSes)
*CorporationApi* | [**get_corporations_corporation_id_starbases_starbase_id**](docs/CorporationApi.md#get_corporations_corporation_id_starbases_starbase_id) | **GET** /corporations/{corporation_id}/starbases/{starbase_id} | Get starbase (POS) detail
*CorporationApi* | [**get_corporations_corporation_id_structures**](docs/CorporationApi.md#get_corporations_corporation_id_structures) | **GET** /corporations/{corporation_id}/structures | Get corporation structures
*CorporationApi* | [**get_corporations_corporation_id_titles**](docs/CorporationApi.md#get_corporations_corporation_id_titles) | **GET** /corporations/{corporation_id}/titles | Get corporation titles
*CorporationApi* | [**get_corporations_npccorps**](docs/CorporationApi.md#get_corporations_npccorps) | **GET** /corporations/npccorps | Get npc corporations
*DogmaApi* | [**get_dogma_attributes**](docs/DogmaApi.md#get_dogma_attributes) | **GET** /dogma/attributes | Get attributes
*DogmaApi* | [**get_dogma_attributes_attribute_id**](docs/DogmaApi.md#get_dogma_attributes_attribute_id) | **GET** /dogma/attributes/{attribute_id} | Get attribute information
*DogmaApi* | [**get_dogma_dynamic_items_type_id_item_id**](docs/DogmaApi.md#get_dogma_dynamic_items_type_id_item_id) | **GET** /dogma/dynamic/items/{type_id}/{item_id} | Get dynamic item information
*DogmaApi* | [**get_dogma_effects**](docs/DogmaApi.md#get_dogma_effects) | **GET** /dogma/effects | Get effects
*DogmaApi* | [**get_dogma_effects_effect_id**](docs/DogmaApi.md#get_dogma_effects_effect_id) | **GET** /dogma/effects/{effect_id} | Get effect information
*FactionWarfareApi* | [**get_characters_character_id_fw_stats**](docs/FactionWarfareApi.md#get_characters_character_id_fw_stats) | **GET** /characters/{character_id}/fw/stats | Overview of a character involved in faction warfare
*FactionWarfareApi* | [**get_corporations_corporation_id_fw_stats**](docs/FactionWarfareApi.md#get_corporations_corporation_id_fw_stats) | **GET** /corporations/{corporation_id}/fw/stats | Overview of a corporation involved in faction warfare
*FactionWarfareApi* | [**get_fw_leaderboards**](docs/FactionWarfareApi.md#get_fw_leaderboards) | **GET** /fw/leaderboards | List of the top factions in faction warfare
*FactionWarfareApi* | [**get_fw_leaderboards_characters**](docs/FactionWarfareApi.md#get_fw_leaderboards_characters) | **GET** /fw/leaderboards/characters | List of the top pilots in faction warfare
*FactionWarfareApi* | [**get_fw_leaderboards_corporations**](docs/FactionWarfareApi.md#get_fw_leaderboards_corporations) | **GET** /fw/leaderboards/corporations | List of the top corporations in faction warfare
*FactionWarfareApi* | [**get_fw_stats**](docs/FactionWarfareApi.md#get_fw_stats) | **GET** /fw/stats | An overview of statistics about factions involved in faction warfare
*FactionWarfareApi* | [**get_fw_systems**](docs/FactionWarfareApi.md#get_fw_systems) | **GET** /fw/systems | Ownership of faction warfare systems
*FactionWarfareApi* | [**get_fw_wars**](docs/FactionWarfareApi.md#get_fw_wars) | **GET** /fw/wars | Data about which NPC factions are at war
*FittingsApi* | [**delete_characters_character_id_fittings_fitting_id**](docs/FittingsApi.md#delete_characters_character_id_fittings_fitting_id) | **DELETE** /characters/{character_id}/fittings/{fitting_id} | Delete fitting
*FittingsApi* | [**get_characters_character_id_fittings**](docs/FittingsApi.md#get_characters_character_id_fittings) | **GET** /characters/{character_id}/fittings | Get fittings
*FittingsApi* | [**post_characters_character_id_fittings**](docs/FittingsApi.md#post_characters_character_id_fittings) | **POST** /characters/{character_id}/fittings | Create fitting
*FleetsApi* | [**delete_fleets_fleet_id_members_member_id**](docs/FleetsApi.md#delete_fleets_fleet_id_members_member_id) | **DELETE** /fleets/{fleet_id}/members/{member_id} | Kick fleet member
*FleetsApi* | [**delete_fleets_fleet_id_squads_squad_id**](docs/FleetsApi.md#delete_fleets_fleet_id_squads_squad_id) | **DELETE** /fleets/{fleet_id}/squads/{squad_id} | Delete fleet squad
*FleetsApi* | [**delete_fleets_fleet_id_wings_wing_id**](docs/FleetsApi.md#delete_fleets_fleet_id_wings_wing_id) | **DELETE** /fleets/{fleet_id}/wings/{wing_id} | Delete fleet wing
*FleetsApi* | [**get_characters_character_id_fleet**](docs/FleetsApi.md#get_characters_character_id_fleet) | **GET** /characters/{character_id}/fleet | Get character fleet info
*FleetsApi* | [**get_fleets_fleet_id**](docs/FleetsApi.md#get_fleets_fleet_id) | **GET** /fleets/{fleet_id} | Get fleet information
*FleetsApi* | [**get_fleets_fleet_id_members**](docs/FleetsApi.md#get_fleets_fleet_id_members) | **GET** /fleets/{fleet_id}/members | Get fleet members
*FleetsApi* | [**get_fleets_fleet_id_wings**](docs/FleetsApi.md#get_fleets_fleet_id_wings) | **GET** /fleets/{fleet_id}/wings | Get fleet wings
*FleetsApi* | [**post_fleets_fleet_id_members**](docs/FleetsApi.md#post_fleets_fleet_id_members) | **POST** /fleets/{fleet_id}/members | Create fleet invitation
*FleetsApi* | [**post_fleets_fleet_id_wings**](docs/FleetsApi.md#post_fleets_fleet_id_wings) | **POST** /fleets/{fleet_id}/wings | Create fleet wing
*FleetsApi* | [**post_fleets_fleet_id_wings_wing_id_squads**](docs/FleetsApi.md#post_fleets_fleet_id_wings_wing_id_squads) | **POST** /fleets/{fleet_id}/wings/{wing_id}/squads | Create fleet squad
*FleetsApi* | [**put_fleets_fleet_id**](docs/FleetsApi.md#put_fleets_fleet_id) | **PUT** /fleets/{fleet_id} | Update fleet
*FleetsApi* | [**put_fleets_fleet_id_members_member_id**](docs/FleetsApi.md#put_fleets_fleet_id_members_member_id) | **PUT** /fleets/{fleet_id}/members/{member_id} | Move fleet member
*FleetsApi* | [**put_fleets_fleet_id_squads_squad_id**](docs/FleetsApi.md#put_fleets_fleet_id_squads_squad_id) | **PUT** /fleets/{fleet_id}/squads/{squad_id} | Rename fleet squad
*FleetsApi* | [**put_fleets_fleet_id_wings_wing_id**](docs/FleetsApi.md#put_fleets_fleet_id_wings_wing_id) | **PUT** /fleets/{fleet_id}/wings/{wing_id} | Rename fleet wing
*IncursionsApi* | [**get_incursions**](docs/IncursionsApi.md#get_incursions) | **GET** /incursions | List incursions
*IndustryApi* | [**get_characters_character_id_industry_jobs**](docs/IndustryApi.md#get_characters_character_id_industry_jobs) | **GET** /characters/{character_id}/industry/jobs | List character industry jobs
*IndustryApi* | [**get_characters_character_id_mining**](docs/IndustryApi.md#get_characters_character_id_mining) | **GET** /characters/{character_id}/mining | Character mining ledger
*IndustryApi* | [**get_corporation_corporation_id_mining_extractions**](docs/IndustryApi.md#get_corporation_corporation_id_mining_extractions) | **GET** /corporation/{corporation_id}/mining/extractions | Moon extraction timers
*IndustryApi* | [**get_corporation_corporation_id_mining_observers**](docs/IndustryApi.md#get_corporation_corporation_id_mining_observers) | **GET** /corporation/{corporation_id}/mining/observers | Corporation mining observers
*IndustryApi* | [**get_corporation_corporation_id_mining_observers_observer_id**](docs/IndustryApi.md#get_corporation_corporation_id_mining_observers_observer_id) | **GET** /corporation/{corporation_id}/mining/observers/{observer_id} | Observed corporation mining
*IndustryApi* | [**get_corporations_corporation_id_industry_jobs**](docs/IndustryApi.md#get_corporations_corporation_id_industry_jobs) | **GET** /corporations/{corporation_id}/industry/jobs | List corporation industry jobs
*IndustryApi* | [**get_industry_facilities**](docs/IndustryApi.md#get_industry_facilities) | **GET** /industry/facilities | List industry facilities
*IndustryApi* | [**get_industry_systems**](docs/IndustryApi.md#get_industry_systems) | **GET** /industry/systems | List solar system cost indices
*InsuranceApi* | [**get_insurance_prices**](docs/InsuranceApi.md#get_insurance_prices) | **GET** /insurance/prices | List insurance levels
*KillmailsApi* | [**get_characters_character_id_killmails_recent**](docs/KillmailsApi.md#get_characters_character_id_killmails_recent) | **GET** /characters/{character_id}/killmails/recent | Get a character&#39;s recent kills and losses
*KillmailsApi* | [**get_corporations_corporation_id_killmails_recent**](docs/KillmailsApi.md#get_corporations_corporation_id_killmails_recent) | **GET** /corporations/{corporation_id}/killmails/recent | Get a corporation&#39;s recent kills and losses
*KillmailsApi* | [**get_killmails_killmail_id_killmail_hash**](docs/KillmailsApi.md#get_killmails_killmail_id_killmail_hash) | **GET** /killmails/{killmail_id}/{killmail_hash} | Get a single killmail
*LocationApi* | [**get_characters_character_id_location**](docs/LocationApi.md#get_characters_character_id_location) | **GET** /characters/{character_id}/location | Get character location
*LocationApi* | [**get_characters_character_id_online**](docs/LocationApi.md#get_characters_character_id_online) | **GET** /characters/{character_id}/online | Get character online
*LocationApi* | [**get_characters_character_id_ship**](docs/LocationApi.md#get_characters_character_id_ship) | **GET** /characters/{character_id}/ship | Get current ship
*LoyaltyApi* | [**get_characters_character_id_loyalty_points**](docs/LoyaltyApi.md#get_characters_character_id_loyalty_points) | **GET** /characters/{character_id}/loyalty/points | Get loyalty points
*LoyaltyApi* | [**get_loyalty_stores_corporation_id_offers**](docs/LoyaltyApi.md#get_loyalty_stores_corporation_id_offers) | **GET** /loyalty/stores/{corporation_id}/offers | List loyalty store offers
*MailApi* | [**delete_characters_character_id_mail_labels_label_id**](docs/MailApi.md#delete_characters_character_id_mail_labels_label_id) | **DELETE** /characters/{character_id}/mail/labels/{label_id} | Delete a mail label
*MailApi* | [**delete_characters_character_id_mail_mail_id**](docs/MailApi.md#delete_characters_character_id_mail_mail_id) | **DELETE** /characters/{character_id}/mail/{mail_id} | Delete a mail
*MailApi* | [**get_characters_character_id_mail**](docs/MailApi.md#get_characters_character_id_mail) | **GET** /characters/{character_id}/mail | Return mail headers
*MailApi* | [**get_characters_character_id_mail_labels**](docs/MailApi.md#get_characters_character_id_mail_labels) | **GET** /characters/{character_id}/mail/labels | Get mail labels and unread counts
*MailApi* | [**get_characters_character_id_mail_lists**](docs/MailApi.md#get_characters_character_id_mail_lists) | **GET** /characters/{character_id}/mail/lists | Return mailing list subscriptions
*MailApi* | [**get_characters_character_id_mail_mail_id**](docs/MailApi.md#get_characters_character_id_mail_mail_id) | **GET** /characters/{character_id}/mail/{mail_id} | Return a mail
*MailApi* | [**post_characters_character_id_mail**](docs/MailApi.md#post_characters_character_id_mail) | **POST** /characters/{character_id}/mail | Send a new mail
*MailApi* | [**post_characters_character_id_mail_labels**](docs/MailApi.md#post_characters_character_id_mail_labels) | **POST** /characters/{character_id}/mail/labels | Create a mail label
*MailApi* | [**put_characters_character_id_mail_mail_id**](docs/MailApi.md#put_characters_character_id_mail_mail_id) | **PUT** /characters/{character_id}/mail/{mail_id} | Update metadata about a mail
*MarketApi* | [**get_characters_character_id_orders**](docs/MarketApi.md#get_characters_character_id_orders) | **GET** /characters/{character_id}/orders | List open orders from a character
*MarketApi* | [**get_characters_character_id_orders_history**](docs/MarketApi.md#get_characters_character_id_orders_history) | **GET** /characters/{character_id}/orders/history | List historical orders by a character
*MarketApi* | [**get_corporations_corporation_id_orders**](docs/MarketApi.md#get_corporations_corporation_id_orders) | **GET** /corporations/{corporation_id}/orders | List open orders from a corporation
*MarketApi* | [**get_corporations_corporation_id_orders_history**](docs/MarketApi.md#get_corporations_corporation_id_orders_history) | **GET** /corporations/{corporation_id}/orders/history | List historical orders from a corporation
*MarketApi* | [**get_markets_groups**](docs/MarketApi.md#get_markets_groups) | **GET** /markets/groups | Get item groups
*MarketApi* | [**get_markets_groups_market_group_id**](docs/MarketApi.md#get_markets_groups_market_group_id) | **GET** /markets/groups/{market_group_id} | Get item group information
*MarketApi* | [**get_markets_prices**](docs/MarketApi.md#get_markets_prices) | **GET** /markets/prices | List market prices
*MarketApi* | [**get_markets_region_id_history**](docs/MarketApi.md#get_markets_region_id_history) | **GET** /markets/{region_id}/history | List historical market statistics in a region
*MarketApi* | [**get_markets_region_id_orders**](docs/MarketApi.md#get_markets_region_id_orders) | **GET** /markets/{region_id}/orders | List orders in a region
*MarketApi* | [**get_markets_region_id_types**](docs/MarketApi.md#get_markets_region_id_types) | **GET** /markets/{region_id}/types | List type IDs relevant to a market
*MarketApi* | [**get_markets_structures_structure_id**](docs/MarketApi.md#get_markets_structures_structure_id) | **GET** /markets/structures/{structure_id} | List orders in a structure
*MetaApi* | [**get_meta_changelog**](docs/MetaApi.md#get_meta_changelog) | **GET** /meta/changelog | Get changelog
*MetaApi* | [**get_meta_compatibility_dates**](docs/MetaApi.md#get_meta_compatibility_dates) | **GET** /meta/compatibility-dates | Get compatibility dates
*PlanetaryInteractionApi* | [**get_characters_character_id_planets**](docs/PlanetaryInteractionApi.md#get_characters_character_id_planets) | **GET** /characters/{character_id}/planets | Get colonies
*PlanetaryInteractionApi* | [**get_characters_character_id_planets_planet_id**](docs/PlanetaryInteractionApi.md#get_characters_character_id_planets_planet_id) | **GET** /characters/{character_id}/planets/{planet_id} | Get colony layout
*PlanetaryInteractionApi* | [**get_corporations_corporation_id_customs_offices**](docs/PlanetaryInteractionApi.md#get_corporations_corporation_id_customs_offices) | **GET** /corporations/{corporation_id}/customs_offices | List corporation customs offices
*PlanetaryInteractionApi* | [**get_universe_schematics_schematic_id**](docs/PlanetaryInteractionApi.md#get_universe_schematics_schematic_id) | **GET** /universe/schematics/{schematic_id} | Get schematic information
*RoutesApi* | [**get_route_origin_destination**](docs/RoutesApi.md#get_route_origin_destination) | **GET** /route/{origin}/{destination} | Get route
*SearchApi* | [**get_characters_character_id_search**](docs/SearchApi.md#get_characters_character_id_search) | **GET** /characters/{character_id}/search | Search on a string
*SkillsApi* | [**get_characters_character_id_attributes**](docs/SkillsApi.md#get_characters_character_id_attributes) | **GET** /characters/{character_id}/attributes | Get character attributes
*SkillsApi* | [**get_characters_character_id_skillqueue**](docs/SkillsApi.md#get_characters_character_id_skillqueue) | **GET** /characters/{character_id}/skillqueue | Get character&#39;s skill queue
*SkillsApi* | [**get_characters_character_id_skills**](docs/SkillsApi.md#get_characters_character_id_skills) | **GET** /characters/{character_id}/skills | Get character skills
*SovereigntyApi* | [**get_sovereignty_campaigns**](docs/SovereigntyApi.md#get_sovereignty_campaigns) | **GET** /sovereignty/campaigns | List sovereignty campaigns
*SovereigntyApi* | [**get_sovereignty_map**](docs/SovereigntyApi.md#get_sovereignty_map) | **GET** /sovereignty/map | List sovereignty of systems
*SovereigntyApi* | [**get_sovereignty_structures**](docs/SovereigntyApi.md#get_sovereignty_structures) | **GET** /sovereignty/structures | List sovereignty structures
*StatusApi* | [**get_status**](docs/StatusApi.md#get_status) | **GET** /status | Retrieve the uptime and player counts
*UniverseApi* | [**get_universe_ancestries**](docs/UniverseApi.md#get_universe_ancestries) | **GET** /universe/ancestries | Get ancestries
*UniverseApi* | [**get_universe_asteroid_belts_asteroid_belt_id**](docs/UniverseApi.md#get_universe_asteroid_belts_asteroid_belt_id) | **GET** /universe/asteroid_belts/{asteroid_belt_id} | Get asteroid belt information
*UniverseApi* | [**get_universe_bloodlines**](docs/UniverseApi.md#get_universe_bloodlines) | **GET** /universe/bloodlines | Get bloodlines
*UniverseApi* | [**get_universe_categories**](docs/UniverseApi.md#get_universe_categories) | **GET** /universe/categories | Get item categories
*UniverseApi* | [**get_universe_categories_category_id**](docs/UniverseApi.md#get_universe_categories_category_id) | **GET** /universe/categories/{category_id} | Get item category information
*UniverseApi* | [**get_universe_constellations**](docs/UniverseApi.md#get_universe_constellations) | **GET** /universe/constellations | Get constellations
*UniverseApi* | [**get_universe_constellations_constellation_id**](docs/UniverseApi.md#get_universe_constellations_constellation_id) | **GET** /universe/constellations/{constellation_id} | Get constellation information
*UniverseApi* | [**get_universe_factions**](docs/UniverseApi.md#get_universe_factions) | **GET** /universe/factions | Get factions
*UniverseApi* | [**get_universe_graphics**](docs/UniverseApi.md#get_universe_graphics) | **GET** /universe/graphics | Get graphics
*UniverseApi* | [**get_universe_graphics_graphic_id**](docs/UniverseApi.md#get_universe_graphics_graphic_id) | **GET** /universe/graphics/{graphic_id} | Get graphic information
*UniverseApi* | [**get_universe_groups**](docs/UniverseApi.md#get_universe_groups) | **GET** /universe/groups | Get item groups
*UniverseApi* | [**get_universe_groups_group_id**](docs/UniverseApi.md#get_universe_groups_group_id) | **GET** /universe/groups/{group_id} | Get item group information
*UniverseApi* | [**get_universe_moons_moon_id**](docs/UniverseApi.md#get_universe_moons_moon_id) | **GET** /universe/moons/{moon_id} | Get moon information
*UniverseApi* | [**get_universe_planets_planet_id**](docs/UniverseApi.md#get_universe_planets_planet_id) | **GET** /universe/planets/{planet_id} | Get planet information
*UniverseApi* | [**get_universe_races**](docs/UniverseApi.md#get_universe_races) | **GET** /universe/races | Get character races
*UniverseApi* | [**get_universe_regions**](docs/UniverseApi.md#get_universe_regions) | **GET** /universe/regions | Get regions
*UniverseApi* | [**get_universe_regions_region_id**](docs/UniverseApi.md#get_universe_regions_region_id) | **GET** /universe/regions/{region_id} | Get region information
*UniverseApi* | [**get_universe_stargates_stargate_id**](docs/UniverseApi.md#get_universe_stargates_stargate_id) | **GET** /universe/stargates/{stargate_id} | Get stargate information
*UniverseApi* | [**get_universe_stars_star_id**](docs/UniverseApi.md#get_universe_stars_star_id) | **GET** /universe/stars/{star_id} | Get star information
*UniverseApi* | [**get_universe_stations_station_id**](docs/UniverseApi.md#get_universe_stations_station_id) | **GET** /universe/stations/{station_id} | Get station information
*UniverseApi* | [**get_universe_structures**](docs/UniverseApi.md#get_universe_structures) | **GET** /universe/structures | List all public structures
*UniverseApi* | [**get_universe_structures_structure_id**](docs/UniverseApi.md#get_universe_structures_structure_id) | **GET** /universe/structures/{structure_id} | Get structure information
*UniverseApi* | [**get_universe_system_jumps**](docs/UniverseApi.md#get_universe_system_jumps) | **GET** /universe/system_jumps | Get system jumps
*UniverseApi* | [**get_universe_system_kills**](docs/UniverseApi.md#get_universe_system_kills) | **GET** /universe/system_kills | Get system kills
*UniverseApi* | [**get_universe_systems**](docs/UniverseApi.md#get_universe_systems) | **GET** /universe/systems | Get solar systems
*UniverseApi* | [**get_universe_systems_system_id**](docs/UniverseApi.md#get_universe_systems_system_id) | **GET** /universe/systems/{system_id} | Get solar system information
*UniverseApi* | [**get_universe_types**](docs/UniverseApi.md#get_universe_types) | **GET** /universe/types | Get types
*UniverseApi* | [**get_universe_types_type_id**](docs/UniverseApi.md#get_universe_types_type_id) | **GET** /universe/types/{type_id} | Get type information
*UniverseApi* | [**post_universe_ids**](docs/UniverseApi.md#post_universe_ids) | **POST** /universe/ids | Bulk names to IDs
*UniverseApi* | [**post_universe_names**](docs/UniverseApi.md#post_universe_names) | **POST** /universe/names | Get names and categories for a set of IDs
*UserInterfaceApi* | [**post_ui_autopilot_waypoint**](docs/UserInterfaceApi.md#post_ui_autopilot_waypoint) | **POST** /ui/autopilot/waypoint | Set Autopilot Waypoint
*UserInterfaceApi* | [**post_ui_openwindow_contract**](docs/UserInterfaceApi.md#post_ui_openwindow_contract) | **POST** /ui/openwindow/contract | Open Contract Window
*UserInterfaceApi* | [**post_ui_openwindow_information**](docs/UserInterfaceApi.md#post_ui_openwindow_information) | **POST** /ui/openwindow/information | Open Information Window
*UserInterfaceApi* | [**post_ui_openwindow_marketdetails**](docs/UserInterfaceApi.md#post_ui_openwindow_marketdetails) | **POST** /ui/openwindow/marketdetails | Open Market Details
*UserInterfaceApi* | [**post_ui_openwindow_newmail**](docs/UserInterfaceApi.md#post_ui_openwindow_newmail) | **POST** /ui/openwindow/newmail | Open New Mail Window
*WalletApi* | [**get_characters_character_id_wallet**](docs/WalletApi.md#get_characters_character_id_wallet) | **GET** /characters/{character_id}/wallet | Get a character&#39;s wallet balance
*WalletApi* | [**get_characters_character_id_wallet_journal**](docs/WalletApi.md#get_characters_character_id_wallet_journal) | **GET** /characters/{character_id}/wallet/journal | Get character wallet journal
*WalletApi* | [**get_characters_character_id_wallet_transactions**](docs/WalletApi.md#get_characters_character_id_wallet_transactions) | **GET** /characters/{character_id}/wallet/transactions | Get wallet transactions
*WalletApi* | [**get_corporations_corporation_id_wallets**](docs/WalletApi.md#get_corporations_corporation_id_wallets) | **GET** /corporations/{corporation_id}/wallets | Returns a corporation&#39;s wallet balance
*WalletApi* | [**get_corporations_corporation_id_wallets_division_journal**](docs/WalletApi.md#get_corporations_corporation_id_wallets_division_journal) | **GET** /corporations/{corporation_id}/wallets/{division}/journal | Get corporation wallet journal
*WalletApi* | [**get_corporations_corporation_id_wallets_division_transactions**](docs/WalletApi.md#get_corporations_corporation_id_wallets_division_transactions) | **GET** /corporations/{corporation_id}/wallets/{division}/transactions | Get corporation wallet transactions
*WarsApi* | [**get_wars**](docs/WarsApi.md#get_wars) | **GET** /wars | List wars
*WarsApi* | [**get_wars_war_id**](docs/WarsApi.md#get_wars_war_id) | **GET** /wars/{war_id} | Get war information
*WarsApi* | [**get_wars_war_id_killmails**](docs/WarsApi.md#get_wars_war_id_killmails) | **GET** /wars/{war_id}/killmails | List kills for a war


## Documentation For Models

 - [AlliancesAllianceIdContactsGetInner](docs/AlliancesAllianceIdContactsGetInner.md)
 - [AlliancesAllianceIdContactsLabelsGetInner](docs/AlliancesAllianceIdContactsLabelsGetInner.md)
 - [AlliancesAllianceIdGet](docs/AlliancesAllianceIdGet.md)
 - [AlliancesAllianceIdIconsGet](docs/AlliancesAllianceIdIconsGet.md)
 - [CharactersAffiliationPostInner](docs/CharactersAffiliationPostInner.md)
 - [CharactersCharacterIdAgentsResearchGetInner](docs/CharactersCharacterIdAgentsResearchGetInner.md)
 - [CharactersCharacterIdAssetsGetInner](docs/CharactersCharacterIdAssetsGetInner.md)
 - [CharactersCharacterIdAssetsLocationsPostInner](docs/CharactersCharacterIdAssetsLocationsPostInner.md)
 - [CharactersCharacterIdAssetsLocationsPostInnerPosition](docs/CharactersCharacterIdAssetsLocationsPostInnerPosition.md)
 - [CharactersCharacterIdAssetsNamesPostInner](docs/CharactersCharacterIdAssetsNamesPostInner.md)
 - [CharactersCharacterIdAttributesGet](docs/CharactersCharacterIdAttributesGet.md)
 - [CharactersCharacterIdBlueprintsGetInner](docs/CharactersCharacterIdBlueprintsGetInner.md)
 - [CharactersCharacterIdCalendarEventIdAttendeesGetInner](docs/CharactersCharacterIdCalendarEventIdAttendeesGetInner.md)
 - [CharactersCharacterIdCalendarEventIdGet](docs/CharactersCharacterIdCalendarEventIdGet.md)
 - [CharactersCharacterIdCalendarGetInner](docs/CharactersCharacterIdCalendarGetInner.md)
 - [CharactersCharacterIdClonesGet](docs/CharactersCharacterIdClonesGet.md)
 - [CharactersCharacterIdClonesGetHomeLocation](docs/CharactersCharacterIdClonesGetHomeLocation.md)
 - [CharactersCharacterIdClonesGetJumpClonesInner](docs/CharactersCharacterIdClonesGetJumpClonesInner.md)
 - [CharactersCharacterIdContactsGetInner](docs/CharactersCharacterIdContactsGetInner.md)
 - [CharactersCharacterIdContractsContractIdBidsGetInner](docs/CharactersCharacterIdContractsContractIdBidsGetInner.md)
 - [CharactersCharacterIdContractsContractIdItemsGetInner](docs/CharactersCharacterIdContractsContractIdItemsGetInner.md)
 - [CharactersCharacterIdContractsGetInner](docs/CharactersCharacterIdContractsGetInner.md)
 - [CharactersCharacterIdCorporationhistoryGetInner](docs/CharactersCharacterIdCorporationhistoryGetInner.md)
 - [CharactersCharacterIdFatigueGet](docs/CharactersCharacterIdFatigueGet.md)
 - [CharactersCharacterIdFittingsGetInner](docs/CharactersCharacterIdFittingsGetInner.md)
 - [CharactersCharacterIdFittingsGetInnerItemsInner](docs/CharactersCharacterIdFittingsGetInnerItemsInner.md)
 - [CharactersCharacterIdFittingsPost](docs/CharactersCharacterIdFittingsPost.md)
 - [CharactersCharacterIdFleetGet](docs/CharactersCharacterIdFleetGet.md)
 - [CharactersCharacterIdFwStatsGet](docs/CharactersCharacterIdFwStatsGet.md)
 - [CharactersCharacterIdFwStatsGetKills](docs/CharactersCharacterIdFwStatsGetKills.md)
 - [CharactersCharacterIdFwStatsGetVictoryPoints](docs/CharactersCharacterIdFwStatsGetVictoryPoints.md)
 - [CharactersCharacterIdGet](docs/CharactersCharacterIdGet.md)
 - [CharactersCharacterIdIndustryJobsGetInner](docs/CharactersCharacterIdIndustryJobsGetInner.md)
 - [CharactersCharacterIdKillmailsRecentGetInner](docs/CharactersCharacterIdKillmailsRecentGetInner.md)
 - [CharactersCharacterIdLocationGet](docs/CharactersCharacterIdLocationGet.md)
 - [CharactersCharacterIdLoyaltyPointsGetInner](docs/CharactersCharacterIdLoyaltyPointsGetInner.md)
 - [CharactersCharacterIdMailGetInner](docs/CharactersCharacterIdMailGetInner.md)
 - [CharactersCharacterIdMailLabelsGet](docs/CharactersCharacterIdMailLabelsGet.md)
 - [CharactersCharacterIdMailLabelsGetLabelsInner](docs/CharactersCharacterIdMailLabelsGetLabelsInner.md)
 - [CharactersCharacterIdMailListsGetInner](docs/CharactersCharacterIdMailListsGetInner.md)
 - [CharactersCharacterIdMailMailIdGet](docs/CharactersCharacterIdMailMailIdGet.md)
 - [CharactersCharacterIdMedalsGetInner](docs/CharactersCharacterIdMedalsGetInner.md)
 - [CharactersCharacterIdMedalsGetInnerGraphicsInner](docs/CharactersCharacterIdMedalsGetInnerGraphicsInner.md)
 - [CharactersCharacterIdMiningGetInner](docs/CharactersCharacterIdMiningGetInner.md)
 - [CharactersCharacterIdNotificationsContactsGetInner](docs/CharactersCharacterIdNotificationsContactsGetInner.md)
 - [CharactersCharacterIdNotificationsGetInner](docs/CharactersCharacterIdNotificationsGetInner.md)
 - [CharactersCharacterIdOnlineGet](docs/CharactersCharacterIdOnlineGet.md)
 - [CharactersCharacterIdOrdersGetInner](docs/CharactersCharacterIdOrdersGetInner.md)
 - [CharactersCharacterIdOrdersHistoryGetInner](docs/CharactersCharacterIdOrdersHistoryGetInner.md)
 - [CharactersCharacterIdPlanetsGetInner](docs/CharactersCharacterIdPlanetsGetInner.md)
 - [CharactersCharacterIdPlanetsPlanetIdGet](docs/CharactersCharacterIdPlanetsPlanetIdGet.md)
 - [CharactersCharacterIdPlanetsPlanetIdGetLinksInner](docs/CharactersCharacterIdPlanetsPlanetIdGetLinksInner.md)
 - [CharactersCharacterIdPlanetsPlanetIdGetPinsInner](docs/CharactersCharacterIdPlanetsPlanetIdGetPinsInner.md)
 - [CharactersCharacterIdPlanetsPlanetIdGetPinsInnerContentsInner](docs/CharactersCharacterIdPlanetsPlanetIdGetPinsInnerContentsInner.md)
 - [CharactersCharacterIdPlanetsPlanetIdGetPinsInnerExtractorDetails](docs/CharactersCharacterIdPlanetsPlanetIdGetPinsInnerExtractorDetails.md)
 - [CharactersCharacterIdPlanetsPlanetIdGetPinsInnerExtractorDetailsHeadsInner](docs/CharactersCharacterIdPlanetsPlanetIdGetPinsInnerExtractorDetailsHeadsInner.md)
 - [CharactersCharacterIdPlanetsPlanetIdGetPinsInnerFactoryDetails](docs/CharactersCharacterIdPlanetsPlanetIdGetPinsInnerFactoryDetails.md)
 - [CharactersCharacterIdPlanetsPlanetIdGetRoutesInner](docs/CharactersCharacterIdPlanetsPlanetIdGetRoutesInner.md)
 - [CharactersCharacterIdPortraitGet](docs/CharactersCharacterIdPortraitGet.md)
 - [CharactersCharacterIdRolesGet](docs/CharactersCharacterIdRolesGet.md)
 - [CharactersCharacterIdSearchGet](docs/CharactersCharacterIdSearchGet.md)
 - [CharactersCharacterIdShipGet](docs/CharactersCharacterIdShipGet.md)
 - [CharactersCharacterIdSkillqueueGetInner](docs/CharactersCharacterIdSkillqueueGetInner.md)
 - [CharactersCharacterIdSkillsGet](docs/CharactersCharacterIdSkillsGet.md)
 - [CharactersCharacterIdSkillsGetSkillsInner](docs/CharactersCharacterIdSkillsGetSkillsInner.md)
 - [CharactersCharacterIdStandingsGetInner](docs/CharactersCharacterIdStandingsGetInner.md)
 - [CharactersCharacterIdTitlesGetInner](docs/CharactersCharacterIdTitlesGetInner.md)
 - [CharactersCharacterIdWalletJournalGetInner](docs/CharactersCharacterIdWalletJournalGetInner.md)
 - [CharactersCharacterIdWalletTransactionsGetInner](docs/CharactersCharacterIdWalletTransactionsGetInner.md)
 - [ContractsPublicBidsContractIdGetInner](docs/ContractsPublicBidsContractIdGetInner.md)
 - [ContractsPublicItemsContractIdGetInner](docs/ContractsPublicItemsContractIdGetInner.md)
 - [ContractsPublicRegionIdGetInner](docs/ContractsPublicRegionIdGetInner.md)
 - [CorporationCorporationIdMiningExtractionsGetInner](docs/CorporationCorporationIdMiningExtractionsGetInner.md)
 - [CorporationCorporationIdMiningObserversGetInner](docs/CorporationCorporationIdMiningObserversGetInner.md)
 - [CorporationCorporationIdMiningObserversObserverIdGetInner](docs/CorporationCorporationIdMiningObserversObserverIdGetInner.md)
 - [CorporationsCorporationIdAlliancehistoryGetInner](docs/CorporationsCorporationIdAlliancehistoryGetInner.md)
 - [CorporationsCorporationIdAssetsGetInner](docs/CorporationsCorporationIdAssetsGetInner.md)
 - [CorporationsCorporationIdBlueprintsGetInner](docs/CorporationsCorporationIdBlueprintsGetInner.md)
 - [CorporationsCorporationIdContactsGetInner](docs/CorporationsCorporationIdContactsGetInner.md)
 - [CorporationsCorporationIdContainersLogsGetInner](docs/CorporationsCorporationIdContainersLogsGetInner.md)
 - [CorporationsCorporationIdContractsGetInner](docs/CorporationsCorporationIdContractsGetInner.md)
 - [CorporationsCorporationIdCustomsOfficesGetInner](docs/CorporationsCorporationIdCustomsOfficesGetInner.md)
 - [CorporationsCorporationIdDivisionsGet](docs/CorporationsCorporationIdDivisionsGet.md)
 - [CorporationsCorporationIdDivisionsGetHangarInner](docs/CorporationsCorporationIdDivisionsGetHangarInner.md)
 - [CorporationsCorporationIdDivisionsGetWalletInner](docs/CorporationsCorporationIdDivisionsGetWalletInner.md)
 - [CorporationsCorporationIdFacilitiesGetInner](docs/CorporationsCorporationIdFacilitiesGetInner.md)
 - [CorporationsCorporationIdFwStatsGet](docs/CorporationsCorporationIdFwStatsGet.md)
 - [CorporationsCorporationIdFwStatsGetKills](docs/CorporationsCorporationIdFwStatsGetKills.md)
 - [CorporationsCorporationIdFwStatsGetVictoryPoints](docs/CorporationsCorporationIdFwStatsGetVictoryPoints.md)
 - [CorporationsCorporationIdGet](docs/CorporationsCorporationIdGet.md)
 - [CorporationsCorporationIdIconsGet](docs/CorporationsCorporationIdIconsGet.md)
 - [CorporationsCorporationIdIndustryJobsGetInner](docs/CorporationsCorporationIdIndustryJobsGetInner.md)
 - [CorporationsCorporationIdMedalsGetInner](docs/CorporationsCorporationIdMedalsGetInner.md)
 - [CorporationsCorporationIdMedalsIssuedGetInner](docs/CorporationsCorporationIdMedalsIssuedGetInner.md)
 - [CorporationsCorporationIdMembersTitlesGetInner](docs/CorporationsCorporationIdMembersTitlesGetInner.md)
 - [CorporationsCorporationIdMembertrackingGetInner](docs/CorporationsCorporationIdMembertrackingGetInner.md)
 - [CorporationsCorporationIdOrdersGetInner](docs/CorporationsCorporationIdOrdersGetInner.md)
 - [CorporationsCorporationIdOrdersHistoryGetInner](docs/CorporationsCorporationIdOrdersHistoryGetInner.md)
 - [CorporationsCorporationIdRolesGetInner](docs/CorporationsCorporationIdRolesGetInner.md)
 - [CorporationsCorporationIdRolesHistoryGetInner](docs/CorporationsCorporationIdRolesHistoryGetInner.md)
 - [CorporationsCorporationIdShareholdersGetInner](docs/CorporationsCorporationIdShareholdersGetInner.md)
 - [CorporationsCorporationIdStarbasesGetInner](docs/CorporationsCorporationIdStarbasesGetInner.md)
 - [CorporationsCorporationIdStarbasesStarbaseIdGet](docs/CorporationsCorporationIdStarbasesStarbaseIdGet.md)
 - [CorporationsCorporationIdStarbasesStarbaseIdGetFuelsInner](docs/CorporationsCorporationIdStarbasesStarbaseIdGetFuelsInner.md)
 - [CorporationsCorporationIdStructuresGetInner](docs/CorporationsCorporationIdStructuresGetInner.md)
 - [CorporationsCorporationIdStructuresGetInnerServicesInner](docs/CorporationsCorporationIdStructuresGetInnerServicesInner.md)
 - [CorporationsCorporationIdTitlesGetInner](docs/CorporationsCorporationIdTitlesGetInner.md)
 - [CorporationsCorporationIdWalletsDivisionJournalGetInner](docs/CorporationsCorporationIdWalletsDivisionJournalGetInner.md)
 - [CorporationsCorporationIdWalletsDivisionTransactionsGetInner](docs/CorporationsCorporationIdWalletsDivisionTransactionsGetInner.md)
 - [CorporationsCorporationIdWalletsGetInner](docs/CorporationsCorporationIdWalletsGetInner.md)
 - [DogmaAttributesAttributeIdGet](docs/DogmaAttributesAttributeIdGet.md)
 - [DogmaDynamicItemsTypeIdItemIdGet](docs/DogmaDynamicItemsTypeIdItemIdGet.md)
 - [DogmaDynamicItemsTypeIdItemIdGetDogmaAttributesInner](docs/DogmaDynamicItemsTypeIdItemIdGetDogmaAttributesInner.md)
 - [DogmaDynamicItemsTypeIdItemIdGetDogmaEffectsInner](docs/DogmaDynamicItemsTypeIdItemIdGetDogmaEffectsInner.md)
 - [DogmaEffectsEffectIdGet](docs/DogmaEffectsEffectIdGet.md)
 - [DogmaEffectsEffectIdGetModifiersInner](docs/DogmaEffectsEffectIdGetModifiersInner.md)
 - [Error](docs/Error.md)
 - [ErrorDetail](docs/ErrorDetail.md)
 - [FleetsFleetIdGet](docs/FleetsFleetIdGet.md)
 - [FleetsFleetIdMembersGetInner](docs/FleetsFleetIdMembersGetInner.md)
 - [FleetsFleetIdWingsGetInner](docs/FleetsFleetIdWingsGetInner.md)
 - [FleetsFleetIdWingsGetInnerSquadsInner](docs/FleetsFleetIdWingsGetInnerSquadsInner.md)
 - [FleetsFleetIdWingsPost](docs/FleetsFleetIdWingsPost.md)
 - [FleetsFleetIdWingsWingIdSquadsPost](docs/FleetsFleetIdWingsWingIdSquadsPost.md)
 - [FwLeaderboardsCharactersGet](docs/FwLeaderboardsCharactersGet.md)
 - [FwLeaderboardsCharactersGetKills](docs/FwLeaderboardsCharactersGetKills.md)
 - [FwLeaderboardsCharactersGetKillsActiveTotalInner](docs/FwLeaderboardsCharactersGetKillsActiveTotalInner.md)
 - [FwLeaderboardsCharactersGetKillsLastWeekInner](docs/FwLeaderboardsCharactersGetKillsLastWeekInner.md)
 - [FwLeaderboardsCharactersGetKillsYesterdayInner](docs/FwLeaderboardsCharactersGetKillsYesterdayInner.md)
 - [FwLeaderboardsCharactersGetVictoryPoints](docs/FwLeaderboardsCharactersGetVictoryPoints.md)
 - [FwLeaderboardsCharactersGetVictoryPointsActiveTotalInner](docs/FwLeaderboardsCharactersGetVictoryPointsActiveTotalInner.md)
 - [FwLeaderboardsCharactersGetVictoryPointsLastWeekInner](docs/FwLeaderboardsCharactersGetVictoryPointsLastWeekInner.md)
 - [FwLeaderboardsCharactersGetVictoryPointsYesterdayInner](docs/FwLeaderboardsCharactersGetVictoryPointsYesterdayInner.md)
 - [FwLeaderboardsCorporationsGet](docs/FwLeaderboardsCorporationsGet.md)
 - [FwLeaderboardsCorporationsGetKills](docs/FwLeaderboardsCorporationsGetKills.md)
 - [FwLeaderboardsCorporationsGetKillsActiveTotalInner](docs/FwLeaderboardsCorporationsGetKillsActiveTotalInner.md)
 - [FwLeaderboardsCorporationsGetKillsLastWeekInner](docs/FwLeaderboardsCorporationsGetKillsLastWeekInner.md)
 - [FwLeaderboardsCorporationsGetKillsYesterdayInner](docs/FwLeaderboardsCorporationsGetKillsYesterdayInner.md)
 - [FwLeaderboardsCorporationsGetVictoryPoints](docs/FwLeaderboardsCorporationsGetVictoryPoints.md)
 - [FwLeaderboardsCorporationsGetVictoryPointsActiveTotalInner](docs/FwLeaderboardsCorporationsGetVictoryPointsActiveTotalInner.md)
 - [FwLeaderboardsCorporationsGetVictoryPointsLastWeekInner](docs/FwLeaderboardsCorporationsGetVictoryPointsLastWeekInner.md)
 - [FwLeaderboardsCorporationsGetVictoryPointsYesterdayInner](docs/FwLeaderboardsCorporationsGetVictoryPointsYesterdayInner.md)
 - [FwLeaderboardsGet](docs/FwLeaderboardsGet.md)
 - [FwLeaderboardsGetKills](docs/FwLeaderboardsGetKills.md)
 - [FwLeaderboardsGetKillsActiveTotalInner](docs/FwLeaderboardsGetKillsActiveTotalInner.md)
 - [FwLeaderboardsGetKillsLastWeekInner](docs/FwLeaderboardsGetKillsLastWeekInner.md)
 - [FwLeaderboardsGetKillsYesterdayInner](docs/FwLeaderboardsGetKillsYesterdayInner.md)
 - [FwLeaderboardsGetVictoryPoints](docs/FwLeaderboardsGetVictoryPoints.md)
 - [FwLeaderboardsGetVictoryPointsActiveTotalInner](docs/FwLeaderboardsGetVictoryPointsActiveTotalInner.md)
 - [FwLeaderboardsGetVictoryPointsLastWeekInner](docs/FwLeaderboardsGetVictoryPointsLastWeekInner.md)
 - [FwLeaderboardsGetVictoryPointsYesterdayInner](docs/FwLeaderboardsGetVictoryPointsYesterdayInner.md)
 - [FwStatsGetInner](docs/FwStatsGetInner.md)
 - [FwStatsGetInnerKills](docs/FwStatsGetInnerKills.md)
 - [FwStatsGetInnerVictoryPoints](docs/FwStatsGetInnerVictoryPoints.md)
 - [FwSystemsGetInner](docs/FwSystemsGetInner.md)
 - [FwWarsGetInner](docs/FwWarsGetInner.md)
 - [IncursionsGetInner](docs/IncursionsGetInner.md)
 - [IndustryFacilitiesGetInner](docs/IndustryFacilitiesGetInner.md)
 - [IndustrySystemsGetInner](docs/IndustrySystemsGetInner.md)
 - [IndustrySystemsGetInnerCostIndicesInner](docs/IndustrySystemsGetInnerCostIndicesInner.md)
 - [InsurancePricesGetInner](docs/InsurancePricesGetInner.md)
 - [InsurancePricesGetInnerLevelsInner](docs/InsurancePricesGetInnerLevelsInner.md)
 - [KillmailsKillmailIdKillmailHashGet](docs/KillmailsKillmailIdKillmailHashGet.md)
 - [KillmailsKillmailIdKillmailHashGetAttackersInner](docs/KillmailsKillmailIdKillmailHashGetAttackersInner.md)
 - [KillmailsKillmailIdKillmailHashGetVictim](docs/KillmailsKillmailIdKillmailHashGetVictim.md)
 - [KillmailsKillmailIdKillmailHashGetVictimItemsInner](docs/KillmailsKillmailIdKillmailHashGetVictimItemsInner.md)
 - [KillmailsKillmailIdKillmailHashGetVictimItemsInnerItemsInner](docs/KillmailsKillmailIdKillmailHashGetVictimItemsInnerItemsInner.md)
 - [KillmailsKillmailIdKillmailHashGetVictimPosition](docs/KillmailsKillmailIdKillmailHashGetVictimPosition.md)
 - [LoyaltyStoresCorporationIdOffersGetInner](docs/LoyaltyStoresCorporationIdOffersGetInner.md)
 - [LoyaltyStoresCorporationIdOffersGetInnerRequiredItemsInner](docs/LoyaltyStoresCorporationIdOffersGetInnerRequiredItemsInner.md)
 - [MarketsGroupsMarketGroupIdGet](docs/MarketsGroupsMarketGroupIdGet.md)
 - [MarketsPricesGetInner](docs/MarketsPricesGetInner.md)
 - [MarketsRegionIdHistoryGetInner](docs/MarketsRegionIdHistoryGetInner.md)
 - [MarketsRegionIdOrdersGetInner](docs/MarketsRegionIdOrdersGetInner.md)
 - [MarketsStructuresStructureIdGetInner](docs/MarketsStructuresStructureIdGetInner.md)
 - [MetaChangelog](docs/MetaChangelog.md)
 - [MetaChangelogEntry](docs/MetaChangelogEntry.md)
 - [MetaCompatibilityDates](docs/MetaCompatibilityDates.md)
 - [PostCharactersCharacterIdFittingsRequest](docs/PostCharactersCharacterIdFittingsRequest.md)
 - [PostCharactersCharacterIdFittingsRequestItemsInner](docs/PostCharactersCharacterIdFittingsRequestItemsInner.md)
 - [PostCharactersCharacterIdMailLabelsRequest](docs/PostCharactersCharacterIdMailLabelsRequest.md)
 - [PostCharactersCharacterIdMailRequest](docs/PostCharactersCharacterIdMailRequest.md)
 - [PostCharactersCharacterIdMailRequestRecipientsInner](docs/PostCharactersCharacterIdMailRequestRecipientsInner.md)
 - [PostFleetsFleetIdMembersRequest](docs/PostFleetsFleetIdMembersRequest.md)
 - [PostUiOpenwindowNewmailRequest](docs/PostUiOpenwindowNewmailRequest.md)
 - [PutCharactersCharacterIdCalendarEventIdRequest](docs/PutCharactersCharacterIdCalendarEventIdRequest.md)
 - [PutCharactersCharacterIdMailMailIdRequest](docs/PutCharactersCharacterIdMailMailIdRequest.md)
 - [PutFleetsFleetIdMembersMemberIdRequest](docs/PutFleetsFleetIdMembersMemberIdRequest.md)
 - [PutFleetsFleetIdRequest](docs/PutFleetsFleetIdRequest.md)
 - [PutFleetsFleetIdSquadsSquadIdRequest](docs/PutFleetsFleetIdSquadsSquadIdRequest.md)
 - [SovereigntyCampaignsGetInner](docs/SovereigntyCampaignsGetInner.md)
 - [SovereigntyCampaignsGetInnerParticipantsInner](docs/SovereigntyCampaignsGetInnerParticipantsInner.md)
 - [SovereigntyMapGetInner](docs/SovereigntyMapGetInner.md)
 - [SovereigntyStructuresGetInner](docs/SovereigntyStructuresGetInner.md)
 - [StatusGet](docs/StatusGet.md)
 - [UniverseAncestriesGetInner](docs/UniverseAncestriesGetInner.md)
 - [UniverseAsteroidBeltsAsteroidBeltIdGet](docs/UniverseAsteroidBeltsAsteroidBeltIdGet.md)
 - [UniverseBloodlinesGetInner](docs/UniverseBloodlinesGetInner.md)
 - [UniverseCategoriesCategoryIdGet](docs/UniverseCategoriesCategoryIdGet.md)
 - [UniverseConstellationsConstellationIdGet](docs/UniverseConstellationsConstellationIdGet.md)
 - [UniverseFactionsGetInner](docs/UniverseFactionsGetInner.md)
 - [UniverseGraphicsGraphicIdGet](docs/UniverseGraphicsGraphicIdGet.md)
 - [UniverseGroupsGroupIdGet](docs/UniverseGroupsGroupIdGet.md)
 - [UniverseIdsPost](docs/UniverseIdsPost.md)
 - [UniverseIdsPostAgentsInner](docs/UniverseIdsPostAgentsInner.md)
 - [UniverseIdsPostAlliancesInner](docs/UniverseIdsPostAlliancesInner.md)
 - [UniverseIdsPostCharactersInner](docs/UniverseIdsPostCharactersInner.md)
 - [UniverseIdsPostConstellationsInner](docs/UniverseIdsPostConstellationsInner.md)
 - [UniverseIdsPostCorporationsInner](docs/UniverseIdsPostCorporationsInner.md)
 - [UniverseIdsPostFactionsInner](docs/UniverseIdsPostFactionsInner.md)
 - [UniverseIdsPostInventoryTypesInner](docs/UniverseIdsPostInventoryTypesInner.md)
 - [UniverseIdsPostRegionsInner](docs/UniverseIdsPostRegionsInner.md)
 - [UniverseIdsPostStationsInner](docs/UniverseIdsPostStationsInner.md)
 - [UniverseIdsPostSystemsInner](docs/UniverseIdsPostSystemsInner.md)
 - [UniverseMoonsMoonIdGet](docs/UniverseMoonsMoonIdGet.md)
 - [UniverseNamesPostInner](docs/UniverseNamesPostInner.md)
 - [UniversePlanetsPlanetIdGet](docs/UniversePlanetsPlanetIdGet.md)
 - [UniverseRacesGetInner](docs/UniverseRacesGetInner.md)
 - [UniverseRegionsRegionIdGet](docs/UniverseRegionsRegionIdGet.md)
 - [UniverseSchematicsSchematicIdGet](docs/UniverseSchematicsSchematicIdGet.md)
 - [UniverseStargatesStargateIdGet](docs/UniverseStargatesStargateIdGet.md)
 - [UniverseStargatesStargateIdGetDestination](docs/UniverseStargatesStargateIdGetDestination.md)
 - [UniverseStarsStarIdGet](docs/UniverseStarsStarIdGet.md)
 - [UniverseStationsStationIdGet](docs/UniverseStationsStationIdGet.md)
 - [UniverseStructuresStructureIdGet](docs/UniverseStructuresStructureIdGet.md)
 - [UniverseStructuresStructureIdGetPosition](docs/UniverseStructuresStructureIdGetPosition.md)
 - [UniverseSystemJumpsGetInner](docs/UniverseSystemJumpsGetInner.md)
 - [UniverseSystemKillsGetInner](docs/UniverseSystemKillsGetInner.md)
 - [UniverseSystemsSystemIdGet](docs/UniverseSystemsSystemIdGet.md)
 - [UniverseSystemsSystemIdGetPlanetsInner](docs/UniverseSystemsSystemIdGetPlanetsInner.md)
 - [UniverseTypesTypeIdGet](docs/UniverseTypesTypeIdGet.md)
 - [WarsWarIdGet](docs/WarsWarIdGet.md)
 - [WarsWarIdGetAggressor](docs/WarsWarIdGetAggressor.md)
 - [WarsWarIdGetAlliesInner](docs/WarsWarIdGetAlliesInner.md)
 - [WarsWarIdGetDefender](docs/WarsWarIdGetDefender.md)


<a id="documentation-for-authorization"></a>
## Documentation For Authorization


Authentication schemes defined for the API:
<a id="OAuth2"></a>
### OAuth2

- **Type**: OAuth
- **Flow**: accessCode
- **Authorization URL**: https://login.eveonline.com/v2/oauth/authorize
- **Scopes**: 
 - **esi-alliances.read_contacts.v1**: esi-alliances.read_contacts.v1
 - **esi-assets.read_assets.v1**: esi-assets.read_assets.v1
 - **esi-assets.read_corporation_assets.v1**: esi-assets.read_corporation_assets.v1
 - **esi-calendar.read_calendar_events.v1**: esi-calendar.read_calendar_events.v1
 - **esi-calendar.respond_calendar_events.v1**: esi-calendar.respond_calendar_events.v1
 - **esi-characters.read_agents_research.v1**: esi-characters.read_agents_research.v1
 - **esi-characters.read_blueprints.v1**: esi-characters.read_blueprints.v1
 - **esi-characters.read_contacts.v1**: esi-characters.read_contacts.v1
 - **esi-characters.read_corporation_roles.v1**: esi-characters.read_corporation_roles.v1
 - **esi-characters.read_fatigue.v1**: esi-characters.read_fatigue.v1
 - **esi-characters.read_fw_stats.v1**: esi-characters.read_fw_stats.v1
 - **esi-characters.read_loyalty.v1**: esi-characters.read_loyalty.v1
 - **esi-characters.read_medals.v1**: esi-characters.read_medals.v1
 - **esi-characters.read_notifications.v1**: esi-characters.read_notifications.v1
 - **esi-characters.read_standings.v1**: esi-characters.read_standings.v1
 - **esi-characters.read_titles.v1**: esi-characters.read_titles.v1
 - **esi-characters.write_contacts.v1**: esi-characters.write_contacts.v1
 - **esi-clones.read_clones.v1**: esi-clones.read_clones.v1
 - **esi-clones.read_implants.v1**: esi-clones.read_implants.v1
 - **esi-contracts.read_character_contracts.v1**: esi-contracts.read_character_contracts.v1
 - **esi-contracts.read_corporation_contracts.v1**: esi-contracts.read_corporation_contracts.v1
 - **esi-corporations.read_blueprints.v1**: esi-corporations.read_blueprints.v1
 - **esi-corporations.read_contacts.v1**: esi-corporations.read_contacts.v1
 - **esi-corporations.read_container_logs.v1**: esi-corporations.read_container_logs.v1
 - **esi-corporations.read_corporation_membership.v1**: esi-corporations.read_corporation_membership.v1
 - **esi-corporations.read_divisions.v1**: esi-corporations.read_divisions.v1
 - **esi-corporations.read_facilities.v1**: esi-corporations.read_facilities.v1
 - **esi-corporations.read_fw_stats.v1**: esi-corporations.read_fw_stats.v1
 - **esi-corporations.read_medals.v1**: esi-corporations.read_medals.v1
 - **esi-corporations.read_projects.v1**: esi-corporations.read_projects.v1
 - **esi-corporations.read_standings.v1**: esi-corporations.read_standings.v1
 - **esi-corporations.read_starbases.v1**: esi-corporations.read_starbases.v1
 - **esi-corporations.read_structures.v1**: esi-corporations.read_structures.v1
 - **esi-corporations.read_titles.v1**: esi-corporations.read_titles.v1
 - **esi-corporations.track_members.v1**: esi-corporations.track_members.v1
 - **esi-fittings.read_fittings.v1**: esi-fittings.read_fittings.v1
 - **esi-fittings.write_fittings.v1**: esi-fittings.write_fittings.v1
 - **esi-fleets.read_fleet.v1**: esi-fleets.read_fleet.v1
 - **esi-fleets.write_fleet.v1**: esi-fleets.write_fleet.v1
 - **esi-industry.read_character_jobs.v1**: esi-industry.read_character_jobs.v1
 - **esi-industry.read_character_mining.v1**: esi-industry.read_character_mining.v1
 - **esi-industry.read_corporation_jobs.v1**: esi-industry.read_corporation_jobs.v1
 - **esi-industry.read_corporation_mining.v1**: esi-industry.read_corporation_mining.v1
 - **esi-killmails.read_corporation_killmails.v1**: esi-killmails.read_corporation_killmails.v1
 - **esi-killmails.read_killmails.v1**: esi-killmails.read_killmails.v1
 - **esi-location.read_location.v1**: esi-location.read_location.v1
 - **esi-location.read_online.v1**: esi-location.read_online.v1
 - **esi-location.read_ship_type.v1**: esi-location.read_ship_type.v1
 - **esi-mail.organize_mail.v1**: esi-mail.organize_mail.v1
 - **esi-mail.read_mail.v1**: esi-mail.read_mail.v1
 - **esi-mail.send_mail.v1**: esi-mail.send_mail.v1
 - **esi-markets.read_character_orders.v1**: esi-markets.read_character_orders.v1
 - **esi-markets.read_corporation_orders.v1**: esi-markets.read_corporation_orders.v1
 - **esi-markets.structure_markets.v1**: esi-markets.structure_markets.v1
 - **esi-planets.manage_planets.v1**: esi-planets.manage_planets.v1
 - **esi-planets.read_customs_offices.v1**: esi-planets.read_customs_offices.v1
 - **esi-search.search_structures.v1**: esi-search.search_structures.v1
 - **esi-skills.read_skillqueue.v1**: esi-skills.read_skillqueue.v1
 - **esi-skills.read_skills.v1**: esi-skills.read_skills.v1
 - **esi-ui.open_window.v1**: esi-ui.open_window.v1
 - **esi-ui.write_waypoint.v1**: esi-ui.write_waypoint.v1
 - **esi-universe.read_structures.v1**: esi-universe.read_structures.v1
 - **esi-wallet.read_character_wallet.v1**: esi-wallet.read_character_wallet.v1
 - **esi-wallet.read_corporation_wallets.v1**: esi-wallet.read_corporation_wallets.v1


## Author

arxbombus@gmail.com


