# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import date
from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from pyesi_openapi.models.characters_character_id_assets_get_inner import CharactersCharacterIdAssetsGetInner
from pyesi_openapi.models.characters_character_id_assets_locations_post_inner import CharactersCharacterIdAssetsLocationsPostInner
from pyesi_openapi.models.characters_character_id_assets_names_post_inner import CharactersCharacterIdAssetsNamesPostInner
from pyesi_openapi.models.corporations_corporation_id_assets_get_inner import CorporationsCorporationIdAssetsGetInner

from pyesi_openapi.api_client import ApiClient, RequestSerialized
from pyesi_openapi.api_response import ApiResponse
from pyesi_openapi.rest import RESTResponseType


class AssetsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_characters_character_id_assets(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdAssetsGetInner]:
        """Get character assets

        Return a list of the characters assets

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_assets_serialize(
            character_id=character_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_assets_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdAssetsGetInner]]:
        """Get character assets

        Return a list of the characters assets

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_assets_serialize(
            character_id=character_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_assets_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get character assets

        Return a list of the characters assets

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_assets_serialize(
            character_id=character_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_assets_serialize(
        self,
        character_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/assets',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_assets(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdAssetsGetInner]:
        """Get corporation assets

        Return a list of the corporation assets

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_assets_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdAssetsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_assets_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdAssetsGetInner]]:
        """Get corporation assets

        Return a list of the corporation assets

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_assets_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdAssetsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_assets_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation assets

        Return a list of the corporation assets

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_assets_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdAssetsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_assets_serialize(
        self,
        corporation_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/assets',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_characters_character_id_assets_locations(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdAssetsLocationsPostInner]:
        """Get character asset locations

        Return locations for a set of item ids, which you can get from character assets endpoint. Coordinates for items in hangars or stations are set to (0,0,0)

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_character_id_assets_locations_serialize(
            character_id=character_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsLocationsPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_characters_character_id_assets_locations_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdAssetsLocationsPostInner]]:
        """Get character asset locations

        Return locations for a set of item ids, which you can get from character assets endpoint. Coordinates for items in hangars or stations are set to (0,0,0)

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_character_id_assets_locations_serialize(
            character_id=character_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsLocationsPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_characters_character_id_assets_locations_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get character asset locations

        Return locations for a set of item ids, which you can get from character assets endpoint. Coordinates for items in hangars or stations are set to (0,0,0)

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_character_id_assets_locations_serialize(
            character_id=character_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsLocationsPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_characters_character_id_assets_locations_serialize(
        self,
        character_id,
        request_body,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'request_body': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/characters/{character_id}/assets/locations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_characters_character_id_assets_names(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdAssetsNamesPostInner]:
        """Get character asset names

        Return names for a set of item ids, which you can get from character assets endpoint. Typically used for items that can customize names, like containers or ships.

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_character_id_assets_names_serialize(
            character_id=character_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsNamesPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_characters_character_id_assets_names_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdAssetsNamesPostInner]]:
        """Get character asset names

        Return names for a set of item ids, which you can get from character assets endpoint. Typically used for items that can customize names, like containers or ships.

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_character_id_assets_names_serialize(
            character_id=character_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsNamesPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_characters_character_id_assets_names_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get character asset names

        Return names for a set of item ids, which you can get from character assets endpoint. Typically used for items that can customize names, like containers or ships.

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_character_id_assets_names_serialize(
            character_id=character_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsNamesPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_characters_character_id_assets_names_serialize(
        self,
        character_id,
        request_body,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'request_body': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/characters/{character_id}/assets/names',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_corporations_corporation_id_assets_locations(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdAssetsLocationsPostInner]:
        """Get corporation asset locations

        Return locations for a set of item ids, which you can get from corporation assets endpoint. Coordinates for items in hangars or stations are set to (0,0,0)

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_corporations_corporation_id_assets_locations_serialize(
            corporation_id=corporation_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsLocationsPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_corporations_corporation_id_assets_locations_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdAssetsLocationsPostInner]]:
        """Get corporation asset locations

        Return locations for a set of item ids, which you can get from corporation assets endpoint. Coordinates for items in hangars or stations are set to (0,0,0)

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_corporations_corporation_id_assets_locations_serialize(
            corporation_id=corporation_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsLocationsPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_corporations_corporation_id_assets_locations_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation asset locations

        Return locations for a set of item ids, which you can get from corporation assets endpoint. Coordinates for items in hangars or stations are set to (0,0,0)

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_corporations_corporation_id_assets_locations_serialize(
            corporation_id=corporation_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsLocationsPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_corporations_corporation_id_assets_locations_serialize(
        self,
        corporation_id,
        request_body,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'request_body': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/corporations/{corporation_id}/assets/locations',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_corporations_corporation_id_assets_names(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdAssetsNamesPostInner]:
        """Get corporation asset names

        Return names for a set of item ids, which you can get from corporation assets endpoint. Only valid for items that can customize names, like containers or ships

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_corporations_corporation_id_assets_names_serialize(
            corporation_id=corporation_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsNamesPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_corporations_corporation_id_assets_names_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdAssetsNamesPostInner]]:
        """Get corporation asset names

        Return names for a set of item ids, which you can get from corporation assets endpoint. Only valid for items that can customize names, like containers or ships

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_corporations_corporation_id_assets_names_serialize(
            corporation_id=corporation_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsNamesPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_corporations_corporation_id_assets_names_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation asset names

        Return names for a set of item ids, which you can get from corporation assets endpoint. Only valid for items that can customize names, like containers or ships

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_corporations_corporation_id_assets_names_serialize(
            corporation_id=corporation_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAssetsNamesPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_corporations_corporation_id_assets_names_serialize(
        self,
        corporation_id,
        request_body,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'request_body': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/corporations/{corporation_id}/assets/names',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


