# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import date
from pydantic import Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import List, Optional, Union
from typing_extensions import Annotated
from pyesi_openapi.models.characters_affiliation_post_inner import CharactersAffiliationPostInner
from pyesi_openapi.models.characters_character_id_agents_research_get_inner import CharactersCharacterIdAgentsResearchGetInner
from pyesi_openapi.models.characters_character_id_blueprints_get_inner import CharactersCharacterIdBlueprintsGetInner
from pyesi_openapi.models.characters_character_id_corporationhistory_get_inner import CharactersCharacterIdCorporationhistoryGetInner
from pyesi_openapi.models.characters_character_id_fatigue_get import CharactersCharacterIdFatigueGet
from pyesi_openapi.models.characters_character_id_get import CharactersCharacterIdGet
from pyesi_openapi.models.characters_character_id_medals_get_inner import CharactersCharacterIdMedalsGetInner
from pyesi_openapi.models.characters_character_id_notifications_contacts_get_inner import CharactersCharacterIdNotificationsContactsGetInner
from pyesi_openapi.models.characters_character_id_notifications_get_inner import CharactersCharacterIdNotificationsGetInner
from pyesi_openapi.models.characters_character_id_portrait_get import CharactersCharacterIdPortraitGet
from pyesi_openapi.models.characters_character_id_roles_get import CharactersCharacterIdRolesGet
from pyesi_openapi.models.characters_character_id_standings_get_inner import CharactersCharacterIdStandingsGetInner
from pyesi_openapi.models.characters_character_id_titles_get_inner import CharactersCharacterIdTitlesGetInner

from pyesi_openapi.api_client import ApiClient, RequestSerialized
from pyesi_openapi.api_response import ApiResponse
from pyesi_openapi.rest import RESTResponseType


class CharacterApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_characters_character_id(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CharactersCharacterIdGet:
        """Get character's public information

        Public information about a character

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CharactersCharacterIdGet]:
        """Get character's public information

        Public information about a character

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get character's public information

        Public information about a character

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_serialize(
        self,
        character_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_agents_research(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdAgentsResearchGetInner]:
        """Get agents research

        Return a list of agents research information for a character. The formula for finding the current research points with an agent is: currentPoints = remainderPoints + pointsPerDay * days(currentTime - researchStartDate)

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_agents_research_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAgentsResearchGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_agents_research_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdAgentsResearchGetInner]]:
        """Get agents research

        Return a list of agents research information for a character. The formula for finding the current research points with an agent is: currentPoints = remainderPoints + pointsPerDay * days(currentTime - researchStartDate)

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_agents_research_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAgentsResearchGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_agents_research_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get agents research

        Return a list of agents research information for a character. The formula for finding the current research points with an agent is: currentPoints = remainderPoints + pointsPerDay * days(currentTime - researchStartDate)

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_agents_research_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdAgentsResearchGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_agents_research_serialize(
        self,
        character_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/agents_research',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_blueprints(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdBlueprintsGetInner]:
        """Get blueprints

        Return a list of blueprints the character owns

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_blueprints_serialize(
            character_id=character_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdBlueprintsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_blueprints_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdBlueprintsGetInner]]:
        """Get blueprints

        Return a list of blueprints the character owns

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_blueprints_serialize(
            character_id=character_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdBlueprintsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_blueprints_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get blueprints

        Return a list of blueprints the character owns

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_blueprints_serialize(
            character_id=character_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdBlueprintsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_blueprints_serialize(
        self,
        character_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/blueprints',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_corporationhistory(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdCorporationhistoryGetInner]:
        """Get corporation history

        Get a list of all the corporations a character has been a member of

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_corporationhistory_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdCorporationhistoryGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_corporationhistory_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdCorporationhistoryGetInner]]:
        """Get corporation history

        Get a list of all the corporations a character has been a member of

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_corporationhistory_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdCorporationhistoryGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_corporationhistory_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation history

        Get a list of all the corporations a character has been a member of

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_corporationhistory_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdCorporationhistoryGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_corporationhistory_serialize(
        self,
        character_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/corporationhistory',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_fatigue(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CharactersCharacterIdFatigueGet:
        """Get jump fatigue

        Return a character's jump activation and fatigue information

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_fatigue_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdFatigueGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_fatigue_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CharactersCharacterIdFatigueGet]:
        """Get jump fatigue

        Return a character's jump activation and fatigue information

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_fatigue_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdFatigueGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_fatigue_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get jump fatigue

        Return a character's jump activation and fatigue information

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_fatigue_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdFatigueGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_fatigue_serialize(
        self,
        character_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/fatigue',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_medals(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdMedalsGetInner]:
        """Get medals

        Return a list of medals the character has

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_medals_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdMedalsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_medals_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdMedalsGetInner]]:
        """Get medals

        Return a list of medals the character has

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_medals_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdMedalsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_medals_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get medals

        Return a list of medals the character has

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_medals_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdMedalsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_medals_serialize(
        self,
        character_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/medals',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_notifications(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdNotificationsGetInner]:
        """Get character notifications

        Return character notifications

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_notifications_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdNotificationsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_notifications_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdNotificationsGetInner]]:
        """Get character notifications

        Return character notifications

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_notifications_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdNotificationsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_notifications_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get character notifications

        Return character notifications

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_notifications_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdNotificationsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_notifications_serialize(
        self,
        character_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/notifications',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_notifications_contacts(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdNotificationsContactsGetInner]:
        """Get new contact notifications

        Return notifications about having been added to someone's contact list

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_notifications_contacts_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdNotificationsContactsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_notifications_contacts_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdNotificationsContactsGetInner]]:
        """Get new contact notifications

        Return notifications about having been added to someone's contact list

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_notifications_contacts_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdNotificationsContactsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_notifications_contacts_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get new contact notifications

        Return notifications about having been added to someone's contact list

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_notifications_contacts_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdNotificationsContactsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_notifications_contacts_serialize(
        self,
        character_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/notifications/contacts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_portrait(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CharactersCharacterIdPortraitGet:
        """Get character portraits

        Get portrait urls for a character  This route expires daily at 11:05

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_portrait_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdPortraitGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_portrait_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CharactersCharacterIdPortraitGet]:
        """Get character portraits

        Get portrait urls for a character  This route expires daily at 11:05

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_portrait_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdPortraitGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_portrait_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get character portraits

        Get portrait urls for a character  This route expires daily at 11:05

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_portrait_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdPortraitGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_portrait_serialize(
        self,
        character_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/portrait',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_roles(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CharactersCharacterIdRolesGet:
        """Get character corporation roles

        Returns a character's corporation roles

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_roles_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdRolesGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_roles_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CharactersCharacterIdRolesGet]:
        """Get character corporation roles

        Returns a character's corporation roles

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_roles_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdRolesGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_roles_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get character corporation roles

        Returns a character's corporation roles

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_roles_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdRolesGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_roles_serialize(
        self,
        character_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/roles',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_standings(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdStandingsGetInner]:
        """Get standings

        Return character standings from agents, NPC corporations, and factions

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_standings_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdStandingsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_standings_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdStandingsGetInner]]:
        """Get standings

        Return character standings from agents, NPC corporations, and factions

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_standings_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdStandingsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_standings_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get standings

        Return character standings from agents, NPC corporations, and factions

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_standings_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdStandingsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_standings_serialize(
        self,
        character_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/standings',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_titles(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdTitlesGetInner]:
        """Get character corporation titles

        Returns a character's titles

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_titles_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdTitlesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_titles_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdTitlesGetInner]]:
        """Get character corporation titles

        Returns a character's titles

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_titles_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdTitlesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_titles_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get character corporation titles

        Returns a character's titles

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_titles_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdTitlesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_titles_serialize(
        self,
        character_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/titles',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_characters_affiliation(
        self,
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersAffiliationPostInner]:
        """Character affiliation

        Bulk lookup of character IDs to corporation, alliance and faction

        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_affiliation_serialize(
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersAffiliationPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_characters_affiliation_with_http_info(
        self,
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersAffiliationPostInner]]:
        """Character affiliation

        Bulk lookup of character IDs to corporation, alliance and faction

        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_affiliation_serialize(
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersAffiliationPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_characters_affiliation_without_preload_content(
        self,
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=1000)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Character affiliation

        Bulk lookup of character IDs to corporation, alliance and faction

        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_affiliation_serialize(
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersAffiliationPostInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_characters_affiliation_serialize(
        self,
        request_body,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'request_body': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/characters/affiliation',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_characters_character_id_cspa(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=100)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> float:
        """Calculate a CSPA charge cost

        Takes a source character ID in the url and a set of target character ID's in the body, returns a CSPA charge cost

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_character_id_cspa_serialize(
            character_id=character_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "float",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_characters_character_id_cspa_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=100)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[float]:
        """Calculate a CSPA charge cost

        Takes a source character ID in the url and a set of target character ID's in the body, returns a CSPA charge cost

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_character_id_cspa_serialize(
            character_id=character_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "float",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_characters_character_id_cspa_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=100)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Calculate a CSPA charge cost

        Takes a source character ID in the url and a set of target character ID's in the body, returns a CSPA charge cost

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param request_body: (required)
        :type request_body: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_character_id_cspa_serialize(
            character_id=character_id,
            request_body=request_body,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "float",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_characters_character_id_cspa_serialize(
        self,
        character_id,
        request_body,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'request_body': '',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/characters/{character_id}/cspa',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


