# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import date
from pydantic import Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import List, Optional, Union
from typing_extensions import Annotated
from pyesi_openapi.models.alliances_alliance_id_contacts_get_inner import AlliancesAllianceIdContactsGetInner
from pyesi_openapi.models.alliances_alliance_id_contacts_labels_get_inner import AlliancesAllianceIdContactsLabelsGetInner
from pyesi_openapi.models.characters_character_id_contacts_get_inner import CharactersCharacterIdContactsGetInner
from pyesi_openapi.models.corporations_corporation_id_contacts_get_inner import CorporationsCorporationIdContactsGetInner

from pyesi_openapi.api_client import ApiClient, RequestSerialized
from pyesi_openapi.api_response import ApiResponse
from pyesi_openapi.rest import RESTResponseType


class ContactsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def delete_characters_character_id_contacts(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        contact_ids: Annotated[List[StrictInt], Field(min_length=1, max_length=20)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete contacts

        Bulk delete contacts

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param contact_ids: (required)
        :type contact_ids: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_characters_character_id_contacts_serialize(
            character_id=character_id,
            contact_ids=contact_ids,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_characters_character_id_contacts_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        contact_ids: Annotated[List[StrictInt], Field(min_length=1, max_length=20)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete contacts

        Bulk delete contacts

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param contact_ids: (required)
        :type contact_ids: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_characters_character_id_contacts_serialize(
            character_id=character_id,
            contact_ids=contact_ids,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_characters_character_id_contacts_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        contact_ids: Annotated[List[StrictInt], Field(min_length=1, max_length=20)],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete contacts

        Bulk delete contacts

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param contact_ids: (required)
        :type contact_ids: List[int]
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_characters_character_id_contacts_serialize(
            character_id=character_id,
            contact_ids=contact_ids,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_characters_character_id_contacts_serialize(
        self,
        character_id,
        contact_ids,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'contact_ids': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        if contact_ids is not None:
            
            _query_params.append(('contact_ids', contact_ids))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/characters/{character_id}/contacts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_alliances_alliance_id_contacts(
        self,
        alliance_id: Annotated[StrictInt, Field(description="The ID of the alliance")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[AlliancesAllianceIdContactsGetInner]:
        """Get alliance contacts

        Return contacts of an alliance

        :param alliance_id: The ID of the alliance (required)
        :type alliance_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alliances_alliance_id_contacts_serialize(
            alliance_id=alliance_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlliancesAllianceIdContactsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_alliances_alliance_id_contacts_with_http_info(
        self,
        alliance_id: Annotated[StrictInt, Field(description="The ID of the alliance")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[AlliancesAllianceIdContactsGetInner]]:
        """Get alliance contacts

        Return contacts of an alliance

        :param alliance_id: The ID of the alliance (required)
        :type alliance_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alliances_alliance_id_contacts_serialize(
            alliance_id=alliance_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlliancesAllianceIdContactsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_alliances_alliance_id_contacts_without_preload_content(
        self,
        alliance_id: Annotated[StrictInt, Field(description="The ID of the alliance")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get alliance contacts

        Return contacts of an alliance

        :param alliance_id: The ID of the alliance (required)
        :type alliance_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alliances_alliance_id_contacts_serialize(
            alliance_id=alliance_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlliancesAllianceIdContactsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_alliances_alliance_id_contacts_serialize(
        self,
        alliance_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if alliance_id is not None:
            _path_params['alliance_id'] = alliance_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/alliances/{alliance_id}/contacts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_alliances_alliance_id_contacts_labels(
        self,
        alliance_id: Annotated[StrictInt, Field(description="The ID of the alliance")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[AlliancesAllianceIdContactsLabelsGetInner]:
        """Get alliance contact labels

        Return custom labels for an alliance's contacts

        :param alliance_id: The ID of the alliance (required)
        :type alliance_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alliances_alliance_id_contacts_labels_serialize(
            alliance_id=alliance_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlliancesAllianceIdContactsLabelsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_alliances_alliance_id_contacts_labels_with_http_info(
        self,
        alliance_id: Annotated[StrictInt, Field(description="The ID of the alliance")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[AlliancesAllianceIdContactsLabelsGetInner]]:
        """Get alliance contact labels

        Return custom labels for an alliance's contacts

        :param alliance_id: The ID of the alliance (required)
        :type alliance_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alliances_alliance_id_contacts_labels_serialize(
            alliance_id=alliance_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlliancesAllianceIdContactsLabelsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_alliances_alliance_id_contacts_labels_without_preload_content(
        self,
        alliance_id: Annotated[StrictInt, Field(description="The ID of the alliance")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get alliance contact labels

        Return custom labels for an alliance's contacts

        :param alliance_id: The ID of the alliance (required)
        :type alliance_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_alliances_alliance_id_contacts_labels_serialize(
            alliance_id=alliance_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlliancesAllianceIdContactsLabelsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_alliances_alliance_id_contacts_labels_serialize(
        self,
        alliance_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if alliance_id is not None:
            _path_params['alliance_id'] = alliance_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/alliances/{alliance_id}/contacts/labels',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_contacts(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdContactsGetInner]:
        """Get contacts

        Return contacts of a character

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_contacts_serialize(
            character_id=character_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdContactsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_contacts_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdContactsGetInner]]:
        """Get contacts

        Return contacts of a character

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_contacts_serialize(
            character_id=character_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdContactsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_contacts_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get contacts

        Return contacts of a character

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_contacts_serialize(
            character_id=character_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdContactsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_contacts_serialize(
        self,
        character_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/contacts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_contacts_labels(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[AlliancesAllianceIdContactsLabelsGetInner]:
        """Get contact labels

        Return custom labels for a character's contacts

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_contacts_labels_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlliancesAllianceIdContactsLabelsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_contacts_labels_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[AlliancesAllianceIdContactsLabelsGetInner]]:
        """Get contact labels

        Return custom labels for a character's contacts

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_contacts_labels_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlliancesAllianceIdContactsLabelsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_contacts_labels_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get contact labels

        Return custom labels for a character's contacts

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_contacts_labels_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlliancesAllianceIdContactsLabelsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_contacts_labels_serialize(
        self,
        character_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/contacts/labels',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_contacts(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdContactsGetInner]:
        """Get corporation contacts

        Return contacts of a corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_contacts_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdContactsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_contacts_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdContactsGetInner]]:
        """Get corporation contacts

        Return contacts of a corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_contacts_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdContactsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_contacts_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation contacts

        Return contacts of a corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_contacts_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdContactsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_contacts_serialize(
        self,
        corporation_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/contacts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_contacts_labels(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[AlliancesAllianceIdContactsLabelsGetInner]:
        """Get corporation contact labels

        Return custom labels for a corporation's contacts

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_contacts_labels_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlliancesAllianceIdContactsLabelsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_contacts_labels_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[AlliancesAllianceIdContactsLabelsGetInner]]:
        """Get corporation contact labels

        Return custom labels for a corporation's contacts

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_contacts_labels_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlliancesAllianceIdContactsLabelsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_contacts_labels_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation contact labels

        Return custom labels for a corporation's contacts

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_contacts_labels_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[AlliancesAllianceIdContactsLabelsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_contacts_labels_serialize(
        self,
        corporation_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/contacts/labels',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_characters_character_id_contacts(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        standing: Union[StrictFloat, StrictInt],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=100)],
        label_ids: Optional[Annotated[List[StrictInt], Field(max_length=63)]] = None,
        watched: Optional[StrictBool] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[int]:
        """Add contacts

        Bulk add contacts with same settings

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param standing: (required)
        :type standing: float
        :param request_body: (required)
        :type request_body: List[int]
        :param label_ids:
        :type label_ids: List[int]
        :param watched:
        :type watched: bool
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_character_id_contacts_serialize(
            character_id=character_id,
            standing=standing,
            request_body=request_body,
            label_ids=label_ids,
            watched=watched,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "List[int]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_characters_character_id_contacts_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        standing: Union[StrictFloat, StrictInt],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=100)],
        label_ids: Optional[Annotated[List[StrictInt], Field(max_length=63)]] = None,
        watched: Optional[StrictBool] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[int]]:
        """Add contacts

        Bulk add contacts with same settings

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param standing: (required)
        :type standing: float
        :param request_body: (required)
        :type request_body: List[int]
        :param label_ids:
        :type label_ids: List[int]
        :param watched:
        :type watched: bool
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_character_id_contacts_serialize(
            character_id=character_id,
            standing=standing,
            request_body=request_body,
            label_ids=label_ids,
            watched=watched,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "List[int]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_characters_character_id_contacts_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        standing: Union[StrictFloat, StrictInt],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=100)],
        label_ids: Optional[Annotated[List[StrictInt], Field(max_length=63)]] = None,
        watched: Optional[StrictBool] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Add contacts

        Bulk add contacts with same settings

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param standing: (required)
        :type standing: float
        :param request_body: (required)
        :type request_body: List[int]
        :param label_ids:
        :type label_ids: List[int]
        :param watched:
        :type watched: bool
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_characters_character_id_contacts_serialize(
            character_id=character_id,
            standing=standing,
            request_body=request_body,
            label_ids=label_ids,
            watched=watched,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "List[int]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_characters_character_id_contacts_serialize(
        self,
        character_id,
        standing,
        request_body,
        label_ids,
        watched,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'request_body': '',
            'label_ids': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        if label_ids is not None:
            
            _query_params.append(('label_ids', label_ids))
            
        if standing is not None:
            
            _query_params.append(('standing', standing))
            
        if watched is not None:
            
            _query_params.append(('watched', watched))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/characters/{character_id}/contacts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def put_characters_character_id_contacts(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        standing: Union[StrictFloat, StrictInt],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=100)],
        label_ids: Optional[Annotated[List[StrictInt], Field(max_length=63)]] = None,
        watched: Optional[StrictBool] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Edit contacts

        Bulk edit contacts with same settings

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param standing: (required)
        :type standing: float
        :param request_body: (required)
        :type request_body: List[int]
        :param label_ids:
        :type label_ids: List[int]
        :param watched:
        :type watched: bool
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_characters_character_id_contacts_serialize(
            character_id=character_id,
            standing=standing,
            request_body=request_body,
            label_ids=label_ids,
            watched=watched,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def put_characters_character_id_contacts_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        standing: Union[StrictFloat, StrictInt],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=100)],
        label_ids: Optional[Annotated[List[StrictInt], Field(max_length=63)]] = None,
        watched: Optional[StrictBool] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Edit contacts

        Bulk edit contacts with same settings

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param standing: (required)
        :type standing: float
        :param request_body: (required)
        :type request_body: List[int]
        :param label_ids:
        :type label_ids: List[int]
        :param watched:
        :type watched: bool
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_characters_character_id_contacts_serialize(
            character_id=character_id,
            standing=standing,
            request_body=request_body,
            label_ids=label_ids,
            watched=watched,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def put_characters_character_id_contacts_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        standing: Union[StrictFloat, StrictInt],
        request_body: Annotated[List[StrictInt], Field(min_length=1, max_length=100)],
        label_ids: Optional[Annotated[List[StrictInt], Field(max_length=63)]] = None,
        watched: Optional[StrictBool] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Edit contacts

        Bulk edit contacts with same settings

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param standing: (required)
        :type standing: float
        :param request_body: (required)
        :type request_body: List[int]
        :param label_ids:
        :type label_ids: List[int]
        :param watched:
        :type watched: bool
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_characters_character_id_contacts_serialize(
            character_id=character_id,
            standing=standing,
            request_body=request_body,
            label_ids=label_ids,
            watched=watched,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _put_characters_character_id_contacts_serialize(
        self,
        character_id,
        standing,
        request_body,
        label_ids,
        watched,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
            'request_body': '',
            'label_ids': 'multi',
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        if label_ids is not None:
            
            _query_params.append(('label_ids', label_ids))
            
        if standing is not None:
            
            _query_params.append(('standing', standing))
            
        if watched is not None:
            
            _query_params.append(('watched', watched))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter
        if request_body is not None:
            _body_params = request_body


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/characters/{character_id}/contacts',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


