# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import date
from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from pyesi_openapi.models.characters_character_id_standings_get_inner import CharactersCharacterIdStandingsGetInner
from pyesi_openapi.models.corporations_corporation_id_alliancehistory_get_inner import CorporationsCorporationIdAlliancehistoryGetInner
from pyesi_openapi.models.corporations_corporation_id_blueprints_get_inner import CorporationsCorporationIdBlueprintsGetInner
from pyesi_openapi.models.corporations_corporation_id_containers_logs_get_inner import CorporationsCorporationIdContainersLogsGetInner
from pyesi_openapi.models.corporations_corporation_id_divisions_get import CorporationsCorporationIdDivisionsGet
from pyesi_openapi.models.corporations_corporation_id_facilities_get_inner import CorporationsCorporationIdFacilitiesGetInner
from pyesi_openapi.models.corporations_corporation_id_get import CorporationsCorporationIdGet
from pyesi_openapi.models.corporations_corporation_id_icons_get import CorporationsCorporationIdIconsGet
from pyesi_openapi.models.corporations_corporation_id_medals_get_inner import CorporationsCorporationIdMedalsGetInner
from pyesi_openapi.models.corporations_corporation_id_medals_issued_get_inner import CorporationsCorporationIdMedalsIssuedGetInner
from pyesi_openapi.models.corporations_corporation_id_members_titles_get_inner import CorporationsCorporationIdMembersTitlesGetInner
from pyesi_openapi.models.corporations_corporation_id_membertracking_get_inner import CorporationsCorporationIdMembertrackingGetInner
from pyesi_openapi.models.corporations_corporation_id_roles_get_inner import CorporationsCorporationIdRolesGetInner
from pyesi_openapi.models.corporations_corporation_id_roles_history_get_inner import CorporationsCorporationIdRolesHistoryGetInner
from pyesi_openapi.models.corporations_corporation_id_shareholders_get_inner import CorporationsCorporationIdShareholdersGetInner
from pyesi_openapi.models.corporations_corporation_id_starbases_get_inner import CorporationsCorporationIdStarbasesGetInner
from pyesi_openapi.models.corporations_corporation_id_starbases_starbase_id_get import CorporationsCorporationIdStarbasesStarbaseIdGet
from pyesi_openapi.models.corporations_corporation_id_structures_get_inner import CorporationsCorporationIdStructuresGetInner
from pyesi_openapi.models.corporations_corporation_id_titles_get_inner import CorporationsCorporationIdTitlesGetInner

from pyesi_openapi.api_client import ApiClient, RequestSerialized
from pyesi_openapi.api_response import ApiResponse
from pyesi_openapi.rest import RESTResponseType


class CorporationApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def get_corporations_corporation_id(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CorporationsCorporationIdGet:
        """Get corporation information

        Public information about a corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CorporationsCorporationIdGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CorporationsCorporationIdGet]:
        """Get corporation information

        Public information about a corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CorporationsCorporationIdGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation information

        Public information about a corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CorporationsCorporationIdGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_serialize(
        self,
        corporation_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_alliancehistory(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdAlliancehistoryGetInner]:
        """Get alliance history

        Get a list of all the alliances a corporation has been a member of

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_alliancehistory_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdAlliancehistoryGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_alliancehistory_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdAlliancehistoryGetInner]]:
        """Get alliance history

        Get a list of all the alliances a corporation has been a member of

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_alliancehistory_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdAlliancehistoryGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_alliancehistory_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get alliance history

        Get a list of all the alliances a corporation has been a member of

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_alliancehistory_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdAlliancehistoryGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_alliancehistory_serialize(
        self,
        corporation_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/alliancehistory',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_blueprints(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdBlueprintsGetInner]:
        """Get corporation blueprints

        Returns a list of blueprints the corporation owns

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_blueprints_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdBlueprintsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_blueprints_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdBlueprintsGetInner]]:
        """Get corporation blueprints

        Returns a list of blueprints the corporation owns

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_blueprints_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdBlueprintsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_blueprints_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation blueprints

        Returns a list of blueprints the corporation owns

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_blueprints_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdBlueprintsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_blueprints_serialize(
        self,
        corporation_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/blueprints',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_containers_logs(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdContainersLogsGetInner]:
        """Get all corporation ALSC logs

        Returns logs recorded in the past seven days from all audit log secure containers (ALSC) owned by a given corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_containers_logs_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdContainersLogsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_containers_logs_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdContainersLogsGetInner]]:
        """Get all corporation ALSC logs

        Returns logs recorded in the past seven days from all audit log secure containers (ALSC) owned by a given corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_containers_logs_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdContainersLogsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_containers_logs_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get all corporation ALSC logs

        Returns logs recorded in the past seven days from all audit log secure containers (ALSC) owned by a given corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_containers_logs_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdContainersLogsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_containers_logs_serialize(
        self,
        corporation_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/containers/logs',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_divisions(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CorporationsCorporationIdDivisionsGet:
        """Get corporation divisions

        Return corporation hangar and wallet division names, only show if a division is not using the default name

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_divisions_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CorporationsCorporationIdDivisionsGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_divisions_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CorporationsCorporationIdDivisionsGet]:
        """Get corporation divisions

        Return corporation hangar and wallet division names, only show if a division is not using the default name

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_divisions_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CorporationsCorporationIdDivisionsGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_divisions_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation divisions

        Return corporation hangar and wallet division names, only show if a division is not using the default name

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_divisions_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CorporationsCorporationIdDivisionsGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_divisions_serialize(
        self,
        corporation_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/divisions',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_facilities(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdFacilitiesGetInner]:
        """Get corporation facilities

        Return a corporation's facilities

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_facilities_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdFacilitiesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_facilities_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdFacilitiesGetInner]]:
        """Get corporation facilities

        Return a corporation's facilities

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_facilities_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdFacilitiesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_facilities_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation facilities

        Return a corporation's facilities

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_facilities_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdFacilitiesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_facilities_serialize(
        self,
        corporation_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/facilities',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_icons(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CorporationsCorporationIdIconsGet:
        """Get corporation icon

        Get the icon urls for a corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_icons_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CorporationsCorporationIdIconsGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_icons_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CorporationsCorporationIdIconsGet]:
        """Get corporation icon

        Get the icon urls for a corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_icons_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CorporationsCorporationIdIconsGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_icons_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation icon

        Get the icon urls for a corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_icons_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CorporationsCorporationIdIconsGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_icons_serialize(
        self,
        corporation_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/icons',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_medals(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdMedalsGetInner]:
        """Get corporation medals

        Returns a corporation's medals

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_medals_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdMedalsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_medals_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdMedalsGetInner]]:
        """Get corporation medals

        Returns a corporation's medals

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_medals_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdMedalsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_medals_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation medals

        Returns a corporation's medals

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_medals_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdMedalsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_medals_serialize(
        self,
        corporation_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/medals',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_medals_issued(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdMedalsIssuedGetInner]:
        """Get corporation issued medals

        Returns medals issued by a corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_medals_issued_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdMedalsIssuedGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_medals_issued_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdMedalsIssuedGetInner]]:
        """Get corporation issued medals

        Returns medals issued by a corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_medals_issued_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdMedalsIssuedGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_medals_issued_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation issued medals

        Returns medals issued by a corporation

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_medals_issued_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdMedalsIssuedGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_medals_issued_serialize(
        self,
        corporation_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/medals/issued',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_members(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[int]:
        """Get corporation members

        Return the current member list of a corporation, the token's character need to be a member of the corporation.

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_members_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[int]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_members_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[int]]:
        """Get corporation members

        Return the current member list of a corporation, the token's character need to be a member of the corporation.

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_members_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[int]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_members_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation members

        Return the current member list of a corporation, the token's character need to be a member of the corporation.

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_members_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[int]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_members_serialize(
        self,
        corporation_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/members',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_members_limit(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> int:
        """Get corporation member limit

        Return a corporation's member limit, not including CEO himself

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_members_limit_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "int",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_members_limit_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[int]:
        """Get corporation member limit

        Return a corporation's member limit, not including CEO himself

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_members_limit_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "int",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_members_limit_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation member limit

        Return a corporation's member limit, not including CEO himself

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_members_limit_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "int",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_members_limit_serialize(
        self,
        corporation_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/members/limit',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_members_titles(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdMembersTitlesGetInner]:
        """Get corporation's members' titles

        Returns a corporation's members' titles

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_members_titles_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdMembersTitlesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_members_titles_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdMembersTitlesGetInner]]:
        """Get corporation's members' titles

        Returns a corporation's members' titles

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_members_titles_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdMembersTitlesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_members_titles_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation's members' titles

        Returns a corporation's members' titles

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_members_titles_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdMembersTitlesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_members_titles_serialize(
        self,
        corporation_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/members/titles',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_membertracking(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdMembertrackingGetInner]:
        """Track corporation members

        Returns additional information about a corporation's members which helps tracking their activities

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_membertracking_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdMembertrackingGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_membertracking_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdMembertrackingGetInner]]:
        """Track corporation members

        Returns additional information about a corporation's members which helps tracking their activities

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_membertracking_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdMembertrackingGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_membertracking_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Track corporation members

        Returns additional information about a corporation's members which helps tracking their activities

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_membertracking_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdMembertrackingGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_membertracking_serialize(
        self,
        corporation_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/membertracking',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_roles(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdRolesGetInner]:
        """Get corporation member roles

        Return the roles of all members if the character has the personnel manager role or any grantable role.

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_roles_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdRolesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_roles_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdRolesGetInner]]:
        """Get corporation member roles

        Return the roles of all members if the character has the personnel manager role or any grantable role.

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_roles_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdRolesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_roles_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation member roles

        Return the roles of all members if the character has the personnel manager role or any grantable role.

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_roles_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdRolesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_roles_serialize(
        self,
        corporation_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/roles',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_roles_history(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdRolesHistoryGetInner]:
        """Get corporation member roles history

        Return how roles have changed for a coporation's members, up to a month

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_roles_history_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdRolesHistoryGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_roles_history_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdRolesHistoryGetInner]]:
        """Get corporation member roles history

        Return how roles have changed for a coporation's members, up to a month

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_roles_history_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdRolesHistoryGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_roles_history_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation member roles history

        Return how roles have changed for a coporation's members, up to a month

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_roles_history_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdRolesHistoryGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_roles_history_serialize(
        self,
        corporation_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/roles/history',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_shareholders(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdShareholdersGetInner]:
        """Get corporation shareholders

        Return the current shareholders of a corporation.

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_shareholders_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdShareholdersGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_shareholders_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdShareholdersGetInner]]:
        """Get corporation shareholders

        Return the current shareholders of a corporation.

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_shareholders_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdShareholdersGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_shareholders_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation shareholders

        Return the current shareholders of a corporation.

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_shareholders_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdShareholdersGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_shareholders_serialize(
        self,
        corporation_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/shareholders',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_standings(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CharactersCharacterIdStandingsGetInner]:
        """Get corporation standings

        Return corporation standings from agents, NPC corporations, and factions

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_standings_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdStandingsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_standings_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CharactersCharacterIdStandingsGetInner]]:
        """Get corporation standings

        Return corporation standings from agents, NPC corporations, and factions

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_standings_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdStandingsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_standings_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation standings

        Return corporation standings from agents, NPC corporations, and factions

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_standings_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CharactersCharacterIdStandingsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_standings_serialize(
        self,
        corporation_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/standings',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_starbases(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdStarbasesGetInner]:
        """Get corporation starbases (POSes)

        Returns list of corporation starbases (POSes)

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_starbases_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdStarbasesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_starbases_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdStarbasesGetInner]]:
        """Get corporation starbases (POSes)

        Returns list of corporation starbases (POSes)

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_starbases_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdStarbasesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_starbases_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation starbases (POSes)

        Returns list of corporation starbases (POSes)

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_starbases_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdStarbasesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_starbases_serialize(
        self,
        corporation_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/starbases',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_starbases_starbase_id(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        starbase_id: StrictInt,
        system_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CorporationsCorporationIdStarbasesStarbaseIdGet:
        """Get starbase (POS) detail

        Returns various settings and fuels of a starbase (POS)

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param starbase_id: (required)
        :type starbase_id: int
        :param system_id: (required)
        :type system_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_starbases_starbase_id_serialize(
            corporation_id=corporation_id,
            starbase_id=starbase_id,
            system_id=system_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CorporationsCorporationIdStarbasesStarbaseIdGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_starbases_starbase_id_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        starbase_id: StrictInt,
        system_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CorporationsCorporationIdStarbasesStarbaseIdGet]:
        """Get starbase (POS) detail

        Returns various settings and fuels of a starbase (POS)

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param starbase_id: (required)
        :type starbase_id: int
        :param system_id: (required)
        :type system_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_starbases_starbase_id_serialize(
            corporation_id=corporation_id,
            starbase_id=starbase_id,
            system_id=system_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CorporationsCorporationIdStarbasesStarbaseIdGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_starbases_starbase_id_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        starbase_id: StrictInt,
        system_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get starbase (POS) detail

        Returns various settings and fuels of a starbase (POS)

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param starbase_id: (required)
        :type starbase_id: int
        :param system_id: (required)
        :type system_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_starbases_starbase_id_serialize(
            corporation_id=corporation_id,
            starbase_id=starbase_id,
            system_id=system_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CorporationsCorporationIdStarbasesStarbaseIdGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_starbases_starbase_id_serialize(
        self,
        corporation_id,
        starbase_id,
        system_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        if starbase_id is not None:
            _path_params['starbase_id'] = starbase_id
        # process the query parameters
        if system_id is not None:
            
            _query_params.append(('system_id', system_id))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/starbases/{starbase_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_structures(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdStructuresGetInner]:
        """Get corporation structures

        Get a list of corporation structures. This route's version includes the changes to structures detailed in this blog: https://www.eveonline.com/article/upwell-2.0-structures-changes-coming-on-february-13th

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_structures_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdStructuresGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_structures_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdStructuresGetInner]]:
        """Get corporation structures

        Get a list of corporation structures. This route's version includes the changes to structures detailed in this blog: https://www.eveonline.com/article/upwell-2.0-structures-changes-coming-on-february-13th

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_structures_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdStructuresGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_structures_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        page: Optional[Annotated[int, Field(strict=True, ge=1)]] = None,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation structures

        Get a list of corporation structures. This route's version includes the changes to structures detailed in this blog: https://www.eveonline.com/article/upwell-2.0-structures-changes-coming-on-february-13th

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param page:
        :type page: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_structures_serialize(
            corporation_id=corporation_id,
            page=page,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdStructuresGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_structures_serialize(
        self,
        corporation_id,
        page,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        if page is not None:
            
            _query_params.append(('page', page))
            
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/structures',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_corporation_id_titles(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[CorporationsCorporationIdTitlesGetInner]:
        """Get corporation titles

        Returns a corporation's titles

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_titles_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdTitlesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_corporation_id_titles_with_http_info(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[CorporationsCorporationIdTitlesGetInner]]:
        """Get corporation titles

        Returns a corporation's titles

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_titles_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdTitlesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_corporation_id_titles_without_preload_content(
        self,
        corporation_id: Annotated[StrictInt, Field(description="The ID of the corporation")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get corporation titles

        Returns a corporation's titles

        :param corporation_id: The ID of the corporation (required)
        :type corporation_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_corporation_id_titles_serialize(
            corporation_id=corporation_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[CorporationsCorporationIdTitlesGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_corporation_id_titles_serialize(
        self,
        corporation_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if corporation_id is not None:
            _path_params['corporation_id'] = corporation_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/{corporation_id}/titles',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_corporations_npccorps(
        self,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[int]:
        """Get npc corporations

        Get a list of npc corporations  This route expires daily at 11:05

        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_npccorps_serialize(
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[int]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_corporations_npccorps_with_http_info(
        self,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[int]]:
        """Get npc corporations

        Get a list of npc corporations  This route expires daily at 11:05

        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_npccorps_serialize(
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[int]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_corporations_npccorps_without_preload_content(
        self,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get npc corporations

        Get a list of npc corporations  This route expires daily at 11:05

        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_corporations_npccorps_serialize(
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[int]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_corporations_npccorps_serialize(
        self,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/corporations/npccorps',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


