# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501

import warnings
from pydantic import validate_call, Field, StrictFloat, StrictStr, StrictInt
from typing import Any, Dict, List, Optional, Tuple, Union
from typing_extensions import Annotated

from datetime import date
from pydantic import Field, StrictInt, StrictStr, field_validator
from typing import List, Optional
from typing_extensions import Annotated
from pyesi_openapi.models.characters_character_id_fleet_get import CharactersCharacterIdFleetGet
from pyesi_openapi.models.fleets_fleet_id_get import FleetsFleetIdGet
from pyesi_openapi.models.fleets_fleet_id_members_get_inner import FleetsFleetIdMembersGetInner
from pyesi_openapi.models.fleets_fleet_id_wings_get_inner import FleetsFleetIdWingsGetInner
from pyesi_openapi.models.fleets_fleet_id_wings_post import FleetsFleetIdWingsPost
from pyesi_openapi.models.fleets_fleet_id_wings_wing_id_squads_post import FleetsFleetIdWingsWingIdSquadsPost
from pyesi_openapi.models.post_fleets_fleet_id_members_request import PostFleetsFleetIdMembersRequest
from pyesi_openapi.models.put_fleets_fleet_id_members_member_id_request import PutFleetsFleetIdMembersMemberIdRequest
from pyesi_openapi.models.put_fleets_fleet_id_request import PutFleetsFleetIdRequest
from pyesi_openapi.models.put_fleets_fleet_id_squads_squad_id_request import PutFleetsFleetIdSquadsSquadIdRequest

from pyesi_openapi.api_client import ApiClient, RequestSerialized
from pyesi_openapi.api_response import ApiResponse
from pyesi_openapi.rest import RESTResponseType


class FleetsApi:
    """NOTE: This class is auto generated by OpenAPI Generator
    Ref: https://openapi-generator.tech

    Do not edit the class manually.
    """

    def __init__(self, api_client=None) -> None:
        if api_client is None:
            api_client = ApiClient.get_default()
        self.api_client = api_client


    @validate_call
    def delete_fleets_fleet_id_members_member_id(
        self,
        fleet_id: StrictInt,
        member_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Kick fleet member

        Kick a fleet member

        :param fleet_id: (required)
        :type fleet_id: int
        :param member_id: (required)
        :type member_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_fleets_fleet_id_members_member_id_serialize(
            fleet_id=fleet_id,
            member_id=member_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_fleets_fleet_id_members_member_id_with_http_info(
        self,
        fleet_id: StrictInt,
        member_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Kick fleet member

        Kick a fleet member

        :param fleet_id: (required)
        :type fleet_id: int
        :param member_id: (required)
        :type member_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_fleets_fleet_id_members_member_id_serialize(
            fleet_id=fleet_id,
            member_id=member_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_fleets_fleet_id_members_member_id_without_preload_content(
        self,
        fleet_id: StrictInt,
        member_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Kick fleet member

        Kick a fleet member

        :param fleet_id: (required)
        :type fleet_id: int
        :param member_id: (required)
        :type member_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_fleets_fleet_id_members_member_id_serialize(
            fleet_id=fleet_id,
            member_id=member_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_fleets_fleet_id_members_member_id_serialize(
        self,
        fleet_id,
        member_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if fleet_id is not None:
            _path_params['fleet_id'] = fleet_id
        if member_id is not None:
            _path_params['member_id'] = member_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/fleets/{fleet_id}/members/{member_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_fleets_fleet_id_squads_squad_id(
        self,
        fleet_id: StrictInt,
        squad_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete fleet squad

        Delete a fleet squad, only empty squads can be deleted

        :param fleet_id: (required)
        :type fleet_id: int
        :param squad_id: (required)
        :type squad_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_fleets_fleet_id_squads_squad_id_serialize(
            fleet_id=fleet_id,
            squad_id=squad_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_fleets_fleet_id_squads_squad_id_with_http_info(
        self,
        fleet_id: StrictInt,
        squad_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete fleet squad

        Delete a fleet squad, only empty squads can be deleted

        :param fleet_id: (required)
        :type fleet_id: int
        :param squad_id: (required)
        :type squad_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_fleets_fleet_id_squads_squad_id_serialize(
            fleet_id=fleet_id,
            squad_id=squad_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_fleets_fleet_id_squads_squad_id_without_preload_content(
        self,
        fleet_id: StrictInt,
        squad_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete fleet squad

        Delete a fleet squad, only empty squads can be deleted

        :param fleet_id: (required)
        :type fleet_id: int
        :param squad_id: (required)
        :type squad_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_fleets_fleet_id_squads_squad_id_serialize(
            fleet_id=fleet_id,
            squad_id=squad_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_fleets_fleet_id_squads_squad_id_serialize(
        self,
        fleet_id,
        squad_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if fleet_id is not None:
            _path_params['fleet_id'] = fleet_id
        if squad_id is not None:
            _path_params['squad_id'] = squad_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/fleets/{fleet_id}/squads/{squad_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def delete_fleets_fleet_id_wings_wing_id(
        self,
        fleet_id: StrictInt,
        wing_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Delete fleet wing

        Delete a fleet wing, only empty wings can be deleted. The wing may contain squads, but the squads must be empty

        :param fleet_id: (required)
        :type fleet_id: int
        :param wing_id: (required)
        :type wing_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_fleets_fleet_id_wings_wing_id_serialize(
            fleet_id=fleet_id,
            wing_id=wing_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def delete_fleets_fleet_id_wings_wing_id_with_http_info(
        self,
        fleet_id: StrictInt,
        wing_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Delete fleet wing

        Delete a fleet wing, only empty wings can be deleted. The wing may contain squads, but the squads must be empty

        :param fleet_id: (required)
        :type fleet_id: int
        :param wing_id: (required)
        :type wing_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_fleets_fleet_id_wings_wing_id_serialize(
            fleet_id=fleet_id,
            wing_id=wing_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def delete_fleets_fleet_id_wings_wing_id_without_preload_content(
        self,
        fleet_id: StrictInt,
        wing_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Delete fleet wing

        Delete a fleet wing, only empty wings can be deleted. The wing may contain squads, but the squads must be empty

        :param fleet_id: (required)
        :type fleet_id: int
        :param wing_id: (required)
        :type wing_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._delete_fleets_fleet_id_wings_wing_id_serialize(
            fleet_id=fleet_id,
            wing_id=wing_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _delete_fleets_fleet_id_wings_wing_id_serialize(
        self,
        fleet_id,
        wing_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if fleet_id is not None:
            _path_params['fleet_id'] = fleet_id
        if wing_id is not None:
            _path_params['wing_id'] = wing_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='DELETE',
            resource_path='/fleets/{fleet_id}/wings/{wing_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_characters_character_id_fleet(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> CharactersCharacterIdFleetGet:
        """Get character fleet info

        Return the fleet ID the character is in, if any.

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_fleet_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdFleetGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_characters_character_id_fleet_with_http_info(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[CharactersCharacterIdFleetGet]:
        """Get character fleet info

        Return the fleet ID the character is in, if any.

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_fleet_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdFleetGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_characters_character_id_fleet_without_preload_content(
        self,
        character_id: Annotated[StrictInt, Field(description="The ID of the character")],
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get character fleet info

        Return the fleet ID the character is in, if any.

        :param character_id: The ID of the character (required)
        :type character_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_characters_character_id_fleet_serialize(
            character_id=character_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "CharactersCharacterIdFleetGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_characters_character_id_fleet_serialize(
        self,
        character_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if character_id is not None:
            _path_params['character_id'] = character_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/characters/{character_id}/fleet',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_fleets_fleet_id(
        self,
        fleet_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FleetsFleetIdGet:
        """Get fleet information

        Return details about a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_fleets_fleet_id_serialize(
            fleet_id=fleet_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FleetsFleetIdGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_fleets_fleet_id_with_http_info(
        self,
        fleet_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FleetsFleetIdGet]:
        """Get fleet information

        Return details about a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_fleets_fleet_id_serialize(
            fleet_id=fleet_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FleetsFleetIdGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_fleets_fleet_id_without_preload_content(
        self,
        fleet_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get fleet information

        Return details about a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_fleets_fleet_id_serialize(
            fleet_id=fleet_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "FleetsFleetIdGet",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_fleets_fleet_id_serialize(
        self,
        fleet_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if fleet_id is not None:
            _path_params['fleet_id'] = fleet_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/fleets/{fleet_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_fleets_fleet_id_members(
        self,
        fleet_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[FleetsFleetIdMembersGetInner]:
        """Get fleet members

        Return information about fleet members

        :param fleet_id: (required)
        :type fleet_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_fleets_fleet_id_members_serialize(
            fleet_id=fleet_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[FleetsFleetIdMembersGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_fleets_fleet_id_members_with_http_info(
        self,
        fleet_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[FleetsFleetIdMembersGetInner]]:
        """Get fleet members

        Return information about fleet members

        :param fleet_id: (required)
        :type fleet_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_fleets_fleet_id_members_serialize(
            fleet_id=fleet_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[FleetsFleetIdMembersGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_fleets_fleet_id_members_without_preload_content(
        self,
        fleet_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get fleet members

        Return information about fleet members

        :param fleet_id: (required)
        :type fleet_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_fleets_fleet_id_members_serialize(
            fleet_id=fleet_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[FleetsFleetIdMembersGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_fleets_fleet_id_members_serialize(
        self,
        fleet_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if fleet_id is not None:
            _path_params['fleet_id'] = fleet_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/fleets/{fleet_id}/members',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def get_fleets_fleet_id_wings(
        self,
        fleet_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> List[FleetsFleetIdWingsGetInner]:
        """Get fleet wings

        Return information about wings in a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_fleets_fleet_id_wings_serialize(
            fleet_id=fleet_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[FleetsFleetIdWingsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def get_fleets_fleet_id_wings_with_http_info(
        self,
        fleet_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[List[FleetsFleetIdWingsGetInner]]:
        """Get fleet wings

        Return information about wings in a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_fleets_fleet_id_wings_serialize(
            fleet_id=fleet_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[FleetsFleetIdWingsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def get_fleets_fleet_id_wings_without_preload_content(
        self,
        fleet_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Get fleet wings

        Return information about wings in a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._get_fleets_fleet_id_wings_serialize(
            fleet_id=fleet_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '200': "List[FleetsFleetIdWingsGetInner]",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _get_fleets_fleet_id_wings_serialize(
        self,
        fleet_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if fleet_id is not None:
            _path_params['fleet_id'] = fleet_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='GET',
            resource_path='/fleets/{fleet_id}/wings',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_fleets_fleet_id_members(
        self,
        fleet_id: StrictInt,
        post_fleets_fleet_id_members_request: PostFleetsFleetIdMembersRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Create fleet invitation

        Invite a character into the fleet. If a character has a CSPA charge set it is not possible to invite them to the fleet using ESI

        :param fleet_id: (required)
        :type fleet_id: int
        :param post_fleets_fleet_id_members_request: (required)
        :type post_fleets_fleet_id_members_request: PostFleetsFleetIdMembersRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_fleets_fleet_id_members_serialize(
            fleet_id=fleet_id,
            post_fleets_fleet_id_members_request=post_fleets_fleet_id_members_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_fleets_fleet_id_members_with_http_info(
        self,
        fleet_id: StrictInt,
        post_fleets_fleet_id_members_request: PostFleetsFleetIdMembersRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Create fleet invitation

        Invite a character into the fleet. If a character has a CSPA charge set it is not possible to invite them to the fleet using ESI

        :param fleet_id: (required)
        :type fleet_id: int
        :param post_fleets_fleet_id_members_request: (required)
        :type post_fleets_fleet_id_members_request: PostFleetsFleetIdMembersRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_fleets_fleet_id_members_serialize(
            fleet_id=fleet_id,
            post_fleets_fleet_id_members_request=post_fleets_fleet_id_members_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_fleets_fleet_id_members_without_preload_content(
        self,
        fleet_id: StrictInt,
        post_fleets_fleet_id_members_request: PostFleetsFleetIdMembersRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create fleet invitation

        Invite a character into the fleet. If a character has a CSPA charge set it is not possible to invite them to the fleet using ESI

        :param fleet_id: (required)
        :type fleet_id: int
        :param post_fleets_fleet_id_members_request: (required)
        :type post_fleets_fleet_id_members_request: PostFleetsFleetIdMembersRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_fleets_fleet_id_members_serialize(
            fleet_id=fleet_id,
            post_fleets_fleet_id_members_request=post_fleets_fleet_id_members_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_fleets_fleet_id_members_serialize(
        self,
        fleet_id,
        post_fleets_fleet_id_members_request,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if fleet_id is not None:
            _path_params['fleet_id'] = fleet_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter
        if post_fleets_fleet_id_members_request is not None:
            _body_params = post_fleets_fleet_id_members_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/fleets/{fleet_id}/members',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_fleets_fleet_id_wings(
        self,
        fleet_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FleetsFleetIdWingsPost:
        """Create fleet wing

        Create a new wing in a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_fleets_fleet_id_wings_serialize(
            fleet_id=fleet_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "FleetsFleetIdWingsPost",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_fleets_fleet_id_wings_with_http_info(
        self,
        fleet_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FleetsFleetIdWingsPost]:
        """Create fleet wing

        Create a new wing in a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_fleets_fleet_id_wings_serialize(
            fleet_id=fleet_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "FleetsFleetIdWingsPost",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_fleets_fleet_id_wings_without_preload_content(
        self,
        fleet_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create fleet wing

        Create a new wing in a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_fleets_fleet_id_wings_serialize(
            fleet_id=fleet_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "FleetsFleetIdWingsPost",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_fleets_fleet_id_wings_serialize(
        self,
        fleet_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if fleet_id is not None:
            _path_params['fleet_id'] = fleet_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/fleets/{fleet_id}/wings',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def post_fleets_fleet_id_wings_wing_id_squads(
        self,
        fleet_id: StrictInt,
        wing_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> FleetsFleetIdWingsWingIdSquadsPost:
        """Create fleet squad

        Create a new squad in a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param wing_id: (required)
        :type wing_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_fleets_fleet_id_wings_wing_id_squads_serialize(
            fleet_id=fleet_id,
            wing_id=wing_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "FleetsFleetIdWingsWingIdSquadsPost",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def post_fleets_fleet_id_wings_wing_id_squads_with_http_info(
        self,
        fleet_id: StrictInt,
        wing_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[FleetsFleetIdWingsWingIdSquadsPost]:
        """Create fleet squad

        Create a new squad in a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param wing_id: (required)
        :type wing_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_fleets_fleet_id_wings_wing_id_squads_serialize(
            fleet_id=fleet_id,
            wing_id=wing_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "FleetsFleetIdWingsWingIdSquadsPost",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def post_fleets_fleet_id_wings_wing_id_squads_without_preload_content(
        self,
        fleet_id: StrictInt,
        wing_id: StrictInt,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Create fleet squad

        Create a new squad in a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param wing_id: (required)
        :type wing_id: int
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._post_fleets_fleet_id_wings_wing_id_squads_serialize(
            fleet_id=fleet_id,
            wing_id=wing_id,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '201': "FleetsFleetIdWingsWingIdSquadsPost",
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _post_fleets_fleet_id_wings_wing_id_squads_serialize(
        self,
        fleet_id,
        wing_id,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if fleet_id is not None:
            _path_params['fleet_id'] = fleet_id
        if wing_id is not None:
            _path_params['wing_id'] = wing_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )


        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='POST',
            resource_path='/fleets/{fleet_id}/wings/{wing_id}/squads',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def put_fleets_fleet_id(
        self,
        fleet_id: StrictInt,
        put_fleets_fleet_id_request: PutFleetsFleetIdRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Update fleet

        Update settings about a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param put_fleets_fleet_id_request: (required)
        :type put_fleets_fleet_id_request: PutFleetsFleetIdRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_fleets_fleet_id_serialize(
            fleet_id=fleet_id,
            put_fleets_fleet_id_request=put_fleets_fleet_id_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def put_fleets_fleet_id_with_http_info(
        self,
        fleet_id: StrictInt,
        put_fleets_fleet_id_request: PutFleetsFleetIdRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Update fleet

        Update settings about a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param put_fleets_fleet_id_request: (required)
        :type put_fleets_fleet_id_request: PutFleetsFleetIdRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_fleets_fleet_id_serialize(
            fleet_id=fleet_id,
            put_fleets_fleet_id_request=put_fleets_fleet_id_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def put_fleets_fleet_id_without_preload_content(
        self,
        fleet_id: StrictInt,
        put_fleets_fleet_id_request: PutFleetsFleetIdRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Update fleet

        Update settings about a fleet

        :param fleet_id: (required)
        :type fleet_id: int
        :param put_fleets_fleet_id_request: (required)
        :type put_fleets_fleet_id_request: PutFleetsFleetIdRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_fleets_fleet_id_serialize(
            fleet_id=fleet_id,
            put_fleets_fleet_id_request=put_fleets_fleet_id_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _put_fleets_fleet_id_serialize(
        self,
        fleet_id,
        put_fleets_fleet_id_request,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if fleet_id is not None:
            _path_params['fleet_id'] = fleet_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter
        if put_fleets_fleet_id_request is not None:
            _body_params = put_fleets_fleet_id_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/fleets/{fleet_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def put_fleets_fleet_id_members_member_id(
        self,
        fleet_id: StrictInt,
        member_id: StrictInt,
        put_fleets_fleet_id_members_member_id_request: PutFleetsFleetIdMembersMemberIdRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Move fleet member

        Move a fleet member around

        :param fleet_id: (required)
        :type fleet_id: int
        :param member_id: (required)
        :type member_id: int
        :param put_fleets_fleet_id_members_member_id_request: (required)
        :type put_fleets_fleet_id_members_member_id_request: PutFleetsFleetIdMembersMemberIdRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_fleets_fleet_id_members_member_id_serialize(
            fleet_id=fleet_id,
            member_id=member_id,
            put_fleets_fleet_id_members_member_id_request=put_fleets_fleet_id_members_member_id_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def put_fleets_fleet_id_members_member_id_with_http_info(
        self,
        fleet_id: StrictInt,
        member_id: StrictInt,
        put_fleets_fleet_id_members_member_id_request: PutFleetsFleetIdMembersMemberIdRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Move fleet member

        Move a fleet member around

        :param fleet_id: (required)
        :type fleet_id: int
        :param member_id: (required)
        :type member_id: int
        :param put_fleets_fleet_id_members_member_id_request: (required)
        :type put_fleets_fleet_id_members_member_id_request: PutFleetsFleetIdMembersMemberIdRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_fleets_fleet_id_members_member_id_serialize(
            fleet_id=fleet_id,
            member_id=member_id,
            put_fleets_fleet_id_members_member_id_request=put_fleets_fleet_id_members_member_id_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def put_fleets_fleet_id_members_member_id_without_preload_content(
        self,
        fleet_id: StrictInt,
        member_id: StrictInt,
        put_fleets_fleet_id_members_member_id_request: PutFleetsFleetIdMembersMemberIdRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Move fleet member

        Move a fleet member around

        :param fleet_id: (required)
        :type fleet_id: int
        :param member_id: (required)
        :type member_id: int
        :param put_fleets_fleet_id_members_member_id_request: (required)
        :type put_fleets_fleet_id_members_member_id_request: PutFleetsFleetIdMembersMemberIdRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_fleets_fleet_id_members_member_id_serialize(
            fleet_id=fleet_id,
            member_id=member_id,
            put_fleets_fleet_id_members_member_id_request=put_fleets_fleet_id_members_member_id_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _put_fleets_fleet_id_members_member_id_serialize(
        self,
        fleet_id,
        member_id,
        put_fleets_fleet_id_members_member_id_request,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if fleet_id is not None:
            _path_params['fleet_id'] = fleet_id
        if member_id is not None:
            _path_params['member_id'] = member_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter
        if put_fleets_fleet_id_members_member_id_request is not None:
            _body_params = put_fleets_fleet_id_members_member_id_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/fleets/{fleet_id}/members/{member_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def put_fleets_fleet_id_squads_squad_id(
        self,
        fleet_id: StrictInt,
        squad_id: StrictInt,
        put_fleets_fleet_id_squads_squad_id_request: PutFleetsFleetIdSquadsSquadIdRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Rename fleet squad

        Rename a fleet squad

        :param fleet_id: (required)
        :type fleet_id: int
        :param squad_id: (required)
        :type squad_id: int
        :param put_fleets_fleet_id_squads_squad_id_request: (required)
        :type put_fleets_fleet_id_squads_squad_id_request: PutFleetsFleetIdSquadsSquadIdRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_fleets_fleet_id_squads_squad_id_serialize(
            fleet_id=fleet_id,
            squad_id=squad_id,
            put_fleets_fleet_id_squads_squad_id_request=put_fleets_fleet_id_squads_squad_id_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def put_fleets_fleet_id_squads_squad_id_with_http_info(
        self,
        fleet_id: StrictInt,
        squad_id: StrictInt,
        put_fleets_fleet_id_squads_squad_id_request: PutFleetsFleetIdSquadsSquadIdRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Rename fleet squad

        Rename a fleet squad

        :param fleet_id: (required)
        :type fleet_id: int
        :param squad_id: (required)
        :type squad_id: int
        :param put_fleets_fleet_id_squads_squad_id_request: (required)
        :type put_fleets_fleet_id_squads_squad_id_request: PutFleetsFleetIdSquadsSquadIdRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_fleets_fleet_id_squads_squad_id_serialize(
            fleet_id=fleet_id,
            squad_id=squad_id,
            put_fleets_fleet_id_squads_squad_id_request=put_fleets_fleet_id_squads_squad_id_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def put_fleets_fleet_id_squads_squad_id_without_preload_content(
        self,
        fleet_id: StrictInt,
        squad_id: StrictInt,
        put_fleets_fleet_id_squads_squad_id_request: PutFleetsFleetIdSquadsSquadIdRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Rename fleet squad

        Rename a fleet squad

        :param fleet_id: (required)
        :type fleet_id: int
        :param squad_id: (required)
        :type squad_id: int
        :param put_fleets_fleet_id_squads_squad_id_request: (required)
        :type put_fleets_fleet_id_squads_squad_id_request: PutFleetsFleetIdSquadsSquadIdRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_fleets_fleet_id_squads_squad_id_serialize(
            fleet_id=fleet_id,
            squad_id=squad_id,
            put_fleets_fleet_id_squads_squad_id_request=put_fleets_fleet_id_squads_squad_id_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _put_fleets_fleet_id_squads_squad_id_serialize(
        self,
        fleet_id,
        squad_id,
        put_fleets_fleet_id_squads_squad_id_request,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if fleet_id is not None:
            _path_params['fleet_id'] = fleet_id
        if squad_id is not None:
            _path_params['squad_id'] = squad_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter
        if put_fleets_fleet_id_squads_squad_id_request is not None:
            _body_params = put_fleets_fleet_id_squads_squad_id_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/fleets/{fleet_id}/squads/{squad_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )




    @validate_call
    def put_fleets_fleet_id_wings_wing_id(
        self,
        fleet_id: StrictInt,
        wing_id: StrictInt,
        put_fleets_fleet_id_squads_squad_id_request: PutFleetsFleetIdSquadsSquadIdRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> None:
        """Rename fleet wing

        Rename a fleet wing

        :param fleet_id: (required)
        :type fleet_id: int
        :param wing_id: (required)
        :type wing_id: int
        :param put_fleets_fleet_id_squads_squad_id_request: (required)
        :type put_fleets_fleet_id_squads_squad_id_request: PutFleetsFleetIdSquadsSquadIdRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_fleets_fleet_id_wings_wing_id_serialize(
            fleet_id=fleet_id,
            wing_id=wing_id,
            put_fleets_fleet_id_squads_squad_id_request=put_fleets_fleet_id_squads_squad_id_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        ).data


    @validate_call
    def put_fleets_fleet_id_wings_wing_id_with_http_info(
        self,
        fleet_id: StrictInt,
        wing_id: StrictInt,
        put_fleets_fleet_id_squads_squad_id_request: PutFleetsFleetIdSquadsSquadIdRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> ApiResponse[None]:
        """Rename fleet wing

        Rename a fleet wing

        :param fleet_id: (required)
        :type fleet_id: int
        :param wing_id: (required)
        :type wing_id: int
        :param put_fleets_fleet_id_squads_squad_id_request: (required)
        :type put_fleets_fleet_id_squads_squad_id_request: PutFleetsFleetIdSquadsSquadIdRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_fleets_fleet_id_wings_wing_id_serialize(
            fleet_id=fleet_id,
            wing_id=wing_id,
            put_fleets_fleet_id_squads_squad_id_request=put_fleets_fleet_id_squads_squad_id_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        response_data.read()
        return self.api_client.response_deserialize(
            response_data=response_data,
            response_types_map=_response_types_map,
        )


    @validate_call
    def put_fleets_fleet_id_wings_wing_id_without_preload_content(
        self,
        fleet_id: StrictInt,
        wing_id: StrictInt,
        put_fleets_fleet_id_squads_squad_id_request: PutFleetsFleetIdSquadsSquadIdRequest,
        accept_language: Annotated[Optional[StrictStr], Field(description="The language to use for the response.")] = None,
        if_none_match: Annotated[Optional[StrictStr], Field(description="The ETag of the previous request. A 304 will be returned if this matches the current ETag.")] = None,
        x_compatibility_date: Annotated[Optional[date], Field(description="The compatibility date for the request.")] = None,
        x_tenant: Annotated[Optional[StrictStr], Field(description="The tenant ID for the request.")] = None,
        _request_timeout: Union[
            None,
            Annotated[StrictFloat, Field(gt=0)],
            Tuple[
                Annotated[StrictFloat, Field(gt=0)],
                Annotated[StrictFloat, Field(gt=0)]
            ]
        ] = None,
        _request_auth: Optional[Dict[StrictStr, Any]] = None,
        _content_type: Optional[StrictStr] = None,
        _headers: Optional[Dict[StrictStr, Any]] = None,
        _host_index: Annotated[StrictInt, Field(ge=0, le=0)] = 0,
    ) -> RESTResponseType:
        """Rename fleet wing

        Rename a fleet wing

        :param fleet_id: (required)
        :type fleet_id: int
        :param wing_id: (required)
        :type wing_id: int
        :param put_fleets_fleet_id_squads_squad_id_request: (required)
        :type put_fleets_fleet_id_squads_squad_id_request: PutFleetsFleetIdSquadsSquadIdRequest
        :param accept_language: The language to use for the response.
        :type accept_language: str
        :param if_none_match: The ETag of the previous request. A 304 will be returned if this matches the current ETag.
        :type if_none_match: str
        :param x_compatibility_date: The compatibility date for the request.
        :type x_compatibility_date: date
        :param x_tenant: The tenant ID for the request.
        :type x_tenant: str
        :param _request_timeout: timeout setting for this request. If one
                                 number provided, it will be total request
                                 timeout. It can also be a pair (tuple) of
                                 (connection, read) timeouts.
        :type _request_timeout: int, tuple(int, int), optional
        :param _request_auth: set to override the auth_settings for an a single
                              request; this effectively ignores the
                              authentication in the spec for a single request.
        :type _request_auth: dict, optional
        :param _content_type: force content-type for the request.
        :type _content_type: str, Optional
        :param _headers: set to override the headers for a single
                         request; this effectively ignores the headers
                         in the spec for a single request.
        :type _headers: dict, optional
        :param _host_index: set to override the host_index for a single
                            request; this effectively ignores the host_index
                            in the spec for a single request.
        :type _host_index: int, optional
        :return: Returns the result object.
        """ # noqa: E501

        _param = self._put_fleets_fleet_id_wings_wing_id_serialize(
            fleet_id=fleet_id,
            wing_id=wing_id,
            put_fleets_fleet_id_squads_squad_id_request=put_fleets_fleet_id_squads_squad_id_request,
            accept_language=accept_language,
            if_none_match=if_none_match,
            x_compatibility_date=x_compatibility_date,
            x_tenant=x_tenant,
            _request_auth=_request_auth,
            _content_type=_content_type,
            _headers=_headers,
            _host_index=_host_index
        )

        _response_types_map: Dict[str, Optional[str]] = {
            '204': None,
        }
        response_data = self.api_client.call_api(
            *_param,
            _request_timeout=_request_timeout
        )
        return response_data.response


    def _put_fleets_fleet_id_wings_wing_id_serialize(
        self,
        fleet_id,
        wing_id,
        put_fleets_fleet_id_squads_squad_id_request,
        accept_language,
        if_none_match,
        x_compatibility_date,
        x_tenant,
        _request_auth,
        _content_type,
        _headers,
        _host_index,
    ) -> RequestSerialized:

        _host = None

        _collection_formats: Dict[str, str] = {
        }

        _path_params: Dict[str, str] = {}
        _query_params: List[Tuple[str, str]] = []
        _header_params: Dict[str, Optional[str]] = _headers or {}
        _form_params: List[Tuple[str, str]] = []
        _files: Dict[
            str, Union[str, bytes, List[str], List[bytes], List[Tuple[str, bytes]]]
        ] = {}
        _body_params: Optional[bytes] = None

        # process the path parameters
        if fleet_id is not None:
            _path_params['fleet_id'] = fleet_id
        if wing_id is not None:
            _path_params['wing_id'] = wing_id
        # process the query parameters
        # process the header parameters
        if accept_language is not None:
            _header_params['Accept-Language'] = accept_language
        if if_none_match is not None:
            _header_params['If-None-Match'] = if_none_match
        if x_compatibility_date is not None:
            _header_params['X-Compatibility-Date'] = x_compatibility_date
        if x_tenant is not None:
            _header_params['X-Tenant'] = x_tenant
        # process the form parameters
        # process the body parameter
        if put_fleets_fleet_id_squads_squad_id_request is not None:
            _body_params = put_fleets_fleet_id_squads_squad_id_request


        # set the HTTP header `Accept`
        if 'Accept' not in _header_params:
            _header_params['Accept'] = self.api_client.select_header_accept(
                [
                    'application/json'
                ]
            )

        # set the HTTP header `Content-Type`
        if _content_type:
            _header_params['Content-Type'] = _content_type
        else:
            _default_content_type = (
                self.api_client.select_header_content_type(
                    [
                        'application/json'
                    ]
                )
            )
            if _default_content_type is not None:
                _header_params['Content-Type'] = _default_content_type

        # authentication setting
        _auth_settings: List[str] = [
            'OAuth2'
        ]

        return self.api_client.param_serialize(
            method='PUT',
            resource_path='/fleets/{fleet_id}/wings/{wing_id}',
            path_params=_path_params,
            query_params=_query_params,
            header_params=_header_params,
            body=_body_params,
            post_params=_form_params,
            files=_files,
            auth_settings=_auth_settings,
            collection_formats=_collection_formats,
            _host=_host,
            _request_auth=_request_auth
        )


