# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt
from typing import Any, ClassVar, Dict, List, Optional
from typing import Optional, Set
from typing_extensions import Self

class CharactersCharacterIdAttributesGet(BaseModel):
    """
    CharactersCharacterIdAttributesGet
    """ # noqa: E501
    accrued_remap_cooldown_date: Optional[datetime] = Field(default=None, description="Neural remapping cooldown after a character uses remap accrued over time")
    bonus_remaps: Optional[StrictInt] = Field(default=None, description="Number of available bonus character neural remaps")
    charisma: StrictInt
    intelligence: StrictInt
    last_remap_date: Optional[datetime] = Field(default=None, description="Datetime of last neural remap, including usage of bonus remaps")
    memory: StrictInt
    perception: StrictInt
    willpower: StrictInt
    __properties: ClassVar[List[str]] = ["accrued_remap_cooldown_date", "bonus_remaps", "charisma", "intelligence", "last_remap_date", "memory", "perception", "willpower"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdAttributesGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdAttributesGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "accrued_remap_cooldown_date": obj.get("accrued_remap_cooldown_date"),
            "bonus_remaps": obj.get("bonus_remaps"),
            "charisma": obj.get("charisma"),
            "intelligence": obj.get("intelligence"),
            "last_remap_date": obj.get("last_remap_date"),
            "memory": obj.get("memory"),
            "perception": obj.get("perception"),
            "willpower": obj.get("willpower")
        })
        return _obj


