# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class CharactersCharacterIdCalendarEventIdGet(BaseModel):
    """
    Full details of a specific event
    """ # noqa: E501
    var_date: datetime = Field(alias="date")
    duration: StrictInt = Field(description="Length in minutes")
    event_id: StrictInt
    importance: StrictInt
    owner_id: StrictInt
    owner_name: StrictStr
    owner_type: StrictStr
    response: StrictStr
    text: StrictStr
    title: StrictStr
    __properties: ClassVar[List[str]] = ["date", "duration", "event_id", "importance", "owner_id", "owner_name", "owner_type", "response", "text", "title"]

    @field_validator('owner_type')
    def owner_type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['eve_server', 'corporation', 'faction', 'character', 'alliance']):
            raise ValueError("must be one of enum values ('eve_server', 'corporation', 'faction', 'character', 'alliance')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdCalendarEventIdGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdCalendarEventIdGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "date": obj.get("date"),
            "duration": obj.get("duration"),
            "event_id": obj.get("event_id"),
            "importance": obj.get("importance"),
            "owner_id": obj.get("owner_id"),
            "owner_name": obj.get("owner_name"),
            "owner_type": obj.get("owner_type"),
            "response": obj.get("response"),
            "text": obj.get("text"),
            "title": obj.get("title")
        })
        return _obj


