# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List, Optional
from pyesi_openapi.models.characters_character_id_clones_get_home_location import CharactersCharacterIdClonesGetHomeLocation
from pyesi_openapi.models.characters_character_id_clones_get_jump_clones_inner import CharactersCharacterIdClonesGetJumpClonesInner
from typing import Optional, Set
from typing_extensions import Self

class CharactersCharacterIdClonesGet(BaseModel):
    """
    CharactersCharacterIdClonesGet
    """ # noqa: E501
    home_location: Optional[CharactersCharacterIdClonesGetHomeLocation] = None
    jump_clones: List[CharactersCharacterIdClonesGetJumpClonesInner]
    last_clone_jump_date: Optional[datetime] = None
    last_station_change_date: Optional[datetime] = None
    __properties: ClassVar[List[str]] = ["home_location", "jump_clones", "last_clone_jump_date", "last_station_change_date"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdClonesGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of home_location
        if self.home_location:
            _dict['home_location'] = self.home_location.to_dict()
        # override the default output from pydantic by calling `to_dict()` of each item in jump_clones (list)
        _items = []
        if self.jump_clones:
            for _item_jump_clones in self.jump_clones:
                if _item_jump_clones:
                    _items.append(_item_jump_clones.to_dict())
            _dict['jump_clones'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdClonesGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "home_location": CharactersCharacterIdClonesGetHomeLocation.from_dict(obj["home_location"]) if obj.get("home_location") is not None else None,
            "jump_clones": [CharactersCharacterIdClonesGetJumpClonesInner.from_dict(_item) for _item in obj["jump_clones"]] if obj.get("jump_clones") is not None else None,
            "last_clone_jump_date": obj.get("last_clone_jump_date"),
            "last_station_change_date": obj.get("last_station_change_date")
        })
        return _obj


