# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CharactersCharacterIdContractsGetInner(BaseModel):
    """
    CharactersCharacterIdContractsGetInner
    """ # noqa: E501
    acceptor_id: StrictInt = Field(description="Who will accept the contract")
    assignee_id: StrictInt = Field(description="ID to whom the contract is assigned, can be alliance, corporation or character ID")
    availability: StrictStr = Field(description="To whom the contract is available")
    buyout: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Buyout price (for Auctions only)")
    collateral: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Collateral price (for Couriers only)")
    contract_id: StrictInt
    date_accepted: Optional[datetime] = Field(default=None, description="Date of confirmation of contract")
    date_completed: Optional[datetime] = Field(default=None, description="Date of completed of contract")
    date_expired: datetime = Field(description="Expiration date of the contract")
    date_issued: datetime = Field(description="Сreation date of the contract")
    days_to_complete: Optional[StrictInt] = Field(default=None, description="Number of days to perform the contract")
    end_location_id: Optional[StrictInt] = Field(default=None, description="End location ID (for Couriers contract)")
    for_corporation: StrictBool = Field(description="true if the contract was issued on behalf of the issuer's corporation")
    issuer_corporation_id: StrictInt = Field(description="Character's corporation ID for the issuer")
    issuer_id: StrictInt = Field(description="Character ID for the issuer")
    price: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Price of contract (for ItemsExchange and Auctions)")
    reward: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Remuneration for contract (for Couriers only)")
    start_location_id: Optional[StrictInt] = Field(default=None, description="Start location ID (for Couriers contract)")
    status: StrictStr = Field(description="Status of the the contract")
    title: Optional[StrictStr] = Field(default=None, description="Title of the contract")
    type: StrictStr = Field(description="Type of the contract")
    volume: Optional[Union[StrictFloat, StrictInt]] = Field(default=None, description="Volume of items in the contract")
    __properties: ClassVar[List[str]] = ["acceptor_id", "assignee_id", "availability", "buyout", "collateral", "contract_id", "date_accepted", "date_completed", "date_expired", "date_issued", "days_to_complete", "end_location_id", "for_corporation", "issuer_corporation_id", "issuer_id", "price", "reward", "start_location_id", "status", "title", "type", "volume"]

    @field_validator('availability')
    def availability_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['public', 'personal', 'corporation', 'alliance']):
            raise ValueError("must be one of enum values ('public', 'personal', 'corporation', 'alliance')")
        return value

    @field_validator('status')
    def status_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['outstanding', 'in_progress', 'finished_issuer', 'finished_contractor', 'finished', 'cancelled', 'rejected', 'failed', 'deleted', 'reversed']):
            raise ValueError("must be one of enum values ('outstanding', 'in_progress', 'finished_issuer', 'finished_contractor', 'finished', 'cancelled', 'rejected', 'failed', 'deleted', 'reversed')")
        return value

    @field_validator('type')
    def type_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['unknown', 'item_exchange', 'auction', 'courier', 'loan']):
            raise ValueError("must be one of enum values ('unknown', 'item_exchange', 'auction', 'courier', 'loan')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdContractsGetInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdContractsGetInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "acceptor_id": obj.get("acceptor_id"),
            "assignee_id": obj.get("assignee_id"),
            "availability": obj.get("availability"),
            "buyout": obj.get("buyout"),
            "collateral": obj.get("collateral"),
            "contract_id": obj.get("contract_id"),
            "date_accepted": obj.get("date_accepted"),
            "date_completed": obj.get("date_completed"),
            "date_expired": obj.get("date_expired"),
            "date_issued": obj.get("date_issued"),
            "days_to_complete": obj.get("days_to_complete"),
            "end_location_id": obj.get("end_location_id"),
            "for_corporation": obj.get("for_corporation"),
            "issuer_corporation_id": obj.get("issuer_corporation_id"),
            "issuer_id": obj.get("issuer_id"),
            "price": obj.get("price"),
            "reward": obj.get("reward"),
            "start_location_id": obj.get("start_location_id"),
            "status": obj.get("status"),
            "title": obj.get("title"),
            "type": obj.get("type"),
            "volume": obj.get("volume")
        })
        return _obj


