# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict, Field, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List
from typing import Optional, Set
from typing_extensions import Self

class CharactersCharacterIdFleetGet(BaseModel):
    """
    CharactersCharacterIdFleetGet
    """ # noqa: E501
    fleet_boss_id: StrictInt = Field(description="Character ID of the current fleet boss")
    fleet_id: StrictInt = Field(description="The character's current fleet ID")
    role: StrictStr = Field(description="Member’s role in fleet")
    squad_id: StrictInt = Field(description="ID of the squad the member is in. If not applicable, will be set to -1")
    wing_id: StrictInt = Field(description="ID of the wing the member is in. If not applicable, will be set to -1")
    __properties: ClassVar[List[str]] = ["fleet_boss_id", "fleet_id", "role", "squad_id", "wing_id"]

    @field_validator('role')
    def role_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['fleet_commander', 'squad_commander', 'squad_member', 'wing_commander']):
            raise ValueError("must be one of enum values ('fleet_commander', 'squad_commander', 'squad_member', 'wing_commander')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdFleetGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdFleetGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "fleet_boss_id": obj.get("fleet_boss_id"),
            "fleet_id": obj.get("fleet_id"),
            "role": obj.get("role"),
            "squad_id": obj.get("squad_id"),
            "wing_id": obj.get("wing_id")
        })
        return _obj


