# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictFloat, StrictInt, StrictStr, field_validator
from typing import Any, ClassVar, Dict, List, Optional, Union
from typing import Optional, Set
from typing_extensions import Self

class CharactersCharacterIdGet(BaseModel):
    """
    CharactersCharacterIdGet
    """ # noqa: E501
    alliance_id: Optional[StrictInt] = Field(default=None, description="The character's alliance ID")
    birthday: datetime = Field(description="Creation date of the character")
    bloodline_id: StrictInt
    corporation_id: StrictInt = Field(description="The character's corporation ID")
    description: Optional[StrictStr] = None
    faction_id: Optional[StrictInt] = Field(default=None, description="ID of the faction the character is fighting for, if the character is enlisted in Factional Warfare")
    gender: StrictStr
    name: StrictStr
    race_id: StrictInt
    security_status: Optional[Union[StrictFloat, StrictInt]] = None
    title: Optional[StrictStr] = Field(default=None, description="The individual title of the character")
    __properties: ClassVar[List[str]] = ["alliance_id", "birthday", "bloodline_id", "corporation_id", "description", "faction_id", "gender", "name", "race_id", "security_status", "title"]

    @field_validator('gender')
    def gender_validate_enum(cls, value):
        """Validates the enum"""
        if value not in set(['female', 'male']):
            raise ValueError("must be one of enum values ('female', 'male')")
        return value

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "alliance_id": obj.get("alliance_id"),
            "birthday": obj.get("birthday"),
            "bloodline_id": obj.get("bloodline_id"),
            "corporation_id": obj.get("corporation_id"),
            "description": obj.get("description"),
            "faction_id": obj.get("faction_id"),
            "gender": obj.get("gender"),
            "name": obj.get("name"),
            "race_id": obj.get("race_id"),
            "security_status": obj.get("security_status"),
            "title": obj.get("title")
        })
        return _obj


