# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from datetime import datetime
from pydantic import BaseModel, ConfigDict, Field, StrictBool, StrictInt, StrictStr
from typing import Any, ClassVar, Dict, List, Optional
from pyesi_openapi.models.post_characters_character_id_mail_request_recipients_inner import PostCharactersCharacterIdMailRequestRecipientsInner
from typing import Optional, Set
from typing_extensions import Self

class CharactersCharacterIdMailGetInner(BaseModel):
    """
    CharactersCharacterIdMailGetInner
    """ # noqa: E501
    var_from: Optional[StrictInt] = Field(default=None, description="From whom the mail was sent", alias="from")
    is_read: Optional[StrictBool] = None
    labels: Optional[List[StrictInt]] = None
    mail_id: Optional[StrictInt] = None
    recipients: Optional[List[PostCharactersCharacterIdMailRequestRecipientsInner]] = Field(default=None, description="Recipients of the mail")
    subject: Optional[StrictStr] = Field(default=None, description="Mail subject")
    timestamp: Optional[datetime] = Field(default=None, description="When the mail was sent")
    __properties: ClassVar[List[str]] = ["from", "is_read", "labels", "mail_id", "recipients", "subject", "timestamp"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdMailGetInner from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in recipients (list)
        _items = []
        if self.recipients:
            for _item_recipients in self.recipients:
                if _item_recipients:
                    _items.append(_item_recipients.to_dict())
            _dict['recipients'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdMailGetInner from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "from": obj.get("from"),
            "is_read": obj.get("is_read"),
            "labels": obj.get("labels"),
            "mail_id": obj.get("mail_id"),
            "recipients": [PostCharactersCharacterIdMailRequestRecipientsInner.from_dict(_item) for _item in obj["recipients"]] if obj.get("recipients") is not None else None,
            "subject": obj.get("subject"),
            "timestamp": obj.get("timestamp")
        })
        return _obj


