# coding: utf-8

"""
    PyESI (OpenAPI) - EVE Stable Infrastructure (ESI)

    This python SDK was generated with openapi-generator (https://openapi-generator.tech/) using OpenAPI specification for EVE Stable Infrastructure / EVE Swagger Interface (ESI) (https://developers.eveonline.com/api-explorer)and is lightly normalized to improve client generation via our custom templates. It preserves endpoint coverage from CCP's published specification while adjusting metadata and select parameter shapes for a more ergonomic, type-safe Python SDK.

    The version of the OpenAPI document: 2020-01-01
    Contact: arxbombus@gmail.com
    Generated by OpenAPI Generator (https://openapi-generator.tech)

    Do not edit the class manually.
"""  # noqa: E501


from __future__ import annotations
import pprint
import re  # noqa: F401
import json

from pydantic import BaseModel, ConfigDict
from typing import Any, ClassVar, Dict, List
from pyesi_openapi.models.characters_character_id_planets_planet_id_get_links_inner import CharactersCharacterIdPlanetsPlanetIdGetLinksInner
from pyesi_openapi.models.characters_character_id_planets_planet_id_get_pins_inner import CharactersCharacterIdPlanetsPlanetIdGetPinsInner
from pyesi_openapi.models.characters_character_id_planets_planet_id_get_routes_inner import CharactersCharacterIdPlanetsPlanetIdGetRoutesInner
from typing import Optional, Set
from typing_extensions import Self

class CharactersCharacterIdPlanetsPlanetIdGet(BaseModel):
    """
    CharactersCharacterIdPlanetsPlanetIdGet
    """ # noqa: E501
    links: List[CharactersCharacterIdPlanetsPlanetIdGetLinksInner]
    pins: List[CharactersCharacterIdPlanetsPlanetIdGetPinsInner]
    routes: List[CharactersCharacterIdPlanetsPlanetIdGetRoutesInner]
    __properties: ClassVar[List[str]] = ["links", "pins", "routes"]

    model_config = ConfigDict(
        populate_by_name=True,
        validate_assignment=True,
        protected_namespaces=(),
    )


    def to_str(self) -> str:
        """Returns the string representation of the model using alias"""
        return pprint.pformat(self.model_dump(by_alias=True))

    def to_json(self) -> str:
        """Returns the JSON representation of the model using alias"""
        # TODO: pydantic v2: use .model_dump_json(by_alias=True, exclude_unset=True) instead
        return json.dumps(self.to_dict())

    @classmethod
    def from_json(cls, json_str: str) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdPlanetsPlanetIdGet from a JSON string"""
        return cls.from_dict(json.loads(json_str))

    def to_dict(self) -> Dict[str, Any]:
        """Return the dictionary representation of the model using alias.

        This has the following differences from calling pydantic's
        `self.model_dump(by_alias=True)`:

        * `None` is only added to the output dict for nullable fields that
          were set at model initialization. Other fields with value `None`
          are ignored.
        """
        excluded_fields: Set[str] = set([
        ])

        _dict = self.model_dump(
            by_alias=True,
            exclude=excluded_fields,
            exclude_none=True,
        )
        # override the default output from pydantic by calling `to_dict()` of each item in links (list)
        _items = []
        if self.links:
            for _item_links in self.links:
                if _item_links:
                    _items.append(_item_links.to_dict())
            _dict['links'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in pins (list)
        _items = []
        if self.pins:
            for _item_pins in self.pins:
                if _item_pins:
                    _items.append(_item_pins.to_dict())
            _dict['pins'] = _items
        # override the default output from pydantic by calling `to_dict()` of each item in routes (list)
        _items = []
        if self.routes:
            for _item_routes in self.routes:
                if _item_routes:
                    _items.append(_item_routes.to_dict())
            _dict['routes'] = _items
        return _dict

    @classmethod
    def from_dict(cls, obj: Optional[Dict[str, Any]]) -> Optional[Self]:
        """Create an instance of CharactersCharacterIdPlanetsPlanetIdGet from a dict"""
        if obj is None:
            return None

        if not isinstance(obj, dict):
            return cls.model_validate(obj)

        _obj = cls.model_validate({
            "links": [CharactersCharacterIdPlanetsPlanetIdGetLinksInner.from_dict(_item) for _item in obj["links"]] if obj.get("links") is not None else None,
            "pins": [CharactersCharacterIdPlanetsPlanetIdGetPinsInner.from_dict(_item) for _item in obj["pins"]] if obj.get("pins") is not None else None,
            "routes": [CharactersCharacterIdPlanetsPlanetIdGetRoutesInner.from_dict(_item) for _item in obj["routes"]] if obj.get("routes") is not None else None
        })
        return _obj


